/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.jpmml.evaluator.Table;

public class TableReader
extends AbstractMap<String, Object>
implements Iterator<Map<String, Object>> {
    private Table table = null;
    private int position = -1;
    private int maxPosition = -1;

    public TableReader(Table table) {
        this.setTable(table);
    }

    @Override
    public boolean hasNext() {
        int maxPosition;
        int position = this.getPosition();
        return position < (maxPosition = this.getMaxPosition());
    }

    @Override
    public Map<String, Object> next() {
        int maxPosition;
        int position = this.getPosition();
        if (position >= (maxPosition = this.getMaxPosition())) {
            throw new NoSuchElementException();
        }
        this.setPosition(position + 1);
        return this;
    }

    @Override
    public Object get(Object key) {
        Table table = this.getTable();
        int position = this.ensurePosition();
        List<?> values = table.getValues((String)key);
        if (values != null) {
            return values.get(position);
        }
        return null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        final Table table = this.getTable();
        final int position = this.ensurePosition();
        AbstractSet<Map.Entry<String, Object>> result = new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public int size() {
                List<String> columns = table.getColumns();
                return columns.size();
            }

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                final List<String> columns = table.getColumns();
                Iterator<Map.Entry<String, Object>> result = new Iterator<Map.Entry<String, Object>>(){
                    private Iterator<String> it;
                    {
                        this.it = columns.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        String column = this.it.next();
                        List<?> values = table.getValues(column);
                        if (values != null) {
                            Object value = values.get(position);
                            return new AbstractMap.SimpleEntry<String, Object>(column, value);
                        }
                        return new AbstractMap.SimpleEntry<String, Object>(column, null);
                    }
                };
                return result;
            }
        };
        return result;
    }

    protected int ensurePosition() {
        int position = this.getPosition();
        if (position < 0) {
            throw new IllegalStateException();
        }
        return position;
    }

    public Table getTable() {
        return this.table;
    }

    void setTable(Table table) {
        this.table = Objects.requireNonNull(table);
        this.setPosition(-1);
        this.setMaxPosition(table.getNumberOfRows() - 1);
    }

    int getPosition() {
        return this.position;
    }

    void setPosition(int position) {
        this.position = position;
    }

    int getMaxPosition() {
        return this.maxPosition;
    }

    void setMaxPosition(int maxPosition) {
        this.maxPosition = maxPosition;
    }
}

