/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jpmml.evaluator.Table;
import org.jpmml.evaluator.TableUtil;

public class TableWriter
extends AbstractMap<String, Object> {
    private Table table = null;
    private int position = -1;

    public TableWriter(Table table) {
        this.setTable(table);
    }

    public void next() {
        int position = this.getPosition();
        this.setPosition(position + 1);
    }

    @Override
    public Object get(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }

    public void put(Exception exception) {
        Table table = this.getTable();
        int position = this.ensurePosition();
        table.setException(position, exception);
    }

    @Override
    public Object put(String key, Object value) {
        Table table = this.getTable();
        int position = this.ensurePosition();
        List<?> values = table.ensureValues(key);
        return TableUtil.set(values, position, value);
    }

    protected int ensurePosition() {
        int position = this.getPosition();
        if (position < 0) {
            throw new IllegalStateException();
        }
        return position;
    }

    public Table getTable() {
        return this.table;
    }

    private void setTable(Table table) {
        this.table = Objects.requireNonNull(table);
    }

    int getPosition() {
        return this.position;
    }

    void setPosition(int position) {
        this.position = position;
    }
}

