/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.DataType;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.TypeUtil;

public class TypeCheckException
extends EvaluationException {
    public TypeCheckException(String message) {
        super(message);
    }

    public TypeCheckException(DataType expected, Object actual) {
        this(TypeCheckException.formatMessage(TypeCheckException.formatDataType(expected), TypeCheckException.formatDataType(TypeCheckException.getDataType(actual)), actual));
    }

    public TypeCheckException(Class<?> expected, Object actual) {
        this(TypeCheckException.formatMessage(TypeCheckException.formatClass(expected), TypeCheckException.formatClass(TypeCheckException.getClass(actual)), actual));
    }

    private static String formatMessage(String expected, String actual, Object value) {
        return "Expected " + expected + " value, got " + (String)(value != null ? actual + " value" : "missing value (null)");
    }

    private static DataType getDataType(Object value) {
        if (value != null) {
            try {
                return TypeUtil.getDataType(value);
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String formatDataType(DataType dataType) {
        return dataType != null ? dataType.value() : null;
    }

    private static Class<?> getClass(Object value) {
        if (value != null) {
            return value.getClass();
        }
        return null;
    }

    private static String formatClass(Class<?> clazz) {
        return clazz != null ? clazz.getName() : null;
    }
}

