/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jpmml.evaluator.Computable;
import org.jpmml.evaluator.HasGroupFields;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.Table;

public class EvaluatorUtil {
    private EvaluatorUtil() {
    }

    public static Object decode(Object object) {
        if (object instanceof Computable) {
            Computable computable = (Computable)object;
            return computable.getResult();
        }
        if (object instanceof Collection) {
            Collection rawValues = (Collection)object;
            AbstractCollection decodedValues = rawValues instanceof Set ? new LinkedHashSet(rawValues.size()) : new ArrayList(rawValues.size());
            for (Object rawValue : rawValues) {
                decodedValues.add(EvaluatorUtil.decode(rawValue));
            }
            return decodedValues;
        }
        return object;
    }

    public static Map<String, ?> decodeAll(Map<String, ?> map) {
        LinkedHashMap result = new LinkedHashMap(2 * map.size());
        Set<Map.Entry<String, ?>> entries = map.entrySet();
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                value = EvaluatorUtil.decode(value);
            }
            catch (UnsupportedOperationException uoe) {
                continue;
            }
            result.put(name, value);
        }
        return result;
    }

    public static Table groupRows(HasGroupFields hasGroupFields, Table table) {
        List<InputField> groupFields = hasGroupFields.getGroupFields();
        if (groupFields.size() == 1) {
            InputField groupField = groupFields.get(0);
            table = EvaluatorUtil.groupRows(groupField.getName(), table);
        } else if (groupFields.size() > 1) {
            ModelEvaluator modelEvaluator = (ModelEvaluator)((Object)hasGroupFields);
            throw modelEvaluator.createMiningSchemaException("Expected 0 or 1 group field(s), got " + groupFields.size() + " group fields");
        }
        return table;
    }

    /*
     * WARNING - void declaration
     */
    public static Table groupRows(String groupColumn, Table table) {
        LinkedHashMap<Object, ArrayListMultimap> groupedRows = new LinkedHashMap<Object, ArrayListMultimap>();
        Table.Row row = table.createReaderRow(0);
        int max = table.getNumberOfRows();
        for (int i = 0; i < max; ++i) {
            Object groupValue = row.get(groupColumn);
            ListMultimap listMultimap = (ListMultimap)groupedRows.get(groupValue);
            if (listMultimap == null) {
                ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
                groupedRows.put(groupValue, arrayListMultimap);
            }
            Set<Map.Entry<String, Object>> entries = row.entrySet();
            for (Map.Entry entry : entries) {
                void var7_9;
                String column = (String)entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                var7_9.put((Object)column, value);
            }
            row.advance();
        }
        Table groupedTable = new Table(groupedRows.size());
        row = groupedTable.createWriterRow(0);
        Set entries = groupedRows.entrySet();
        for (Map.Entry entry : entries) {
            Object groupValue = entry.getKey();
            ListMultimap groupedRow = (ListMultimap)entry.getValue();
            row.putAll(Multimaps.asMap((ListMultimap)groupedRow));
            row.put(groupColumn, groupValue);
            row.advance();
        }
        return groupedTable;
    }
}

