/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.RangeSet;
import java.util.List;
import java.util.Objects;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasContinuousDomain;
import org.dmg.pmml.HasDiscreteDomain;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.ColumnCollector;
import org.jpmml.evaluator.FieldUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.InputFieldUtil;
import org.jpmml.evaluator.ModelField;
import org.jpmml.evaluator.Table;

public class InputField
extends ModelField {
    private MiningField miningField = null;

    InputField() {
    }

    public InputField(Field<?> field, MiningField miningField) {
        super(field);
        this.setMiningField(miningField);
        if (!Objects.equals(field.requireName(), miningField.requireName())) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public OpType getOpType() {
        return FieldUtil.getOpType(this.getField(), this.getMiningField());
    }

    public FieldValue prepare(Object value) {
        return InputFieldUtil.prepareInputValue(this.getField(), this.getMiningField(), value);
    }

    @IgnoreJRERequirement
    public Table prepare(Table table) {
        String name = this.getName();
        List<?> values = table.getValues(name);
        if (values != null) {
            table = values.stream().map(this::prepare).collect(new ColumnCollector(table, name));
        }
        return table;
    }

    public RangeSet<Double> getContinuousDomain() {
        RangeSet<Double> validRanges;
        Field<?> field = this.getField();
        if (field instanceof HasContinuousDomain && (validRanges = FieldUtil.getValidRanges((Field)((HasContinuousDomain)field))) != null && !validRanges.isEmpty()) {
            return validRanges;
        }
        return null;
    }

    public List<?> getDiscreteDomain() {
        List<?> validValues;
        Field<?> field = this.getField();
        if (field instanceof HasDiscreteDomain && (validValues = FieldUtil.getValidValues((Field)((HasDiscreteDomain)field))) != null && !validValues.isEmpty()) {
            return validValues;
        }
        return null;
    }

    public MiningField getMiningField() {
        return this.miningField;
    }

    private void setMiningField(MiningField miningField) {
        this.miningField = Objects.requireNonNull(miningField);
    }
}

