/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.jpmml.evaluator.Table;

@IgnoreJRERequirement
public class TableCollector
implements Collector<Object, List<Object>, Table> {
    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    @Override
    public Supplier<List<Object>> supplier() {
        return () -> new ArrayList();
    }

    @Override
    public BiConsumer<List<Object>, Object> accumulator() {
        return (elements, element) -> {
            if (element instanceof Map) {
                Map map = (Map)element;
            } else if (element instanceof Exception) {
                Exception exception = (Exception)element;
            } else {
                throw new IllegalArgumentException();
            }
            elements.add(element);
        };
    }

    @Override
    public BinaryOperator<List<Object>> combiner() {
        return (left, right) -> {
            left.addAll(right);
            return left;
        };
    }

    @Override
    public Function<List<Object>, Table> finisher() {
        return elements -> {
            Table table = this.createFinisherTable(elements.size());
            Table.Row row = null;
            for (Object element : elements) {
                if (row == null) {
                    row = this.createFinisherRow(table);
                }
                if (element instanceof Exception) {
                    Exception exception = (Exception)element;
                    row.setException(exception);
                } else if (element instanceof Map) {
                    Map map = (Map)element;
                    row.putAll(map);
                } else {
                    throw new IllegalArgumentException();
                }
                row.advance();
            }
            table.canonicalize();
            return table;
        };
    }

    protected Table createFinisherTable(int initialCapacity) {
        return new Table(initialCapacity);
    }

    protected Table.Row createFinisherRow(Table table) {
        return table.createWriterRow(0);
    }
}

