/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import de.siegmar.fastcsv.reader.CloseableIterator;
import de.siegmar.fastcsv.reader.CsvReader;
import de.siegmar.fastcsv.reader.CsvRecord;
import de.siegmar.fastcsv.reader.NamedCsvRecord;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.jpmml.evaluator.Table;
import org.jpmml.model.ReflectionUtil;

public class TableReader {
    private CsvReader.CsvReaderBuilder csvReaderBuilder = null;

    public TableReader(char separator) {
        this(TableReader.createCsvReaderBuilder(separator));
    }

    public TableReader(CsvReader.CsvReaderBuilder csvReaderBuilder) {
        this.setCsvReaderBuilder(csvReaderBuilder);
    }

    public Table read(InputStream is) throws IOException {
        return this.read(new InputStreamReader(is, "UTF-8"));
    }

    public Table read(Reader reader) throws IOException {
        CsvReader.CsvReaderBuilder csvReaderBuilder = this.getCsvReaderBuilder();
        FilterReader safeReader = new FilterReader(reader){

            @Override
            public void close() {
            }
        };
        Table table = new Table(1024);
        try (CsvReader csvReader = csvReaderBuilder.ofNamedCsvRecord((Reader)safeReader);){
            List<String> columns = null;
            Table.Row row = table.createWriterRow(0);
            for (NamedCsvRecord csvRecord : csvReader) {
                if (columns == null) {
                    columns = TableReader.initColumns(table, csvRecord);
                }
                row.putAll(csvRecord.getFieldsAsMap());
                row.advance();
            }
        }
        table.canonicalize();
        return table;
    }

    public char getSeparator() {
        CsvReader.CsvReaderBuilder csvReaderBuilder = this.getCsvReaderBuilder();
        return TableReader.getSeparator(csvReaderBuilder);
    }

    public CsvReader.CsvReaderBuilder getCsvReaderBuilder() {
        return this.csvReaderBuilder;
    }

    private void setCsvReaderBuilder(CsvReader.CsvReaderBuilder csvReaderBuilder) {
        this.csvReaderBuilder = Objects.requireNonNull(csvReaderBuilder);
    }

    public static char getSeparator(CsvReader.CsvReaderBuilder csvReaderBuilder) {
        try {
            Field fieldSeparatorField = CsvReader.CsvReaderBuilder.class.getDeclaredField("fieldSeparator");
            return ((Character)ReflectionUtil.getFieldValue((Field)fieldSeparatorField, (Object)csvReaderBuilder)).charValue();
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CsvReader.CsvReaderBuilder detectCsvReaderBuilder(Reader reader, int numberOfLines) throws IOException {
        char[] separators;
        if (!reader.markSupported()) {
            throw new IllegalArgumentException();
        }
        FilterReader safeReader = new FilterReader(reader){

            @Override
            public void close() {
            }
        };
        CsvReader.CsvReaderBuilder result = null;
        int resultFieldCount = 1;
        for (char separator : separators = new char[]{',', ';', '\t', '|'}) {
            CsvReader.CsvReaderBuilder csvReaderBuilder = TableReader.createCsvReaderBuilder(separator);
            int fieldCount = -1;
            safeReader.mark(numberOfLines * 256 * 8);
            try (CsvReader csvReader = csvReaderBuilder.ofCsvRecord((Reader)safeReader);){
                CloseableIterator it = csvReader.iterator();
                int max = numberOfLines;
                for (int i = 0; i < max && it.hasNext(); ++i) {
                    CsvRecord csvRecord = (CsvRecord)it.next();
                    fieldCount = csvRecord.getFieldCount();
                }
            }
            finally {
                safeReader.reset();
            }
            if (fieldCount <= resultFieldCount) continue;
            result = csvReaderBuilder;
            resultFieldCount = fieldCount;
        }
        return result;
    }

    public static CsvReader.CsvReaderBuilder createCsvReaderBuilder(char separator) {
        CsvReader.CsvReaderBuilder csvReaderBuilder = CsvReader.builder().fieldSeparator(separator);
        csvReaderBuilder = csvReaderBuilder.acceptCharsAfterQuotes(false).ignoreDifferentFieldCount(false);
        return csvReaderBuilder;
    }

    private static List<String> initColumns(Table table, NamedCsvRecord csvRecord) {
        List columns = csvRecord.getHeader();
        LinkedHashSet<String> duplicateColumns = new LinkedHashSet<String>();
        for (String column : columns) {
            boolean duplicate = !table.addColumn(column);
            if (!duplicate) continue;
            duplicateColumns.add(column);
        }
        if (!duplicateColumns.isEmpty()) {
            throw new IllegalArgumentException("Expected unique column names, got non-unique column name(s) " + duplicateColumns);
        }
        return columns;
    }
}

