/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.functions.UnaryFunction;

public class MeanFunction
extends UnaryFunction {
    public MeanFunction() {
        this(MeanFunction.class.getName());
    }

    public MeanFunction(String name) {
        super(name, Arrays.asList("values"));
    }

    public Double evaluate(Collection<?> values) {
        Mean statistic = new Mean();
        for (Object value : values) {
            Number number = (Number)TypeUtil.parseOrCast(DataType.DOUBLE, value);
            statistic.increment(number.doubleValue());
        }
        return statistic.getResult();
    }

    @Override
    public FieldValue evaluate(FieldValue value) {
        Double result = this.evaluate(value.asCollection());
        return FieldValueUtil.create(TypeInfos.CONTINUOUS_DOUBLE, result);
    }
}

