/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.support_vector_machine;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.support_vector_machine.PMMLAttributes;
import org.dmg.pmml.support_vector_machine.SupportVectorMachine;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.jpmml.evaluator.PMMLTransformer;
import org.jpmml.model.InvalidElementException;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.model.visitors.AbstractVisitor;

public class EnsureClassificationMethodTransformer
implements PMMLTransformer<RuntimeException> {
    @Override
    public PMML apply(PMML pmml) {
        AbstractVisitor visitor = new AbstractVisitor(){

            public VisitorAction visit(SupportVectorMachineModel supportVectorMachineModel) {
                MiningFunction miningFunction = supportVectorMachineModel.requireMiningFunction();
                switch (miningFunction) {
                    case CLASSIFICATION: {
                        this.ensureClassificationMethod(supportVectorMachineModel);
                        break;
                    }
                }
                return super.visit(supportVectorMachineModel);
            }

            private void ensureClassificationMethod(SupportVectorMachineModel supportVectorMachineModel) {
                SupportVectorMachineModel.ClassificationMethod classificationMethod = (SupportVectorMachineModel.ClassificationMethod)ReflectionUtil.getFieldValue((Field)PMMLAttributes.SUPPORTVECTORMACHINEMODEL_CLASSIFICATIONMETHOD, (Object)supportVectorMachineModel);
                if (classificationMethod == null) {
                    classificationMethod = this.detectClassificationMethod(supportVectorMachineModel);
                    supportVectorMachineModel.setClassificationMethod(classificationMethod);
                }
            }

            private SupportVectorMachineModel.ClassificationMethod detectClassificationMethod(SupportVectorMachineModel supportVectorMachineModel) {
                List supportVectorMachines = supportVectorMachineModel.requireSupportVectorMachines();
                Object alternateBinaryTargetCategory = supportVectorMachineModel.getAlternateBinaryTargetCategory();
                if (alternateBinaryTargetCategory != null) {
                    if (supportVectorMachines.size() == 1) {
                        SupportVectorMachine supportVectorMachine = (SupportVectorMachine)supportVectorMachines.get(0);
                        Object targetCategory = supportVectorMachine.getTargetCategory();
                        if (targetCategory != null) {
                            return SupportVectorMachineModel.ClassificationMethod.ONE_AGAINST_ONE;
                        }
                        throw new InvalidElementException((PMMLObject)supportVectorMachine);
                    }
                    throw new InvalidElementException((PMMLObject)supportVectorMachineModel);
                }
                Iterator iterator = supportVectorMachines.iterator();
                if (iterator.hasNext()) {
                    SupportVectorMachine supportVectorMachine = (SupportVectorMachine)iterator.next();
                    Object targetCategory = supportVectorMachine.getTargetCategory();
                    Object alternateTargetCategory = supportVectorMachine.getAlternateTargetCategory();
                    if (targetCategory != null) {
                        if (alternateTargetCategory != null) {
                            return SupportVectorMachineModel.ClassificationMethod.ONE_AGAINST_ONE;
                        }
                        return SupportVectorMachineModel.ClassificationMethod.ONE_AGAINST_ALL;
                    }
                    throw new InvalidElementException((PMMLObject)supportVectorMachine);
                }
                throw new InvalidElementException((PMMLObject)supportVectorMachineModel);
            }
        };
        visitor.applyTo((Visitable)pmml);
        return pmml;
    }
}

