/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.AggregateKey;
import org.jpmml.evaluator.DuplicateFieldValueException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueMap;
import org.jpmml.evaluator.LagKey;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.MissingFieldValueException;
import org.jpmml.evaluator.ScalarValue;
import org.jpmml.evaluator.SymbolTable;

public abstract class EvaluationContext {
    private FieldValueMap values = null;
    private List<String> warnings = null;
    private static final FieldValue UNDECLARED_VALUE = new ScalarValue(DataType.DOUBLE, Double.NaN){
        {
            this.setValid(false);
        }

        @Override
        public OpType getOpType() {
            return OpType.CONTINUOUS;
        }
    };
    public static final ThreadLocal<SymbolTable<String>> DERIVEDFIELD_GUARD_PROVIDER = new ThreadLocal<SymbolTable<String>>(){

        @Override
        public SymbolTable<String> initialValue() {
            return null;
        }
    };
    public static final ThreadLocal<SymbolTable<String>> FUNCTION_GUARD_PROVIDER = new ThreadLocal<SymbolTable<String>>(){

        @Override
        public SymbolTable<String> initialValue() {
            return null;
        }
    };

    EvaluationContext() {
        this.values = FieldValueMap.create();
    }

    EvaluationContext(int numberOfVisibleFields) {
        this.values = FieldValueMap.create(numberOfVisibleFields);
    }

    protected abstract FieldValue prepare(String var1, Object var2);

    protected void reset(boolean clearValues) {
        if (clearValues) {
            this.values.clear();
        }
        if (this.warnings != null) {
            this.warnings.clear();
        }
    }

    public FieldValue lookup(String name) {
        FieldValueMap values = this.getValues();
        FieldValue value = values.getOrDefault((Object)name, UNDECLARED_VALUE);
        if (value != UNDECLARED_VALUE) {
            return value;
        }
        throw new MissingFieldValueException(name);
    }

    public FieldValue evaluate(String name) {
        FieldValueMap values = this.getValues();
        FieldValue value = values.getOrDefault((Object)name, UNDECLARED_VALUE);
        if (value != UNDECLARED_VALUE) {
            return value;
        }
        return this.resolve(name);
    }

    protected FieldValue resolve(String name) {
        throw new MissingFieldException(name);
    }

    public FieldValue declare(String name, Object value) {
        if (value instanceof FieldValue) {
            return this.declareInternal(name, (FieldValue)value);
        }
        value = this.prepare(name, value);
        return this.declareInternal(name, (FieldValue)value);
    }

    public FieldValue evaluateLagged(LagKey lagKey) {
        FieldValueMap values = this.getValues();
        FieldValue value = values.getOrDefault((Object)lagKey, UNDECLARED_VALUE);
        if (value != UNDECLARED_VALUE) {
            return value;
        }
        return this.resolveLagged(lagKey);
    }

    protected FieldValue resolveLagged(LagKey lagKey) {
        throw new MissingFieldException(lagKey.getName());
    }

    public FieldValue declareLagged(LagKey lagKey, Object value) {
        if (value instanceof FieldValue) {
            return this.declareInternal(lagKey, (FieldValue)value);
        }
        value = this.prepare(lagKey.getName(), value);
        return this.declareInternal(lagKey, (FieldValue)value);
    }

    public FieldValue evaluateAggregated(AggregateKey aggregateKey) {
        FieldValueMap values = this.getValues();
        FieldValue value = values.getOrDefault((Object)aggregateKey, UNDECLARED_VALUE);
        if (value != UNDECLARED_VALUE) {
            return value;
        }
        return this.resolveAggregated(aggregateKey);
    }

    protected FieldValue resolveAggregated(AggregateKey aggregateKey) {
        throw new MissingFieldException(aggregateKey.getName());
    }

    public FieldValue declareAggregated(AggregateKey aggregateKey, Object value) {
        if (value instanceof FieldValue) {
            return this.declareInternal(aggregateKey, (FieldValue)value);
        }
        value = this.prepare(aggregateKey.getName(), value);
        return this.declareInternal(aggregateKey, (FieldValue)value);
    }

    public FieldValue declareInternal(Object key, FieldValue value) {
        FieldValueMap values = this.getValues();
        FieldValue prevValue = values.putIfAbsent(key, value);
        if (prevValue != null) {
            String name = (String)key;
            throw new DuplicateFieldValueException(name);
        }
        return value;
    }

    protected DefineFunction getDefineFunction(String name) {
        throw new UnsupportedOperationException();
    }

    public void addWarning(String warning) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        this.warnings.add(warning);
    }

    public FieldValueMap getValues() {
        return this.values;
    }

    public List<String> getWarnings() {
        if (this.warnings == null) {
            return Collections.emptyList();
        }
        return this.warnings;
    }
}

