/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.BlockIndicator;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasExpression;
import org.dmg.pmml.HasType;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.Lag;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.TextIndex;
import org.jpmml.evaluator.AggregateKey;
import org.jpmml.evaluator.DefineFunctionEvaluationContext;
import org.jpmml.evaluator.DiscretizationUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionRegistry;
import org.jpmml.evaluator.Functions;
import org.jpmml.evaluator.JavaExpression;
import org.jpmml.evaluator.LagKey;
import org.jpmml.evaluator.NormalizationUtil;
import org.jpmml.evaluator.SymbolTable;
import org.jpmml.evaluator.TextUtil;
import org.jpmml.evaluator.TokenizedString;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UndefinedResultException;
import org.jpmml.model.InvalidAttributeException;
import org.jpmml.model.PMMLException;
import org.jpmml.model.UnsupportedAttributeException;
import org.jpmml.model.UnsupportedElementException;

public class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static <E extends PMMLObject> FieldValue evaluateExpressionContainer(E hasExpression, EvaluationContext context) {
        return ExpressionUtil.evaluate(((HasExpression)hasExpression).requireExpression(), context);
    }

    public static <E extends PMMLObject & HasExpression<E>> FieldValue evaluateTypedExpressionContainer(E hasTypedExpression, EvaluationContext context) {
        FieldValue value = ExpressionUtil.evaluateExpressionContainer(hasTypedExpression, context);
        if (FieldValueUtil.isMissing(value)) {
            return FieldValues.MISSING_VALUE;
        }
        return value.cast((HasType)hasTypedExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FieldValue evaluate(DerivedField derivedField, EvaluationContext context) {
        String name = derivedField.requireName();
        SymbolTable<String> symbolTable = EvaluationContext.DERIVEDFIELD_GUARD_PROVIDER.get();
        if (symbolTable != null) {
            symbolTable.lock(name);
        }
        try {
            FieldValue fieldValue = ExpressionUtil.evaluateTypedExpressionContainer(derivedField, context);
            return fieldValue;
        }
        finally {
            if (symbolTable != null) {
                symbolTable.release(name);
            }
        }
    }

    public static FieldValue evaluate(DefineFunction defineFunction, List<FieldValue> values, EvaluationContext context) {
        List parameterFields = defineFunction.getParameterFields();
        if (parameterFields.size() != values.size()) {
            throw new EvaluationException("Function " + EvaluationException.formatName(defineFunction.getName()) + " expects " + parameterFields.size() + " arguments, got " + values.size() + " arguments");
        }
        DefineFunctionEvaluationContext functionContext = new DefineFunctionEvaluationContext(defineFunction, context);
        int max = parameterFields.size();
        for (int i = 0; i < max; ++i) {
            ParameterField parameterField = (ParameterField)parameterFields.get(i);
            FieldValue value = values.get(i);
            value = FieldValueUtil.isMissing(value) ? FieldValues.MISSING_VALUE : value.cast((HasType<?>)parameterField);
            String name = parameterField.requireName();
            functionContext.declareInternal(name, value);
        }
        return ExpressionUtil.evaluateTypedExpressionContainer(defineFunction, functionContext);
    }

    public static FieldValue evaluate(Expression expression, EvaluationContext context) {
        try {
            return ExpressionUtil.evaluateExpression(expression, context);
        }
        catch (PMMLException pe) {
            throw pe.ensureContext((PMMLObject)expression);
        }
    }

    static FieldValue evaluateExpression(Expression expression, EvaluationContext context) {
        if (expression instanceof Constant) {
            return ExpressionUtil.evaluateConstant((Constant)expression);
        }
        if (expression instanceof FieldRef) {
            return ExpressionUtil.evaluateFieldRef((FieldRef)expression, context);
        }
        if (expression instanceof NormContinuous) {
            return ExpressionUtil.evaluateNormContinuous((NormContinuous)expression, context);
        }
        if (expression instanceof NormDiscrete) {
            return ExpressionUtil.evaluateNormDiscrete((NormDiscrete)expression, context);
        }
        if (expression instanceof Discretize) {
            return ExpressionUtil.evaluateDiscretize((Discretize)expression, context);
        }
        if (expression instanceof MapValues) {
            return ExpressionUtil.evaluateMapValues((MapValues)expression, context);
        }
        if (expression instanceof TextIndex) {
            return ExpressionUtil.evaluateTextIndex((TextIndex)expression, context);
        }
        if (expression instanceof Apply) {
            return ExpressionUtil.evaluateApply((Apply)expression, context);
        }
        if (expression instanceof Aggregate) {
            return ExpressionUtil.evaluateAggregate((Aggregate)expression, context);
        }
        if (expression instanceof Lag) {
            return ExpressionUtil.evaluateLag((Lag)expression, context);
        }
        if (expression instanceof JavaExpression) {
            return ExpressionUtil.evaluateJavaExpression((JavaExpression)expression, context);
        }
        throw new UnsupportedElementException((PMMLObject)expression);
    }

    public static FieldValue evaluateConstant(Constant constant) {
        boolean missing = constant.isMissing();
        if (missing) {
            return FieldValues.MISSING_VALUE;
        }
        Object value = constant.getValue();
        DataType dataType = constant.getDataType();
        if (dataType != null) {
            if (ExpressionUtil.isEmptyContent(value)) {
                switch (dataType) {
                    case STRING: {
                        return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, "");
                    }
                }
                return FieldValues.MISSING_VALUE;
            }
        } else {
            if (ExpressionUtil.isEmptyContent(value)) {
                return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, "");
            }
            dataType = TypeUtil.getConstantDataType(value);
        }
        OpType opType = TypeUtil.getOpType(dataType);
        return FieldValueUtil.create(opType, dataType, value);
    }

    public static FieldValue evaluateFieldRef(FieldRef fieldRef, EvaluationContext context) {
        FieldValue value = context.evaluate(fieldRef.requireField());
        if (FieldValueUtil.isMissing(value)) {
            return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, fieldRef.getMapMissingTo());
        }
        return value;
    }

    public static FieldValue evaluateNormContinuous(NormContinuous normContinuous, EvaluationContext context) {
        FieldValue value = context.evaluate(normContinuous.requireField());
        if (FieldValueUtil.isMissing(value)) {
            return FieldValueUtil.create(TypeInfos.CONTINUOUS_DOUBLE, normContinuous.getMapMissingTo());
        }
        return NormalizationUtil.normalize(normContinuous, value);
    }

    public static FieldValue evaluateNormDiscrete(NormDiscrete normDiscrete, EvaluationContext context) {
        FieldValue value = context.evaluate(normDiscrete.requireField());
        if (FieldValueUtil.isMissing(value)) {
            return FieldValueUtil.create(TypeInfos.CATEGORICAL_DOUBLE, normDiscrete.getMapMissingTo());
        }
        NormDiscrete.Method method = normDiscrete.getMethod();
        switch (method) {
            case INDICATOR: {
                boolean equals = value.equals((HasValue<?>)normDiscrete);
                return equals ? FieldValues.CATEGORICAL_DOUBLE_ONE : FieldValues.CATEGORICAL_DOUBLE_ZERO;
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)normDiscrete, (Enum)method);
    }

    public static FieldValue evaluateDiscretize(Discretize discretize, EvaluationContext context) {
        FieldValue value = context.evaluate(discretize.requireField());
        if (FieldValueUtil.isMissing(value)) {
            return FieldValueUtil.create(OpType.CATEGORICAL, discretize.getDataType(DataType.STRING), discretize.getMapMissingTo());
        }
        return DiscretizationUtil.discretize(discretize, value);
    }

    public static FieldValue evaluateMapValues(MapValues mapValues, EvaluationContext context) {
        LinkedHashMap<String, FieldValue> values = new LinkedHashMap<String, FieldValue>();
        List fieldColumnPairs = mapValues.getFieldColumnPairs();
        int max = fieldColumnPairs.size();
        for (int i = 0; i < max; ++i) {
            FieldColumnPair fieldColumnPair = (FieldColumnPair)fieldColumnPairs.get(i);
            FieldValue value = context.evaluate(fieldColumnPair.requireField());
            if (FieldValueUtil.isMissing(value)) {
                return FieldValueUtil.create(OpType.CATEGORICAL, mapValues.getDataType(DataType.STRING), mapValues.getMapMissingTo());
            }
            values.put(fieldColumnPair.requireColumn(), value);
        }
        return DiscretizationUtil.mapValue(mapValues, values);
    }

    public static FieldValue evaluateTextIndex(TextIndex textIndex, EvaluationContext context) {
        FieldValue textValue = context.evaluate(textIndex.requireTextField());
        FieldValue termValue = ExpressionUtil.evaluateExpressionContainer(textIndex, context);
        if (FieldValueUtil.isMissing(textValue) || FieldValueUtil.isMissing(termValue)) {
            return FieldValues.MISSING_VALUE;
        }
        TextUtil.TextProcessor textProcessor = new TextUtil.TextProcessor(textIndex, textValue.asString());
        TokenizedString textTokens = textProcessor.process();
        TextUtil.TermProcessor termProcessor = new TextUtil.TermProcessor(textIndex, termValue.asString());
        TokenizedString termTokens = termProcessor.process();
        int termFrequency = TextUtil.termFrequency(textIndex, textTokens, termTokens);
        TextIndex.LocalTermWeights localTermWeights = textIndex.getLocalTermWeights();
        switch (localTermWeights) {
            case BINARY: 
            case TERM_FREQUENCY: {
                return FieldValueUtil.create(TypeInfos.CONTINUOUS_INTEGER, termFrequency);
            }
            case LOGARITHMIC: {
                return FieldValueUtil.create(TypeInfos.CONTINUOUS_DOUBLE, Math.log10(1.0 + (double)termFrequency));
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)textIndex, (Enum)localTermWeights);
    }

    public static FieldValue evaluateApply(Apply apply, EvaluationContext context) {
        FieldValue result;
        Object mapMissingTo = apply.getMapMissingTo();
        String function = apply.requireFunction();
        List expressions = apply.getExpressions();
        ArrayList<FieldValue> values = new ArrayList<FieldValue>(expressions.size());
        int max = expressions.size();
        if ("if".equals(function) && max > 0) {
            FieldValue flag = ExpressionUtil.evaluate((Expression)expressions.get(0), context);
            if (flag == null && mapMissingTo != null) {
                return FieldValueUtil.create(mapMissingTo);
            }
            values.add(flag);
            if (flag == null) {
                if (max > 1) {
                    values.add(FieldValues.MISSING_VALUE);
                    if (max > 2) {
                        values.add(FieldValues.MISSING_VALUE);
                    }
                }
            } else if (flag.asBoolean().booleanValue()) {
                if (max > 1) {
                    FieldValue trueValue = ExpressionUtil.evaluate((Expression)expressions.get(1), context);
                    if (FieldValueUtil.isMissing(trueValue) && mapMissingTo != null) {
                        return FieldValueUtil.create(mapMissingTo);
                    }
                    values.add(trueValue);
                    if (max > 2) {
                        values.add(FieldValues.MISSING_VALUE);
                    }
                }
            } else if (max > 1) {
                values.add(FieldValues.MISSING_VALUE);
                if (max > 2) {
                    FieldValue falseValue = ExpressionUtil.evaluate((Expression)expressions.get(2), context);
                    if (FieldValueUtil.isMissing(falseValue) && mapMissingTo != null) {
                        return FieldValueUtil.create(mapMissingTo);
                    }
                    values.add(falseValue);
                }
            }
        }
        for (int i = values.size(); i < max; ++i) {
            Expression expression = (Expression)expressions.get(i);
            FieldValue value = ExpressionUtil.evaluate(expression, context);
            if (FieldValueUtil.isMissing(value) && mapMissingTo != null) {
                return FieldValueUtil.create(mapMissingTo);
            }
            values.add(value);
        }
        Object defaultValue = apply.getDefaultValue();
        SymbolTable<String> symbolTable = EvaluationContext.FUNCTION_GUARD_PROVIDER.get();
        if (symbolTable != null) {
            symbolTable.lock(function);
        }
        try {
            result = ExpressionUtil.evaluateFunction(function, values, context);
        }
        catch (UndefinedResultException ure) {
            InvalidValueTreatmentMethod invalidValueTreatment = apply.getInvalidValueTreatment();
            switch (invalidValueTreatment) {
                case RETURN_INVALID: {
                    throw new EvaluationException("Function " + EvaluationException.formatName(function) + " failed", (PMMLObject)apply).initCause((Throwable)((Object)ure));
                }
                case AS_IS: {
                    throw ure;
                }
                case AS_MISSING: {
                    FieldValue fieldValue = FieldValueUtil.create(defaultValue);
                    return fieldValue;
                }
                case AS_VALUE: {
                    throw new InvalidAttributeException((PMMLObject)apply, (Enum)invalidValueTreatment);
                }
            }
            throw new UnsupportedAttributeException((PMMLObject)apply, (Enum)invalidValueTreatment);
        }
        finally {
            if (symbolTable != null) {
                symbolTable.release(function);
            }
        }
        if (FieldValueUtil.isMissing(result)) {
            if (defaultValue != null) {
                return FieldValueUtil.create(defaultValue);
            }
        } else if (FieldValueUtil.isInvalid(result)) {
            InvalidValueTreatmentMethod invalidValueTreatment = apply.getInvalidValueTreatment();
            switch (invalidValueTreatment) {
                case RETURN_INVALID: {
                    throw new EvaluationException("Function " + EvaluationException.formatName(function) + " returned invalid value", (PMMLObject)apply);
                }
                case AS_IS: {
                    return result;
                }
                case AS_MISSING: {
                    return FieldValueUtil.create(defaultValue);
                }
                case AS_VALUE: {
                    throw new InvalidAttributeException((PMMLObject)apply, (Enum)invalidValueTreatment);
                }
            }
            throw new UnsupportedAttributeException((PMMLObject)apply, (Enum)invalidValueTreatment);
        }
        return result;
    }

    private static FieldValue evaluateFunction(String name, List<FieldValue> values, EvaluationContext context) {
        Function function = FunctionRegistry.getFunction(name);
        if (function != null) {
            return function.evaluate(values);
        }
        DefineFunction defineFunction = context.getDefineFunction(name);
        if (defineFunction != null) {
            return ExpressionUtil.evaluate(defineFunction, values, context);
        }
        throw new EvaluationException("Function " + EvaluationException.formatName(name) + " is not defined");
    }

    public static FieldValue evaluateAggregate(Aggregate aggregate, EvaluationContext context) {
        FieldValue value = context.evaluate(aggregate.requireField());
        if (FieldValueUtil.isMissing(value)) {
            return FieldValues.MISSING_VALUE;
        }
        Collection<?> objects = value.asCollection();
        String groupName = aggregate.getGroupField();
        if (groupName != null) {
            FieldValue groupValue = context.evaluate(groupName);
            DataType dataType = TypeUtil.getDataType(FieldValueUtil.getValue(groupValue));
        }
        ArrayList<FieldValue> values = new ArrayList<FieldValue>(objects.size());
        for (Object object : objects) {
            if (FieldValueUtil.isMissing(object)) continue;
            values.add(FieldValueUtil.create(value, object));
        }
        Aggregate.Function function = aggregate.requireFunction();
        switch (function) {
            case COUNT: {
                return FieldValueUtil.create(TypeInfos.CONTINUOUS_INTEGER, values.size());
            }
            case SUM: {
                return Functions.SUM.evaluate(values);
            }
            case AVERAGE: {
                return Functions.AVG.evaluate(values);
            }
            case MIN: {
                return (FieldValue)Collections.min(values);
            }
            case MAX: {
                return (FieldValue)Collections.max(values);
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)aggregate, (Enum)function);
    }

    public static FieldValue evaluateLag(Lag lag, EvaluationContext context) {
        Integer n;
        List<String> blockIndicatorFields = Collections.emptyList();
        if (lag.hasBlockIndicators()) {
            List blockIndicators = lag.getBlockIndicators();
            blockIndicatorFields = new ArrayList(blockIndicators.size());
            for (int i = 0; i < blockIndicators.size(); ++i) {
                BlockIndicator blockIndicator = (BlockIndicator)blockIndicators.get(i);
                blockIndicatorFields.add(blockIndicator.requireField());
            }
        }
        if ((n = lag.getN()) < 1) {
            throw new InvalidAttributeException((PMMLObject)lag, PMMLAttributes.LAG_N, (Object)n);
        }
        Lag.Aggregate aggregate = lag.getAggregate();
        switch (aggregate) {
            case NONE: {
                return context.evaluateLagged(new LagKey(lag.requireField(), n, blockIndicatorFields));
            }
            case AVG: 
            case MAX: 
            case MEDIAN: 
            case MIN: 
            case PRODUCT: 
            case SUM: 
            case STDDEV: {
                return context.evaluateAggregated(new AggregateKey(lag.requireField(), aggregate.value(), n, blockIndicatorFields));
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)lag, (Enum)aggregate);
    }

    public static FieldValue evaluateJavaExpression(JavaExpression javaExpression, EvaluationContext context) {
        FieldValue value = javaExpression.evaluate(context);
        return value;
    }

    public static boolean isEmptyContent(Object value) {
        return value == null || "".equals(value);
    }
}

