/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.dmg.pmml.ParameterField;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.MissingFieldException;

public class DefineFunctionEvaluationContext
extends EvaluationContext {
    private DefineFunction defineFunction = null;
    private EvaluationContext parent = null;

    public DefineFunctionEvaluationContext(DefineFunction defineFunction, EvaluationContext parent) {
        this.setDefineFunction(defineFunction);
        this.setParent(parent);
    }

    @Override
    public FieldValue prepare(String name, Object value) {
        ParameterField parameterField = this.findParameterField(name);
        if (parameterField == null) {
            throw new MissingFieldException(name);
        }
        DataType dataType = parameterField.requireDataType();
        OpType opType = parameterField.requireOpType();
        return FieldValueUtil.create(opType, dataType, value);
    }

    @Override
    protected FieldValue resolve(String name) {
        DerivedField derivedField = this.findDerivedField(name);
        if (derivedField == null) {
            throw new MissingFieldException(name);
        }
        FieldValue value = ExpressionUtil.evaluate(derivedField, (EvaluationContext)this);
        return this.declareInternal(name, value);
    }

    @Override
    protected DefineFunction getDefineFunction(String name) {
        EvaluationContext parent = this.getParent();
        return parent.getDefineFunction(name);
    }

    private ParameterField findParameterField(String name) {
        DefineFunction defineFunction = this.getDefineFunction();
        if (defineFunction.hasParameterFields()) {
            return (ParameterField)DefineFunctionEvaluationContext.findField(name, defineFunction.getParameterFields());
        }
        return null;
    }

    private DerivedField findDerivedField(String name) {
        DefineFunction defineFunction = this.getDefineFunction();
        if (defineFunction.hasDerivedFields()) {
            return (DerivedField)DefineFunctionEvaluationContext.findField(name, defineFunction.getDerivedFields());
        }
        return null;
    }

    public DefineFunction getDefineFunction() {
        return this.defineFunction;
    }

    private void setDefineFunction(DefineFunction defineFunction) {
        this.defineFunction = Objects.requireNonNull(defineFunction);
    }

    public EvaluationContext getParent() {
        return this.parent;
    }

    private void setParent(EvaluationContext parent) {
        this.parent = Objects.requireNonNull(parent);
    }

    private static <F extends Field<?>> F findField(String name, List<F> fields) {
        int max = fields.size();
        for (int i = 0; i < max; ++i) {
            Field field = (Field)fields.get(i);
            if (!Objects.equals(field.requireName(), name)) continue;
            return (F)field;
        }
        return null;
    }
}

