/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collection;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.ScalarValue;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.evaluator.TypeUtil;

public class FieldValueUtil {
    private FieldValueUtil() {
    }

    public static FieldValue create(Object value) {
        DataType dataType;
        if (value == null) {
            return FieldValues.MISSING_VALUE;
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            dataType = TypeUtil.getDataType(values);
        } else {
            dataType = TypeUtil.getDataType(value);
        }
        OpType opType = TypeUtil.getOpType(dataType);
        return FieldValue.create(opType, dataType, value);
    }

    public static FieldValue create(OpType opType, DataType dataType, Object value) {
        if (value == null) {
            return FieldValues.MISSING_VALUE;
        }
        return FieldValue.create(opType, dataType, value);
    }

    public static FieldValue create(TypeInfo typeInfo, Object value) {
        if (value == null) {
            return FieldValues.MISSING_VALUE;
        }
        return FieldValue.create(typeInfo, value);
    }

    public static boolean isMissing(Object value) {
        return value == null;
    }

    public static boolean isMissing(FieldValue value) {
        return value == null;
    }

    public static boolean isInvalid(FieldValue value) {
        if (value instanceof ScalarValue) {
            ScalarValue scalarValue = (ScalarValue)value;
            return !scalarValue.isValid();
        }
        return false;
    }

    public static Object getValue(FieldValue value) {
        return value != null ? value.getValue() : null;
    }
}

