/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.RangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasContinuousDomain;
import org.dmg.pmml.HasDiscreteDomain;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethod;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.InputTypeInfo;
import org.jpmml.evaluator.NumberUtil;
import org.jpmml.evaluator.ScalarValue;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.ValueCheckException;
import org.jpmml.evaluator.ValueStatusHolder;
import org.jpmml.model.InvalidElementException;
import org.jpmml.model.UnsupportedAttributeException;

public class InputFieldUtil {
    private InputFieldUtil() {
    }

    public static boolean isDefault(Field<?> field, MiningField miningField) {
        if (field instanceof DataField ? !Objects.equals(field.getOpType(), FieldUtil.getOpType(field, miningField)) : !Objects.equals(miningField.getOpType(), null)) {
            return false;
        }
        Object invalidValueReplacement = miningField.getInvalidValueReplacement();
        if (invalidValueReplacement != null) {
            return false;
        }
        InvalidValueTreatmentMethod invalidValueTreatment = miningField.getInvalidValueTreatment();
        switch (invalidValueTreatment) {
            case RETURN_INVALID: 
            case AS_IS: {
                break;
            }
            default: {
                return false;
            }
        }
        Object missingValueReplacement = miningField.getMissingValueReplacement();
        if (missingValueReplacement != null) {
            return false;
        }
        OutlierTreatmentMethod outlierTreatment = miningField.getOutlierTreatment();
        switch (outlierTreatment) {
            case AS_IS: {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static FieldValue prepareInputValue(Field<?> field, MiningField miningField, Object value) {
        InputTypeInfo typeInfo = InputFieldUtil.getTypeInfo(field, miningField);
        if (value instanceof Collection) {
            Collection rawValues = (Collection)value;
            ArrayList<Object> pmmlValues = new ArrayList<Object>(rawValues.size());
            for (Object rawValue : rawValues) {
                ScalarValue fieldValue = InputFieldUtil.prepareScalarInputValue(typeInfo, rawValue);
                pmmlValues.add(FieldValueUtil.getValue(fieldValue));
            }
            return InputFieldUtil.createInputValue(typeInfo, pmmlValues);
        }
        return InputFieldUtil.prepareScalarInputValue(typeInfo, value);
    }

    public static FieldValue prepareResidualInputValue(DataField dataField, MiningField miningField, Object value) {
        return InputFieldUtil.prepareInputValue(dataField, miningField, value);
    }

    private static ScalarValue prepareScalarInputValue(InputTypeInfo typeInfo, Object value) {
        boolean compatible;
        if (FieldValueUtil.isMissing(value)) {
            return InputFieldUtil.performMissingValueTreatment(typeInfo);
        }
        try {
            value = InputFieldUtil.createInputValue(typeInfo, value);
            compatible = true;
        }
        catch (IllegalArgumentException | TypeCheckException e) {
            compatible = false;
        }
        int status = InputFieldUtil.getStatus(typeInfo, value, compatible);
        if (status > 0) {
            return InputFieldUtil.performValidValueTreatment(typeInfo, (ScalarValue)value);
        }
        if (status == 0) {
            return InputFieldUtil.performMissingValueTreatment(typeInfo);
        }
        if (status < 0) {
            return InputFieldUtil.performInvalidValueTreatment(typeInfo, value);
        }
        throw new IllegalArgumentException();
    }

    private static ScalarValue performValidValueTreatment(InputTypeInfo typeInfo, ScalarValue value) {
        MiningField miningField = typeInfo.getMiningField();
        OutlierTreatmentMethod outlierTreatment = miningField.getOutlierTreatment();
        switch (outlierTreatment) {
            case AS_IS: {
                return value;
            }
            case AS_MISSING_VALUES: 
            case AS_EXTREME_VALUES: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)miningField, (Enum)outlierTreatment);
            }
        }
        Number lowValue = miningField.getLowValue();
        Number highValue = miningField.getHighValue();
        if (lowValue == null && highValue == null) {
            throw new InvalidElementException((PMMLObject)miningField);
        }
        if (lowValue != null && highValue != null && NumberUtil.compare(lowValue, highValue) > 0) {
            throw new InvalidElementException((PMMLObject)miningField);
        }
        switch (outlierTreatment) {
            case AS_MISSING_VALUES: {
                if (lowValue != null && value.compareToValue(lowValue) < 0) {
                    return InputFieldUtil.createMissingInputValue(typeInfo);
                }
                if (highValue == null || value.compareToValue(highValue) <= 0) break;
                return InputFieldUtil.createMissingInputValue(typeInfo);
            }
            case AS_EXTREME_VALUES: {
                if (lowValue != null && value.compareToValue(lowValue) < 0) {
                    return (ScalarValue)InputFieldUtil.createInputValue(typeInfo, lowValue);
                }
                if (highValue == null || value.compareToValue(highValue) <= 0) break;
                return (ScalarValue)InputFieldUtil.createInputValue(typeInfo, highValue);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)miningField, (Enum)outlierTreatment);
            }
        }
        return value;
    }

    private static ScalarValue performInvalidValueTreatment(InputTypeInfo typeInfo, Object value) {
        MiningField miningField = typeInfo.getMiningField();
        InvalidValueTreatmentMethod invalidValueTreatment = miningField.getInvalidValueTreatment();
        switch (invalidValueTreatment) {
            case RETURN_INVALID: {
                Field<?> field = typeInfo.getField();
                throw new ValueCheckException("Field " + EvaluationException.formatName(field.getName()) + " cannot accept invalid value " + EvaluationException.formatValue(value), (PMMLObject)miningField);
            }
            case AS_IS: {
                return InputFieldUtil.createInvalidInputValue(typeInfo, value);
            }
            case AS_MISSING: {
                return InputFieldUtil.createMissingInputValue(typeInfo);
            }
            case AS_VALUE: {
                return InputFieldUtil.createInvalidInputValue(typeInfo, value);
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)miningField, (Enum)invalidValueTreatment);
    }

    private static ScalarValue performMissingValueTreatment(InputTypeInfo typeInfo) {
        MiningField miningField = typeInfo.getMiningField();
        MissingValueTreatmentMethod missingValueTreatment = miningField.getMissingValueTreatment();
        if (missingValueTreatment == null) {
            missingValueTreatment = MissingValueTreatmentMethod.AS_IS;
        }
        switch (missingValueTreatment) {
            case AS_IS: 
            case AS_MEAN: 
            case AS_MODE: 
            case AS_MEDIAN: 
            case AS_VALUE: {
                return InputFieldUtil.createMissingInputValue(typeInfo);
            }
            case RETURN_INVALID: {
                Field<?> field = typeInfo.getField();
                throw new ValueCheckException("Field " + EvaluationException.formatName(field.getName()) + " cannot accept missing value", (PMMLObject)miningField);
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)miningField, (Enum)missingValueTreatment);
    }

    private static Integer getStatus(InputTypeInfo typeInfo, Object value, boolean compatible) {
        HasContinuousDomain hasContinuousDomain;
        HasDiscreteDomain hasDiscreteDomain;
        Field<?> field = typeInfo.getField();
        if (field instanceof HasDiscreteDomain && (hasDiscreteDomain = (HasDiscreteDomain)field).hasValues()) {
            DataType dataType = typeInfo.getDataType();
            if (field instanceof ValueStatusHolder) {
                ValueStatusHolder valueStatusHolder = (ValueStatusHolder)field;
                if (compatible) {
                    FieldValue fieldValue = (FieldValue)value;
                    Integer index = (Integer)valueStatusHolder.get(fieldValue.getDataType(), fieldValue.getValue());
                    if (index != null) {
                        return index;
                    }
                    if (valueStatusHolder.hasValidValues()) {
                        return FieldValue.STATUS_UNKNOWN_INVALID;
                    }
                }
            }
            int validIndex = 0;
            List pmmlValues = hasDiscreteDomain.getValues();
            int max = pmmlValues.size();
            block11: for (int i = 0; i < max; ++i) {
                Value pmmlValue = (Value)pmmlValues.get(i);
                Object objectValue = pmmlValue.requireValue();
                Value.Property property = pmmlValue.getProperty();
                switch (property) {
                    case VALID: {
                        boolean equals;
                        FieldValue fieldValue;
                        ++validIndex;
                        if (!compatible) continue block11;
                        if (value instanceof FieldValue) {
                            fieldValue = (FieldValue)value;
                            equals = fieldValue.equalsValue(objectValue);
                        } else {
                            equals = TypeUtil.equals(dataType, value, objectValue);
                        }
                        if (!equals) continue block11;
                        return validIndex;
                    }
                    case INVALID: 
                    case MISSING: {
                        boolean equals;
                        FieldValue fieldValue;
                        if (value instanceof FieldValue) {
                            fieldValue = (FieldValue)value;
                            equals = TypeUtil.equals(dataType, fieldValue.getValue(), objectValue);
                        } else {
                            equals = TypeUtil.equals(dataType, value, objectValue);
                        }
                        if (!equals) continue block11;
                        switch (property) {
                            case INVALID: {
                                return FieldValue.STATUS_UNKNOWN_INVALID;
                            }
                            case MISSING: {
                                return FieldValue.STATUS_MISSING;
                            }
                        }
                        throw new UnsupportedAttributeException((PMMLObject)pmmlValue, (Enum)property);
                    }
                    default: {
                        throw new UnsupportedAttributeException((PMMLObject)pmmlValue, (Enum)property);
                    }
                }
            }
            if (validIndex > 0) {
                return FieldValue.STATUS_UNKNOWN_INVALID;
            }
        }
        if (!compatible) {
            return FieldValue.STATUS_UNKNOWN_INVALID;
        }
        if (field instanceof HasContinuousDomain && (hasContinuousDomain = (HasContinuousDomain)field).hasIntervals()) {
            OpType opType = typeInfo.getOpType();
            switch (opType) {
                case CONTINUOUS: {
                    break;
                }
                default: {
                    throw new InvalidElementException(field);
                }
            }
            RangeSet<Double> validRanges = FieldUtil.getValidRanges((Field)((HasContinuousDomain)field));
            if (!(value instanceof FieldValue)) {
                throw new IllegalArgumentException();
            }
            FieldValue fieldValue = (FieldValue)value;
            Double doubleValue = fieldValue.asDouble();
            if (!validRanges.contains((Comparable)doubleValue)) {
                return FieldValue.STATUS_UNKNOWN_INVALID;
            }
        }
        if (value instanceof FieldValue) {
            FieldValue fieldValue = (FieldValue)value;
            if (FieldValueUtil.isInvalid(fieldValue)) {
                return FieldValue.STATUS_UNKNOWN_INVALID;
            }
            return FieldValue.STATUS_UNKNOWN_VALID;
        }
        throw new IllegalArgumentException();
    }

    private static ScalarValue createInvalidInputValue(InputTypeInfo typeInfo, Object value) {
        MiningField miningField = typeInfo.getMiningField();
        Object invalidValueReplacement = miningField.getInvalidValueReplacement();
        if (invalidValueReplacement != null) {
            return (ScalarValue)InputFieldUtil.createInputValue(typeInfo, invalidValueReplacement);
        }
        ScalarValue scalarValue = (ScalarValue)InputFieldUtil.createInputValue(typeInfo, value);
        if (scalarValue.isValid()) {
            scalarValue.setValid(false);
        }
        return scalarValue;
    }

    private static ScalarValue createMissingInputValue(InputTypeInfo typeInfo) {
        MiningField miningField = typeInfo.getMiningField();
        Object missingValueReplacement = miningField.getMissingValueReplacement();
        if (missingValueReplacement != null) {
            return (ScalarValue)InputFieldUtil.createInputValue(typeInfo, missingValueReplacement);
        }
        return (ScalarValue)FieldValues.MISSING_VALUE;
    }

    private static FieldValue createInputValue(TypeInfo typeInfo, Object value) {
        if (value instanceof FieldValue) {
            FieldValue fieldValue = (FieldValue)value;
            return fieldValue.cast(typeInfo);
        }
        return FieldValueUtil.create(typeInfo, value);
    }

    private static InputTypeInfo getTypeInfo(final Field<?> field, final MiningField miningField) {
        InputTypeInfo typeInfo = new InputTypeInfo(){

            @Override
            public Field<?> getField() {
                return field;
            }

            @Override
            public MiningField getMiningField() {
                return miningField;
            }

            @Override
            public OpType getOpType() {
                return FieldUtil.getOpType(field, miningField);
            }

            @Override
            public DataType getDataType() {
                return FieldUtil.getDataType(field);
            }

            @Override
            public List<?> getOrdering() {
                List<?> ordering = null;
                if (field instanceof HasDiscreteDomain) {
                    ordering = FieldUtil.getValidValues((Field)((HasDiscreteDomain)field));
                }
                return ordering;
            }
        };
        return typeInfo;
    }
}

