/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Joiner;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.dmg.pmml.Value;
import org.dmg.pmml.association.AssociationRule;
import org.dmg.pmml.association.Item;
import org.dmg.pmml.association.ItemRef;
import org.dmg.pmml.association.Itemset;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.Functions;
import org.jpmml.evaluator.HasAffinity;
import org.jpmml.evaluator.HasAffinityRanking;
import org.jpmml.evaluator.HasConfidence;
import org.jpmml.evaluator.HasDisplayValue;
import org.jpmml.evaluator.HasEntityAffinity;
import org.jpmml.evaluator.HasEntityId;
import org.jpmml.evaluator.HasEntityIdRanking;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.HasPrediction;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.HasReasonCodeRanking;
import org.jpmml.evaluator.HasRuleValues;
import org.jpmml.evaluator.MapUtil;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.MissingFieldValueException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.NumberUtil;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.OutputFilter;
import org.jpmml.evaluator.Report;
import org.jpmml.evaluator.ReportUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetFieldUtil;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.mining.MiningModelEvaluationContext;
import org.jpmml.evaluator.mining.SegmentResult;
import org.jpmml.evaluator.mining.SegmentationlUtil;
import org.jpmml.model.InvalidAttributeException;
import org.jpmml.model.InvalidElementException;
import org.jpmml.model.MisplacedAttributeException;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.UnsupportedAttributeException;
import org.jpmml.model.UnsupportedElementException;

public class OutputUtil {
    private OutputUtil() {
    }

    public static Map<String, ?> evaluate(Map<String, ?> predictions, ModelEvaluationContext context) {
        ModelEvaluator<?> modelEvaluator = context.getModelEvaluator();
        Object model = modelEvaluator.getModel();
        Output output = model.getOutput();
        if (output == null || !output.hasOutputFields()) {
            return predictions;
        }
        LinkedHashMap<String, ?> result = MapUtil.ensureLinkedHashMap(predictions);
        OutputFilter outputFilter = modelEvaluator.ensureOutputFilter();
        List outputFields = output.getOutputFields();
        int max = outputFields.size();
        for (int i = 0; i < max; ++i) {
            Object name;
            Object value;
            SegmentResult segmentPredictions;
            String segmentId;
            boolean requireTargetValue;
            ResultFeature resultFeature;
            Object targetValue;
            String targetFieldName;
            OutputField outputField;
            block55: {
                block56: {
                    block54: {
                        outputField = (OutputField)outputFields.get(i);
                        targetFieldName = outputField.getTargetField();
                        targetValue = null;
                        resultFeature = outputField.getResultFeature();
                        switch (resultFeature) {
                            case TRANSFORMED_VALUE: 
                            case DECISION: 
                            case WARNING: {
                                requireTargetValue = false;
                                break;
                            }
                            default: {
                                requireTargetValue = true;
                            }
                        }
                        segmentId = outputField.getSegmentId();
                        if (segmentId == null) break block54;
                        if (!(model instanceof MiningModel)) {
                            throw new MisplacedAttributeException((PMMLObject)outputField, PMMLAttributes.OUTPUTFIELD_SEGMENTID, (Object)segmentId);
                        }
                        MiningModelEvaluationContext miningModelContext = (MiningModelEvaluationContext)context;
                        segmentPredictions = miningModelContext.getResult(segmentId);
                        if (segmentPredictions == null) continue;
                        if (requireTargetValue) {
                            if (targetFieldName != null) {
                                if (!segmentPredictions.containsKey(targetFieldName)) {
                                    throw new MissingFieldValueException(targetFieldName, (PMMLObject)outputField);
                                }
                                targetValue = segmentPredictions.get(targetFieldName);
                            } else {
                                targetValue = segmentPredictions.getTargetValue();
                            }
                        }
                        break block55;
                    }
                    segmentPredictions = null;
                    if (!requireTargetValue) break block55;
                    if (!(model instanceof MiningModel)) break block56;
                    MiningModel miningModel = (MiningModel)model;
                    switch (resultFeature) {
                        case ENTITY_ID: {
                            if (targetFieldName != null) {
                                throw new MisplacedAttributeException((PMMLObject)outputField, PMMLAttributes.OUTPUTFIELD_TARGETFIELD, (Object)targetFieldName);
                            }
                            targetValue = TypeUtil.cast(HasEntityId.class, predictions);
                            break block55;
                        }
                        default: {
                            Segmentation segmentation;
                            SegmentResult segmentResult;
                            if (targetFieldName != null || (segmentResult = SegmentationlUtil.asSegmentResult((segmentation = miningModel.requireSegmentation()).requireMultipleModelMethod(), predictions)) == null) break;
                            targetValue = segmentResult.getTargetValue();
                            break block55;
                        }
                    }
                }
                if (targetFieldName == null) {
                    targetFieldName = modelEvaluator.getTargetName();
                }
                if (!predictions.containsKey(targetFieldName)) {
                    throw new MissingFieldValueException(targetFieldName, (PMMLObject)outputField);
                }
                targetValue = predictions.get(targetFieldName);
            }
            if (requireTargetValue && targetValue == null) continue;
            block6 : switch (resultFeature) {
                case PREDICTED_VALUE: {
                    value = OutputUtil.getPredictedValue(targetValue);
                    break;
                }
                case PREDICTED_DISPLAY_VALUE: {
                    if (segmentId != null) {
                        throw new UnsupportedElementException((PMMLObject)outputField);
                    }
                    TargetField targetField = modelEvaluator.findTargetField(targetFieldName);
                    if (targetField == null) {
                        throw new MissingFieldException(targetFieldName, (PMMLObject)outputField);
                    }
                    value = OutputUtil.getPredictedDisplayValue(targetValue, targetField);
                    break;
                }
                case TRANSFORMED_VALUE: 
                case DECISION: {
                    if (segmentId != null) {
                        name = outputField.requireValue();
                        value = segmentPredictions.get(TypeUtil.format(name));
                        break;
                    }
                    value = FieldValueUtil.getValue(ExpressionUtil.evaluateExpressionContainer(outputField, context));
                    break;
                }
                case PROBABILITY: {
                    value = OutputUtil.getProbability(targetValue, outputField);
                    break;
                }
                case CONFIDENCE: {
                    if (targetValue instanceof HasRuleValues) {
                        value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.CONFIDENCE);
                        break;
                    }
                    value = OutputUtil.getConfidence(targetValue, outputField);
                    break;
                }
                case RESIDUAL: {
                    if (segmentId != null) {
                        throw new UnsupportedElementException((PMMLObject)outputField);
                    }
                    FieldValue expectedTargetValue = context.evaluate(targetFieldName);
                    if (FieldValueUtil.isMissing(expectedTargetValue)) {
                        throw new MissingFieldValueException(targetFieldName, (PMMLObject)outputField);
                    }
                    TargetField targetField = modelEvaluator.findTargetField(targetFieldName);
                    if (targetField == null) {
                        throw new MissingFieldException(targetFieldName, (PMMLObject)outputField);
                    }
                    OpType opType = targetField.getOpType();
                    switch (opType) {
                        case CONTINUOUS: {
                            value = OutputUtil.getContinuousResidual(targetValue, expectedTargetValue);
                            break block6;
                        }
                        case CATEGORICAL: 
                        case ORDINAL: {
                            value = OutputUtil.getDiscreteResidual(targetValue, expectedTargetValue);
                            break block6;
                        }
                    }
                    throw new InvalidElementException((PMMLObject)outputField);
                }
                case CLUSTER_ID: {
                    value = OutputUtil.getClusterId(targetValue);
                    break;
                }
                case ENTITY_ID: {
                    if (targetValue instanceof HasRuleValues) {
                        value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.RULE_ID);
                        break;
                    }
                    value = OutputUtil.getEntityId(targetValue, outputField);
                    break;
                }
                case AFFINITY: {
                    value = OutputUtil.getAffinity(targetValue, outputField);
                    break;
                }
                case CLUSTER_AFFINITY: 
                case ENTITY_AFFINITY: {
                    Object entityId = outputField.getValue();
                    if (entityId != null) {
                        value = OutputUtil.getAffinity(targetValue, outputField);
                        break;
                    }
                    value = OutputUtil.getEntityAffinity(targetValue);
                    break;
                }
                case REASON_CODE: {
                    value = OutputUtil.getReasonCode(targetValue, outputField);
                    break;
                }
                case RULE_VALUE: {
                    value = OutputUtil.getRuleValue(targetValue, outputField);
                    break;
                }
                case ANTECEDENT: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.ANTECEDENT);
                    break;
                }
                case CONSEQUENT: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.CONSEQUENT);
                    break;
                }
                case RULE: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.RULE);
                    break;
                }
                case RULE_ID: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.RULE_ID);
                    break;
                }
                case SUPPORT: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.SUPPORT);
                    break;
                }
                case LIFT: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.LIFT);
                    break;
                }
                case LEVERAGE: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.LEVERAGE);
                    break;
                }
                case REPORT: {
                    String reportFieldName = outputField.getReportField();
                    if (reportFieldName == null) {
                        throw new MissingAttributeException((PMMLObject)outputField, PMMLAttributes.OUTPUTFIELD_REPORTFIELD);
                    }
                    OutputField reportOutputField = modelEvaluator.getOutputField(reportFieldName);
                    if (reportOutputField == null) {
                        throw new MissingFieldException(reportFieldName);
                    }
                    value = OutputUtil.getReport(targetValue, reportOutputField);
                    break;
                }
                case WARNING: {
                    value = context.getWarnings();
                    break;
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)outputField, (Enum)resultFeature);
                }
            }
            name = outputField.requireName();
            TypeInfo typeInfo = new TypeInfo(){

                @Override
                public OpType getOpType() {
                    OpType opType = outputField.getOpType();
                    if (opType == null) {
                        DataType dataType = this.getDataType();
                        opType = TypeUtil.getOpType(dataType);
                    }
                    return opType;
                }

                @Override
                public DataType getDataType() {
                    DataType dataType = outputField.getDataType();
                    if (dataType == null) {
                        if (value instanceof Collection) {
                            Collection values = (Collection)value;
                            dataType = TypeUtil.getDataType(values);
                        } else {
                            dataType = TypeUtil.getDataType(value);
                        }
                    }
                    return dataType;
                }

                @Override
                public List<?> getOrdering() {
                    List<?> ordering = FieldUtil.getValidValues(outputField);
                    return ordering;
                }
            };
            FieldValue outputValue = FieldValueUtil.create(typeInfo, value);
            context.declareInternal(name, outputValue);
            if (!outputFilter.test(outputField)) continue;
            result.put((String)name, FieldValueUtil.getValue(outputValue));
        }
        return result;
    }

    private static Object getPredictedValue(Object object) {
        return EvaluatorUtil.decode(object);
    }

    private static Object getPredictedDisplayValue(Object object, TargetField targetField) {
        String displayValue;
        TargetValue targetValue;
        if (object instanceof HasDisplayValue) {
            HasDisplayValue hasDisplayValue = TypeUtil.cast(HasDisplayValue.class, object);
            return hasDisplayValue.getDisplayValue();
        }
        object = OutputUtil.getPredictedValue(object);
        Target target = targetField.getTarget();
        if (target != null && (targetValue = TargetUtil.getTargetValue(target, object)) != null && (displayValue = targetValue.getDisplayValue()) != null) {
            return displayValue;
        }
        DataField dataField = targetField.getField();
        OpType opType = targetField.getOpType();
        switch (opType) {
            case CONTINUOUS: {
                break;
            }
            case CATEGORICAL: 
            case ORDINAL: {
                String displayValue2;
                Value value = TargetFieldUtil.getValidValue(dataField, object);
                if (value == null || (displayValue2 = value.getDisplayValue()) == null) break;
                return displayValue2;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)dataField, (Enum)opType);
            }
        }
        return object;
    }

    private static Double getProbability(Object object, OutputField outputField) {
        HasProbability hasProbability = TypeUtil.cast(HasProbability.class, object);
        Object value = OutputUtil.getCategoryValue(object, outputField);
        return hasProbability.getProbability(value);
    }

    private static Double getConfidence(Object object, OutputField outputField) {
        HasConfidence hasConfidence = TypeUtil.cast(HasConfidence.class, object);
        Object value = OutputUtil.getCategoryValue(object, outputField);
        return hasConfidence.getConfidence(value);
    }

    private static Object getCategoryValue(Object object, OutputField outputField) {
        Object value = outputField.getValue();
        if (value == null) {
            return OutputUtil.getPredictedValue(object);
        }
        return value;
    }

    private static Number getContinuousResidual(Object value, FieldValue expectedValue) {
        value = OutputUtil.getPredictedValue(value);
        return Functions.SUBTRACT.evaluate(expectedValue.asNumber(), (Number)value);
    }

    public static Number getDiscreteResidual(Object value, FieldValue expectedValue) {
        HasProbability hasProbability = TypeUtil.cast(HasProbability.class, value);
        boolean equals = expectedValue.equalsValue(value = OutputUtil.getPredictedValue(value));
        return Functions.SUBTRACT.evaluate(equals ? Numbers.DOUBLE_ONE : Numbers.DOUBLE_ZERO, hasProbability.getProbability(value));
    }

    private static String getClusterId(Object object) {
        HasEntityId hasEntityId = TypeUtil.cast(HasEntityId.class, object);
        return hasEntityId.getEntityId();
    }

    private static String getEntityId(Object object, OutputField outputField) {
        HasEntityId hasEntityId = TypeUtil.cast(HasEntityId.class, object);
        int rank = outputField.getRank();
        if (rank <= 0) {
            throw new InvalidAttributeException((PMMLObject)outputField, PMMLAttributes.OUTPUTFIELD_RANK, (Object)rank);
        }
        if (rank > 1) {
            HasEntityIdRanking hasEntityIdRanking = TypeUtil.cast(HasEntityIdRanking.class, object);
            OutputField.RankOrder rankOrder = outputField.getRankOrder();
            switch (rankOrder) {
                case DESCENDING: {
                    break;
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)outputField, (Enum)rankOrder);
                }
            }
            return OutputUtil.getElement(hasEntityIdRanking.getEntityIdRanking(), rank);
        }
        return hasEntityId.getEntityId();
    }

    public static Double getAffinity(Object object, OutputField outputField) {
        HasAffinity hasAffinity = TypeUtil.cast(HasAffinity.class, object);
        int rank = outputField.getRank();
        if (rank <= 0) {
            throw new InvalidAttributeException((PMMLObject)outputField, PMMLAttributes.OUTPUTFIELD_RANK, (Object)rank);
        }
        if (rank > 1) {
            HasAffinityRanking hasAffinityRanking = TypeUtil.cast(HasAffinityRanking.class, object);
            OutputField.RankOrder rankOrder = outputField.getRankOrder();
            switch (rankOrder) {
                case DESCENDING: {
                    break;
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)outputField, (Enum)rankOrder);
                }
            }
            return OutputUtil.getElement(hasAffinityRanking.getAffinityRanking(), rank);
        }
        Object value = OutputUtil.getCategoryValue(object, outputField);
        return hasAffinity.getAffinity(TypeUtil.format(value));
    }

    public static Double getEntityAffinity(Object object) {
        HasEntityAffinity hasEntityAffinity = TypeUtil.cast(HasEntityAffinity.class, object);
        return hasEntityAffinity.getEntityAffinity();
    }

    public static String getReasonCode(Object object, OutputField outputField) {
        HasReasonCodeRanking hasReasonCodeRanking = TypeUtil.cast(HasReasonCodeRanking.class, object);
        int rank = outputField.getRank();
        if (rank <= 0) {
            throw new InvalidAttributeException((PMMLObject)outputField, PMMLAttributes.OUTPUTFIELD_RANK, (Object)rank);
        }
        return OutputUtil.getElement(hasReasonCodeRanking.getReasonCodeRanking(), rank);
    }

    public static Object getRuleValue(Object object, OutputField outputField) {
        return OutputUtil.getRuleValue(object, outputField, outputField.getRuleFeature());
    }

    public static Object getRuleValue(Object object, OutputField outputField, OutputField.RuleFeature ruleFeature) {
        HasRuleValues hasRuleValues = TypeUtil.cast(HasRuleValues.class, object);
        List<AssociationRule> associationRules = OutputUtil.getRuleValues(hasRuleValues, outputField);
        OutputField.MultiValued multiValued = outputField.getMultiValued();
        switch (multiValued) {
            case ZERO: {
                int rank = outputField.getRank();
                if (rank <= 0) {
                    throw new InvalidAttributeException((PMMLObject)outputField, PMMLAttributes.OUTPUTFIELD_RANK, (Object)rank);
                }
                AssociationRule associationRule = OutputUtil.getElement(associationRules, rank);
                if (associationRule != null) {
                    return OutputUtil.getRuleFeature(hasRuleValues, associationRule, outputField, ruleFeature);
                }
                return null;
            }
            case ONE: {
                int rank = outputField.getRank();
                if (rank < 0) {
                    throw new InvalidAttributeException((PMMLObject)outputField, PMMLAttributes.OUTPUTFIELD_RANK, (Object)rank);
                }
                int size = rank == 0 ? associationRules.size() : Math.min(rank, associationRules.size());
                associationRules = associationRules.subList(0, size);
                ArrayList<Object> result = new ArrayList<Object>(associationRules.size());
                for (AssociationRule associationRule : associationRules) {
                    result.add(OutputUtil.getRuleFeature(hasRuleValues, associationRule, outputField, ruleFeature));
                }
                return result;
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)outputField, (Enum)multiValued);
    }

    public static String getReport(Object object, OutputField outputField) {
        Report report = null;
        ResultFeature resultFeature = outputField.getResultFeature();
        switch (resultFeature) {
            case PREDICTED_VALUE: {
                HasPrediction hasPrediction;
                try {
                    hasPrediction = TypeUtil.cast(HasPrediction.class, object);
                }
                catch (TypeCheckException tce) {
                    return null;
                }
                report = hasPrediction.getPredictionReport();
                break;
            }
            case PROBABILITY: {
                HasProbability hasProbability = TypeUtil.cast(HasProbability.class, object);
                Object value = OutputUtil.getCategoryValue(object, outputField);
                report = hasProbability.getProbabilityReport(value);
                break;
            }
            case CONFIDENCE: {
                HasConfidence hasConfidence = TypeUtil.cast(HasConfidence.class, object);
                Object value = OutputUtil.getCategoryValue(object, outputField);
                report = hasConfidence.getConfidenceReport(value);
                break;
            }
            case AFFINITY: {
                HasAffinity hasAffinity = TypeUtil.cast(HasAffinity.class, object);
                Object value = OutputUtil.getCategoryValue(object, outputField);
                report = hasAffinity.getAffinityReport(TypeUtil.format(value));
                break;
            }
        }
        return ReportUtil.format(report);
    }

    private static List<AssociationRule> getRuleValues(HasRuleValues hasRuleValues, final OutputField outputField) {
        List<AssociationRule> associationRules;
        OutputField.Algorithm algorithm = outputField.getAlgorithm();
        switch (algorithm) {
            case RECOMMENDATION: 
            case EXCLUSIVE_RECOMMENDATION: 
            case RULE_ASSOCIATION: {
                associationRules = hasRuleValues.getRuleValues(algorithm);
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)outputField, (Enum)algorithm);
            }
        }
        Comparator<AssociationRule> comparator = new Comparator<AssociationRule>(){
            private OutputField.RankBasis rankBasis;
            private OutputField.RankOrder rankOrder;
            {
                this.rankBasis = outputField.getRankBasis();
                this.rankOrder = outputField.getRankOrder();
            }

            @Override
            public int compare(AssociationRule left, AssociationRule right) {
                Number rightValue;
                Number leftValue;
                switch (this.rankBasis) {
                    case CONFIDENCE: {
                        leftValue = left.requireConfidence();
                        rightValue = right.requireConfidence();
                        break;
                    }
                    case SUPPORT: {
                        leftValue = left.requireSupport();
                        rightValue = right.requireSupport();
                        break;
                    }
                    case LIFT: {
                        leftValue = left.requireLift();
                        rightValue = right.requireLift();
                        break;
                    }
                    case LEVERAGE: {
                        leftValue = left.requireLeverage();
                        rightValue = right.requireLeverage();
                        break;
                    }
                    case AFFINITY: {
                        leftValue = left.requireAffinity();
                        rightValue = right.requireAffinity();
                        break;
                    }
                    default: {
                        throw new UnsupportedAttributeException((PMMLObject)outputField, (Enum)this.rankBasis);
                    }
                }
                int order = NumberUtil.compare(leftValue, rightValue);
                switch (this.rankOrder) {
                    case ASCENDING: {
                        return order;
                    }
                    case DESCENDING: {
                        return -order;
                    }
                }
                throw new UnsupportedAttributeException((PMMLObject)outputField, (Enum)this.rankOrder);
            }
        };
        Ordering ordering = Ordering.from((Comparator)comparator);
        return ordering.sortedCopy(associationRules);
    }

    private static Object getRuleFeature(HasRuleValues hasRuleValues, AssociationRule associationRule, OutputField outputField, OutputField.RuleFeature ruleFeature) {
        switch (ruleFeature) {
            case ANTECEDENT: {
                return OutputUtil.getItemValues(hasRuleValues, associationRule.getAntecedent());
            }
            case CONSEQUENT: {
                return OutputUtil.getItemValues(hasRuleValues, associationRule.getConsequent());
            }
            case RULE: {
                Joiner joiner = Joiner.on((char)',');
                StringBuilder sb = new StringBuilder();
                String left = joiner.join(OutputUtil.getItemValues(hasRuleValues, associationRule.getAntecedent()));
                sb.append('{').append(left).append('}');
                sb.append("->");
                String right = joiner.join(OutputUtil.getItemValues(hasRuleValues, associationRule.getConsequent()));
                sb.append('{').append(right).append('}');
                return sb.toString();
            }
            case RULE_ID: {
                HasEntityRegistry hasEntityRegistry = (HasEntityRegistry)((Object)hasRuleValues);
                return EntityUtil.getId(associationRule, hasEntityRegistry);
            }
            case CONFIDENCE: {
                return associationRule.getConfidence();
            }
            case SUPPORT: {
                return associationRule.getSupport();
            }
            case LIFT: {
                return associationRule.getLift();
            }
            case LEVERAGE: {
                return associationRule.getLeverage();
            }
            case AFFINITY: {
                return associationRule.getAffinity();
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)outputField, (Enum)ruleFeature);
    }

    private static List<String> getItemValues(HasRuleValues hasRuleValues, String id) {
        Map<String, Item> items = hasRuleValues.getItems();
        Map<String, Itemset> itemsets = hasRuleValues.getItemsets();
        Itemset itemset = itemsets.get(id);
        List itemRefs = itemset.getItemRefs();
        ArrayList<String> result = new ArrayList<String>(itemRefs.size());
        int max = itemRefs.size();
        for (int i = 0; i < max; ++i) {
            ItemRef itemRef = (ItemRef)itemRefs.get(i);
            Item item = items.get(itemRef.requireItemRef());
            result.add(item.getValue());
        }
        return result;
    }

    private static <E> E getElement(List<E> elements, int rank) {
        int index = rank - 1;
        if (index < elements.size()) {
            return elements.get(index);
        }
        return null;
    }
}

