/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Interner;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.InternerUtil;

public class RegExUtil {
    private static final Interner<CompilationTask> INTERNER = InternerUtil.buildInterner();
    private static final LoadingCache<CompilationTask, Pattern> patternCache = CacheUtil.buildLoadingCache(new CacheLoader<CompilationTask, Pattern>(){

        public Pattern load(CompilationTask compilationTask) {
            return compilationTask.call();
        }
    });

    private RegExUtil() {
    }

    public static Pattern compile(String regex, PMMLObject context) {
        return RegExUtil.compile(regex, 0, context);
    }

    public static Pattern compile(String regex, int flags, PMMLObject context) {
        CompilationTask compilationTask = new CompilationTask(regex, flags);
        compilationTask = (CompilationTask)INTERNER.intern((Object)compilationTask);
        try {
            return (Pattern)patternCache.get((Object)compilationTask);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            String message = "Regex pattern could not be compiled";
            throw new EvaluationException(message, context).initCause(e.getCause());
        }
    }

    private static class CompilationTask {
        private String regex = null;
        private int flags = 0;

        private CompilationTask(String regex, int flags) {
            this.setRegEx(regex);
            this.setFlags(flags);
        }

        public Pattern call() throws PatternSyntaxException {
            String regex = this.getRegEx();
            int flags = this.getFlags();
            return Pattern.compile(regex, flags);
        }

        public int hashCode() {
            return 31 * this.getRegEx().hashCode() + this.getFlags();
        }

        public boolean equals(Object object) {
            if (object instanceof CompilationTask) {
                CompilationTask that = (CompilationTask)object;
                return Objects.equals(this.getRegEx(), that.getRegEx()) && this.getFlags() == that.getFlags();
            }
            return false;
        }

        public String getRegEx() {
            return this.regex;
        }

        private void setRegEx(String regex) {
            this.regex = Objects.requireNonNull(regex);
        }

        public int getFlags() {
            return this.flags;
        }

        private void setFlags(int flags) {
            this.flags = flags;
        }
    }
}

