/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ImmutableMap;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.ValueStatusHolder;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.model.UnsupportedAttributeException;
import org.jpmml.model.annotations.CopyConstructor;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

public class RichDataField
extends DataField
implements ValueStatusHolder {
    @XmlTransient
    private Map<?, Integer> valueMap = null;
    @XmlTransient
    private boolean hasValidValues = false;

    public RichDataField() {
    }

    @CopyConstructor
    public RichDataField(DataField dataField) {
        ReflectionUtil.copyState((PMMLObject)dataField, (PMMLObject)this);
    }

    @ValueConstructor
    public RichDataField(@Property(value="name") String name, @Property(value="opType") OpType opType, @Property(value="dataType") DataType dataType) {
        super(name, opType, dataType);
    }

    @Override
    public Map<?, Integer> getMap() {
        if (this.valueMap == null) {
            this.valueMap = ImmutableMap.copyOf(this.parseValues());
        }
        return this.valueMap;
    }

    @Override
    public boolean hasValidValues() {
        return this.hasValidValues;
    }

    private Map<Object, Integer> parseValues() {
        DataType dataType = this.requireDataType();
        LinkedHashMap<Object, Integer> result = new LinkedHashMap<Object, Integer>();
        int validIndex = 0;
        List pmmlValues = this.getValues();
        block9: for (Value pmmlValue : pmmlValues) {
            Object objectValue = pmmlValue.requireValue();
            Value.Property property = pmmlValue.getProperty();
            switch (property) {
                case VALID: {
                    Object value = TypeUtil.parseOrCast(dataType, objectValue);
                    result.put(value, ++validIndex);
                    continue block9;
                }
                case INVALID: {
                    Object value;
                    try {
                        value = TypeUtil.parseOrCast(dataType, objectValue);
                    }
                    catch (IllegalArgumentException | TypeCheckException e) {
                        continue block9;
                    }
                    result.put(value, FieldValue.STATUS_UNKNOWN_INVALID);
                    continue block9;
                }
                case MISSING: {
                    Object value;
                    try {
                        value = TypeUtil.parseOrCast(dataType, objectValue);
                    }
                    catch (IllegalArgumentException | TypeCheckException e) {
                        continue block9;
                    }
                    result.put(value, FieldValue.STATUS_MISSING);
                    continue block9;
                }
            }
            throw new UnsupportedAttributeException((PMMLObject)pmmlValue, (Enum)property);
        }
        this.hasValidValues = validIndex > 0;
        return result;
    }
}

