/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.AbstractCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class SimpleCache<K, V>
extends AbstractCache<K, V> {
    private Map<K, V> cache = new HashMap();

    private SimpleCache() {
    }

    public V get(K key, Callable<? extends V> callable) throws ExecutionException {
        V value = this.cache.get(key);
        if (value == null) {
            try {
                value = callable.call();
            }
            catch (RuntimeException re) {
                throw new UncheckedExecutionException((Throwable)re);
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
            this.cache.put(key, value);
        }
        return value;
    }

    public V getIfPresent(Object key) {
        return this.cache.get(key);
    }

    public void invalidate(Object key) {
        this.cache.remove(key);
    }

    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    public static <K, V> SimpleCache<K, V> newInstance() {
        return new SimpleCache<K, V>();
    }
}

