/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.AbstractLoadingCache;
import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class SimpleLoadingCache<K, V>
extends AbstractLoadingCache<K, V> {
    private Map<K, V> cache = new HashMap();
    private CacheLoader<K, ? extends V> cacheLoader = null;

    private SimpleLoadingCache(CacheLoader<K, V> cacheLoader) {
        this.cacheLoader = Objects.requireNonNull(cacheLoader);
    }

    public V get(Object key) throws ExecutionException {
        return (V)this.get(key, () -> this.cacheLoader.load(key));
    }

    public V get(K key, Callable<? extends V> callable) throws ExecutionException {
        V value = this.cache.get(key);
        if (value == null) {
            try {
                value = callable.call();
            }
            catch (RuntimeException re) {
                throw new UncheckedExecutionException((Throwable)re);
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
            this.cache.put(key, value);
        }
        return value;
    }

    public V getIfPresent(Object key) {
        return this.cache.get(key);
    }

    public void invalidate(Object key) {
        this.cache.remove(key);
    }

    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    public static <K, V> SimpleLoadingCache<K, V> newInstance(CacheLoader<K, V> cacheLoader) {
        return new SimpleLoadingCache<K, V>(cacheLoader);
    }
}

