/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.regression;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.regression.PMMLAttributes;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.regression.RegressionTableUtil;
import org.jpmml.model.InvalidAttributeException;
import org.jpmml.model.InvalidElementException;

public class RegressionModelEvaluator
extends ModelEvaluator<RegressionModel> {
    private RegressionModelEvaluator() {
    }

    public RegressionModelEvaluator(PMML pmml) {
        this(pmml, PMMLUtil.findModel(pmml, RegressionModel.class));
    }

    public RegressionModelEvaluator(PMML pmml, RegressionModel regressionModel) {
        super(pmml, regressionModel);
        List regressionTables = regressionModel.requireRegressionTables();
    }

    @Override
    public String getSummary() {
        return "Regression";
    }

    @Override
    protected <V extends Number> Map<String, ?> evaluateRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        RegressionModel regressionModel = (RegressionModel)this.getModel();
        TargetField targetField = this.getTargetField();
        String targetFieldName = regressionModel.getTargetField();
        if (targetFieldName != null && !Objects.equals(targetField.getName(), targetFieldName)) {
            throw new InvalidAttributeException((PMMLObject)regressionModel, PMMLAttributes.REGRESSIONMODEL_TARGETFIELD, (Object)targetFieldName);
        }
        Value<V> value = RegressionTableUtil.evaluateRegression(valueFactory, regressionModel, context);
        if (value == null) {
            return TargetUtil.evaluateRegressionDefault(valueFactory, targetField);
        }
        return TargetUtil.evaluateRegression(targetField, value);
    }

    @Override
    protected <V extends Number> Map<String, ? extends Classification<?, V>> evaluateClassification(ValueFactory<V> valueFactory, EvaluationContext context) {
        RegressionModel regressionModel = (RegressionModel)this.getModel();
        TargetField targetField = this.getTargetField();
        String targetFieldName = regressionModel.getTargetField();
        if (targetFieldName != null && !Objects.equals(targetField.getName(), targetFieldName)) {
            throw new InvalidAttributeException((PMMLObject)regressionModel, PMMLAttributes.REGRESSIONMODEL_TARGETFIELD, (Object)targetFieldName);
        }
        OpType opType = targetField.getOpType();
        switch (opType) {
            case CATEGORICAL: 
            case ORDINAL: {
                break;
            }
            default: {
                throw new InvalidElementException((PMMLObject)regressionModel);
            }
        }
        List<Object> targetCategories = targetField.getCategories();
        ValueMap<Object, V> values = RegressionTableUtil.evaluateClassification(valueFactory, regressionModel, opType, targetCategories, context);
        if (values == null) {
            return TargetUtil.evaluateClassificationDefault(valueFactory, targetField);
        }
        Classification<Object, V> result = this.createClassification(values);
        return TargetUtil.evaluateClassification(targetField, result);
    }
}

