/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import java.util.List;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.ResultField;
import org.dmg.pmml.TableLocator;
import org.dmg.pmml.Targets;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.baseline.BaselineModel;
import org.dmg.pmml.bayesian_network.BayesianNetworkModel;
import org.dmg.pmml.clustering.CenterFields;
import org.dmg.pmml.clustering.ClusteringModel;
import org.dmg.pmml.gaussian_process.GaussianProcessModel;
import org.dmg.pmml.general_regression.Categories;
import org.dmg.pmml.general_regression.Predictor;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.sequence.SequenceModel;
import org.dmg.pmml.support_vector_machine.PMMLAttributes;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.dmg.pmml.text.TextModel;
import org.dmg.pmml.time_series.ARIMA;
import org.dmg.pmml.time_series.DynamicRegressor;
import org.dmg.pmml.time_series.ExponentialSmoothing;
import org.dmg.pmml.time_series.GARCH;
import org.dmg.pmml.time_series.SeasonalTrendDecomposition;
import org.dmg.pmml.time_series.SpectralAnalysis;
import org.dmg.pmml.tree.DecisionTree;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.model.MarkupException;
import org.jpmml.model.UnsupportedAttributeException;
import org.jpmml.model.UnsupportedElementException;
import org.jpmml.model.UnsupportedElementListException;
import org.jpmml.model.UnsupportedMarkupException;
import org.jpmml.model.visitors.MarkupInspector;

public class UnsupportedMarkupInspector
extends MarkupInspector<UnsupportedMarkupException> {
    public VisitorAction visit(Aggregate aggregate) {
        Aggregate.Function function = aggregate.getFunction();
        switch (function) {
            case MULTISET: {
                this.report((MarkupException)new UnsupportedAttributeException((PMMLObject)aggregate, (Enum)function));
                break;
            }
        }
        return super.visit(aggregate);
    }

    public VisitorAction visit(Apply apply) {
        String function;
        switch (function = apply.requireFunction()) {
            case "erf": 
            case "normalCDF": 
            case "normalIDF": 
            case "normalPDF": 
            case "stdNormalCDF": 
            case "stdNormalIDF": 
            case "stdNormalPDF": {
                this.report((MarkupException)new UnsupportedAttributeException((PMMLObject)apply, org.dmg.pmml.PMMLAttributes.APPLY_FUNCTION, (Object)function));
                break;
            }
        }
        return super.visit(apply);
    }

    public VisitorAction visit(ARIMA arima) {
        this.report((MarkupException)new UnsupportedElementException((PMMLObject)arima));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(BaselineModel baselineModel) {
        this.report((MarkupException)new UnsupportedElementException((PMMLObject)baselineModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(BayesianNetworkModel bayesianNetworkModel) {
        this.report((MarkupException)new UnsupportedElementException((PMMLObject)bayesianNetworkModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(CenterFields centerFields) {
        this.report((MarkupException)new UnsupportedElementException((PMMLObject)centerFields));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(ClusteringModel clusteringModel) {
        ClusteringModel.ModelClass modelClass = clusteringModel.getModelClass();
        switch (modelClass) {
            case DISTRIBUTION_BASED: {
                this.report((MarkupException)new UnsupportedAttributeException((PMMLObject)clusteringModel, (Enum)modelClass));
                break;
            }
        }
        return super.visit(clusteringModel);
    }

    public VisitorAction visit(DecisionTree decisionTree) {
        this.report((MarkupException)new UnsupportedElementException((PMMLObject)decisionTree));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(DynamicRegressor dynamicRegressor) {
        this.report((MarkupException)new UnsupportedElementException((PMMLObject)dynamicRegressor));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(EmbeddedModel embeddedModel) {
        LocalTransformations localTransformations = embeddedModel.getLocalTransformations();
        Targets targets = embeddedModel.getTargets();
        Output output = embeddedModel.getOutput();
        if (localTransformations != null && localTransformations.hasDerivedFields()) {
            this.report((MarkupException)new UnsupportedElementException((PMMLObject)localTransformations));
        }
        if (targets != null && targets.hasTargets()) {
            this.report((MarkupException)new UnsupportedElementException((PMMLObject)targets));
        }
        if (output != null && output.hasOutputFields()) {
            this.report((MarkupException)new UnsupportedElementException((PMMLObject)output));
        }
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(ExponentialSmoothing exponentialSmooting) {
        this.report((MarkupException)new UnsupportedElementException((PMMLObject)exponentialSmooting));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(GARCH garch) {
        this.report((MarkupException)new UnsupportedElementException((PMMLObject)garch));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(GaussianProcessModel gaussianProcessModel) {
        this.report((MarkupException)new UnsupportedElementException((PMMLObject)gaussianProcessModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(MiningModel miningModel) {
        if (miningModel.hasEmbeddedModels()) {
            List embeddedModels = miningModel.getEmbeddedModels();
            this.report((MarkupException)new UnsupportedElementListException(embeddedModels));
        }
        return super.visit(miningModel);
    }

    public VisitorAction visit(NormDiscrete normDiscrete) {
        NormDiscrete.Method method = normDiscrete.getMethod();
        switch (method) {
            case THERMOMETER: {
                this.report((MarkupException)new UnsupportedAttributeException((PMMLObject)normDiscrete, (Enum)method));
                break;
            }
        }
        return super.visit(normDiscrete);
    }

    public VisitorAction visit(OutputField outputField) {
        ResultFeature resultFeature = outputField.getResultFeature();
        switch (resultFeature) {
            case STANDARD_ERROR: {
                this.report((MarkupException)new UnsupportedAttributeException((PMMLObject)outputField, (Enum)resultFeature));
                break;
            }
        }
        return super.visit(outputField);
    }

    public VisitorAction visit(Predictor predictor) {
        Categories categories;
        Matrix matrix = predictor.getMatrix();
        if (matrix != null && (categories = predictor.getCategories()) == null) {
            this.report((MarkupException)new UnsupportedElementException((PMMLObject)predictor));
        }
        return super.visit(predictor);
    }

    public VisitorAction visit(ResultField resultField) {
        this.report((MarkupException)new UnsupportedElementException((PMMLObject)resultField));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(SeasonalTrendDecomposition seasonalTrendDecomposition) {
        this.report((MarkupException)new UnsupportedElementException((PMMLObject)seasonalTrendDecomposition));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(Segmentation segmentation) {
        LocalTransformations localTransformations = segmentation.getLocalTransformations();
        if (localTransformations != null && localTransformations.hasDerivedFields()) {
            this.report((MarkupException)new UnsupportedElementException((PMMLObject)localTransformations));
        }
        return super.visit(segmentation);
    }

    public VisitorAction visit(SequenceModel sequenceModel) {
        this.report((MarkupException)new UnsupportedElementException((PMMLObject)sequenceModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(SpectralAnalysis spectralAnalysis) {
        this.report((MarkupException)new UnsupportedElementException((PMMLObject)spectralAnalysis));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(SupportVectorMachineModel supportVectorMachineModel) {
        boolean maxWins = supportVectorMachineModel.isMaxWins();
        if (maxWins) {
            this.report((MarkupException)new UnsupportedAttributeException((PMMLObject)supportVectorMachineModel, PMMLAttributes.SUPPORTVECTORMACHINEMODEL_MAXWINS, (Object)true));
        }
        SupportVectorMachineModel.Representation representation = supportVectorMachineModel.getRepresentation();
        switch (representation) {
            case COEFFICIENTS: {
                this.report((MarkupException)new UnsupportedAttributeException((PMMLObject)supportVectorMachineModel, (Enum)representation));
                break;
            }
        }
        return super.visit(supportVectorMachineModel);
    }

    public VisitorAction visit(TableLocator tableLocator) {
        this.report((MarkupException)new UnsupportedElementException((PMMLObject)tableLocator));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(TextIndex textIndex) {
        boolean tokenize = textIndex.isTokenize();
        if (!tokenize) {
            this.report((MarkupException)new UnsupportedAttributeException((PMMLObject)textIndex, org.dmg.pmml.PMMLAttributes.TEXTINDEX_TOKENIZE, (Object)false));
        }
        TextIndex.LocalTermWeights localTermWeights = textIndex.getLocalTermWeights();
        switch (localTermWeights) {
            case AUGMENTED_NORMALIZED_TERM_FREQUENCY: {
                this.report((MarkupException)new UnsupportedAttributeException((PMMLObject)textIndex, (Enum)localTermWeights));
                break;
            }
        }
        return super.visit(textIndex);
    }

    public VisitorAction visit(TextModel textModel) {
        this.report((MarkupException)new UnsupportedElementException((PMMLObject)textModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(TreeModel treeModel) {
        TreeModel.MissingValueStrategy missingValueStrategy = treeModel.getMissingValueStrategy();
        switch (missingValueStrategy) {
            case AGGREGATE_NODES: 
            case WEIGHTED_CONFIDENCE: {
                this.report((MarkupException)new UnsupportedAttributeException((PMMLObject)treeModel, (Enum)missingValueStrategy));
                break;
            }
        }
        return super.visit(treeModel);
    }
}

