/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.h2o;

import com.google.common.primitives.Doubles;
import hex.genmodel.MojoModel;
import hex.genmodel.algos.glm.GlmOrdinalMojoModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.DerivedOutputField;
import org.jpmml.converter.DiscreteLabel;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.OrdinalLabel;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.converter.regression.RegressionModelUtil;
import org.jpmml.h2o.GlmMojoModelBaseConverter;
import org.jpmml.h2o.H2OEncoder;

public class GlmOrdinalMojoModelConverter
extends GlmMojoModelBaseConverter<GlmOrdinalMojoModel> {
    public GlmOrdinalMojoModelConverter(GlmOrdinalMojoModel model) {
        super(model);
    }

    @Override
    public Schema encodeSchema(H2OEncoder encoder) {
        Schema schema = super.encodeSchema(encoder);
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        List features = schema.getFeatures();
        DataField dataField = encoder.getDataField(categoricalLabel.getName());
        dataField.setOpType(OpType.ORDINAL);
        return new Schema((PMMLEncoder)encoder, (Label)new OrdinalLabel((Field)dataField), features);
    }

    public MiningModel encodeModel(Schema schema) {
        GlmOrdinalMojoModel model = (GlmOrdinalMojoModel)this.getModel();
        ModelEncoder encoder = (ModelEncoder)schema.getEncoder();
        OrdinalLabel ordinalLabel = (OrdinalLabel)schema.getLabel();
        List features = schema.getFeatures();
        List beta = Doubles.asList((double[])GlmOrdinalMojoModelConverter.getBeta((MojoModel)model));
        SchemaUtil.checkSize((int)(beta.size() - ordinalLabel.size()), (DiscreteLabel)ordinalLabel, (List)features);
        List sharedCoefficients = null;
        ArrayList<Double> thresholds = new ArrayList<Double>();
        int offset = 0;
        for (int i = 0; i < ordinalLabel.size(); ++i) {
            List coefficients = beta.subList(offset, offset + features.size());
            Double intercept = (Double)beta.get(offset + features.size());
            if (i < ordinalLabel.size() - 1) {
                if (sharedCoefficients == null) {
                    sharedCoefficients = coefficients;
                } else if (!Objects.equals(sharedCoefficients, coefficients)) {
                    throw new IllegalArgumentException();
                }
                thresholds.add(intercept);
            } else {
                if (sharedCoefficients == null) {
                    throw new IllegalArgumentException();
                }
                for (Number coefficient : coefficients) {
                    if (coefficient.doubleValue() == 0.0) continue;
                    throw new IllegalArgumentException();
                }
                if (intercept != 0.0) {
                    throw new IllegalArgumentException();
                }
            }
            offset += features.size() + 1;
        }
        Schema segmentSchema = schema.toAnonymousRegressorSchema(DataType.DOUBLE);
        RegressionModel firstRegressionModel = RegressionModelUtil.createRegression((List)features, sharedCoefficients, (Number)0.0, (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.NONE, (Schema)segmentSchema).setTargets(ModelUtil.createRescaleTargets((Number)-1.0, null, (ContinuousLabel)((ContinuousLabel)segmentSchema.getLabel())));
        OutputField linpredOutputField = ModelUtil.createPredictedField((String)"linpred", (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE);
        DerivedOutputField linpredField = encoder.createDerivedField((Model)firstRegressionModel, linpredOutputField, true);
        ContinuousFeature feature = new ContinuousFeature((PMMLEncoder)encoder, (Field)linpredField);
        RegressionModel secondRegressionModel = RegressionModelUtil.createOrdinalClassification((Feature)feature, thresholds, (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.LOGIT, (boolean)true, (Schema)schema);
        return MiningModelUtil.createModelChain(Arrays.asList(firstRegressionModel, secondRegressionModel), (Segmentation.MissingPredictionTreatment)Segmentation.MissingPredictionTreatment.RETURN_MISSING);
    }
}

