/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.h2o;

import com.google.common.collect.Iterables;
import hex.genmodel.algos.isoforextended.ExtendedIsolationForestMojoModel;
import hex.genmodel.utils.ByteBufferWrapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.tree.BranchNode;
import org.dmg.pmml.tree.CountingLeafNode;
import org.dmg.pmml.tree.LeafNode;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.converter.transformations.AbstractTransformation;
import org.jpmml.h2o.Converter;

public class ExtendedIsolationForestMojoModelConverter
extends Converter<ExtendedIsolationForestMojoModel> {
    private static final Field FIELD_COMPRESSEDTREES;
    private static final Field FIELD_SAMPLE_SIZE;

    public ExtendedIsolationForestMojoModelConverter(ExtendedIsolationForestMojoModel model) {
        super(model);
    }

    public MiningModel encodeModel(Schema schema) {
        ExtendedIsolationForestMojoModel model = (ExtendedIsolationForestMojoModel)this.getModel();
        final long sampleSize = ExtendedIsolationForestMojoModelConverter.getSampleSize(model);
        List<TreeModel> treeModels = this.encodeTreeModels(schema);
        AbstractTransformation anomalyScore = new AbstractTransformation(){

            public String getName(String name) {
                return "anomalyScore";
            }

            public boolean isFinalResult() {
                return true;
            }

            public Expression createExpression(FieldRef fieldRef) {
                return ExpressionUtil.createApply((String)"pow", (Expression[])new Expression[]{ExpressionUtil.createConstant((Number)2.0), ExpressionUtil.createApply((String)"/", (Expression[])new Expression[]{fieldRef, ExpressionUtil.createConstant((Number)(-1.0 * ExtendedIsolationForestMojoModel.averagePathLengthOfUnsuccessfulSearch((long)sampleSize)))})});
            }
        };
        MiningModel miningModel = new MiningModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema(null)).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)Segmentation.MultipleModelMethod.AVERAGE, (Segmentation.MissingPredictionTreatment)Segmentation.MissingPredictionTreatment.RETURN_MISSING, treeModels)).setOutput(ModelUtil.createPredictedOutput((String)"meanPathLength", (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE, (Transformation[])new Transformation[]{anomalyScore}));
        return miningModel;
    }

    private List<TreeModel> encodeTreeModels(Schema schema) {
        ExtendedIsolationForestMojoModel model = (ExtendedIsolationForestMojoModel)this.getModel();
        byte[][] compressedTrees = ExtendedIsolationForestMojoModelConverter.getCompressedTrees(model);
        ArrayList<TreeModel> result = new ArrayList<TreeModel>();
        int max = compressedTrees.length;
        for (int i = 0; i < max; ++i) {
            byte[] compressedTree = compressedTrees[i];
            TreeModel treeModel = this.encodeTreeModel(i, compressedTree, schema);
            result.add(treeModel);
        }
        return result;
    }

    private TreeModel encodeTreeModel(int index, byte[] compressedTree, Schema schema) {
        ByteBufferWrapper byteBuffer = new ByteBufferWrapper(compressedTree);
        HashMap<Integer, Node> nodeMap = new HashMap<Integer, Node>();
        HashMap<Integer, Feature> featureMap = new HashMap<Integer, Feature>();
        HashMap<Integer, Integer> countMap = new HashMap<Integer, Integer>();
        int sizeOfBranchingArrays = byteBuffer.get4();
        double[] n = new double[sizeOfBranchingArrays];
        double[] p = new double[sizeOfBranchingArrays];
        while (byteBuffer.hasRemaining()) {
            BranchNode node;
            int nodeNumber = byteBuffer.get4();
            int nodeType = byteBuffer.get1U();
            if (nodeNumber == 0 && !nodeMap.isEmpty()) break;
            switch (nodeType) {
                case 78: {
                    node = new BranchNode();
                    Feature feature = ExtendedIsolationForestMojoModelConverter.loadFeature(FieldNameUtil.create((String)"split", (Object[])new Object[]{index, nodeNumber}), byteBuffer, n, p, schema);
                    featureMap.put(nodeNumber, feature);
                    break;
                }
                case 76: {
                    node = new CountingLeafNode();
                    int numRows = ExtendedIsolationForestMojoModelConverter.loadSampleSize(byteBuffer);
                    countMap.put(nodeNumber, numRows);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            nodeMap.put(nodeNumber, (Node)node);
        }
        ContinuousLabel label = new ContinuousLabel(DataType.DOUBLE);
        Node root = ExtendedIsolationForestMojoModelConverter.encodeNode(0, (Predicate)True.INSTANCE, 0, nodeMap, featureMap, countMap);
        TreeModel treeModel = new TreeModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)label), root);
        return treeModel;
    }

    private static Node encodeNode(int index, Predicate predicate, int height, Map<Integer, Node> nodeMap, Map<Integer, Feature> featureMap, Map<Integer, Integer> countMap) {
        Node result = nodeMap.get(index);
        result.setId((Object)index).setPredicate(predicate);
        if (result instanceof BranchNode) {
            Feature feature = featureMap.get(index);
            String name = feature.getName();
            SimplePredicate leftPredicate = new SimplePredicate(name, SimplePredicate.Operator.LESS_OR_EQUAL, (Object)0);
            SimplePredicate rightPredicate = new SimplePredicate(name, SimplePredicate.Operator.GREATER_THAN, (Object)0);
            Node leftChild = ExtendedIsolationForestMojoModelConverter.encodeNode(2 * index + 1, (Predicate)leftPredicate, height + 1, nodeMap, featureMap, countMap);
            Node rightChild = ExtendedIsolationForestMojoModelConverter.encodeNode(2 * index + 2, (Predicate)rightPredicate, height + 1, nodeMap, featureMap, countMap);
            result.addNodes(leftChild, rightChild);
        } else if (result instanceof LeafNode) {
            Integer numRows = countMap.get(index);
            result.setScore((Object)((double)height + ExtendedIsolationForestMojoModel.averagePathLengthOfUnsuccessfulSearch((long)numRows.intValue())));
        } else {
            throw new IllegalArgumentException();
        }
        return result;
    }

    private static Feature loadFeature(String name, ByteBufferWrapper byteBuffer, double[] n, double[] p, Schema schema) {
        Expression expression;
        int i;
        ModelEncoder encoder = schema.getEncoder();
        for (i = 0; i < n.length; ++i) {
            n[i] = byteBuffer.get8d();
        }
        for (i = 0; i < p.length; ++i) {
            p[i] = byteBuffer.get8d();
        }
        ArrayList<FieldRef> expressions = new ArrayList<FieldRef>();
        for (int i2 = 0; i2 < n.length; ++i2) {
            Feature feature = schema.getFeature(i2);
            if (ValueUtil.isZero((Number)n[i2])) continue;
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            FieldRef expression2 = continuousFeature.ref();
            if (!ValueUtil.isOne((Number)p[i2])) {
                expression2 = ExpressionUtil.createApply((String)"-", (Expression[])new Expression[]{expression2, ExpressionUtil.createConstant((Number)p[i2])});
            }
            expression2 = ExpressionUtil.createApply((String)"*", (Expression[])new Expression[]{expression2, ExpressionUtil.createConstant((Number)n[i2])});
            expressions.add(expression2);
        }
        if (expressions.size() == 1) {
            expression = (Expression)Iterables.getOnlyElement(expressions);
        } else if (expressions.size() >= 2) {
            Apply apply = ExpressionUtil.createApply((String)"sum", (Expression[])new Expression[0]);
            apply.getExpressions().addAll(expressions);
            expression = apply;
        } else {
            throw new IllegalArgumentException();
        }
        DerivedField derivedField = encoder.createDerivedField(name, OpType.CONTINUOUS, DataType.DOUBLE, expression);
        return new ContinuousFeature((PMMLEncoder)encoder, (org.dmg.pmml.Field)derivedField);
    }

    private static int loadSampleSize(ByteBufferWrapper byteBuffer) {
        return byteBuffer.get4();
    }

    public static byte[][] getCompressedTrees(ExtendedIsolationForestMojoModel model) {
        return (byte[][])ExtendedIsolationForestMojoModelConverter.getFieldValue(FIELD_COMPRESSEDTREES, model);
    }

    public static long getSampleSize(ExtendedIsolationForestMojoModel model) {
        return (Long)ExtendedIsolationForestMojoModelConverter.getFieldValue(FIELD_SAMPLE_SIZE, model);
    }

    static {
        try {
            FIELD_COMPRESSEDTREES = ExtendedIsolationForestMojoModel.class.getDeclaredField("_compressedTrees");
            FIELD_SAMPLE_SIZE = ExtendedIsolationForestMojoModel.class.getDeclaredField("_sample_size");
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
    }
}

