/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.lightgbm.example;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.jpmml.lightgbm.GBDT;
import org.jpmml.lightgbm.LightGBMUtil;
import org.jpmml.lightgbm.ObjectiveFunction;
import org.jpmml.model.metro.MetroJAXBSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    @Parameter(names={"--lgbm-input"}, description="LightGBM text input file", required=true, order=1)
    private File input = null;
    @Parameter(names={"--pmml-output"}, description="PMML output file", required=true, order=2)
    private File output = null;
    @Parameter(names={"--objective"}, description="Custom objective function", order=3)
    private String objectiveFunction = null;
    @Parameter(names={"--target-name"}, description="Target name. Defaults to \"_target\"", order=4)
    private String targetName = null;
    @Parameter(names={"--target-categories"}, description="Target categories. Defaults to 0-based index [0, 1, .., num_class - 1]", order=5)
    private List<String> targetCategories = null;
    @Parameter(names={"--X-compact"}, description="Transform LightGBM-style trees to PMML-style trees", arity=1, order=6)
    private Boolean compact = null;
    @Parameter(names={"--X-nan_as_missing"}, description="Treat Not-a-Number (NaN) values as missing values", arity=1, order=7)
    private boolean nanAsMissing = true;
    @Parameter(names={"--X-num_iteration"}, description="Limit the number of trees. Defaults to all trees", order=8)
    private Integer numIteration = null;
    @Parameter(names={"--help"}, description="Show the list of configuration options and exit", help=true, order=0x7FFFFFFF)
    private boolean help = false;
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = new JCommander((Object)main);
        commander.setProgramName(Main.class.getName());
        DefaultUsageFormatter usageFormatter = new DefaultUsageFormatter(commander);
        try {
            commander.parse(args);
        }
        catch (ParameterException pe) {
            StringBuilder sb = new StringBuilder();
            sb.append(pe.toString());
            sb.append("\n");
            usageFormatter.usage(sb);
            System.err.println(sb.toString());
            System.exit(-1);
        }
        if (main.help) {
            StringBuilder sb = new StringBuilder();
            usageFormatter.usage(sb);
            System.out.println(sb.toString());
            System.exit(0);
        }
        main.run();
    }

    private void run() throws Exception {
        PMML pmml;
        Boolean compact;
        GBDT gbdt;
        try (FileInputStream is = new FileInputStream(this.input);){
            logger.info("Loading GBDT..");
            long begin = System.currentTimeMillis();
            gbdt = LightGBMUtil.loadGBDT((InputStream)is);
            long end = System.currentTimeMillis();
            logger.info("Loaded GBDT in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to load GBDT", (Throwable)e);
            throw e;
        }
        if (this.objectiveFunction != null) {
            logger.info("Setting custom objective function");
            ObjectiveFunction objectiveFunction = LightGBMUtil.parseObjectiveFunction((String)this.objectiveFunction);
            gbdt.setObjectiveFunction(objectiveFunction);
        }
        if ((compact = this.compact) == null) {
            compact = !gbdt.hasLinearTree();
        }
        LinkedHashMap<String, Comparable<Boolean>> options = new LinkedHashMap<String, Comparable<Boolean>>();
        options.put("compact", compact);
        options.put("nan_as_missing", Boolean.valueOf(this.nanAsMissing));
        options.put("num_iteration", this.numIteration);
        try {
            logger.info("Converting GBDT to PMML..");
            long begin = System.currentTimeMillis();
            pmml = gbdt.encodePMML(options, this.targetName, this.targetCategories);
            long end = System.currentTimeMillis();
            logger.info("Converted GBDT to PMML in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to convert GBDT to PMML", (Throwable)e);
            throw e;
        }
        try (FileOutputStream os = new FileOutputStream(this.output);){
            logger.info("Marshalling PMML..");
            MetroJAXBSerializer jaxbSerializer = new MetroJAXBSerializer();
            long begin = System.currentTimeMillis();
            jaxbSerializer.serializePretty((PMMLObject)pmml, (OutputStream)os);
            long end = System.currentTimeMillis();
            logger.info("Marshalled PMML in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to marshal PMML", (Throwable)e);
            throw e;
        }
    }
}

