
package org.dmg.pmml.time_series;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Array;
import org.dmg.pmml.HasDisplayName;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "TimeCycle", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "array"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonRootName("TimeCycle")
@JsonPropertyOrder({
    "length",
    "type",
    "displayName",
    "array"
})
public class TimeCycle
    extends org.dmg.pmml.PMMLObject
    implements HasDisplayName<TimeCycle>
{

    @XmlAttribute(name = "length")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("length")
    private Integer length;
    @XmlAttribute(name = "type")
    @JsonProperty("type")
    private TimeCycle.Type type;
    @XmlAttribute(name = "displayName")
    @JsonProperty("displayName")
    private String displayName;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Array")
    private Array array;
    private final static long serialVersionUID = 67371270L;

    public TimeCycle() {
    }

    @ValueConstructor
    public TimeCycle(
        @org.jpmml.model.annotations.Property("array")
        Array array) {
        this.array = array;
    }

    public Integer getLength() {
        return length;
    }

    public TimeCycle setLength(
        @org.jpmml.model.annotations.Property("length")
        Integer length) {
        this.length = length;
        return this;
    }

    public TimeCycle.Type getType() {
        return type;
    }

    public TimeCycle setType(
        @org.jpmml.model.annotations.Property("type")
        TimeCycle.Type type) {
        this.type = type;
        return this;
    }

    @Override
    public String getDisplayName() {
        return displayName;
    }

    @Override
    public TimeCycle setDisplayName(
        @org.jpmml.model.annotations.Property("displayName")
        String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Array requireArray() {
        if (this.array == null) {
            throw new MissingElementException(this, PMMLElements.TIMECYCLE_ARRAY);
        }
        return this.array;
    }

    public Array getArray() {
        return array;
    }

    public TimeCycle setArray(
        @org.jpmml.model.annotations.Property("array")
        Array array) {
        this.array = array;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getArray());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Type
        implements StringValue<TimeCycle.Type>
    {

        @XmlEnumValue("includeAll")
        @JsonProperty("includeAll")
        INCLUDE_ALL("includeAll"),
        @XmlEnumValue("includeFromTo")
        @JsonProperty("includeFromTo")
        INCLUDE_FROM_TO("includeFromTo"),
        @XmlEnumValue("excludeFromTo")
        @JsonProperty("excludeFromTo")
        EXCLUDE_FROM_TO("excludeFromTo"),
        @XmlEnumValue("includeSet")
        @JsonProperty("includeSet")
        INCLUDE_SET("includeSet"),
        @XmlEnumValue("excludeSet")
        @JsonProperty("excludeSet")
        EXCLUDE_SET("excludeSet");
        private final String value;

        Type(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static TimeCycle.Type fromValue(String v) {
            for (TimeCycle.Type c: TimeCycle.Type.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
