
package org.dmg.pmml;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Item" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Itemset" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}AssociationRule" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_1}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="numberOfTransactions" use="required" type="{http://www.dmg.org/PMML-4_1}INT-NUMBER" />
 *       &lt;attribute name="maxNumberOfItemsPerTA" type="{http://www.dmg.org/PMML-4_1}INT-NUMBER" />
 *       &lt;attribute name="avgNumberOfItemsPerTA" type="{http://www.dmg.org/PMML-4_1}REAL-NUMBER" />
 *       &lt;attribute name="minimumSupport" use="required" type="{http://www.dmg.org/PMML-4_1}PROB-NUMBER" />
 *       &lt;attribute name="minimumConfidence" use="required" type="{http://www.dmg.org/PMML-4_1}PROB-NUMBER" />
 *       &lt;attribute name="lengthLimit" type="{http://www.dmg.org/PMML-4_1}INT-NUMBER" />
 *       &lt;attribute name="numberOfItems" use="required" type="{http://www.dmg.org/PMML-4_1}INT-NUMBER" />
 *       &lt;attribute name="numberOfItemsets" use="required" type="{http://www.dmg.org/PMML-4_1}INT-NUMBER" />
 *       &lt;attribute name="numberOfRules" use="required" type="{http://www.dmg.org/PMML-4_1}INT-NUMBER" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "localTransformations",
    "items",
    "itemsets",
    "associationRules",
    "modelVerification"
})
@XmlRootElement(name = "AssociationModel")
public class AssociationModel
    extends Model
    implements Equals, HashCode
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "MiningSchema", required = true)
    protected MiningSchema miningSchema;
    @XmlElement(name = "Output")
    protected Output output;
    @XmlElement(name = "ModelStats")
    protected ModelStats modelStats;
    @XmlElement(name = "LocalTransformations")
    protected LocalTransformations localTransformations;
    @XmlElement(name = "Item")
    protected List<Item> items;
    @XmlElement(name = "Itemset")
    protected List<Itemset> itemsets;
    @XmlElement(name = "AssociationRule")
    protected List<AssociationRule> associationRules;
    @XmlElement(name = "ModelVerification")
    protected ModelVerification modelVerification;
    @XmlAttribute(name = "modelName")
    protected String modelName;
    @XmlAttribute(name = "functionName", required = true)
    protected MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    protected String algorithmName;
    @XmlAttribute(name = "numberOfTransactions", required = true)
    protected BigInteger numberOfTransactions;
    @XmlAttribute(name = "maxNumberOfItemsPerTA")
    protected BigInteger maxNumberOfItemsPerTA;
    @XmlAttribute(name = "avgNumberOfItemsPerTA")
    protected Double avgNumberOfItemsPerTA;
    @XmlAttribute(name = "minimumSupport", required = true)
    protected BigDecimal minimumSupport;
    @XmlAttribute(name = "minimumConfidence", required = true)
    protected BigDecimal minimumConfidence;
    @XmlAttribute(name = "lengthLimit")
    protected BigInteger lengthLimit;
    @XmlAttribute(name = "numberOfItems", required = true)
    protected BigInteger numberOfItems;
    @XmlAttribute(name = "numberOfItemsets", required = true)
    protected BigInteger numberOfItemsets;
    @XmlAttribute(name = "numberOfRules", required = true)
    protected BigInteger numberOfRules;
    @XmlAttribute(name = "isScorable")
    protected Boolean scorable;

    @Deprecated
    public AssociationModel() {
        super();
    }

    public AssociationModel(final MiningSchema miningSchema, final MiningFunctionType functionName, final BigInteger numberOfTransactions, final BigDecimal minimumSupport, final BigDecimal minimumConfidence, final BigInteger numberOfItems, final BigInteger numberOfItemsets, final BigInteger numberOfRules) {
        super();
        this.miningSchema = miningSchema;
        this.functionName = functionName;
        this.numberOfTransactions = numberOfTransactions;
        this.minimumSupport = minimumSupport;
        this.minimumConfidence = minimumConfidence;
        this.numberOfItems = numberOfItems;
        this.numberOfItemsets = numberOfItemsets;
        this.numberOfRules = numberOfRules;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public void setMiningSchema(MiningSchema value) {
        this.miningSchema = value;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param value
     *     allowed object is
     *     {@link Output }
     *     
     */
    public void setOutput(Output value) {
        this.output = value;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public void setModelStats(ModelStats value) {
        this.modelStats = value;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public void setLocalTransformations(LocalTransformations value) {
        this.localTransformations = value;
    }

    /**
     * Gets the value of the items property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the items property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getItems().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Item }
     * 
     * 
     */
    public List<Item> getItems() {
        if (items == null) {
            items = new ArrayList<Item>();
        }
        return this.items;
    }

    /**
     * Gets the value of the itemsets property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the itemsets property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getItemsets().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Itemset }
     * 
     * 
     */
    public List<Itemset> getItemsets() {
        if (itemsets == null) {
            itemsets = new ArrayList<Itemset>();
        }
        return this.itemsets;
    }

    /**
     * Gets the value of the associationRules property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the associationRules property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAssociationRules().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AssociationRule }
     * 
     * 
     */
    public List<AssociationRule> getAssociationRules() {
        if (associationRules == null) {
            associationRules = new ArrayList<AssociationRule>();
        }
        return this.associationRules;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public void setModelVerification(ModelVerification value) {
        this.modelVerification = value;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setModelName(String value) {
        this.modelName = value;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public void setFunctionName(MiningFunctionType value) {
        this.functionName = value;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlgorithmName(String value) {
        this.algorithmName = value;
    }

    /**
     * Gets the value of the numberOfTransactions property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getNumberOfTransactions() {
        return numberOfTransactions;
    }

    /**
     * Sets the value of the numberOfTransactions property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setNumberOfTransactions(BigInteger value) {
        this.numberOfTransactions = value;
    }

    /**
     * Gets the value of the maxNumberOfItemsPerTA property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getMaxNumberOfItemsPerTA() {
        return maxNumberOfItemsPerTA;
    }

    /**
     * Sets the value of the maxNumberOfItemsPerTA property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setMaxNumberOfItemsPerTA(BigInteger value) {
        this.maxNumberOfItemsPerTA = value;
    }

    /**
     * Gets the value of the avgNumberOfItemsPerTA property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getAvgNumberOfItemsPerTA() {
        return avgNumberOfItemsPerTA;
    }

    /**
     * Sets the value of the avgNumberOfItemsPerTA property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setAvgNumberOfItemsPerTA(Double value) {
        this.avgNumberOfItemsPerTA = value;
    }

    /**
     * Gets the value of the minimumSupport property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getMinimumSupport() {
        return minimumSupport;
    }

    /**
     * Sets the value of the minimumSupport property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setMinimumSupport(BigDecimal value) {
        this.minimumSupport = value;
    }

    /**
     * Gets the value of the minimumConfidence property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getMinimumConfidence() {
        return minimumConfidence;
    }

    /**
     * Sets the value of the minimumConfidence property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setMinimumConfidence(BigDecimal value) {
        this.minimumConfidence = value;
    }

    /**
     * Gets the value of the lengthLimit property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getLengthLimit() {
        return lengthLimit;
    }

    /**
     * Sets the value of the lengthLimit property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setLengthLimit(BigInteger value) {
        this.lengthLimit = value;
    }

    /**
     * Gets the value of the numberOfItems property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getNumberOfItems() {
        return numberOfItems;
    }

    /**
     * Sets the value of the numberOfItems property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setNumberOfItems(BigInteger value) {
        this.numberOfItems = value;
    }

    /**
     * Gets the value of the numberOfItemsets property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getNumberOfItemsets() {
        return numberOfItemsets;
    }

    /**
     * Sets the value of the numberOfItemsets property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setNumberOfItemsets(BigInteger value) {
        this.numberOfItemsets = value;
    }

    /**
     * Gets the value of the numberOfRules property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getNumberOfRules() {
        return numberOfRules;
    }

    /**
     * Sets the value of the numberOfRules property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setNumberOfRules(BigInteger value) {
        this.numberOfRules = value;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return true;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setScorable(Boolean value) {
        this.scorable = value;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if (!(object instanceof AssociationModel)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        final AssociationModel that = ((AssociationModel) object);
        {
            List<Extension> lhsExtensions;
            lhsExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            List<Extension> rhsExtensions;
            rhsExtensions = (((that.extensions!= null)&&(!that.extensions.isEmpty()))?that.getExtensions():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "extensions", lhsExtensions), LocatorUtils.property(thatLocator, "extensions", rhsExtensions), lhsExtensions, rhsExtensions)) {
                return false;
            }
        }
        {
            MiningSchema lhsMiningSchema;
            lhsMiningSchema = this.getMiningSchema();
            MiningSchema rhsMiningSchema;
            rhsMiningSchema = that.getMiningSchema();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "miningSchema", lhsMiningSchema), LocatorUtils.property(thatLocator, "miningSchema", rhsMiningSchema), lhsMiningSchema, rhsMiningSchema)) {
                return false;
            }
        }
        {
            Output lhsOutput;
            lhsOutput = this.getOutput();
            Output rhsOutput;
            rhsOutput = that.getOutput();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "output", lhsOutput), LocatorUtils.property(thatLocator, "output", rhsOutput), lhsOutput, rhsOutput)) {
                return false;
            }
        }
        {
            ModelStats lhsModelStats;
            lhsModelStats = this.getModelStats();
            ModelStats rhsModelStats;
            rhsModelStats = that.getModelStats();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelStats", lhsModelStats), LocatorUtils.property(thatLocator, "modelStats", rhsModelStats), lhsModelStats, rhsModelStats)) {
                return false;
            }
        }
        {
            LocalTransformations lhsLocalTransformations;
            lhsLocalTransformations = this.getLocalTransformations();
            LocalTransformations rhsLocalTransformations;
            rhsLocalTransformations = that.getLocalTransformations();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "localTransformations", lhsLocalTransformations), LocatorUtils.property(thatLocator, "localTransformations", rhsLocalTransformations), lhsLocalTransformations, rhsLocalTransformations)) {
                return false;
            }
        }
        {
            List<Item> lhsItems;
            lhsItems = (((this.items!= null)&&(!this.items.isEmpty()))?this.getItems():null);
            List<Item> rhsItems;
            rhsItems = (((that.items!= null)&&(!that.items.isEmpty()))?that.getItems():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "items", lhsItems), LocatorUtils.property(thatLocator, "items", rhsItems), lhsItems, rhsItems)) {
                return false;
            }
        }
        {
            List<Itemset> lhsItemsets;
            lhsItemsets = (((this.itemsets!= null)&&(!this.itemsets.isEmpty()))?this.getItemsets():null);
            List<Itemset> rhsItemsets;
            rhsItemsets = (((that.itemsets!= null)&&(!that.itemsets.isEmpty()))?that.getItemsets():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "itemsets", lhsItemsets), LocatorUtils.property(thatLocator, "itemsets", rhsItemsets), lhsItemsets, rhsItemsets)) {
                return false;
            }
        }
        {
            List<AssociationRule> lhsAssociationRules;
            lhsAssociationRules = (((this.associationRules!= null)&&(!this.associationRules.isEmpty()))?this.getAssociationRules():null);
            List<AssociationRule> rhsAssociationRules;
            rhsAssociationRules = (((that.associationRules!= null)&&(!that.associationRules.isEmpty()))?that.getAssociationRules():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "associationRules", lhsAssociationRules), LocatorUtils.property(thatLocator, "associationRules", rhsAssociationRules), lhsAssociationRules, rhsAssociationRules)) {
                return false;
            }
        }
        {
            ModelVerification lhsModelVerification;
            lhsModelVerification = this.getModelVerification();
            ModelVerification rhsModelVerification;
            rhsModelVerification = that.getModelVerification();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelVerification", lhsModelVerification), LocatorUtils.property(thatLocator, "modelVerification", rhsModelVerification), lhsModelVerification, rhsModelVerification)) {
                return false;
            }
        }
        {
            String lhsModelName;
            lhsModelName = this.getModelName();
            String rhsModelName;
            rhsModelName = that.getModelName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelName", lhsModelName), LocatorUtils.property(thatLocator, "modelName", rhsModelName), lhsModelName, rhsModelName)) {
                return false;
            }
        }
        {
            MiningFunctionType lhsFunctionName;
            lhsFunctionName = this.getFunctionName();
            MiningFunctionType rhsFunctionName;
            rhsFunctionName = that.getFunctionName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "functionName", lhsFunctionName), LocatorUtils.property(thatLocator, "functionName", rhsFunctionName), lhsFunctionName, rhsFunctionName)) {
                return false;
            }
        }
        {
            String lhsAlgorithmName;
            lhsAlgorithmName = this.getAlgorithmName();
            String rhsAlgorithmName;
            rhsAlgorithmName = that.getAlgorithmName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "algorithmName", lhsAlgorithmName), LocatorUtils.property(thatLocator, "algorithmName", rhsAlgorithmName), lhsAlgorithmName, rhsAlgorithmName)) {
                return false;
            }
        }
        {
            BigInteger lhsNumberOfTransactions;
            lhsNumberOfTransactions = this.getNumberOfTransactions();
            BigInteger rhsNumberOfTransactions;
            rhsNumberOfTransactions = that.getNumberOfTransactions();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "numberOfTransactions", lhsNumberOfTransactions), LocatorUtils.property(thatLocator, "numberOfTransactions", rhsNumberOfTransactions), lhsNumberOfTransactions, rhsNumberOfTransactions)) {
                return false;
            }
        }
        {
            BigInteger lhsMaxNumberOfItemsPerTA;
            lhsMaxNumberOfItemsPerTA = this.getMaxNumberOfItemsPerTA();
            BigInteger rhsMaxNumberOfItemsPerTA;
            rhsMaxNumberOfItemsPerTA = that.getMaxNumberOfItemsPerTA();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "maxNumberOfItemsPerTA", lhsMaxNumberOfItemsPerTA), LocatorUtils.property(thatLocator, "maxNumberOfItemsPerTA", rhsMaxNumberOfItemsPerTA), lhsMaxNumberOfItemsPerTA, rhsMaxNumberOfItemsPerTA)) {
                return false;
            }
        }
        {
            Double lhsAvgNumberOfItemsPerTA;
            lhsAvgNumberOfItemsPerTA = this.getAvgNumberOfItemsPerTA();
            Double rhsAvgNumberOfItemsPerTA;
            rhsAvgNumberOfItemsPerTA = that.getAvgNumberOfItemsPerTA();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "avgNumberOfItemsPerTA", lhsAvgNumberOfItemsPerTA), LocatorUtils.property(thatLocator, "avgNumberOfItemsPerTA", rhsAvgNumberOfItemsPerTA), lhsAvgNumberOfItemsPerTA, rhsAvgNumberOfItemsPerTA)) {
                return false;
            }
        }
        {
            BigDecimal lhsMinimumSupport;
            lhsMinimumSupport = this.getMinimumSupport();
            BigDecimal rhsMinimumSupport;
            rhsMinimumSupport = that.getMinimumSupport();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "minimumSupport", lhsMinimumSupport), LocatorUtils.property(thatLocator, "minimumSupport", rhsMinimumSupport), lhsMinimumSupport, rhsMinimumSupport)) {
                return false;
            }
        }
        {
            BigDecimal lhsMinimumConfidence;
            lhsMinimumConfidence = this.getMinimumConfidence();
            BigDecimal rhsMinimumConfidence;
            rhsMinimumConfidence = that.getMinimumConfidence();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "minimumConfidence", lhsMinimumConfidence), LocatorUtils.property(thatLocator, "minimumConfidence", rhsMinimumConfidence), lhsMinimumConfidence, rhsMinimumConfidence)) {
                return false;
            }
        }
        {
            BigInteger lhsLengthLimit;
            lhsLengthLimit = this.getLengthLimit();
            BigInteger rhsLengthLimit;
            rhsLengthLimit = that.getLengthLimit();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "lengthLimit", lhsLengthLimit), LocatorUtils.property(thatLocator, "lengthLimit", rhsLengthLimit), lhsLengthLimit, rhsLengthLimit)) {
                return false;
            }
        }
        {
            BigInteger lhsNumberOfItems;
            lhsNumberOfItems = this.getNumberOfItems();
            BigInteger rhsNumberOfItems;
            rhsNumberOfItems = that.getNumberOfItems();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "numberOfItems", lhsNumberOfItems), LocatorUtils.property(thatLocator, "numberOfItems", rhsNumberOfItems), lhsNumberOfItems, rhsNumberOfItems)) {
                return false;
            }
        }
        {
            BigInteger lhsNumberOfItemsets;
            lhsNumberOfItemsets = this.getNumberOfItemsets();
            BigInteger rhsNumberOfItemsets;
            rhsNumberOfItemsets = that.getNumberOfItemsets();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "numberOfItemsets", lhsNumberOfItemsets), LocatorUtils.property(thatLocator, "numberOfItemsets", rhsNumberOfItemsets), lhsNumberOfItemsets, rhsNumberOfItemsets)) {
                return false;
            }
        }
        {
            BigInteger lhsNumberOfRules;
            lhsNumberOfRules = this.getNumberOfRules();
            BigInteger rhsNumberOfRules;
            rhsNumberOfRules = that.getNumberOfRules();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "numberOfRules", lhsNumberOfRules), LocatorUtils.property(thatLocator, "numberOfRules", rhsNumberOfRules), lhsNumberOfRules, rhsNumberOfRules)) {
                return false;
            }
        }
        {
            boolean lhsScorable;
            lhsScorable = ((this.scorable!= null)?this.isScorable():false);
            boolean rhsScorable;
            rhsScorable = ((that.scorable!= null)?that.isScorable():false);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "scorable", lhsScorable), LocatorUtils.property(thatLocator, "scorable", rhsScorable), lhsScorable, rhsScorable)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        {
            List<Extension> theExtensions;
            theExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "extensions", theExtensions), currentHashCode, theExtensions);
        }
        {
            MiningSchema theMiningSchema;
            theMiningSchema = this.getMiningSchema();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "miningSchema", theMiningSchema), currentHashCode, theMiningSchema);
        }
        {
            Output theOutput;
            theOutput = this.getOutput();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "output", theOutput), currentHashCode, theOutput);
        }
        {
            ModelStats theModelStats;
            theModelStats = this.getModelStats();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelStats", theModelStats), currentHashCode, theModelStats);
        }
        {
            LocalTransformations theLocalTransformations;
            theLocalTransformations = this.getLocalTransformations();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "localTransformations", theLocalTransformations), currentHashCode, theLocalTransformations);
        }
        {
            List<Item> theItems;
            theItems = (((this.items!= null)&&(!this.items.isEmpty()))?this.getItems():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "items", theItems), currentHashCode, theItems);
        }
        {
            List<Itemset> theItemsets;
            theItemsets = (((this.itemsets!= null)&&(!this.itemsets.isEmpty()))?this.getItemsets():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "itemsets", theItemsets), currentHashCode, theItemsets);
        }
        {
            List<AssociationRule> theAssociationRules;
            theAssociationRules = (((this.associationRules!= null)&&(!this.associationRules.isEmpty()))?this.getAssociationRules():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "associationRules", theAssociationRules), currentHashCode, theAssociationRules);
        }
        {
            ModelVerification theModelVerification;
            theModelVerification = this.getModelVerification();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelVerification", theModelVerification), currentHashCode, theModelVerification);
        }
        {
            String theModelName;
            theModelName = this.getModelName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelName", theModelName), currentHashCode, theModelName);
        }
        {
            MiningFunctionType theFunctionName;
            theFunctionName = this.getFunctionName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "functionName", theFunctionName), currentHashCode, theFunctionName);
        }
        {
            String theAlgorithmName;
            theAlgorithmName = this.getAlgorithmName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "algorithmName", theAlgorithmName), currentHashCode, theAlgorithmName);
        }
        {
            BigInteger theNumberOfTransactions;
            theNumberOfTransactions = this.getNumberOfTransactions();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "numberOfTransactions", theNumberOfTransactions), currentHashCode, theNumberOfTransactions);
        }
        {
            BigInteger theMaxNumberOfItemsPerTA;
            theMaxNumberOfItemsPerTA = this.getMaxNumberOfItemsPerTA();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "maxNumberOfItemsPerTA", theMaxNumberOfItemsPerTA), currentHashCode, theMaxNumberOfItemsPerTA);
        }
        {
            Double theAvgNumberOfItemsPerTA;
            theAvgNumberOfItemsPerTA = this.getAvgNumberOfItemsPerTA();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "avgNumberOfItemsPerTA", theAvgNumberOfItemsPerTA), currentHashCode, theAvgNumberOfItemsPerTA);
        }
        {
            BigDecimal theMinimumSupport;
            theMinimumSupport = this.getMinimumSupport();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "minimumSupport", theMinimumSupport), currentHashCode, theMinimumSupport);
        }
        {
            BigDecimal theMinimumConfidence;
            theMinimumConfidence = this.getMinimumConfidence();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "minimumConfidence", theMinimumConfidence), currentHashCode, theMinimumConfidence);
        }
        {
            BigInteger theLengthLimit;
            theLengthLimit = this.getLengthLimit();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "lengthLimit", theLengthLimit), currentHashCode, theLengthLimit);
        }
        {
            BigInteger theNumberOfItems;
            theNumberOfItems = this.getNumberOfItems();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "numberOfItems", theNumberOfItems), currentHashCode, theNumberOfItems);
        }
        {
            BigInteger theNumberOfItemsets;
            theNumberOfItemsets = this.getNumberOfItemsets();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "numberOfItemsets", theNumberOfItemsets), currentHashCode, theNumberOfItemsets);
        }
        {
            BigInteger theNumberOfRules;
            theNumberOfRules = this.getNumberOfRules();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "numberOfRules", theNumberOfRules), currentHashCode, theNumberOfRules);
        }
        {
            boolean theScorable;
            theScorable = ((this.scorable!= null)?this.isScorable():false);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "scorable", theScorable), currentHashCode, theScorable);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

}
