
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Level"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Trend_ExpoSmooth" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Seasonality_ExpoSmooth" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}TimeValue" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="RMSE" type="{http://www.dmg.org/PMML-4_1}REAL-NUMBER" />
 *       &lt;attribute name="transformation" default="none">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}NMTOKEN">
 *             &lt;enumeration value="none"/>
 *             &lt;enumeration value="logarithmic"/>
 *             &lt;enumeration value="squareroot"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "level",
    "trendExpoSmooth",
    "seasonalityExpoSmooth",
    "timeValues"
})
@XmlRootElement(name = "ExponentialSmoothing")
@Schema(min = Version.PMML_4_0)
public class ExponentialSmoothing
    extends PMMLObject
    implements Equals, HashCode
{

    @XmlElement(name = "Level", required = true)
    protected Level level;
    @XmlElement(name = "Trend_ExpoSmooth")
    protected TrendExpoSmooth trendExpoSmooth;
    @XmlElement(name = "Seasonality_ExpoSmooth")
    protected SeasonalityExpoSmooth seasonalityExpoSmooth;
    @XmlElement(name = "TimeValue")
    protected List<TimeValue> timeValues;
    @XmlAttribute(name = "RMSE")
    protected Double rmse;
    @XmlAttribute(name = "transformation")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String transformation;

    @Deprecated
    public ExponentialSmoothing() {
        super();
    }

    public ExponentialSmoothing(final Level level) {
        super();
        this.level = level;
    }

    /**
     * Gets the value of the level property.
     * 
     * @return
     *     possible object is
     *     {@link Level }
     *     
     */
    public Level getLevel() {
        return level;
    }

    /**
     * Sets the value of the level property.
     * 
     * @param value
     *     allowed object is
     *     {@link Level }
     *     
     */
    public void setLevel(Level value) {
        this.level = value;
    }

    /**
     * Gets the value of the trendExpoSmooth property.
     * 
     * @return
     *     possible object is
     *     {@link TrendExpoSmooth }
     *     
     */
    public TrendExpoSmooth getTrendExpoSmooth() {
        return trendExpoSmooth;
    }

    /**
     * Sets the value of the trendExpoSmooth property.
     * 
     * @param value
     *     allowed object is
     *     {@link TrendExpoSmooth }
     *     
     */
    public void setTrendExpoSmooth(TrendExpoSmooth value) {
        this.trendExpoSmooth = value;
    }

    /**
     * Gets the value of the seasonalityExpoSmooth property.
     * 
     * @return
     *     possible object is
     *     {@link SeasonalityExpoSmooth }
     *     
     */
    public SeasonalityExpoSmooth getSeasonalityExpoSmooth() {
        return seasonalityExpoSmooth;
    }

    /**
     * Sets the value of the seasonalityExpoSmooth property.
     * 
     * @param value
     *     allowed object is
     *     {@link SeasonalityExpoSmooth }
     *     
     */
    public void setSeasonalityExpoSmooth(SeasonalityExpoSmooth value) {
        this.seasonalityExpoSmooth = value;
    }

    /**
     * Gets the value of the timeValues property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the timeValues property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTimeValues().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TimeValue }
     * 
     * 
     */
    public List<TimeValue> getTimeValues() {
        if (timeValues == null) {
            timeValues = new ArrayList<TimeValue>();
        }
        return this.timeValues;
    }

    /**
     * Gets the value of the rmse property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getRMSE() {
        return rmse;
    }

    /**
     * Sets the value of the rmse property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setRMSE(Double value) {
        this.rmse = value;
    }

    /**
     * Gets the value of the transformation property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTransformation() {
        if (transformation == null) {
            return "none";
        } else {
            return transformation;
        }
    }

    /**
     * Sets the value of the transformation property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTransformation(String value) {
        this.transformation = value;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if (!(object instanceof ExponentialSmoothing)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        final ExponentialSmoothing that = ((ExponentialSmoothing) object);
        {
            Level lhsLevel;
            lhsLevel = this.getLevel();
            Level rhsLevel;
            rhsLevel = that.getLevel();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "level", lhsLevel), LocatorUtils.property(thatLocator, "level", rhsLevel), lhsLevel, rhsLevel)) {
                return false;
            }
        }
        {
            TrendExpoSmooth lhsTrendExpoSmooth;
            lhsTrendExpoSmooth = this.getTrendExpoSmooth();
            TrendExpoSmooth rhsTrendExpoSmooth;
            rhsTrendExpoSmooth = that.getTrendExpoSmooth();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "trendExpoSmooth", lhsTrendExpoSmooth), LocatorUtils.property(thatLocator, "trendExpoSmooth", rhsTrendExpoSmooth), lhsTrendExpoSmooth, rhsTrendExpoSmooth)) {
                return false;
            }
        }
        {
            SeasonalityExpoSmooth lhsSeasonalityExpoSmooth;
            lhsSeasonalityExpoSmooth = this.getSeasonalityExpoSmooth();
            SeasonalityExpoSmooth rhsSeasonalityExpoSmooth;
            rhsSeasonalityExpoSmooth = that.getSeasonalityExpoSmooth();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "seasonalityExpoSmooth", lhsSeasonalityExpoSmooth), LocatorUtils.property(thatLocator, "seasonalityExpoSmooth", rhsSeasonalityExpoSmooth), lhsSeasonalityExpoSmooth, rhsSeasonalityExpoSmooth)) {
                return false;
            }
        }
        {
            List<TimeValue> lhsTimeValues;
            lhsTimeValues = (((this.timeValues!= null)&&(!this.timeValues.isEmpty()))?this.getTimeValues():null);
            List<TimeValue> rhsTimeValues;
            rhsTimeValues = (((that.timeValues!= null)&&(!that.timeValues.isEmpty()))?that.getTimeValues():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "timeValues", lhsTimeValues), LocatorUtils.property(thatLocator, "timeValues", rhsTimeValues), lhsTimeValues, rhsTimeValues)) {
                return false;
            }
        }
        {
            Double lhsRMSE;
            lhsRMSE = this.getRMSE();
            Double rhsRMSE;
            rhsRMSE = that.getRMSE();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "rmse", lhsRMSE), LocatorUtils.property(thatLocator, "rmse", rhsRMSE), lhsRMSE, rhsRMSE)) {
                return false;
            }
        }
        {
            String lhsTransformation;
            lhsTransformation = this.getTransformation();
            String rhsTransformation;
            rhsTransformation = that.getTransformation();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "transformation", lhsTransformation), LocatorUtils.property(thatLocator, "transformation", rhsTransformation), lhsTransformation, rhsTransformation)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        {
            Level theLevel;
            theLevel = this.getLevel();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "level", theLevel), currentHashCode, theLevel);
        }
        {
            TrendExpoSmooth theTrendExpoSmooth;
            theTrendExpoSmooth = this.getTrendExpoSmooth();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "trendExpoSmooth", theTrendExpoSmooth), currentHashCode, theTrendExpoSmooth);
        }
        {
            SeasonalityExpoSmooth theSeasonalityExpoSmooth;
            theSeasonalityExpoSmooth = this.getSeasonalityExpoSmooth();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "seasonalityExpoSmooth", theSeasonalityExpoSmooth), currentHashCode, theSeasonalityExpoSmooth);
        }
        {
            List<TimeValue> theTimeValues;
            theTimeValues = (((this.timeValues!= null)&&(!this.timeValues.isEmpty()))?this.getTimeValues():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "timeValues", theTimeValues), currentHashCode, theTimeValues);
        }
        {
            Double theRMSE;
            theRMSE = this.getRMSE();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "rmse", theRMSE), currentHashCode, theRMSE);
        }
        {
            String theTransformation;
            theTransformation = this.getTransformation();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "transformation", theTransformation), currentHashCode, theTransformation);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

}
