
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}TimeSeries" maxOccurs="3" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}SpectralAnalysis" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ARIMA" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ExponentialSmoothing" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}SeasonalTrendDecomposition" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_1}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="bestFit" use="required" type="{http://www.dmg.org/PMML-4_1}TIMESERIES-ALGORITHM" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "localTransformations",
    "timeSeries",
    "spectralAnalysis",
    "arima",
    "exponentialSmoothing",
    "seasonalTrendDecomposition",
    "modelVerification"
})
@XmlRootElement(name = "TimeSeriesModel")
@Schema(min = Version.PMML_4_0)
public class TimeSeriesModel
    extends Model
    implements Equals, HashCode
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "MiningSchema", required = true)
    protected MiningSchema miningSchema;
    @XmlElement(name = "Output")
    protected Output output;
    @XmlElement(name = "ModelStats")
    protected ModelStats modelStats;
    @XmlElement(name = "ModelExplanation")
    protected ModelExplanation modelExplanation;
    @XmlElement(name = "LocalTransformations")
    protected LocalTransformations localTransformations;
    @XmlElement(name = "TimeSeries")
    protected List<TimeSeries> timeSeries;
    @XmlElement(name = "SpectralAnalysis")
    protected Object spectralAnalysis;
    @XmlElement(name = "ARIMA")
    protected Object arima;
    @XmlElement(name = "ExponentialSmoothing")
    protected ExponentialSmoothing exponentialSmoothing;
    @XmlElement(name = "SeasonalTrendDecomposition")
    protected Object seasonalTrendDecomposition;
    @XmlElement(name = "ModelVerification")
    protected ModelVerification modelVerification;
    @XmlAttribute(name = "modelName")
    protected String modelName;
    @XmlAttribute(name = "functionName", required = true)
    protected MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    protected String algorithmName;
    @XmlAttribute(name = "bestFit", required = true)
    protected TimeSeriesAlgorithmType bestFit;
    @XmlAttribute(name = "isScorable")
    protected Boolean scorable;

    @Deprecated
    public TimeSeriesModel() {
        super();
    }

    public TimeSeriesModel(final MiningSchema miningSchema, final MiningFunctionType functionName, final TimeSeriesAlgorithmType bestFit) {
        super();
        this.miningSchema = miningSchema;
        this.functionName = functionName;
        this.bestFit = bestFit;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public void setMiningSchema(MiningSchema value) {
        this.miningSchema = value;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param value
     *     allowed object is
     *     {@link Output }
     *     
     */
    public void setOutput(Output value) {
        this.output = value;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public void setModelStats(ModelStats value) {
        this.modelStats = value;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public void setModelExplanation(ModelExplanation value) {
        this.modelExplanation = value;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public void setLocalTransformations(LocalTransformations value) {
        this.localTransformations = value;
    }

    /**
     * Gets the value of the timeSeries property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the timeSeries property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTimeSeries().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TimeSeries }
     * 
     * 
     */
    public List<TimeSeries> getTimeSeries() {
        if (timeSeries == null) {
            timeSeries = new ArrayList<TimeSeries>();
        }
        return this.timeSeries;
    }

    /**
     * Gets the value of the spectralAnalysis property.
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    public Object getSpectralAnalysis() {
        return spectralAnalysis;
    }

    /**
     * Sets the value of the spectralAnalysis property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     */
    public void setSpectralAnalysis(Object value) {
        this.spectralAnalysis = value;
    }

    /**
     * Gets the value of the arima property.
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    public Object getARIMA() {
        return arima;
    }

    /**
     * Sets the value of the arima property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     */
    public void setARIMA(Object value) {
        this.arima = value;
    }

    /**
     * Gets the value of the exponentialSmoothing property.
     * 
     * @return
     *     possible object is
     *     {@link ExponentialSmoothing }
     *     
     */
    public ExponentialSmoothing getExponentialSmoothing() {
        return exponentialSmoothing;
    }

    /**
     * Sets the value of the exponentialSmoothing property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExponentialSmoothing }
     *     
     */
    public void setExponentialSmoothing(ExponentialSmoothing value) {
        this.exponentialSmoothing = value;
    }

    /**
     * Gets the value of the seasonalTrendDecomposition property.
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    public Object getSeasonalTrendDecomposition() {
        return seasonalTrendDecomposition;
    }

    /**
     * Sets the value of the seasonalTrendDecomposition property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     */
    public void setSeasonalTrendDecomposition(Object value) {
        this.seasonalTrendDecomposition = value;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public void setModelVerification(ModelVerification value) {
        this.modelVerification = value;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setModelName(String value) {
        this.modelName = value;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public void setFunctionName(MiningFunctionType value) {
        this.functionName = value;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlgorithmName(String value) {
        this.algorithmName = value;
    }

    /**
     * Gets the value of the bestFit property.
     * 
     * @return
     *     possible object is
     *     {@link TimeSeriesAlgorithmType }
     *     
     */
    public TimeSeriesAlgorithmType getBestFit() {
        return bestFit;
    }

    /**
     * Sets the value of the bestFit property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimeSeriesAlgorithmType }
     *     
     */
    public void setBestFit(TimeSeriesAlgorithmType value) {
        this.bestFit = value;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return true;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setScorable(Boolean value) {
        this.scorable = value;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if (!(object instanceof TimeSeriesModel)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        final TimeSeriesModel that = ((TimeSeriesModel) object);
        {
            List<Extension> lhsExtensions;
            lhsExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            List<Extension> rhsExtensions;
            rhsExtensions = (((that.extensions!= null)&&(!that.extensions.isEmpty()))?that.getExtensions():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "extensions", lhsExtensions), LocatorUtils.property(thatLocator, "extensions", rhsExtensions), lhsExtensions, rhsExtensions)) {
                return false;
            }
        }
        {
            MiningSchema lhsMiningSchema;
            lhsMiningSchema = this.getMiningSchema();
            MiningSchema rhsMiningSchema;
            rhsMiningSchema = that.getMiningSchema();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "miningSchema", lhsMiningSchema), LocatorUtils.property(thatLocator, "miningSchema", rhsMiningSchema), lhsMiningSchema, rhsMiningSchema)) {
                return false;
            }
        }
        {
            Output lhsOutput;
            lhsOutput = this.getOutput();
            Output rhsOutput;
            rhsOutput = that.getOutput();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "output", lhsOutput), LocatorUtils.property(thatLocator, "output", rhsOutput), lhsOutput, rhsOutput)) {
                return false;
            }
        }
        {
            ModelStats lhsModelStats;
            lhsModelStats = this.getModelStats();
            ModelStats rhsModelStats;
            rhsModelStats = that.getModelStats();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelStats", lhsModelStats), LocatorUtils.property(thatLocator, "modelStats", rhsModelStats), lhsModelStats, rhsModelStats)) {
                return false;
            }
        }
        {
            ModelExplanation lhsModelExplanation;
            lhsModelExplanation = this.getModelExplanation();
            ModelExplanation rhsModelExplanation;
            rhsModelExplanation = that.getModelExplanation();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelExplanation", lhsModelExplanation), LocatorUtils.property(thatLocator, "modelExplanation", rhsModelExplanation), lhsModelExplanation, rhsModelExplanation)) {
                return false;
            }
        }
        {
            LocalTransformations lhsLocalTransformations;
            lhsLocalTransformations = this.getLocalTransformations();
            LocalTransformations rhsLocalTransformations;
            rhsLocalTransformations = that.getLocalTransformations();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "localTransformations", lhsLocalTransformations), LocatorUtils.property(thatLocator, "localTransformations", rhsLocalTransformations), lhsLocalTransformations, rhsLocalTransformations)) {
                return false;
            }
        }
        {
            List<TimeSeries> lhsTimeSeries;
            lhsTimeSeries = (((this.timeSeries!= null)&&(!this.timeSeries.isEmpty()))?this.getTimeSeries():null);
            List<TimeSeries> rhsTimeSeries;
            rhsTimeSeries = (((that.timeSeries!= null)&&(!that.timeSeries.isEmpty()))?that.getTimeSeries():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "timeSeries", lhsTimeSeries), LocatorUtils.property(thatLocator, "timeSeries", rhsTimeSeries), lhsTimeSeries, rhsTimeSeries)) {
                return false;
            }
        }
        {
            Object lhsSpectralAnalysis;
            lhsSpectralAnalysis = this.getSpectralAnalysis();
            Object rhsSpectralAnalysis;
            rhsSpectralAnalysis = that.getSpectralAnalysis();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "spectralAnalysis", lhsSpectralAnalysis), LocatorUtils.property(thatLocator, "spectralAnalysis", rhsSpectralAnalysis), lhsSpectralAnalysis, rhsSpectralAnalysis)) {
                return false;
            }
        }
        {
            Object lhsARIMA;
            lhsARIMA = this.getARIMA();
            Object rhsARIMA;
            rhsARIMA = that.getARIMA();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "arima", lhsARIMA), LocatorUtils.property(thatLocator, "arima", rhsARIMA), lhsARIMA, rhsARIMA)) {
                return false;
            }
        }
        {
            ExponentialSmoothing lhsExponentialSmoothing;
            lhsExponentialSmoothing = this.getExponentialSmoothing();
            ExponentialSmoothing rhsExponentialSmoothing;
            rhsExponentialSmoothing = that.getExponentialSmoothing();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "exponentialSmoothing", lhsExponentialSmoothing), LocatorUtils.property(thatLocator, "exponentialSmoothing", rhsExponentialSmoothing), lhsExponentialSmoothing, rhsExponentialSmoothing)) {
                return false;
            }
        }
        {
            Object lhsSeasonalTrendDecomposition;
            lhsSeasonalTrendDecomposition = this.getSeasonalTrendDecomposition();
            Object rhsSeasonalTrendDecomposition;
            rhsSeasonalTrendDecomposition = that.getSeasonalTrendDecomposition();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "seasonalTrendDecomposition", lhsSeasonalTrendDecomposition), LocatorUtils.property(thatLocator, "seasonalTrendDecomposition", rhsSeasonalTrendDecomposition), lhsSeasonalTrendDecomposition, rhsSeasonalTrendDecomposition)) {
                return false;
            }
        }
        {
            ModelVerification lhsModelVerification;
            lhsModelVerification = this.getModelVerification();
            ModelVerification rhsModelVerification;
            rhsModelVerification = that.getModelVerification();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelVerification", lhsModelVerification), LocatorUtils.property(thatLocator, "modelVerification", rhsModelVerification), lhsModelVerification, rhsModelVerification)) {
                return false;
            }
        }
        {
            String lhsModelName;
            lhsModelName = this.getModelName();
            String rhsModelName;
            rhsModelName = that.getModelName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelName", lhsModelName), LocatorUtils.property(thatLocator, "modelName", rhsModelName), lhsModelName, rhsModelName)) {
                return false;
            }
        }
        {
            MiningFunctionType lhsFunctionName;
            lhsFunctionName = this.getFunctionName();
            MiningFunctionType rhsFunctionName;
            rhsFunctionName = that.getFunctionName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "functionName", lhsFunctionName), LocatorUtils.property(thatLocator, "functionName", rhsFunctionName), lhsFunctionName, rhsFunctionName)) {
                return false;
            }
        }
        {
            String lhsAlgorithmName;
            lhsAlgorithmName = this.getAlgorithmName();
            String rhsAlgorithmName;
            rhsAlgorithmName = that.getAlgorithmName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "algorithmName", lhsAlgorithmName), LocatorUtils.property(thatLocator, "algorithmName", rhsAlgorithmName), lhsAlgorithmName, rhsAlgorithmName)) {
                return false;
            }
        }
        {
            TimeSeriesAlgorithmType lhsBestFit;
            lhsBestFit = this.getBestFit();
            TimeSeriesAlgorithmType rhsBestFit;
            rhsBestFit = that.getBestFit();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "bestFit", lhsBestFit), LocatorUtils.property(thatLocator, "bestFit", rhsBestFit), lhsBestFit, rhsBestFit)) {
                return false;
            }
        }
        {
            boolean lhsScorable;
            lhsScorable = ((this.scorable!= null)?this.isScorable():false);
            boolean rhsScorable;
            rhsScorable = ((that.scorable!= null)?that.isScorable():false);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "scorable", lhsScorable), LocatorUtils.property(thatLocator, "scorable", rhsScorable), lhsScorable, rhsScorable)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        {
            List<Extension> theExtensions;
            theExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "extensions", theExtensions), currentHashCode, theExtensions);
        }
        {
            MiningSchema theMiningSchema;
            theMiningSchema = this.getMiningSchema();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "miningSchema", theMiningSchema), currentHashCode, theMiningSchema);
        }
        {
            Output theOutput;
            theOutput = this.getOutput();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "output", theOutput), currentHashCode, theOutput);
        }
        {
            ModelStats theModelStats;
            theModelStats = this.getModelStats();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelStats", theModelStats), currentHashCode, theModelStats);
        }
        {
            ModelExplanation theModelExplanation;
            theModelExplanation = this.getModelExplanation();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelExplanation", theModelExplanation), currentHashCode, theModelExplanation);
        }
        {
            LocalTransformations theLocalTransformations;
            theLocalTransformations = this.getLocalTransformations();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "localTransformations", theLocalTransformations), currentHashCode, theLocalTransformations);
        }
        {
            List<TimeSeries> theTimeSeries;
            theTimeSeries = (((this.timeSeries!= null)&&(!this.timeSeries.isEmpty()))?this.getTimeSeries():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "timeSeries", theTimeSeries), currentHashCode, theTimeSeries);
        }
        {
            Object theSpectralAnalysis;
            theSpectralAnalysis = this.getSpectralAnalysis();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "spectralAnalysis", theSpectralAnalysis), currentHashCode, theSpectralAnalysis);
        }
        {
            Object theARIMA;
            theARIMA = this.getARIMA();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "arima", theARIMA), currentHashCode, theARIMA);
        }
        {
            ExponentialSmoothing theExponentialSmoothing;
            theExponentialSmoothing = this.getExponentialSmoothing();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "exponentialSmoothing", theExponentialSmoothing), currentHashCode, theExponentialSmoothing);
        }
        {
            Object theSeasonalTrendDecomposition;
            theSeasonalTrendDecomposition = this.getSeasonalTrendDecomposition();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "seasonalTrendDecomposition", theSeasonalTrendDecomposition), currentHashCode, theSeasonalTrendDecomposition);
        }
        {
            ModelVerification theModelVerification;
            theModelVerification = this.getModelVerification();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelVerification", theModelVerification), currentHashCode, theModelVerification);
        }
        {
            String theModelName;
            theModelName = this.getModelName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelName", theModelName), currentHashCode, theModelName);
        }
        {
            MiningFunctionType theFunctionName;
            theFunctionName = this.getFunctionName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "functionName", theFunctionName), currentHashCode, theFunctionName);
        }
        {
            String theAlgorithmName;
            theAlgorithmName = this.getAlgorithmName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "algorithmName", theAlgorithmName), currentHashCode, theAlgorithmName);
        }
        {
            TimeSeriesAlgorithmType theBestFit;
            theBestFit = this.getBestFit();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "bestFit", theBestFit), currentHashCode, theBestFit);
        }
        {
            boolean theScorable;
            theScorable = ((this.scorable!= null)?this.isScorable():false);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "scorable", theScorable), currentHashCode, theScorable);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

}
