
package org.dmg.pmml;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;sequence minOccurs="0">
 *           &lt;element ref="{http://www.dmg.org/PMML-4_1}Decisions" minOccurs="0"/>
 *           &lt;group ref="{http://www.dmg.org/PMML-4_1}EXPRESSION"/>
 *         &lt;/sequence>
 *       &lt;/sequence>
 *       &lt;attribute name="name" use="required" type="{http://www.dmg.org/PMML-4_1}FIELD-NAME" />
 *       &lt;attribute name="displayName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="optype" type="{http://www.dmg.org/PMML-4_1}OPTYPE" />
 *       &lt;attribute name="dataType" type="{http://www.dmg.org/PMML-4_1}DATATYPE" />
 *       &lt;attribute name="targetField" type="{http://www.dmg.org/PMML-4_1}FIELD-NAME" />
 *       &lt;attribute name="feature" type="{http://www.dmg.org/PMML-4_1}RESULT-FEATURE" />
 *       &lt;attribute name="value" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="ruleFeature" type="{http://www.dmg.org/PMML-4_1}RULE-FEATURE" default="consequent" />
 *       &lt;attribute name="algorithm" default="exclusiveRecommendation">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="recommendation"/>
 *             &lt;enumeration value="exclusiveRecommendation"/>
 *             &lt;enumeration value="ruleAssociation"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="rank" type="{http://www.dmg.org/PMML-4_1}INT-NUMBER" default="1" />
 *       &lt;attribute name="rankBasis" default="confidence">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="confidence"/>
 *             &lt;enumeration value="support"/>
 *             &lt;enumeration value="lift"/>
 *             &lt;enumeration value="leverage"/>
 *             &lt;enumeration value="affinity"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="rankOrder" default="descending">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="descending"/>
 *             &lt;enumeration value="ascending"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="isMultiValued" type="{http://www.w3.org/2001/XMLSchema}anySimpleType" default="0" />
 *       &lt;attribute name="segmentId" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "decisions",
    "expression"
})
@XmlRootElement(name = "OutputField")
public class OutputField
    extends DictionaryField
    implements Equals, HashCode, ToString
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "Decisions")
    protected Decisions decisions;
    @XmlElements({
        @XmlElement(name = "Constant", type = Constant.class),
        @XmlElement(name = "FieldRef", type = FieldRef.class),
        @XmlElement(name = "NormContinuous", type = NormContinuous.class),
        @XmlElement(name = "NormDiscrete", type = NormDiscrete.class),
        @XmlElement(name = "Discretize", type = Discretize.class),
        @XmlElement(name = "MapValues", type = MapValues.class),
        @XmlElement(name = "Apply", type = Apply.class),
        @XmlElement(name = "Aggregate", type = Aggregate.class)
    })
    protected Expression expression;
    @XmlAttribute(name = "name", required = true)
    protected FieldName name;
    @XmlAttribute(name = "displayName")
    protected String displayName;
    @XmlAttribute(name = "optype")
    protected OpType optype;
    @XmlAttribute(name = "dataType")
    protected DataType dataType;
    @XmlAttribute(name = "targetField")
    protected FieldName targetField;
    @XmlAttribute(name = "feature")
    protected ResultFeatureType feature;
    @XmlAttribute(name = "value")
    protected String value;
    @XmlAttribute(name = "ruleFeature")
    protected RuleFeatureType ruleFeature;
    @XmlAttribute(name = "algorithm")
    protected String algorithm;
    @XmlAttribute(name = "rank")
    protected BigInteger rank;
    @XmlAttribute(name = "rankBasis")
    protected String rankBasis;
    @XmlAttribute(name = "rankOrder")
    protected String rankOrder;
    @XmlAttribute(name = "isMultiValued")
    @XmlSchemaType(name = "anySimpleType")
    protected String isMultiValued;
    @XmlAttribute(name = "segmentId")
    protected String segmentId;

    @Deprecated
    public OutputField() {
        super();
    }

    public OutputField(final FieldName name) {
        super();
        this.name = name;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the decisions property.
     * 
     * @return
     *     possible object is
     *     {@link Decisions }
     *     
     */
    public Decisions getDecisions() {
        return decisions;
    }

    /**
     * Sets the value of the decisions property.
     * 
     * @param value
     *     allowed object is
     *     {@link Decisions }
     *     
     */
    public void setDecisions(Decisions value) {
        this.decisions = value;
    }

    /**
     * Gets the value of the expression property.
     * 
     * @return
     *     possible object is
     *     {@link Constant }
     *     {@link FieldRef }
     *     {@link NormContinuous }
     *     {@link NormDiscrete }
     *     {@link Discretize }
     *     {@link MapValues }
     *     {@link Apply }
     *     {@link Aggregate }
     *     
     */
    public Expression getExpression() {
        return expression;
    }

    /**
     * Sets the value of the expression property.
     * 
     * @param value
     *     allowed object is
     *     {@link Constant }
     *     {@link FieldRef }
     *     {@link NormContinuous }
     *     {@link NormDiscrete }
     *     {@link Discretize }
     *     {@link MapValues }
     *     {@link Apply }
     *     {@link Aggregate }
     *     
     */
    public void setExpression(Expression value) {
        this.expression = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link FieldName }
     *     
     */
    public FieldName getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link FieldName }
     *     
     */
    public void setName(FieldName value) {
        this.name = value;
    }

    /**
     * Gets the value of the displayName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * Sets the value of the displayName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDisplayName(String value) {
        this.displayName = value;
    }

    /**
     * Gets the value of the optype property.
     * 
     * @return
     *     possible object is
     *     {@link OpType }
     *     
     */
    public OpType getOptype() {
        return optype;
    }

    /**
     * Sets the value of the optype property.
     * 
     * @param value
     *     allowed object is
     *     {@link OpType }
     *     
     */
    public void setOptype(OpType value) {
        this.optype = value;
    }

    /**
     * Gets the value of the dataType property.
     * 
     * @return
     *     possible object is
     *     {@link DataType }
     *     
     */
    public DataType getDataType() {
        return dataType;
    }

    /**
     * Sets the value of the dataType property.
     * 
     * @param value
     *     allowed object is
     *     {@link DataType }
     *     
     */
    public void setDataType(DataType value) {
        this.dataType = value;
    }

    /**
     * Gets the value of the targetField property.
     * 
     * @return
     *     possible object is
     *     {@link FieldName }
     *     
     */
    public FieldName getTargetField() {
        return targetField;
    }

    /**
     * Sets the value of the targetField property.
     * 
     * @param value
     *     allowed object is
     *     {@link FieldName }
     *     
     */
    public void setTargetField(FieldName value) {
        this.targetField = value;
    }

    /**
     * Gets the value of the feature property.
     * 
     * @return
     *     possible object is
     *     {@link ResultFeatureType }
     *     
     */
    public ResultFeatureType getFeature() {
        return feature;
    }

    /**
     * Sets the value of the feature property.
     * 
     * @param value
     *     allowed object is
     *     {@link ResultFeatureType }
     *     
     */
    public void setFeature(ResultFeatureType value) {
        this.feature = value;
    }

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * Gets the value of the ruleFeature property.
     * 
     * @return
     *     possible object is
     *     {@link RuleFeatureType }
     *     
     */
    public RuleFeatureType getRuleFeature() {
        if (ruleFeature == null) {
            return RuleFeatureType.CONSEQUENT;
        } else {
            return ruleFeature;
        }
    }

    /**
     * Sets the value of the ruleFeature property.
     * 
     * @param value
     *     allowed object is
     *     {@link RuleFeatureType }
     *     
     */
    public void setRuleFeature(RuleFeatureType value) {
        this.ruleFeature = value;
    }

    /**
     * Gets the value of the algorithm property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithm() {
        if (algorithm == null) {
            return "exclusiveRecommendation";
        } else {
            return algorithm;
        }
    }

    /**
     * Sets the value of the algorithm property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlgorithm(String value) {
        this.algorithm = value;
    }

    /**
     * Gets the value of the rank property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getRank() {
        if (rank == null) {
            return new BigInteger("1");
        } else {
            return rank;
        }
    }

    /**
     * Sets the value of the rank property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setRank(BigInteger value) {
        this.rank = value;
    }

    /**
     * Gets the value of the rankBasis property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRankBasis() {
        if (rankBasis == null) {
            return "confidence";
        } else {
            return rankBasis;
        }
    }

    /**
     * Sets the value of the rankBasis property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRankBasis(String value) {
        this.rankBasis = value;
    }

    /**
     * Gets the value of the rankOrder property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRankOrder() {
        if (rankOrder == null) {
            return "descending";
        } else {
            return rankOrder;
        }
    }

    /**
     * Sets the value of the rankOrder property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRankOrder(String value) {
        this.rankOrder = value;
    }

    /**
     * Gets the value of the isMultiValued property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getIsMultiValued() {
        if (isMultiValued == null) {
            return "0";
        } else {
            return isMultiValued;
        }
    }

    /**
     * Sets the value of the isMultiValued property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setIsMultiValued(String value) {
        this.isMultiValued = value;
    }

    /**
     * Gets the value of the segmentId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSegmentId() {
        return segmentId;
    }

    /**
     * Sets the value of the segmentId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSegmentId(String value) {
        this.segmentId = value;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if (!(object instanceof OutputField)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        final OutputField that = ((OutputField) object);
        {
            List<Extension> lhsExtensions;
            lhsExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            List<Extension> rhsExtensions;
            rhsExtensions = (((that.extensions!= null)&&(!that.extensions.isEmpty()))?that.getExtensions():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "extensions", lhsExtensions), LocatorUtils.property(thatLocator, "extensions", rhsExtensions), lhsExtensions, rhsExtensions)) {
                return false;
            }
        }
        {
            Decisions lhsDecisions;
            lhsDecisions = this.getDecisions();
            Decisions rhsDecisions;
            rhsDecisions = that.getDecisions();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "decisions", lhsDecisions), LocatorUtils.property(thatLocator, "decisions", rhsDecisions), lhsDecisions, rhsDecisions)) {
                return false;
            }
        }
        {
            Expression lhsExpression;
            lhsExpression = this.getExpression();
            Expression rhsExpression;
            rhsExpression = that.getExpression();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "expression", lhsExpression), LocatorUtils.property(thatLocator, "expression", rhsExpression), lhsExpression, rhsExpression)) {
                return false;
            }
        }
        {
            FieldName lhsName;
            lhsName = this.getName();
            FieldName rhsName;
            rhsName = that.getName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "name", lhsName), LocatorUtils.property(thatLocator, "name", rhsName), lhsName, rhsName)) {
                return false;
            }
        }
        {
            String lhsDisplayName;
            lhsDisplayName = this.getDisplayName();
            String rhsDisplayName;
            rhsDisplayName = that.getDisplayName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "displayName", lhsDisplayName), LocatorUtils.property(thatLocator, "displayName", rhsDisplayName), lhsDisplayName, rhsDisplayName)) {
                return false;
            }
        }
        {
            OpType lhsOptype;
            lhsOptype = this.getOptype();
            OpType rhsOptype;
            rhsOptype = that.getOptype();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "optype", lhsOptype), LocatorUtils.property(thatLocator, "optype", rhsOptype), lhsOptype, rhsOptype)) {
                return false;
            }
        }
        {
            DataType lhsDataType;
            lhsDataType = this.getDataType();
            DataType rhsDataType;
            rhsDataType = that.getDataType();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "dataType", lhsDataType), LocatorUtils.property(thatLocator, "dataType", rhsDataType), lhsDataType, rhsDataType)) {
                return false;
            }
        }
        {
            FieldName lhsTargetField;
            lhsTargetField = this.getTargetField();
            FieldName rhsTargetField;
            rhsTargetField = that.getTargetField();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "targetField", lhsTargetField), LocatorUtils.property(thatLocator, "targetField", rhsTargetField), lhsTargetField, rhsTargetField)) {
                return false;
            }
        }
        {
            ResultFeatureType lhsFeature;
            lhsFeature = this.getFeature();
            ResultFeatureType rhsFeature;
            rhsFeature = that.getFeature();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "feature", lhsFeature), LocatorUtils.property(thatLocator, "feature", rhsFeature), lhsFeature, rhsFeature)) {
                return false;
            }
        }
        {
            String lhsValue;
            lhsValue = this.getValue();
            String rhsValue;
            rhsValue = that.getValue();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "value", lhsValue), LocatorUtils.property(thatLocator, "value", rhsValue), lhsValue, rhsValue)) {
                return false;
            }
        }
        {
            RuleFeatureType lhsRuleFeature;
            lhsRuleFeature = this.getRuleFeature();
            RuleFeatureType rhsRuleFeature;
            rhsRuleFeature = that.getRuleFeature();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "ruleFeature", lhsRuleFeature), LocatorUtils.property(thatLocator, "ruleFeature", rhsRuleFeature), lhsRuleFeature, rhsRuleFeature)) {
                return false;
            }
        }
        {
            String lhsAlgorithm;
            lhsAlgorithm = this.getAlgorithm();
            String rhsAlgorithm;
            rhsAlgorithm = that.getAlgorithm();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "algorithm", lhsAlgorithm), LocatorUtils.property(thatLocator, "algorithm", rhsAlgorithm), lhsAlgorithm, rhsAlgorithm)) {
                return false;
            }
        }
        {
            BigInteger lhsRank;
            lhsRank = this.getRank();
            BigInteger rhsRank;
            rhsRank = that.getRank();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "rank", lhsRank), LocatorUtils.property(thatLocator, "rank", rhsRank), lhsRank, rhsRank)) {
                return false;
            }
        }
        {
            String lhsRankBasis;
            lhsRankBasis = this.getRankBasis();
            String rhsRankBasis;
            rhsRankBasis = that.getRankBasis();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "rankBasis", lhsRankBasis), LocatorUtils.property(thatLocator, "rankBasis", rhsRankBasis), lhsRankBasis, rhsRankBasis)) {
                return false;
            }
        }
        {
            String lhsRankOrder;
            lhsRankOrder = this.getRankOrder();
            String rhsRankOrder;
            rhsRankOrder = that.getRankOrder();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "rankOrder", lhsRankOrder), LocatorUtils.property(thatLocator, "rankOrder", rhsRankOrder), lhsRankOrder, rhsRankOrder)) {
                return false;
            }
        }
        {
            String lhsIsMultiValued;
            lhsIsMultiValued = this.getIsMultiValued();
            String rhsIsMultiValued;
            rhsIsMultiValued = that.getIsMultiValued();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "isMultiValued", lhsIsMultiValued), LocatorUtils.property(thatLocator, "isMultiValued", rhsIsMultiValued), lhsIsMultiValued, rhsIsMultiValued)) {
                return false;
            }
        }
        {
            String lhsSegmentId;
            lhsSegmentId = this.getSegmentId();
            String rhsSegmentId;
            rhsSegmentId = that.getSegmentId();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "segmentId", lhsSegmentId), LocatorUtils.property(thatLocator, "segmentId", rhsSegmentId), lhsSegmentId, rhsSegmentId)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        {
            List<Extension> theExtensions;
            theExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "extensions", theExtensions), currentHashCode, theExtensions);
        }
        {
            Decisions theDecisions;
            theDecisions = this.getDecisions();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "decisions", theDecisions), currentHashCode, theDecisions);
        }
        {
            Expression theExpression;
            theExpression = this.getExpression();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "expression", theExpression), currentHashCode, theExpression);
        }
        {
            FieldName theName;
            theName = this.getName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "name", theName), currentHashCode, theName);
        }
        {
            String theDisplayName;
            theDisplayName = this.getDisplayName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "displayName", theDisplayName), currentHashCode, theDisplayName);
        }
        {
            OpType theOptype;
            theOptype = this.getOptype();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "optype", theOptype), currentHashCode, theOptype);
        }
        {
            DataType theDataType;
            theDataType = this.getDataType();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "dataType", theDataType), currentHashCode, theDataType);
        }
        {
            FieldName theTargetField;
            theTargetField = this.getTargetField();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "targetField", theTargetField), currentHashCode, theTargetField);
        }
        {
            ResultFeatureType theFeature;
            theFeature = this.getFeature();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "feature", theFeature), currentHashCode, theFeature);
        }
        {
            String theValue;
            theValue = this.getValue();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "value", theValue), currentHashCode, theValue);
        }
        {
            RuleFeatureType theRuleFeature;
            theRuleFeature = this.getRuleFeature();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "ruleFeature", theRuleFeature), currentHashCode, theRuleFeature);
        }
        {
            String theAlgorithm;
            theAlgorithm = this.getAlgorithm();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "algorithm", theAlgorithm), currentHashCode, theAlgorithm);
        }
        {
            BigInteger theRank;
            theRank = this.getRank();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "rank", theRank), currentHashCode, theRank);
        }
        {
            String theRankBasis;
            theRankBasis = this.getRankBasis();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "rankBasis", theRankBasis), currentHashCode, theRankBasis);
        }
        {
            String theRankOrder;
            theRankOrder = this.getRankOrder();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "rankOrder", theRankOrder), currentHashCode, theRankOrder);
        }
        {
            String theIsMultiValued;
            theIsMultiValued = this.getIsMultiValued();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "isMultiValued", theIsMultiValued), currentHashCode, theIsMultiValued);
        }
        {
            String theSegmentId;
            theSegmentId = this.getSegmentId();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "segmentId", theSegmentId), currentHashCode, theSegmentId);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<Extension> theExtensions;
            theExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            strategy.appendField(locator, this, "extensions", buffer, theExtensions);
        }
        {
            Decisions theDecisions;
            theDecisions = this.getDecisions();
            strategy.appendField(locator, this, "decisions", buffer, theDecisions);
        }
        {
            Expression theExpression;
            theExpression = this.getExpression();
            strategy.appendField(locator, this, "expression", buffer, theExpression);
        }
        {
            FieldName theName;
            theName = this.getName();
            strategy.appendField(locator, this, "name", buffer, theName);
        }
        {
            String theDisplayName;
            theDisplayName = this.getDisplayName();
            strategy.appendField(locator, this, "displayName", buffer, theDisplayName);
        }
        {
            OpType theOptype;
            theOptype = this.getOptype();
            strategy.appendField(locator, this, "optype", buffer, theOptype);
        }
        {
            DataType theDataType;
            theDataType = this.getDataType();
            strategy.appendField(locator, this, "dataType", buffer, theDataType);
        }
        {
            FieldName theTargetField;
            theTargetField = this.getTargetField();
            strategy.appendField(locator, this, "targetField", buffer, theTargetField);
        }
        {
            ResultFeatureType theFeature;
            theFeature = this.getFeature();
            strategy.appendField(locator, this, "feature", buffer, theFeature);
        }
        {
            String theValue;
            theValue = this.getValue();
            strategy.appendField(locator, this, "value", buffer, theValue);
        }
        {
            RuleFeatureType theRuleFeature;
            theRuleFeature = this.getRuleFeature();
            strategy.appendField(locator, this, "ruleFeature", buffer, theRuleFeature);
        }
        {
            String theAlgorithm;
            theAlgorithm = this.getAlgorithm();
            strategy.appendField(locator, this, "algorithm", buffer, theAlgorithm);
        }
        {
            BigInteger theRank;
            theRank = this.getRank();
            strategy.appendField(locator, this, "rank", buffer, theRank);
        }
        {
            String theRankBasis;
            theRankBasis = this.getRankBasis();
            strategy.appendField(locator, this, "rankBasis", buffer, theRankBasis);
        }
        {
            String theRankOrder;
            theRankOrder = this.getRankOrder();
            strategy.appendField(locator, this, "rankOrder", buffer, theRankOrder);
        }
        {
            String theIsMultiValued;
            theIsMultiValued = this.getIsMultiValued();
            strategy.appendField(locator, this, "isMultiValued", buffer, theIsMultiValued);
        }
        {
            String theSegmentId;
            theSegmentId = this.getSegmentId();
            strategy.appendField(locator, this, "segmentId", buffer, theSegmentId);
        }
        return buffer;
    }

}
