
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}LocalTransformations" minOccurs="0"/>
 *         &lt;sequence>
 *           &lt;choice>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_1}LinearKernelType"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_1}PolynomialKernelType"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_1}RadialBasisKernelType"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_1}SigmoidKernelType"/>
 *           &lt;/choice>
 *         &lt;/sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}VectorDictionary"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}SupportVectorMachine" maxOccurs="unbounded"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_1}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="threshold" type="{http://www.dmg.org/PMML-4_1}REAL-NUMBER" default="0" />
 *       &lt;attribute name="svmRepresentation" type="{http://www.dmg.org/PMML-4_1}SVM-REPRESENTATION" default="SupportVectors" />
 *       &lt;attribute name="classificationMethod" type="{http://www.dmg.org/PMML-4_1}SVM-CLASSIFICATION-METHOD" default="OneAgainstAll" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "linearKernelType",
    "polynomialKernelType",
    "radialBasisKernelType",
    "sigmoidKernelType",
    "vectorDictionary",
    "supportVectorMachines",
    "modelVerification"
})
@XmlRootElement(name = "SupportVectorMachineModel")
public class SupportVectorMachineModel
    extends Model
    implements Equals, HashCode, ToString
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "MiningSchema", required = true)
    protected MiningSchema miningSchema;
    @XmlElement(name = "Output")
    protected Output output;
    @XmlElement(name = "ModelStats")
    protected ModelStats modelStats;
    @XmlElement(name = "ModelExplanation")
    protected ModelExplanation modelExplanation;
    @XmlElement(name = "Targets")
    protected Targets targets;
    @XmlElement(name = "LocalTransformations")
    protected LocalTransformations localTransformations;
    @XmlElement(name = "LinearKernelType")
    protected LinearKernelType linearKernelType;
    @XmlElement(name = "PolynomialKernelType")
    protected PolynomialKernelType polynomialKernelType;
    @XmlElement(name = "RadialBasisKernelType")
    protected RadialBasisKernelType radialBasisKernelType;
    @XmlElement(name = "SigmoidKernelType")
    protected SigmoidKernelType sigmoidKernelType;
    @XmlElement(name = "VectorDictionary", required = true)
    protected VectorDictionary vectorDictionary;
    @XmlElement(name = "SupportVectorMachine", required = true)
    protected List<SupportVectorMachine> supportVectorMachines;
    @XmlElement(name = "ModelVerification")
    protected ModelVerification modelVerification;
    @XmlAttribute(name = "modelName")
    protected String modelName;
    @XmlAttribute(name = "functionName", required = true)
    protected MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    protected String algorithmName;
    @XmlAttribute(name = "threshold")
    protected Double threshold;
    @XmlAttribute(name = "svmRepresentation")
    protected SvmRepresentationType svmRepresentation;
    @XmlAttribute(name = "classificationMethod")
    protected SvmClassificationMethodType classificationMethod;
    @XmlAttribute(name = "isScorable")
    protected Boolean scorable;

    @Deprecated
    public SupportVectorMachineModel() {
        super();
    }

    public SupportVectorMachineModel(final MiningSchema miningSchema, final VectorDictionary vectorDictionary, final MiningFunctionType functionName) {
        super();
        this.miningSchema = miningSchema;
        this.vectorDictionary = vectorDictionary;
        this.functionName = functionName;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public void setMiningSchema(MiningSchema value) {
        this.miningSchema = value;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param value
     *     allowed object is
     *     {@link Output }
     *     
     */
    public void setOutput(Output value) {
        this.output = value;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public void setModelStats(ModelStats value) {
        this.modelStats = value;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public void setModelExplanation(ModelExplanation value) {
        this.modelExplanation = value;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param value
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public void setTargets(Targets value) {
        this.targets = value;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public void setLocalTransformations(LocalTransformations value) {
        this.localTransformations = value;
    }

    /**
     * Gets the value of the linearKernelType property.
     * 
     * @return
     *     possible object is
     *     {@link LinearKernelType }
     *     
     */
    public LinearKernelType getLinearKernelType() {
        return linearKernelType;
    }

    /**
     * Sets the value of the linearKernelType property.
     * 
     * @param value
     *     allowed object is
     *     {@link LinearKernelType }
     *     
     */
    public void setLinearKernelType(LinearKernelType value) {
        this.linearKernelType = value;
    }

    /**
     * Gets the value of the polynomialKernelType property.
     * 
     * @return
     *     possible object is
     *     {@link PolynomialKernelType }
     *     
     */
    public PolynomialKernelType getPolynomialKernelType() {
        return polynomialKernelType;
    }

    /**
     * Sets the value of the polynomialKernelType property.
     * 
     * @param value
     *     allowed object is
     *     {@link PolynomialKernelType }
     *     
     */
    public void setPolynomialKernelType(PolynomialKernelType value) {
        this.polynomialKernelType = value;
    }

    /**
     * Gets the value of the radialBasisKernelType property.
     * 
     * @return
     *     possible object is
     *     {@link RadialBasisKernelType }
     *     
     */
    public RadialBasisKernelType getRadialBasisKernelType() {
        return radialBasisKernelType;
    }

    /**
     * Sets the value of the radialBasisKernelType property.
     * 
     * @param value
     *     allowed object is
     *     {@link RadialBasisKernelType }
     *     
     */
    public void setRadialBasisKernelType(RadialBasisKernelType value) {
        this.radialBasisKernelType = value;
    }

    /**
     * Gets the value of the sigmoidKernelType property.
     * 
     * @return
     *     possible object is
     *     {@link SigmoidKernelType }
     *     
     */
    public SigmoidKernelType getSigmoidKernelType() {
        return sigmoidKernelType;
    }

    /**
     * Sets the value of the sigmoidKernelType property.
     * 
     * @param value
     *     allowed object is
     *     {@link SigmoidKernelType }
     *     
     */
    public void setSigmoidKernelType(SigmoidKernelType value) {
        this.sigmoidKernelType = value;
    }

    /**
     * Gets the value of the vectorDictionary property.
     * 
     * @return
     *     possible object is
     *     {@link VectorDictionary }
     *     
     */
    public VectorDictionary getVectorDictionary() {
        return vectorDictionary;
    }

    /**
     * Sets the value of the vectorDictionary property.
     * 
     * @param value
     *     allowed object is
     *     {@link VectorDictionary }
     *     
     */
    public void setVectorDictionary(VectorDictionary value) {
        this.vectorDictionary = value;
    }

    /**
     * Gets the value of the supportVectorMachines property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the supportVectorMachines property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSupportVectorMachines().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SupportVectorMachine }
     * 
     * 
     */
    public List<SupportVectorMachine> getSupportVectorMachines() {
        if (supportVectorMachines == null) {
            supportVectorMachines = new ArrayList<SupportVectorMachine>();
        }
        return this.supportVectorMachines;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public void setModelVerification(ModelVerification value) {
        this.modelVerification = value;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setModelName(String value) {
        this.modelName = value;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public void setFunctionName(MiningFunctionType value) {
        this.functionName = value;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlgorithmName(String value) {
        this.algorithmName = value;
    }

    /**
     * Gets the value of the threshold property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getThreshold() {
        if (threshold == null) {
            return  0.0D;
        } else {
            return threshold;
        }
    }

    /**
     * Sets the value of the threshold property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setThreshold(Double value) {
        this.threshold = value;
    }

    /**
     * Gets the value of the svmRepresentation property.
     * 
     * @return
     *     possible object is
     *     {@link SvmRepresentationType }
     *     
     */
    public SvmRepresentationType getSvmRepresentation() {
        if (svmRepresentation == null) {
            return SvmRepresentationType.SUPPORT_VECTORS;
        } else {
            return svmRepresentation;
        }
    }

    /**
     * Sets the value of the svmRepresentation property.
     * 
     * @param value
     *     allowed object is
     *     {@link SvmRepresentationType }
     *     
     */
    public void setSvmRepresentation(SvmRepresentationType value) {
        this.svmRepresentation = value;
    }

    /**
     * Gets the value of the classificationMethod property.
     * 
     * @return
     *     possible object is
     *     {@link SvmClassificationMethodType }
     *     
     */
    public SvmClassificationMethodType getClassificationMethod() {
        if (classificationMethod == null) {
            return SvmClassificationMethodType.ONE_AGAINST_ALL;
        } else {
            return classificationMethod;
        }
    }

    /**
     * Sets the value of the classificationMethod property.
     * 
     * @param value
     *     allowed object is
     *     {@link SvmClassificationMethodType }
     *     
     */
    public void setClassificationMethod(SvmClassificationMethodType value) {
        this.classificationMethod = value;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return true;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setScorable(Boolean value) {
        this.scorable = value;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if (!(object instanceof SupportVectorMachineModel)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        final SupportVectorMachineModel that = ((SupportVectorMachineModel) object);
        {
            List<Extension> lhsExtensions;
            lhsExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            List<Extension> rhsExtensions;
            rhsExtensions = (((that.extensions!= null)&&(!that.extensions.isEmpty()))?that.getExtensions():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "extensions", lhsExtensions), LocatorUtils.property(thatLocator, "extensions", rhsExtensions), lhsExtensions, rhsExtensions)) {
                return false;
            }
        }
        {
            MiningSchema lhsMiningSchema;
            lhsMiningSchema = this.getMiningSchema();
            MiningSchema rhsMiningSchema;
            rhsMiningSchema = that.getMiningSchema();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "miningSchema", lhsMiningSchema), LocatorUtils.property(thatLocator, "miningSchema", rhsMiningSchema), lhsMiningSchema, rhsMiningSchema)) {
                return false;
            }
        }
        {
            Output lhsOutput;
            lhsOutput = this.getOutput();
            Output rhsOutput;
            rhsOutput = that.getOutput();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "output", lhsOutput), LocatorUtils.property(thatLocator, "output", rhsOutput), lhsOutput, rhsOutput)) {
                return false;
            }
        }
        {
            ModelStats lhsModelStats;
            lhsModelStats = this.getModelStats();
            ModelStats rhsModelStats;
            rhsModelStats = that.getModelStats();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelStats", lhsModelStats), LocatorUtils.property(thatLocator, "modelStats", rhsModelStats), lhsModelStats, rhsModelStats)) {
                return false;
            }
        }
        {
            ModelExplanation lhsModelExplanation;
            lhsModelExplanation = this.getModelExplanation();
            ModelExplanation rhsModelExplanation;
            rhsModelExplanation = that.getModelExplanation();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelExplanation", lhsModelExplanation), LocatorUtils.property(thatLocator, "modelExplanation", rhsModelExplanation), lhsModelExplanation, rhsModelExplanation)) {
                return false;
            }
        }
        {
            Targets lhsTargets;
            lhsTargets = this.getTargets();
            Targets rhsTargets;
            rhsTargets = that.getTargets();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "targets", lhsTargets), LocatorUtils.property(thatLocator, "targets", rhsTargets), lhsTargets, rhsTargets)) {
                return false;
            }
        }
        {
            LocalTransformations lhsLocalTransformations;
            lhsLocalTransformations = this.getLocalTransformations();
            LocalTransformations rhsLocalTransformations;
            rhsLocalTransformations = that.getLocalTransformations();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "localTransformations", lhsLocalTransformations), LocatorUtils.property(thatLocator, "localTransformations", rhsLocalTransformations), lhsLocalTransformations, rhsLocalTransformations)) {
                return false;
            }
        }
        {
            LinearKernelType lhsLinearKernelType;
            lhsLinearKernelType = this.getLinearKernelType();
            LinearKernelType rhsLinearKernelType;
            rhsLinearKernelType = that.getLinearKernelType();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "linearKernelType", lhsLinearKernelType), LocatorUtils.property(thatLocator, "linearKernelType", rhsLinearKernelType), lhsLinearKernelType, rhsLinearKernelType)) {
                return false;
            }
        }
        {
            PolynomialKernelType lhsPolynomialKernelType;
            lhsPolynomialKernelType = this.getPolynomialKernelType();
            PolynomialKernelType rhsPolynomialKernelType;
            rhsPolynomialKernelType = that.getPolynomialKernelType();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "polynomialKernelType", lhsPolynomialKernelType), LocatorUtils.property(thatLocator, "polynomialKernelType", rhsPolynomialKernelType), lhsPolynomialKernelType, rhsPolynomialKernelType)) {
                return false;
            }
        }
        {
            RadialBasisKernelType lhsRadialBasisKernelType;
            lhsRadialBasisKernelType = this.getRadialBasisKernelType();
            RadialBasisKernelType rhsRadialBasisKernelType;
            rhsRadialBasisKernelType = that.getRadialBasisKernelType();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "radialBasisKernelType", lhsRadialBasisKernelType), LocatorUtils.property(thatLocator, "radialBasisKernelType", rhsRadialBasisKernelType), lhsRadialBasisKernelType, rhsRadialBasisKernelType)) {
                return false;
            }
        }
        {
            SigmoidKernelType lhsSigmoidKernelType;
            lhsSigmoidKernelType = this.getSigmoidKernelType();
            SigmoidKernelType rhsSigmoidKernelType;
            rhsSigmoidKernelType = that.getSigmoidKernelType();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "sigmoidKernelType", lhsSigmoidKernelType), LocatorUtils.property(thatLocator, "sigmoidKernelType", rhsSigmoidKernelType), lhsSigmoidKernelType, rhsSigmoidKernelType)) {
                return false;
            }
        }
        {
            VectorDictionary lhsVectorDictionary;
            lhsVectorDictionary = this.getVectorDictionary();
            VectorDictionary rhsVectorDictionary;
            rhsVectorDictionary = that.getVectorDictionary();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "vectorDictionary", lhsVectorDictionary), LocatorUtils.property(thatLocator, "vectorDictionary", rhsVectorDictionary), lhsVectorDictionary, rhsVectorDictionary)) {
                return false;
            }
        }
        {
            List<SupportVectorMachine> lhsSupportVectorMachines;
            lhsSupportVectorMachines = (((this.supportVectorMachines!= null)&&(!this.supportVectorMachines.isEmpty()))?this.getSupportVectorMachines():null);
            List<SupportVectorMachine> rhsSupportVectorMachines;
            rhsSupportVectorMachines = (((that.supportVectorMachines!= null)&&(!that.supportVectorMachines.isEmpty()))?that.getSupportVectorMachines():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "supportVectorMachines", lhsSupportVectorMachines), LocatorUtils.property(thatLocator, "supportVectorMachines", rhsSupportVectorMachines), lhsSupportVectorMachines, rhsSupportVectorMachines)) {
                return false;
            }
        }
        {
            ModelVerification lhsModelVerification;
            lhsModelVerification = this.getModelVerification();
            ModelVerification rhsModelVerification;
            rhsModelVerification = that.getModelVerification();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelVerification", lhsModelVerification), LocatorUtils.property(thatLocator, "modelVerification", rhsModelVerification), lhsModelVerification, rhsModelVerification)) {
                return false;
            }
        }
        {
            String lhsModelName;
            lhsModelName = this.getModelName();
            String rhsModelName;
            rhsModelName = that.getModelName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelName", lhsModelName), LocatorUtils.property(thatLocator, "modelName", rhsModelName), lhsModelName, rhsModelName)) {
                return false;
            }
        }
        {
            MiningFunctionType lhsFunctionName;
            lhsFunctionName = this.getFunctionName();
            MiningFunctionType rhsFunctionName;
            rhsFunctionName = that.getFunctionName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "functionName", lhsFunctionName), LocatorUtils.property(thatLocator, "functionName", rhsFunctionName), lhsFunctionName, rhsFunctionName)) {
                return false;
            }
        }
        {
            String lhsAlgorithmName;
            lhsAlgorithmName = this.getAlgorithmName();
            String rhsAlgorithmName;
            rhsAlgorithmName = that.getAlgorithmName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "algorithmName", lhsAlgorithmName), LocatorUtils.property(thatLocator, "algorithmName", rhsAlgorithmName), lhsAlgorithmName, rhsAlgorithmName)) {
                return false;
            }
        }
        {
            double lhsThreshold;
            lhsThreshold = ((this.threshold!= null)?this.getThreshold(): 0.0D);
            double rhsThreshold;
            rhsThreshold = ((that.threshold!= null)?that.getThreshold(): 0.0D);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "threshold", lhsThreshold), LocatorUtils.property(thatLocator, "threshold", rhsThreshold), lhsThreshold, rhsThreshold)) {
                return false;
            }
        }
        {
            SvmRepresentationType lhsSvmRepresentation;
            lhsSvmRepresentation = this.getSvmRepresentation();
            SvmRepresentationType rhsSvmRepresentation;
            rhsSvmRepresentation = that.getSvmRepresentation();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "svmRepresentation", lhsSvmRepresentation), LocatorUtils.property(thatLocator, "svmRepresentation", rhsSvmRepresentation), lhsSvmRepresentation, rhsSvmRepresentation)) {
                return false;
            }
        }
        {
            SvmClassificationMethodType lhsClassificationMethod;
            lhsClassificationMethod = this.getClassificationMethod();
            SvmClassificationMethodType rhsClassificationMethod;
            rhsClassificationMethod = that.getClassificationMethod();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "classificationMethod", lhsClassificationMethod), LocatorUtils.property(thatLocator, "classificationMethod", rhsClassificationMethod), lhsClassificationMethod, rhsClassificationMethod)) {
                return false;
            }
        }
        {
            boolean lhsScorable;
            lhsScorable = ((this.scorable!= null)?this.isScorable():false);
            boolean rhsScorable;
            rhsScorable = ((that.scorable!= null)?that.isScorable():false);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "scorable", lhsScorable), LocatorUtils.property(thatLocator, "scorable", rhsScorable), lhsScorable, rhsScorable)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        {
            List<Extension> theExtensions;
            theExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "extensions", theExtensions), currentHashCode, theExtensions);
        }
        {
            MiningSchema theMiningSchema;
            theMiningSchema = this.getMiningSchema();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "miningSchema", theMiningSchema), currentHashCode, theMiningSchema);
        }
        {
            Output theOutput;
            theOutput = this.getOutput();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "output", theOutput), currentHashCode, theOutput);
        }
        {
            ModelStats theModelStats;
            theModelStats = this.getModelStats();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelStats", theModelStats), currentHashCode, theModelStats);
        }
        {
            ModelExplanation theModelExplanation;
            theModelExplanation = this.getModelExplanation();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelExplanation", theModelExplanation), currentHashCode, theModelExplanation);
        }
        {
            Targets theTargets;
            theTargets = this.getTargets();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "targets", theTargets), currentHashCode, theTargets);
        }
        {
            LocalTransformations theLocalTransformations;
            theLocalTransformations = this.getLocalTransformations();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "localTransformations", theLocalTransformations), currentHashCode, theLocalTransformations);
        }
        {
            LinearKernelType theLinearKernelType;
            theLinearKernelType = this.getLinearKernelType();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "linearKernelType", theLinearKernelType), currentHashCode, theLinearKernelType);
        }
        {
            PolynomialKernelType thePolynomialKernelType;
            thePolynomialKernelType = this.getPolynomialKernelType();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "polynomialKernelType", thePolynomialKernelType), currentHashCode, thePolynomialKernelType);
        }
        {
            RadialBasisKernelType theRadialBasisKernelType;
            theRadialBasisKernelType = this.getRadialBasisKernelType();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "radialBasisKernelType", theRadialBasisKernelType), currentHashCode, theRadialBasisKernelType);
        }
        {
            SigmoidKernelType theSigmoidKernelType;
            theSigmoidKernelType = this.getSigmoidKernelType();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "sigmoidKernelType", theSigmoidKernelType), currentHashCode, theSigmoidKernelType);
        }
        {
            VectorDictionary theVectorDictionary;
            theVectorDictionary = this.getVectorDictionary();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "vectorDictionary", theVectorDictionary), currentHashCode, theVectorDictionary);
        }
        {
            List<SupportVectorMachine> theSupportVectorMachines;
            theSupportVectorMachines = (((this.supportVectorMachines!= null)&&(!this.supportVectorMachines.isEmpty()))?this.getSupportVectorMachines():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "supportVectorMachines", theSupportVectorMachines), currentHashCode, theSupportVectorMachines);
        }
        {
            ModelVerification theModelVerification;
            theModelVerification = this.getModelVerification();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelVerification", theModelVerification), currentHashCode, theModelVerification);
        }
        {
            String theModelName;
            theModelName = this.getModelName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelName", theModelName), currentHashCode, theModelName);
        }
        {
            MiningFunctionType theFunctionName;
            theFunctionName = this.getFunctionName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "functionName", theFunctionName), currentHashCode, theFunctionName);
        }
        {
            String theAlgorithmName;
            theAlgorithmName = this.getAlgorithmName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "algorithmName", theAlgorithmName), currentHashCode, theAlgorithmName);
        }
        {
            double theThreshold;
            theThreshold = ((this.threshold!= null)?this.getThreshold(): 0.0D);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "threshold", theThreshold), currentHashCode, theThreshold);
        }
        {
            SvmRepresentationType theSvmRepresentation;
            theSvmRepresentation = this.getSvmRepresentation();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "svmRepresentation", theSvmRepresentation), currentHashCode, theSvmRepresentation);
        }
        {
            SvmClassificationMethodType theClassificationMethod;
            theClassificationMethod = this.getClassificationMethod();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "classificationMethod", theClassificationMethod), currentHashCode, theClassificationMethod);
        }
        {
            boolean theScorable;
            theScorable = ((this.scorable!= null)?this.isScorable():false);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "scorable", theScorable), currentHashCode, theScorable);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<Extension> theExtensions;
            theExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            strategy.appendField(locator, this, "extensions", buffer, theExtensions);
        }
        {
            MiningSchema theMiningSchema;
            theMiningSchema = this.getMiningSchema();
            strategy.appendField(locator, this, "miningSchema", buffer, theMiningSchema);
        }
        {
            Output theOutput;
            theOutput = this.getOutput();
            strategy.appendField(locator, this, "output", buffer, theOutput);
        }
        {
            ModelStats theModelStats;
            theModelStats = this.getModelStats();
            strategy.appendField(locator, this, "modelStats", buffer, theModelStats);
        }
        {
            ModelExplanation theModelExplanation;
            theModelExplanation = this.getModelExplanation();
            strategy.appendField(locator, this, "modelExplanation", buffer, theModelExplanation);
        }
        {
            Targets theTargets;
            theTargets = this.getTargets();
            strategy.appendField(locator, this, "targets", buffer, theTargets);
        }
        {
            LocalTransformations theLocalTransformations;
            theLocalTransformations = this.getLocalTransformations();
            strategy.appendField(locator, this, "localTransformations", buffer, theLocalTransformations);
        }
        {
            LinearKernelType theLinearKernelType;
            theLinearKernelType = this.getLinearKernelType();
            strategy.appendField(locator, this, "linearKernelType", buffer, theLinearKernelType);
        }
        {
            PolynomialKernelType thePolynomialKernelType;
            thePolynomialKernelType = this.getPolynomialKernelType();
            strategy.appendField(locator, this, "polynomialKernelType", buffer, thePolynomialKernelType);
        }
        {
            RadialBasisKernelType theRadialBasisKernelType;
            theRadialBasisKernelType = this.getRadialBasisKernelType();
            strategy.appendField(locator, this, "radialBasisKernelType", buffer, theRadialBasisKernelType);
        }
        {
            SigmoidKernelType theSigmoidKernelType;
            theSigmoidKernelType = this.getSigmoidKernelType();
            strategy.appendField(locator, this, "sigmoidKernelType", buffer, theSigmoidKernelType);
        }
        {
            VectorDictionary theVectorDictionary;
            theVectorDictionary = this.getVectorDictionary();
            strategy.appendField(locator, this, "vectorDictionary", buffer, theVectorDictionary);
        }
        {
            List<SupportVectorMachine> theSupportVectorMachines;
            theSupportVectorMachines = (((this.supportVectorMachines!= null)&&(!this.supportVectorMachines.isEmpty()))?this.getSupportVectorMachines():null);
            strategy.appendField(locator, this, "supportVectorMachines", buffer, theSupportVectorMachines);
        }
        {
            ModelVerification theModelVerification;
            theModelVerification = this.getModelVerification();
            strategy.appendField(locator, this, "modelVerification", buffer, theModelVerification);
        }
        {
            String theModelName;
            theModelName = this.getModelName();
            strategy.appendField(locator, this, "modelName", buffer, theModelName);
        }
        {
            MiningFunctionType theFunctionName;
            theFunctionName = this.getFunctionName();
            strategy.appendField(locator, this, "functionName", buffer, theFunctionName);
        }
        {
            String theAlgorithmName;
            theAlgorithmName = this.getAlgorithmName();
            strategy.appendField(locator, this, "algorithmName", buffer, theAlgorithmName);
        }
        {
            double theThreshold;
            theThreshold = ((this.threshold!= null)?this.getThreshold(): 0.0D);
            strategy.appendField(locator, this, "threshold", buffer, theThreshold);
        }
        {
            SvmRepresentationType theSvmRepresentation;
            theSvmRepresentation = this.getSvmRepresentation();
            strategy.appendField(locator, this, "svmRepresentation", buffer, theSvmRepresentation);
        }
        {
            SvmClassificationMethodType theClassificationMethod;
            theClassificationMethod = this.getClassificationMethod();
            strategy.appendField(locator, this, "classificationMethod", buffer, theClassificationMethod);
        }
        {
            boolean theScorable;
            theScorable = ((this.scorable!= null)?this.isScorable():false);
            strategy.appendField(locator, this, "scorable", buffer, theScorable);
        }
        return buffer;
    }

}
