
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}LocalTransformations" minOccurs="0"/>
 *         &lt;sequence>
 *           &lt;choice>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_1}LinearKernelType"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_1}PolynomialKernelType"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_1}RadialBasisKernelType"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_1}SigmoidKernelType"/>
 *           &lt;/choice>
 *         &lt;/sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}VectorDictionary"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}SupportVectorMachine" maxOccurs="unbounded"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_1}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="threshold" type="{http://www.dmg.org/PMML-4_1}REAL-NUMBER" default="0" />
 *       &lt;attribute name="svmRepresentation" type="{http://www.dmg.org/PMML-4_1}SVM-REPRESENTATION" default="SupportVectors" />
 *       &lt;attribute name="classificationMethod" type="{http://www.dmg.org/PMML-4_1}SVM-CLASSIFICATION-METHOD" default="OneAgainstAll" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "linearKernelType",
    "polynomialKernelType",
    "radialBasisKernelType",
    "sigmoidKernelType",
    "vectorDictionary",
    "supportVectorMachines",
    "modelVerification"
})
@XmlRootElement(name = "SupportVectorMachineModel")
public class SupportVectorMachineModel
    extends Model
    implements Locatable
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "MiningSchema", required = true)
    protected MiningSchema miningSchema;
    @XmlElement(name = "Output")
    protected Output output;
    @XmlElement(name = "ModelStats")
    protected ModelStats modelStats;
    @XmlElement(name = "ModelExplanation")
    protected ModelExplanation modelExplanation;
    @XmlElement(name = "Targets")
    protected Targets targets;
    @XmlElement(name = "LocalTransformations")
    protected LocalTransformations localTransformations;
    @XmlElement(name = "LinearKernelType")
    protected LinearKernelType linearKernelType;
    @XmlElement(name = "PolynomialKernelType")
    protected PolynomialKernelType polynomialKernelType;
    @XmlElement(name = "RadialBasisKernelType")
    protected RadialBasisKernelType radialBasisKernelType;
    @XmlElement(name = "SigmoidKernelType")
    protected SigmoidKernelType sigmoidKernelType;
    @XmlElement(name = "VectorDictionary", required = true)
    protected VectorDictionary vectorDictionary;
    @XmlElement(name = "SupportVectorMachine", required = true)
    protected List<SupportVectorMachine> supportVectorMachines;
    @XmlElement(name = "ModelVerification")
    protected ModelVerification modelVerification;
    @XmlAttribute(name = "modelName")
    protected String modelName;
    @XmlAttribute(name = "functionName", required = true)
    protected MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    protected String algorithmName;
    @XmlAttribute(name = "threshold")
    protected Double threshold;
    @XmlAttribute(name = "svmRepresentation")
    protected SvmRepresentationType svmRepresentation;
    @XmlAttribute(name = "classificationMethod")
    protected SvmClassificationMethodType classificationMethod;
    @XmlAttribute(name = "isScorable")
    protected Boolean scorable;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    @Deprecated
    public SupportVectorMachineModel() {
        super();
    }

    public SupportVectorMachineModel(final MiningSchema miningSchema, final VectorDictionary vectorDictionary, final MiningFunctionType functionName) {
        super();
        this.miningSchema = miningSchema;
        this.vectorDictionary = vectorDictionary;
        this.functionName = functionName;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public void setMiningSchema(MiningSchema value) {
        this.miningSchema = value;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param value
     *     allowed object is
     *     {@link Output }
     *     
     */
    public void setOutput(Output value) {
        this.output = value;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public void setModelStats(ModelStats value) {
        this.modelStats = value;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public void setModelExplanation(ModelExplanation value) {
        this.modelExplanation = value;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param value
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public void setTargets(Targets value) {
        this.targets = value;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public void setLocalTransformations(LocalTransformations value) {
        this.localTransformations = value;
    }

    /**
     * Gets the value of the linearKernelType property.
     * 
     * @return
     *     possible object is
     *     {@link LinearKernelType }
     *     
     */
    public LinearKernelType getLinearKernelType() {
        return linearKernelType;
    }

    /**
     * Sets the value of the linearKernelType property.
     * 
     * @param value
     *     allowed object is
     *     {@link LinearKernelType }
     *     
     */
    public void setLinearKernelType(LinearKernelType value) {
        this.linearKernelType = value;
    }

    /**
     * Gets the value of the polynomialKernelType property.
     * 
     * @return
     *     possible object is
     *     {@link PolynomialKernelType }
     *     
     */
    public PolynomialKernelType getPolynomialKernelType() {
        return polynomialKernelType;
    }

    /**
     * Sets the value of the polynomialKernelType property.
     * 
     * @param value
     *     allowed object is
     *     {@link PolynomialKernelType }
     *     
     */
    public void setPolynomialKernelType(PolynomialKernelType value) {
        this.polynomialKernelType = value;
    }

    /**
     * Gets the value of the radialBasisKernelType property.
     * 
     * @return
     *     possible object is
     *     {@link RadialBasisKernelType }
     *     
     */
    public RadialBasisKernelType getRadialBasisKernelType() {
        return radialBasisKernelType;
    }

    /**
     * Sets the value of the radialBasisKernelType property.
     * 
     * @param value
     *     allowed object is
     *     {@link RadialBasisKernelType }
     *     
     */
    public void setRadialBasisKernelType(RadialBasisKernelType value) {
        this.radialBasisKernelType = value;
    }

    /**
     * Gets the value of the sigmoidKernelType property.
     * 
     * @return
     *     possible object is
     *     {@link SigmoidKernelType }
     *     
     */
    public SigmoidKernelType getSigmoidKernelType() {
        return sigmoidKernelType;
    }

    /**
     * Sets the value of the sigmoidKernelType property.
     * 
     * @param value
     *     allowed object is
     *     {@link SigmoidKernelType }
     *     
     */
    public void setSigmoidKernelType(SigmoidKernelType value) {
        this.sigmoidKernelType = value;
    }

    /**
     * Gets the value of the vectorDictionary property.
     * 
     * @return
     *     possible object is
     *     {@link VectorDictionary }
     *     
     */
    public VectorDictionary getVectorDictionary() {
        return vectorDictionary;
    }

    /**
     * Sets the value of the vectorDictionary property.
     * 
     * @param value
     *     allowed object is
     *     {@link VectorDictionary }
     *     
     */
    public void setVectorDictionary(VectorDictionary value) {
        this.vectorDictionary = value;
    }

    /**
     * Gets the value of the supportVectorMachines property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the supportVectorMachines property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSupportVectorMachines().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SupportVectorMachine }
     * 
     * 
     */
    public List<SupportVectorMachine> getSupportVectorMachines() {
        if (supportVectorMachines == null) {
            supportVectorMachines = new ArrayList<SupportVectorMachine>();
        }
        return this.supportVectorMachines;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public void setModelVerification(ModelVerification value) {
        this.modelVerification = value;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setModelName(String value) {
        this.modelName = value;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public void setFunctionName(MiningFunctionType value) {
        this.functionName = value;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlgorithmName(String value) {
        this.algorithmName = value;
    }

    /**
     * Gets the value of the threshold property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getThreshold() {
        if (threshold == null) {
            return  0.0D;
        } else {
            return threshold;
        }
    }

    /**
     * Sets the value of the threshold property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setThreshold(Double value) {
        this.threshold = value;
    }

    /**
     * Gets the value of the svmRepresentation property.
     * 
     * @return
     *     possible object is
     *     {@link SvmRepresentationType }
     *     
     */
    public SvmRepresentationType getSvmRepresentation() {
        if (svmRepresentation == null) {
            return SvmRepresentationType.SUPPORT_VECTORS;
        } else {
            return svmRepresentation;
        }
    }

    /**
     * Sets the value of the svmRepresentation property.
     * 
     * @param value
     *     allowed object is
     *     {@link SvmRepresentationType }
     *     
     */
    public void setSvmRepresentation(SvmRepresentationType value) {
        this.svmRepresentation = value;
    }

    /**
     * Gets the value of the classificationMethod property.
     * 
     * @return
     *     possible object is
     *     {@link SvmClassificationMethodType }
     *     
     */
    public SvmClassificationMethodType getClassificationMethod() {
        if (classificationMethod == null) {
            return SvmClassificationMethodType.ONE_AGAINST_ALL;
        } else {
            return classificationMethod;
        }
    }

    /**
     * Sets the value of the classificationMethod property.
     * 
     * @param value
     *     allowed object is
     *     {@link SvmClassificationMethodType }
     *     
     */
    public void setClassificationMethod(SvmClassificationMethodType value) {
        this.classificationMethod = value;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return true;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setScorable(Boolean value) {
        this.scorable = value;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

}
