/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public final class FieldName {
    private String value = null;
    private static final Map<FieldName, WeakReference<FieldName>> cache = new WeakHashMap<FieldName, WeakReference<FieldName>>();

    public FieldName(String value) {
        this.setValue(value);
    }

    public FieldName intern() {
        return FieldName.create(this.getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof FieldName) {
            FieldName that = (FieldName)object;
            return this.getValue().equals(that.getValue());
        }
        return super.equals(object);
    }

    public String toString() {
        return this.getValue();
    }

    public String getValue() {
        return this.value;
    }

    private void setValue(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    public static FieldName create(String value) {
        return FieldName.unmarshal(value);
    }

    static FieldName unmarshal(String value) {
        FieldName cachedName;
        FieldName name = new FieldName(value);
        WeakReference<FieldName> reference = cache.get(name);
        if (reference != null && (cachedName = (FieldName)reference.get()) != null) {
            return cachedName;
        }
        cache.put(name, new WeakReference<FieldName>(name));
        return name;
    }

    static String marshal(FieldName name) {
        if (name == null) {
            return null;
        }
        return name.getValue();
    }
}

