
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;sequence minOccurs="0">
 *           &lt;element ref="{http://www.dmg.org/PMML-4_1}Decisions" minOccurs="0"/>
 *           &lt;group ref="{http://www.dmg.org/PMML-4_1}EXPRESSION"/>
 *         &lt;/sequence>
 *       &lt;/sequence>
 *       &lt;attribute name="name" use="required" type="{http://www.dmg.org/PMML-4_1}FIELD-NAME" />
 *       &lt;attribute name="displayName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="optype" type="{http://www.dmg.org/PMML-4_1}OPTYPE" />
 *       &lt;attribute name="dataType" type="{http://www.dmg.org/PMML-4_1}DATATYPE" />
 *       &lt;attribute name="targetField" type="{http://www.dmg.org/PMML-4_1}FIELD-NAME" />
 *       &lt;attribute name="feature" type="{http://www.dmg.org/PMML-4_1}RESULT-FEATURE" />
 *       &lt;attribute name="value" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="ruleFeature" type="{http://www.dmg.org/PMML-4_1}RULE-FEATURE" default="consequent" />
 *       &lt;attribute name="algorithm" default="exclusiveRecommendation">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="recommendation"/>
 *             &lt;enumeration value="exclusiveRecommendation"/>
 *             &lt;enumeration value="ruleAssociation"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="rank" type="{http://www.dmg.org/PMML-4_1}INT-NUMBER" default="1" />
 *       &lt;attribute name="rankBasis" default="confidence">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="confidence"/>
 *             &lt;enumeration value="support"/>
 *             &lt;enumeration value="lift"/>
 *             &lt;enumeration value="leverage"/>
 *             &lt;enumeration value="affinity"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="rankOrder" default="descending">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="descending"/>
 *             &lt;enumeration value="ascending"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="isMultiValued" type="{http://www.w3.org/2001/XMLSchema}anySimpleType" default="0" />
 *       &lt;attribute name="segmentId" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "decisions",
    "expression"
})
@XmlRootElement(name = "OutputField")
public class OutputField
    extends Field
    implements Locatable
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "Decisions")
    protected Decisions decisions;
    @XmlElements({
        @XmlElement(name = "Constant", type = Constant.class),
        @XmlElement(name = "FieldRef", type = FieldRef.class),
        @XmlElement(name = "NormContinuous", type = NormContinuous.class),
        @XmlElement(name = "NormDiscrete", type = NormDiscrete.class),
        @XmlElement(name = "Discretize", type = Discretize.class),
        @XmlElement(name = "MapValues", type = MapValues.class),
        @XmlElement(name = "Apply", type = Apply.class),
        @XmlElement(name = "Aggregate", type = Aggregate.class)
    })
    protected Expression expression;
    @XmlAttribute(name = "name", required = true)
    @XmlJavaTypeAdapter(org.dmg.pmml.Adapter1 .class)
    protected FieldName name;
    @XmlAttribute(name = "displayName")
    protected String displayName;
    @XmlAttribute(name = "optype")
    protected OpType optype;
    @XmlAttribute(name = "dataType")
    protected DataType dataType;
    @XmlAttribute(name = "targetField")
    @XmlJavaTypeAdapter(org.dmg.pmml.Adapter1 .class)
    protected FieldName targetField;
    @XmlAttribute(name = "feature")
    protected ResultFeatureType feature;
    @XmlAttribute(name = "value")
    protected String value;
    @XmlAttribute(name = "ruleFeature")
    protected RuleFeatureType ruleFeature;
    @XmlAttribute(name = "algorithm")
    protected OutputField.Algorithm algorithm;
    @XmlAttribute(name = "rank")
    @XmlJavaTypeAdapter(org.w3._2001.xmlschema.Adapter1 .class)
    protected Integer rank;
    @XmlAttribute(name = "rankBasis")
    protected OutputField.RankBasis rankBasis;
    @XmlAttribute(name = "rankOrder")
    protected OutputField.RankOrder rankOrder;
    @XmlAttribute(name = "isMultiValued")
    @XmlSchemaType(name = "anySimpleType")
    protected String isMultiValued;
    @XmlAttribute(name = "segmentId")
    protected String segmentId;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    @Deprecated
    public OutputField() {
        super();
    }

    public OutputField(final FieldName name) {
        super();
        this.name = name;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the decisions property.
     * 
     * @return
     *     possible object is
     *     {@link Decisions }
     *     
     */
    public Decisions getDecisions() {
        return decisions;
    }

    /**
     * Sets the value of the decisions property.
     * 
     * @param value
     *     allowed object is
     *     {@link Decisions }
     *     
     */
    public void setDecisions(Decisions value) {
        this.decisions = value;
    }

    /**
     * Gets the value of the expression property.
     * 
     * @return
     *     possible object is
     *     {@link Constant }
     *     {@link FieldRef }
     *     {@link NormContinuous }
     *     {@link NormDiscrete }
     *     {@link Discretize }
     *     {@link MapValues }
     *     {@link Apply }
     *     {@link Aggregate }
     *     
     */
    public Expression getExpression() {
        return expression;
    }

    /**
     * Sets the value of the expression property.
     * 
     * @param value
     *     allowed object is
     *     {@link Constant }
     *     {@link FieldRef }
     *     {@link NormContinuous }
     *     {@link NormDiscrete }
     *     {@link Discretize }
     *     {@link MapValues }
     *     {@link Apply }
     *     {@link Aggregate }
     *     
     */
    public void setExpression(Expression value) {
        this.expression = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(FieldName value) {
        this.name = value;
    }

    /**
     * Gets the value of the displayName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * Sets the value of the displayName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDisplayName(String value) {
        this.displayName = value;
    }

    /**
     * Gets the value of the optype property.
     * 
     * @return
     *     possible object is
     *     {@link OpType }
     *     
     */
    public OpType getOptype() {
        return optype;
    }

    /**
     * Sets the value of the optype property.
     * 
     * @param value
     *     allowed object is
     *     {@link OpType }
     *     
     */
    public void setOptype(OpType value) {
        this.optype = value;
    }

    /**
     * Gets the value of the dataType property.
     * 
     * @return
     *     possible object is
     *     {@link DataType }
     *     
     */
    public DataType getDataType() {
        return dataType;
    }

    /**
     * Sets the value of the dataType property.
     * 
     * @param value
     *     allowed object is
     *     {@link DataType }
     *     
     */
    public void setDataType(DataType value) {
        this.dataType = value;
    }

    /**
     * Gets the value of the targetField property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getTargetField() {
        return targetField;
    }

    /**
     * Sets the value of the targetField property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTargetField(FieldName value) {
        this.targetField = value;
    }

    /**
     * Gets the value of the feature property.
     * 
     * @return
     *     possible object is
     *     {@link ResultFeatureType }
     *     
     */
    public ResultFeatureType getFeature() {
        return feature;
    }

    /**
     * Sets the value of the feature property.
     * 
     * @param value
     *     allowed object is
     *     {@link ResultFeatureType }
     *     
     */
    public void setFeature(ResultFeatureType value) {
        this.feature = value;
    }

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * Gets the value of the ruleFeature property.
     * 
     * @return
     *     possible object is
     *     {@link RuleFeatureType }
     *     
     */
    public RuleFeatureType getRuleFeature() {
        if (ruleFeature == null) {
            return RuleFeatureType.CONSEQUENT;
        } else {
            return ruleFeature;
        }
    }

    /**
     * Sets the value of the ruleFeature property.
     * 
     * @param value
     *     allowed object is
     *     {@link RuleFeatureType }
     *     
     */
    public void setRuleFeature(RuleFeatureType value) {
        this.ruleFeature = value;
    }

    /**
     * Gets the value of the algorithm property.
     * 
     * @return
     *     possible object is
     *     {@link OutputField.Algorithm }
     *     
     */
    public OutputField.Algorithm getAlgorithm() {
        if (algorithm == null) {
            return OutputField.Algorithm.EXCLUSIVE_RECOMMENDATION;
        } else {
            return algorithm;
        }
    }

    /**
     * Sets the value of the algorithm property.
     * 
     * @param value
     *     allowed object is
     *     {@link OutputField.Algorithm }
     *     
     */
    public void setAlgorithm(OutputField.Algorithm value) {
        this.algorithm = value;
    }

    /**
     * Gets the value of the rank property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public int getRank() {
        if (rank == null) {
            return new org.w3._2001.xmlschema.Adapter1().unmarshal("1");
        } else {
            return rank;
        }
    }

    /**
     * Sets the value of the rank property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRank(Integer value) {
        this.rank = value;
    }

    /**
     * Gets the value of the rankBasis property.
     * 
     * @return
     *     possible object is
     *     {@link OutputField.RankBasis }
     *     
     */
    public OutputField.RankBasis getRankBasis() {
        if (rankBasis == null) {
            return OutputField.RankBasis.CONFIDENCE;
        } else {
            return rankBasis;
        }
    }

    /**
     * Sets the value of the rankBasis property.
     * 
     * @param value
     *     allowed object is
     *     {@link OutputField.RankBasis }
     *     
     */
    public void setRankBasis(OutputField.RankBasis value) {
        this.rankBasis = value;
    }

    /**
     * Gets the value of the rankOrder property.
     * 
     * @return
     *     possible object is
     *     {@link OutputField.RankOrder }
     *     
     */
    public OutputField.RankOrder getRankOrder() {
        if (rankOrder == null) {
            return OutputField.RankOrder.DESCENDING;
        } else {
            return rankOrder;
        }
    }

    /**
     * Sets the value of the rankOrder property.
     * 
     * @param value
     *     allowed object is
     *     {@link OutputField.RankOrder }
     *     
     */
    public void setRankOrder(OutputField.RankOrder value) {
        this.rankOrder = value;
    }

    /**
     * Gets the value of the isMultiValued property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getIsMultiValued() {
        if (isMultiValued == null) {
            return "0";
        } else {
            return isMultiValued;
        }
    }

    /**
     * Sets the value of the isMultiValued property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setIsMultiValued(String value) {
        this.isMultiValued = value;
    }

    /**
     * Gets the value of the segmentId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSegmentId() {
        return segmentId;
    }

    /**
     * Sets the value of the segmentId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSegmentId(String value) {
        this.segmentId = value;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.decisions!= null)) {
            status = this.decisions.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.expression!= null)) {
            status = this.expression.accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="recommendation"/>
     *     &lt;enumeration value="exclusiveRecommendation"/>
     *     &lt;enumeration value="ruleAssociation"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum Algorithm {

        @XmlEnumValue("recommendation")
        RECOMMENDATION("recommendation"),
        @XmlEnumValue("exclusiveRecommendation")
        EXCLUSIVE_RECOMMENDATION("exclusiveRecommendation"),
        @XmlEnumValue("ruleAssociation")
        RULE_ASSOCIATION("ruleAssociation");
        private final String value;

        Algorithm(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static OutputField.Algorithm fromValue(String v) {
            for (OutputField.Algorithm c: OutputField.Algorithm.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="confidence"/>
     *     &lt;enumeration value="support"/>
     *     &lt;enumeration value="lift"/>
     *     &lt;enumeration value="leverage"/>
     *     &lt;enumeration value="affinity"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum RankBasis {

        @XmlEnumValue("confidence")
        CONFIDENCE("confidence"),
        @XmlEnumValue("support")
        SUPPORT("support"),
        @XmlEnumValue("lift")
        LIFT("lift"),
        @XmlEnumValue("leverage")
        LEVERAGE("leverage"),
        @XmlEnumValue("affinity")
        AFFINITY("affinity");
        private final String value;

        RankBasis(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static OutputField.RankBasis fromValue(String v) {
            for (OutputField.RankBasis c: OutputField.RankBasis.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="descending"/>
     *     &lt;enumeration value="ascending"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum RankOrder {

        @XmlEnumValue("descending")
        DESCENDING("descending"),
        @XmlEnumValue("ascending")
        ASCENDING("ascending");
        private final String value;

        RankOrder(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static OutputField.RankOrder fromValue(String v) {
            for (OutputField.RankOrder c: OutputField.RankOrder.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
