
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}TimeSeries" maxOccurs="3" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}SpectralAnalysis" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ARIMA" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ExponentialSmoothing" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}SeasonalTrendDecomposition" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_1}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="bestFit" use="required" type="{http://www.dmg.org/PMML-4_1}TIMESERIES-ALGORITHM" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "localTransformations",
    "timeSeries",
    "spectralAnalysis",
    "arima",
    "exponentialSmoothing",
    "seasonalTrendDecomposition",
    "modelVerification"
})
@XmlRootElement(name = "TimeSeriesModel")
@Schema(min = Version.PMML_4_0)
public class TimeSeriesModel
    extends Model
    implements Locatable
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "MiningSchema", required = true)
    protected MiningSchema miningSchema;
    @XmlElement(name = "Output")
    protected Output output;
    @XmlElement(name = "ModelStats")
    protected ModelStats modelStats;
    @XmlElement(name = "ModelExplanation")
    protected ModelExplanation modelExplanation;
    @XmlElement(name = "LocalTransformations")
    protected LocalTransformations localTransformations;
    @XmlElement(name = "TimeSeries")
    protected List<TimeSeries> timeSeries;
    @XmlElement(name = "SpectralAnalysis")
    protected Object spectralAnalysis;
    @XmlElement(name = "ARIMA")
    protected Object arima;
    @XmlElement(name = "ExponentialSmoothing")
    protected ExponentialSmoothing exponentialSmoothing;
    @XmlElement(name = "SeasonalTrendDecomposition")
    protected Object seasonalTrendDecomposition;
    @XmlElement(name = "ModelVerification")
    protected ModelVerification modelVerification;
    @XmlAttribute(name = "modelName")
    protected String modelName;
    @XmlAttribute(name = "functionName", required = true)
    protected MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    protected String algorithmName;
    @XmlAttribute(name = "bestFit", required = true)
    protected TimeSeriesAlgorithmType bestFit;
    @XmlAttribute(name = "isScorable")
    protected Boolean scorable;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    @Deprecated
    public TimeSeriesModel() {
        super();
    }

    public TimeSeriesModel(final MiningSchema miningSchema, final MiningFunctionType functionName, final TimeSeriesAlgorithmType bestFit) {
        super();
        this.miningSchema = miningSchema;
        this.functionName = functionName;
        this.bestFit = bestFit;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public void setMiningSchema(MiningSchema value) {
        this.miningSchema = value;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param value
     *     allowed object is
     *     {@link Output }
     *     
     */
    public void setOutput(Output value) {
        this.output = value;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public void setModelStats(ModelStats value) {
        this.modelStats = value;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public void setModelExplanation(ModelExplanation value) {
        this.modelExplanation = value;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public void setLocalTransformations(LocalTransformations value) {
        this.localTransformations = value;
    }

    /**
     * Gets the value of the timeSeries property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the timeSeries property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTimeSeries().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TimeSeries }
     * 
     * 
     */
    public List<TimeSeries> getTimeSeries() {
        if (timeSeries == null) {
            timeSeries = new ArrayList<TimeSeries>();
        }
        return this.timeSeries;
    }

    /**
     * Gets the value of the spectralAnalysis property.
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    public Object getSpectralAnalysis() {
        return spectralAnalysis;
    }

    /**
     * Sets the value of the spectralAnalysis property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     */
    public void setSpectralAnalysis(Object value) {
        this.spectralAnalysis = value;
    }

    /**
     * Gets the value of the arima property.
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    public Object getARIMA() {
        return arima;
    }

    /**
     * Sets the value of the arima property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     */
    public void setARIMA(Object value) {
        this.arima = value;
    }

    /**
     * Gets the value of the exponentialSmoothing property.
     * 
     * @return
     *     possible object is
     *     {@link ExponentialSmoothing }
     *     
     */
    public ExponentialSmoothing getExponentialSmoothing() {
        return exponentialSmoothing;
    }

    /**
     * Sets the value of the exponentialSmoothing property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExponentialSmoothing }
     *     
     */
    public void setExponentialSmoothing(ExponentialSmoothing value) {
        this.exponentialSmoothing = value;
    }

    /**
     * Gets the value of the seasonalTrendDecomposition property.
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    public Object getSeasonalTrendDecomposition() {
        return seasonalTrendDecomposition;
    }

    /**
     * Sets the value of the seasonalTrendDecomposition property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     */
    public void setSeasonalTrendDecomposition(Object value) {
        this.seasonalTrendDecomposition = value;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public void setModelVerification(ModelVerification value) {
        this.modelVerification = value;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setModelName(String value) {
        this.modelName = value;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public void setFunctionName(MiningFunctionType value) {
        this.functionName = value;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlgorithmName(String value) {
        this.algorithmName = value;
    }

    /**
     * Gets the value of the bestFit property.
     * 
     * @return
     *     possible object is
     *     {@link TimeSeriesAlgorithmType }
     *     
     */
    public TimeSeriesAlgorithmType getBestFit() {
        return bestFit;
    }

    /**
     * Sets the value of the bestFit property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimeSeriesAlgorithmType }
     *     
     */
    public void setBestFit(TimeSeriesAlgorithmType value) {
        this.bestFit = value;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return true;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setScorable(Boolean value) {
        this.scorable = value;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @throws UnsupportedOperationException
     *     Always.
     */
    @Override
    public Targets getTargets() {
        throw new UnsupportedOperationException();
    }

    /**
     * Sets the value of the targets property.
     * 
     * @throws UnsupportedOperationException
     *     Always.
     */
    @Override
    public void setTargets(Targets targets) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.miningSchema!= null)) {
            status = this.miningSchema.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.output!= null)) {
            status = this.output.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelStats!= null)) {
            status = this.modelStats.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelExplanation!= null)) {
            status = this.modelExplanation.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.localTransformations!= null)) {
            status = this.localTransformations.accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.timeSeries!= null))&&(i<this.timeSeries.size())); i ++) {
            status = this.timeSeries.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.exponentialSmoothing!= null)) {
            status = this.exponentialSmoothing.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelVerification!= null)) {
            status = this.modelVerification.accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
