
package org.dmg.pmml;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ComparisonMeasure"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ClusteringField" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}MissingValueWeights" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Cluster" maxOccurs="unbounded"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_1}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="modelClass" use="required">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="centerBased"/>
 *             &lt;enumeration value="distributionBased"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="numberOfClusters" use="required" type="{http://www.dmg.org/PMML-4_1}INT-NUMBER" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "localTransformations",
    "comparisonMeasure",
    "clusteringFields",
    "missingValueWeights",
    "clusters",
    "modelVerification"
})
@XmlRootElement(name = "ClusteringModel")
public class ClusteringModel
    extends Model
    implements Equals, HashCode, ToString
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "MiningSchema", required = true)
    protected MiningSchema miningSchema;
    @XmlElement(name = "Output")
    protected Output output;
    @XmlElement(name = "ModelStats")
    protected ModelStats modelStats;
    @XmlElement(name = "ModelExplanation")
    protected ModelExplanation modelExplanation;
    @XmlElement(name = "LocalTransformations")
    protected LocalTransformations localTransformations;
    @XmlElement(name = "ComparisonMeasure", required = true)
    protected ComparisonMeasure comparisonMeasure;
    @XmlElement(name = "ClusteringField")
    protected List<ClusteringField> clusteringFields;
    @XmlElement(name = "MissingValueWeights")
    protected MissingValueWeights missingValueWeights;
    @XmlElement(name = "Cluster", required = true)
    protected List<Cluster> clusters;
    @XmlElement(name = "ModelVerification")
    protected ModelVerification modelVerification;
    @XmlAttribute(name = "modelName")
    protected String modelName;
    @XmlAttribute(name = "functionName", required = true)
    protected MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    protected String algorithmName;
    @XmlAttribute(name = "modelClass", required = true)
    protected ClusteringModel.ModelClass modelClass;
    @XmlAttribute(name = "numberOfClusters", required = true)
    protected BigInteger numberOfClusters;
    @XmlAttribute(name = "isScorable")
    protected Boolean scorable;

    @Deprecated
    public ClusteringModel() {
        super();
    }

    public ClusteringModel(final MiningSchema miningSchema, final ComparisonMeasure comparisonMeasure, final MiningFunctionType functionName, final ClusteringModel.ModelClass modelClass, final BigInteger numberOfClusters) {
        super();
        this.miningSchema = miningSchema;
        this.comparisonMeasure = comparisonMeasure;
        this.functionName = functionName;
        this.modelClass = modelClass;
        this.numberOfClusters = numberOfClusters;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public void setMiningSchema(MiningSchema value) {
        this.miningSchema = value;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param value
     *     allowed object is
     *     {@link Output }
     *     
     */
    public void setOutput(Output value) {
        this.output = value;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public void setModelStats(ModelStats value) {
        this.modelStats = value;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public void setModelExplanation(ModelExplanation value) {
        this.modelExplanation = value;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public void setLocalTransformations(LocalTransformations value) {
        this.localTransformations = value;
    }

    /**
     * Gets the value of the comparisonMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link ComparisonMeasure }
     *     
     */
    public ComparisonMeasure getComparisonMeasure() {
        return comparisonMeasure;
    }

    /**
     * Sets the value of the comparisonMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link ComparisonMeasure }
     *     
     */
    public void setComparisonMeasure(ComparisonMeasure value) {
        this.comparisonMeasure = value;
    }

    /**
     * Gets the value of the clusteringFields property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the clusteringFields property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getClusteringFields().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ClusteringField }
     * 
     * 
     */
    public List<ClusteringField> getClusteringFields() {
        if (clusteringFields == null) {
            clusteringFields = new ArrayList<ClusteringField>();
        }
        return this.clusteringFields;
    }

    /**
     * Gets the value of the missingValueWeights property.
     * 
     * @return
     *     possible object is
     *     {@link MissingValueWeights }
     *     
     */
    public MissingValueWeights getMissingValueWeights() {
        return missingValueWeights;
    }

    /**
     * Sets the value of the missingValueWeights property.
     * 
     * @param value
     *     allowed object is
     *     {@link MissingValueWeights }
     *     
     */
    public void setMissingValueWeights(MissingValueWeights value) {
        this.missingValueWeights = value;
    }

    /**
     * Gets the value of the clusters property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the clusters property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getClusters().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Cluster }
     * 
     * 
     */
    public List<Cluster> getClusters() {
        if (clusters == null) {
            clusters = new ArrayList<Cluster>();
        }
        return this.clusters;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public void setModelVerification(ModelVerification value) {
        this.modelVerification = value;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setModelName(String value) {
        this.modelName = value;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public void setFunctionName(MiningFunctionType value) {
        this.functionName = value;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlgorithmName(String value) {
        this.algorithmName = value;
    }

    /**
     * Gets the value of the modelClass property.
     * 
     * @return
     *     possible object is
     *     {@link ClusteringModel.ModelClass }
     *     
     */
    public ClusteringModel.ModelClass getModelClass() {
        return modelClass;
    }

    /**
     * Sets the value of the modelClass property.
     * 
     * @param value
     *     allowed object is
     *     {@link ClusteringModel.ModelClass }
     *     
     */
    public void setModelClass(ClusteringModel.ModelClass value) {
        this.modelClass = value;
    }

    /**
     * Gets the value of the numberOfClusters property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getNumberOfClusters() {
        return numberOfClusters;
    }

    /**
     * Sets the value of the numberOfClusters property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setNumberOfClusters(BigInteger value) {
        this.numberOfClusters = value;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return true;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setScorable(Boolean value) {
        this.scorable = value;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if (!(object instanceof ClusteringModel)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        final ClusteringModel that = ((ClusteringModel) object);
        {
            List<Extension> lhsExtensions;
            lhsExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            List<Extension> rhsExtensions;
            rhsExtensions = (((that.extensions!= null)&&(!that.extensions.isEmpty()))?that.getExtensions():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "extensions", lhsExtensions), LocatorUtils.property(thatLocator, "extensions", rhsExtensions), lhsExtensions, rhsExtensions)) {
                return false;
            }
        }
        {
            MiningSchema lhsMiningSchema;
            lhsMiningSchema = this.getMiningSchema();
            MiningSchema rhsMiningSchema;
            rhsMiningSchema = that.getMiningSchema();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "miningSchema", lhsMiningSchema), LocatorUtils.property(thatLocator, "miningSchema", rhsMiningSchema), lhsMiningSchema, rhsMiningSchema)) {
                return false;
            }
        }
        {
            Output lhsOutput;
            lhsOutput = this.getOutput();
            Output rhsOutput;
            rhsOutput = that.getOutput();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "output", lhsOutput), LocatorUtils.property(thatLocator, "output", rhsOutput), lhsOutput, rhsOutput)) {
                return false;
            }
        }
        {
            ModelStats lhsModelStats;
            lhsModelStats = this.getModelStats();
            ModelStats rhsModelStats;
            rhsModelStats = that.getModelStats();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelStats", lhsModelStats), LocatorUtils.property(thatLocator, "modelStats", rhsModelStats), lhsModelStats, rhsModelStats)) {
                return false;
            }
        }
        {
            ModelExplanation lhsModelExplanation;
            lhsModelExplanation = this.getModelExplanation();
            ModelExplanation rhsModelExplanation;
            rhsModelExplanation = that.getModelExplanation();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelExplanation", lhsModelExplanation), LocatorUtils.property(thatLocator, "modelExplanation", rhsModelExplanation), lhsModelExplanation, rhsModelExplanation)) {
                return false;
            }
        }
        {
            LocalTransformations lhsLocalTransformations;
            lhsLocalTransformations = this.getLocalTransformations();
            LocalTransformations rhsLocalTransformations;
            rhsLocalTransformations = that.getLocalTransformations();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "localTransformations", lhsLocalTransformations), LocatorUtils.property(thatLocator, "localTransformations", rhsLocalTransformations), lhsLocalTransformations, rhsLocalTransformations)) {
                return false;
            }
        }
        {
            ComparisonMeasure lhsComparisonMeasure;
            lhsComparisonMeasure = this.getComparisonMeasure();
            ComparisonMeasure rhsComparisonMeasure;
            rhsComparisonMeasure = that.getComparisonMeasure();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "comparisonMeasure", lhsComparisonMeasure), LocatorUtils.property(thatLocator, "comparisonMeasure", rhsComparisonMeasure), lhsComparisonMeasure, rhsComparisonMeasure)) {
                return false;
            }
        }
        {
            List<ClusteringField> lhsClusteringFields;
            lhsClusteringFields = (((this.clusteringFields!= null)&&(!this.clusteringFields.isEmpty()))?this.getClusteringFields():null);
            List<ClusteringField> rhsClusteringFields;
            rhsClusteringFields = (((that.clusteringFields!= null)&&(!that.clusteringFields.isEmpty()))?that.getClusteringFields():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "clusteringFields", lhsClusteringFields), LocatorUtils.property(thatLocator, "clusteringFields", rhsClusteringFields), lhsClusteringFields, rhsClusteringFields)) {
                return false;
            }
        }
        {
            MissingValueWeights lhsMissingValueWeights;
            lhsMissingValueWeights = this.getMissingValueWeights();
            MissingValueWeights rhsMissingValueWeights;
            rhsMissingValueWeights = that.getMissingValueWeights();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "missingValueWeights", lhsMissingValueWeights), LocatorUtils.property(thatLocator, "missingValueWeights", rhsMissingValueWeights), lhsMissingValueWeights, rhsMissingValueWeights)) {
                return false;
            }
        }
        {
            List<Cluster> lhsClusters;
            lhsClusters = (((this.clusters!= null)&&(!this.clusters.isEmpty()))?this.getClusters():null);
            List<Cluster> rhsClusters;
            rhsClusters = (((that.clusters!= null)&&(!that.clusters.isEmpty()))?that.getClusters():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "clusters", lhsClusters), LocatorUtils.property(thatLocator, "clusters", rhsClusters), lhsClusters, rhsClusters)) {
                return false;
            }
        }
        {
            ModelVerification lhsModelVerification;
            lhsModelVerification = this.getModelVerification();
            ModelVerification rhsModelVerification;
            rhsModelVerification = that.getModelVerification();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelVerification", lhsModelVerification), LocatorUtils.property(thatLocator, "modelVerification", rhsModelVerification), lhsModelVerification, rhsModelVerification)) {
                return false;
            }
        }
        {
            String lhsModelName;
            lhsModelName = this.getModelName();
            String rhsModelName;
            rhsModelName = that.getModelName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelName", lhsModelName), LocatorUtils.property(thatLocator, "modelName", rhsModelName), lhsModelName, rhsModelName)) {
                return false;
            }
        }
        {
            MiningFunctionType lhsFunctionName;
            lhsFunctionName = this.getFunctionName();
            MiningFunctionType rhsFunctionName;
            rhsFunctionName = that.getFunctionName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "functionName", lhsFunctionName), LocatorUtils.property(thatLocator, "functionName", rhsFunctionName), lhsFunctionName, rhsFunctionName)) {
                return false;
            }
        }
        {
            String lhsAlgorithmName;
            lhsAlgorithmName = this.getAlgorithmName();
            String rhsAlgorithmName;
            rhsAlgorithmName = that.getAlgorithmName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "algorithmName", lhsAlgorithmName), LocatorUtils.property(thatLocator, "algorithmName", rhsAlgorithmName), lhsAlgorithmName, rhsAlgorithmName)) {
                return false;
            }
        }
        {
            ClusteringModel.ModelClass lhsModelClass;
            lhsModelClass = this.getModelClass();
            ClusteringModel.ModelClass rhsModelClass;
            rhsModelClass = that.getModelClass();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelClass", lhsModelClass), LocatorUtils.property(thatLocator, "modelClass", rhsModelClass), lhsModelClass, rhsModelClass)) {
                return false;
            }
        }
        {
            BigInteger lhsNumberOfClusters;
            lhsNumberOfClusters = this.getNumberOfClusters();
            BigInteger rhsNumberOfClusters;
            rhsNumberOfClusters = that.getNumberOfClusters();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "numberOfClusters", lhsNumberOfClusters), LocatorUtils.property(thatLocator, "numberOfClusters", rhsNumberOfClusters), lhsNumberOfClusters, rhsNumberOfClusters)) {
                return false;
            }
        }
        {
            boolean lhsScorable;
            lhsScorable = ((this.scorable!= null)?this.isScorable():false);
            boolean rhsScorable;
            rhsScorable = ((that.scorable!= null)?that.isScorable():false);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "scorable", lhsScorable), LocatorUtils.property(thatLocator, "scorable", rhsScorable), lhsScorable, rhsScorable)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        {
            List<Extension> theExtensions;
            theExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "extensions", theExtensions), currentHashCode, theExtensions);
        }
        {
            MiningSchema theMiningSchema;
            theMiningSchema = this.getMiningSchema();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "miningSchema", theMiningSchema), currentHashCode, theMiningSchema);
        }
        {
            Output theOutput;
            theOutput = this.getOutput();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "output", theOutput), currentHashCode, theOutput);
        }
        {
            ModelStats theModelStats;
            theModelStats = this.getModelStats();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelStats", theModelStats), currentHashCode, theModelStats);
        }
        {
            ModelExplanation theModelExplanation;
            theModelExplanation = this.getModelExplanation();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelExplanation", theModelExplanation), currentHashCode, theModelExplanation);
        }
        {
            LocalTransformations theLocalTransformations;
            theLocalTransformations = this.getLocalTransformations();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "localTransformations", theLocalTransformations), currentHashCode, theLocalTransformations);
        }
        {
            ComparisonMeasure theComparisonMeasure;
            theComparisonMeasure = this.getComparisonMeasure();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "comparisonMeasure", theComparisonMeasure), currentHashCode, theComparisonMeasure);
        }
        {
            List<ClusteringField> theClusteringFields;
            theClusteringFields = (((this.clusteringFields!= null)&&(!this.clusteringFields.isEmpty()))?this.getClusteringFields():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "clusteringFields", theClusteringFields), currentHashCode, theClusteringFields);
        }
        {
            MissingValueWeights theMissingValueWeights;
            theMissingValueWeights = this.getMissingValueWeights();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "missingValueWeights", theMissingValueWeights), currentHashCode, theMissingValueWeights);
        }
        {
            List<Cluster> theClusters;
            theClusters = (((this.clusters!= null)&&(!this.clusters.isEmpty()))?this.getClusters():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "clusters", theClusters), currentHashCode, theClusters);
        }
        {
            ModelVerification theModelVerification;
            theModelVerification = this.getModelVerification();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelVerification", theModelVerification), currentHashCode, theModelVerification);
        }
        {
            String theModelName;
            theModelName = this.getModelName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelName", theModelName), currentHashCode, theModelName);
        }
        {
            MiningFunctionType theFunctionName;
            theFunctionName = this.getFunctionName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "functionName", theFunctionName), currentHashCode, theFunctionName);
        }
        {
            String theAlgorithmName;
            theAlgorithmName = this.getAlgorithmName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "algorithmName", theAlgorithmName), currentHashCode, theAlgorithmName);
        }
        {
            ClusteringModel.ModelClass theModelClass;
            theModelClass = this.getModelClass();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelClass", theModelClass), currentHashCode, theModelClass);
        }
        {
            BigInteger theNumberOfClusters;
            theNumberOfClusters = this.getNumberOfClusters();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "numberOfClusters", theNumberOfClusters), currentHashCode, theNumberOfClusters);
        }
        {
            boolean theScorable;
            theScorable = ((this.scorable!= null)?this.isScorable():false);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "scorable", theScorable), currentHashCode, theScorable);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<Extension> theExtensions;
            theExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            strategy.appendField(locator, this, "extensions", buffer, theExtensions);
        }
        {
            MiningSchema theMiningSchema;
            theMiningSchema = this.getMiningSchema();
            strategy.appendField(locator, this, "miningSchema", buffer, theMiningSchema);
        }
        {
            Output theOutput;
            theOutput = this.getOutput();
            strategy.appendField(locator, this, "output", buffer, theOutput);
        }
        {
            ModelStats theModelStats;
            theModelStats = this.getModelStats();
            strategy.appendField(locator, this, "modelStats", buffer, theModelStats);
        }
        {
            ModelExplanation theModelExplanation;
            theModelExplanation = this.getModelExplanation();
            strategy.appendField(locator, this, "modelExplanation", buffer, theModelExplanation);
        }
        {
            LocalTransformations theLocalTransformations;
            theLocalTransformations = this.getLocalTransformations();
            strategy.appendField(locator, this, "localTransformations", buffer, theLocalTransformations);
        }
        {
            ComparisonMeasure theComparisonMeasure;
            theComparisonMeasure = this.getComparisonMeasure();
            strategy.appendField(locator, this, "comparisonMeasure", buffer, theComparisonMeasure);
        }
        {
            List<ClusteringField> theClusteringFields;
            theClusteringFields = (((this.clusteringFields!= null)&&(!this.clusteringFields.isEmpty()))?this.getClusteringFields():null);
            strategy.appendField(locator, this, "clusteringFields", buffer, theClusteringFields);
        }
        {
            MissingValueWeights theMissingValueWeights;
            theMissingValueWeights = this.getMissingValueWeights();
            strategy.appendField(locator, this, "missingValueWeights", buffer, theMissingValueWeights);
        }
        {
            List<Cluster> theClusters;
            theClusters = (((this.clusters!= null)&&(!this.clusters.isEmpty()))?this.getClusters():null);
            strategy.appendField(locator, this, "clusters", buffer, theClusters);
        }
        {
            ModelVerification theModelVerification;
            theModelVerification = this.getModelVerification();
            strategy.appendField(locator, this, "modelVerification", buffer, theModelVerification);
        }
        {
            String theModelName;
            theModelName = this.getModelName();
            strategy.appendField(locator, this, "modelName", buffer, theModelName);
        }
        {
            MiningFunctionType theFunctionName;
            theFunctionName = this.getFunctionName();
            strategy.appendField(locator, this, "functionName", buffer, theFunctionName);
        }
        {
            String theAlgorithmName;
            theAlgorithmName = this.getAlgorithmName();
            strategy.appendField(locator, this, "algorithmName", buffer, theAlgorithmName);
        }
        {
            ClusteringModel.ModelClass theModelClass;
            theModelClass = this.getModelClass();
            strategy.appendField(locator, this, "modelClass", buffer, theModelClass);
        }
        {
            BigInteger theNumberOfClusters;
            theNumberOfClusters = this.getNumberOfClusters();
            strategy.appendField(locator, this, "numberOfClusters", buffer, theNumberOfClusters);
        }
        {
            boolean theScorable;
            theScorable = ((this.scorable!= null)?this.isScorable():false);
            strategy.appendField(locator, this, "scorable", buffer, theScorable);
        }
        return buffer;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="centerBased"/>
     *     &lt;enumeration value="distributionBased"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum ModelClass {

        @XmlEnumValue("centerBased")
        CENTER_BASED("centerBased"),
        @XmlEnumValue("distributionBased")
        DISTRIBUTION_BASED("distributionBased");
        private final String value;

        ModelClass(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static ClusteringModel.ModelClass fromValue(String v) {
            for (ClusteringModel.ModelClass c: ClusteringModel.ModelClass.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
