
package org.dmg.pmml;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ResultField" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Node"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_1}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="missingValueStrategy" type="{http://www.dmg.org/PMML-4_1}MISSING-VALUE-STRATEGY" default="none" />
 *       &lt;attribute name="missingValuePenalty" type="{http://www.dmg.org/PMML-4_1}PROB-NUMBER" default="1.0" />
 *       &lt;attribute name="noTrueChildStrategy" type="{http://www.dmg.org/PMML-4_1}NO-TRUE-CHILD-STRATEGY" default="returnNullPrediction" />
 *       &lt;attribute name="splitCharacteristic" default="multiSplit">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="binarySplit"/>
 *             &lt;enumeration value="multiSplit"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "output",
    "modelStats",
    "targets",
    "localTransformations",
    "resultFields",
    "node"
})
@XmlRootElement(name = "DecisionTree")
public class DecisionTree
    extends PMMLObject
    implements Equals, HashCode, ToString
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "Output")
    protected Output output;
    @XmlElement(name = "ModelStats")
    protected ModelStats modelStats;
    @XmlElement(name = "Targets")
    protected Targets targets;
    @XmlElement(name = "LocalTransformations")
    protected LocalTransformations localTransformations;
    @XmlElement(name = "ResultField")
    protected List<ResultField> resultFields;
    @XmlElement(name = "Node", required = true)
    protected Node node;
    @XmlAttribute(name = "modelName")
    protected String modelName;
    @XmlAttribute(name = "functionName", required = true)
    protected MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    protected String algorithmName;
    @XmlAttribute(name = "missingValueStrategy")
    protected MissingValueStrategyType missingValueStrategy;
    @XmlAttribute(name = "missingValuePenalty")
    protected BigDecimal missingValuePenalty;
    @XmlAttribute(name = "noTrueChildStrategy")
    protected NoTrueChildStrategyType noTrueChildStrategy;
    @XmlAttribute(name = "splitCharacteristic")
    protected DecisionTree.SplitCharacteristic splitCharacteristic;

    @Deprecated
    public DecisionTree() {
        super();
    }

    public DecisionTree(final Node node, final MiningFunctionType functionName) {
        super();
        this.node = node;
        this.functionName = functionName;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param value
     *     allowed object is
     *     {@link Output }
     *     
     */
    public void setOutput(Output value) {
        this.output = value;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public void setModelStats(ModelStats value) {
        this.modelStats = value;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param value
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public void setTargets(Targets value) {
        this.targets = value;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public void setLocalTransformations(LocalTransformations value) {
        this.localTransformations = value;
    }

    /**
     * Gets the value of the resultFields property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the resultFields property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getResultFields().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ResultField }
     * 
     * 
     */
    public List<ResultField> getResultFields() {
        if (resultFields == null) {
            resultFields = new ArrayList<ResultField>();
        }
        return this.resultFields;
    }

    /**
     * Gets the value of the node property.
     * 
     * @return
     *     possible object is
     *     {@link Node }
     *     
     */
    public Node getNode() {
        return node;
    }

    /**
     * Sets the value of the node property.
     * 
     * @param value
     *     allowed object is
     *     {@link Node }
     *     
     */
    public void setNode(Node value) {
        this.node = value;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setModelName(String value) {
        this.modelName = value;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public void setFunctionName(MiningFunctionType value) {
        this.functionName = value;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlgorithmName(String value) {
        this.algorithmName = value;
    }

    /**
     * Gets the value of the missingValueStrategy property.
     * 
     * @return
     *     possible object is
     *     {@link MissingValueStrategyType }
     *     
     */
    public MissingValueStrategyType getMissingValueStrategy() {
        if (missingValueStrategy == null) {
            return MissingValueStrategyType.NONE;
        } else {
            return missingValueStrategy;
        }
    }

    /**
     * Sets the value of the missingValueStrategy property.
     * 
     * @param value
     *     allowed object is
     *     {@link MissingValueStrategyType }
     *     
     */
    public void setMissingValueStrategy(MissingValueStrategyType value) {
        this.missingValueStrategy = value;
    }

    /**
     * Gets the value of the missingValuePenalty property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getMissingValuePenalty() {
        if (missingValuePenalty == null) {
            return new BigDecimal("1.0");
        } else {
            return missingValuePenalty;
        }
    }

    /**
     * Sets the value of the missingValuePenalty property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setMissingValuePenalty(BigDecimal value) {
        this.missingValuePenalty = value;
    }

    /**
     * Gets the value of the noTrueChildStrategy property.
     * 
     * @return
     *     possible object is
     *     {@link NoTrueChildStrategyType }
     *     
     */
    public NoTrueChildStrategyType getNoTrueChildStrategy() {
        if (noTrueChildStrategy == null) {
            return NoTrueChildStrategyType.RETURN_NULL_PREDICTION;
        } else {
            return noTrueChildStrategy;
        }
    }

    /**
     * Sets the value of the noTrueChildStrategy property.
     * 
     * @param value
     *     allowed object is
     *     {@link NoTrueChildStrategyType }
     *     
     */
    public void setNoTrueChildStrategy(NoTrueChildStrategyType value) {
        this.noTrueChildStrategy = value;
    }

    /**
     * Gets the value of the splitCharacteristic property.
     * 
     * @return
     *     possible object is
     *     {@link DecisionTree.SplitCharacteristic }
     *     
     */
    public DecisionTree.SplitCharacteristic getSplitCharacteristic() {
        if (splitCharacteristic == null) {
            return DecisionTree.SplitCharacteristic.MULTI_SPLIT;
        } else {
            return splitCharacteristic;
        }
    }

    /**
     * Sets the value of the splitCharacteristic property.
     * 
     * @param value
     *     allowed object is
     *     {@link DecisionTree.SplitCharacteristic }
     *     
     */
    public void setSplitCharacteristic(DecisionTree.SplitCharacteristic value) {
        this.splitCharacteristic = value;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if (!(object instanceof DecisionTree)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        final DecisionTree that = ((DecisionTree) object);
        {
            List<Extension> lhsExtensions;
            lhsExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            List<Extension> rhsExtensions;
            rhsExtensions = (((that.extensions!= null)&&(!that.extensions.isEmpty()))?that.getExtensions():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "extensions", lhsExtensions), LocatorUtils.property(thatLocator, "extensions", rhsExtensions), lhsExtensions, rhsExtensions)) {
                return false;
            }
        }
        {
            Output lhsOutput;
            lhsOutput = this.getOutput();
            Output rhsOutput;
            rhsOutput = that.getOutput();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "output", lhsOutput), LocatorUtils.property(thatLocator, "output", rhsOutput), lhsOutput, rhsOutput)) {
                return false;
            }
        }
        {
            ModelStats lhsModelStats;
            lhsModelStats = this.getModelStats();
            ModelStats rhsModelStats;
            rhsModelStats = that.getModelStats();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelStats", lhsModelStats), LocatorUtils.property(thatLocator, "modelStats", rhsModelStats), lhsModelStats, rhsModelStats)) {
                return false;
            }
        }
        {
            Targets lhsTargets;
            lhsTargets = this.getTargets();
            Targets rhsTargets;
            rhsTargets = that.getTargets();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "targets", lhsTargets), LocatorUtils.property(thatLocator, "targets", rhsTargets), lhsTargets, rhsTargets)) {
                return false;
            }
        }
        {
            LocalTransformations lhsLocalTransformations;
            lhsLocalTransformations = this.getLocalTransformations();
            LocalTransformations rhsLocalTransformations;
            rhsLocalTransformations = that.getLocalTransformations();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "localTransformations", lhsLocalTransformations), LocatorUtils.property(thatLocator, "localTransformations", rhsLocalTransformations), lhsLocalTransformations, rhsLocalTransformations)) {
                return false;
            }
        }
        {
            List<ResultField> lhsResultFields;
            lhsResultFields = (((this.resultFields!= null)&&(!this.resultFields.isEmpty()))?this.getResultFields():null);
            List<ResultField> rhsResultFields;
            rhsResultFields = (((that.resultFields!= null)&&(!that.resultFields.isEmpty()))?that.getResultFields():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "resultFields", lhsResultFields), LocatorUtils.property(thatLocator, "resultFields", rhsResultFields), lhsResultFields, rhsResultFields)) {
                return false;
            }
        }
        {
            Node lhsNode;
            lhsNode = this.getNode();
            Node rhsNode;
            rhsNode = that.getNode();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "node", lhsNode), LocatorUtils.property(thatLocator, "node", rhsNode), lhsNode, rhsNode)) {
                return false;
            }
        }
        {
            String lhsModelName;
            lhsModelName = this.getModelName();
            String rhsModelName;
            rhsModelName = that.getModelName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelName", lhsModelName), LocatorUtils.property(thatLocator, "modelName", rhsModelName), lhsModelName, rhsModelName)) {
                return false;
            }
        }
        {
            MiningFunctionType lhsFunctionName;
            lhsFunctionName = this.getFunctionName();
            MiningFunctionType rhsFunctionName;
            rhsFunctionName = that.getFunctionName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "functionName", lhsFunctionName), LocatorUtils.property(thatLocator, "functionName", rhsFunctionName), lhsFunctionName, rhsFunctionName)) {
                return false;
            }
        }
        {
            String lhsAlgorithmName;
            lhsAlgorithmName = this.getAlgorithmName();
            String rhsAlgorithmName;
            rhsAlgorithmName = that.getAlgorithmName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "algorithmName", lhsAlgorithmName), LocatorUtils.property(thatLocator, "algorithmName", rhsAlgorithmName), lhsAlgorithmName, rhsAlgorithmName)) {
                return false;
            }
        }
        {
            MissingValueStrategyType lhsMissingValueStrategy;
            lhsMissingValueStrategy = this.getMissingValueStrategy();
            MissingValueStrategyType rhsMissingValueStrategy;
            rhsMissingValueStrategy = that.getMissingValueStrategy();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "missingValueStrategy", lhsMissingValueStrategy), LocatorUtils.property(thatLocator, "missingValueStrategy", rhsMissingValueStrategy), lhsMissingValueStrategy, rhsMissingValueStrategy)) {
                return false;
            }
        }
        {
            BigDecimal lhsMissingValuePenalty;
            lhsMissingValuePenalty = this.getMissingValuePenalty();
            BigDecimal rhsMissingValuePenalty;
            rhsMissingValuePenalty = that.getMissingValuePenalty();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "missingValuePenalty", lhsMissingValuePenalty), LocatorUtils.property(thatLocator, "missingValuePenalty", rhsMissingValuePenalty), lhsMissingValuePenalty, rhsMissingValuePenalty)) {
                return false;
            }
        }
        {
            NoTrueChildStrategyType lhsNoTrueChildStrategy;
            lhsNoTrueChildStrategy = this.getNoTrueChildStrategy();
            NoTrueChildStrategyType rhsNoTrueChildStrategy;
            rhsNoTrueChildStrategy = that.getNoTrueChildStrategy();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "noTrueChildStrategy", lhsNoTrueChildStrategy), LocatorUtils.property(thatLocator, "noTrueChildStrategy", rhsNoTrueChildStrategy), lhsNoTrueChildStrategy, rhsNoTrueChildStrategy)) {
                return false;
            }
        }
        {
            DecisionTree.SplitCharacteristic lhsSplitCharacteristic;
            lhsSplitCharacteristic = this.getSplitCharacteristic();
            DecisionTree.SplitCharacteristic rhsSplitCharacteristic;
            rhsSplitCharacteristic = that.getSplitCharacteristic();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "splitCharacteristic", lhsSplitCharacteristic), LocatorUtils.property(thatLocator, "splitCharacteristic", rhsSplitCharacteristic), lhsSplitCharacteristic, rhsSplitCharacteristic)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        {
            List<Extension> theExtensions;
            theExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "extensions", theExtensions), currentHashCode, theExtensions);
        }
        {
            Output theOutput;
            theOutput = this.getOutput();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "output", theOutput), currentHashCode, theOutput);
        }
        {
            ModelStats theModelStats;
            theModelStats = this.getModelStats();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelStats", theModelStats), currentHashCode, theModelStats);
        }
        {
            Targets theTargets;
            theTargets = this.getTargets();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "targets", theTargets), currentHashCode, theTargets);
        }
        {
            LocalTransformations theLocalTransformations;
            theLocalTransformations = this.getLocalTransformations();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "localTransformations", theLocalTransformations), currentHashCode, theLocalTransformations);
        }
        {
            List<ResultField> theResultFields;
            theResultFields = (((this.resultFields!= null)&&(!this.resultFields.isEmpty()))?this.getResultFields():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "resultFields", theResultFields), currentHashCode, theResultFields);
        }
        {
            Node theNode;
            theNode = this.getNode();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "node", theNode), currentHashCode, theNode);
        }
        {
            String theModelName;
            theModelName = this.getModelName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelName", theModelName), currentHashCode, theModelName);
        }
        {
            MiningFunctionType theFunctionName;
            theFunctionName = this.getFunctionName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "functionName", theFunctionName), currentHashCode, theFunctionName);
        }
        {
            String theAlgorithmName;
            theAlgorithmName = this.getAlgorithmName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "algorithmName", theAlgorithmName), currentHashCode, theAlgorithmName);
        }
        {
            MissingValueStrategyType theMissingValueStrategy;
            theMissingValueStrategy = this.getMissingValueStrategy();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "missingValueStrategy", theMissingValueStrategy), currentHashCode, theMissingValueStrategy);
        }
        {
            BigDecimal theMissingValuePenalty;
            theMissingValuePenalty = this.getMissingValuePenalty();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "missingValuePenalty", theMissingValuePenalty), currentHashCode, theMissingValuePenalty);
        }
        {
            NoTrueChildStrategyType theNoTrueChildStrategy;
            theNoTrueChildStrategy = this.getNoTrueChildStrategy();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "noTrueChildStrategy", theNoTrueChildStrategy), currentHashCode, theNoTrueChildStrategy);
        }
        {
            DecisionTree.SplitCharacteristic theSplitCharacteristic;
            theSplitCharacteristic = this.getSplitCharacteristic();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "splitCharacteristic", theSplitCharacteristic), currentHashCode, theSplitCharacteristic);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<Extension> theExtensions;
            theExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            strategy.appendField(locator, this, "extensions", buffer, theExtensions);
        }
        {
            Output theOutput;
            theOutput = this.getOutput();
            strategy.appendField(locator, this, "output", buffer, theOutput);
        }
        {
            ModelStats theModelStats;
            theModelStats = this.getModelStats();
            strategy.appendField(locator, this, "modelStats", buffer, theModelStats);
        }
        {
            Targets theTargets;
            theTargets = this.getTargets();
            strategy.appendField(locator, this, "targets", buffer, theTargets);
        }
        {
            LocalTransformations theLocalTransformations;
            theLocalTransformations = this.getLocalTransformations();
            strategy.appendField(locator, this, "localTransformations", buffer, theLocalTransformations);
        }
        {
            List<ResultField> theResultFields;
            theResultFields = (((this.resultFields!= null)&&(!this.resultFields.isEmpty()))?this.getResultFields():null);
            strategy.appendField(locator, this, "resultFields", buffer, theResultFields);
        }
        {
            Node theNode;
            theNode = this.getNode();
            strategy.appendField(locator, this, "node", buffer, theNode);
        }
        {
            String theModelName;
            theModelName = this.getModelName();
            strategy.appendField(locator, this, "modelName", buffer, theModelName);
        }
        {
            MiningFunctionType theFunctionName;
            theFunctionName = this.getFunctionName();
            strategy.appendField(locator, this, "functionName", buffer, theFunctionName);
        }
        {
            String theAlgorithmName;
            theAlgorithmName = this.getAlgorithmName();
            strategy.appendField(locator, this, "algorithmName", buffer, theAlgorithmName);
        }
        {
            MissingValueStrategyType theMissingValueStrategy;
            theMissingValueStrategy = this.getMissingValueStrategy();
            strategy.appendField(locator, this, "missingValueStrategy", buffer, theMissingValueStrategy);
        }
        {
            BigDecimal theMissingValuePenalty;
            theMissingValuePenalty = this.getMissingValuePenalty();
            strategy.appendField(locator, this, "missingValuePenalty", buffer, theMissingValuePenalty);
        }
        {
            NoTrueChildStrategyType theNoTrueChildStrategy;
            theNoTrueChildStrategy = this.getNoTrueChildStrategy();
            strategy.appendField(locator, this, "noTrueChildStrategy", buffer, theNoTrueChildStrategy);
        }
        {
            DecisionTree.SplitCharacteristic theSplitCharacteristic;
            theSplitCharacteristic = this.getSplitCharacteristic();
            strategy.appendField(locator, this, "splitCharacteristic", buffer, theSplitCharacteristic);
        }
        return buffer;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="binarySplit"/>
     *     &lt;enumeration value="multiSplit"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum SplitCharacteristic {

        @XmlEnumValue("binarySplit")
        BINARY_SPLIT("binarySplit"),
        @XmlEnumValue("multiSplit")
        MULTI_SPLIT("multiSplit");
        private final String value;

        SplitCharacteristic(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static DecisionTree.SplitCharacteristic fromValue(String v) {
            for (DecisionTree.SplitCharacteristic c: DecisionTree.SplitCharacteristic.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
