
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}DerivedField" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}TargetValueStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}PairCounts" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="fieldName" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "derivedField",
    "targetValueStats",
    "pairCounts"
})
@XmlRootElement(name = "BayesInput")
public class BayesInput
    extends PMMLObject
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "DerivedField")
    protected DerivedField derivedField;
    @XmlElement(name = "TargetValueStats")
    protected TargetValueStats targetValueStats;
    @XmlElement(name = "PairCounts", required = true)
    protected List<PairCounts> pairCounts;
    @XmlAttribute(name = "fieldName", required = true)
    protected String fieldName;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    @Deprecated
    public BayesInput() {
        super();
    }

    public BayesInput(final String fieldName) {
        super();
        this.fieldName = fieldName;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the derivedField property.
     * 
     * @return
     *     possible object is
     *     {@link DerivedField }
     *     
     */
    public DerivedField getDerivedField() {
        return derivedField;
    }

    /**
     * Sets the value of the derivedField property.
     * 
     * @param value
     *     allowed object is
     *     {@link DerivedField }
     *     
     */
    public void setDerivedField(DerivedField value) {
        this.derivedField = value;
    }

    /**
     * Gets the value of the targetValueStats property.
     * 
     * @return
     *     possible object is
     *     {@link TargetValueStats }
     *     
     */
    public TargetValueStats getTargetValueStats() {
        return targetValueStats;
    }

    /**
     * Sets the value of the targetValueStats property.
     * 
     * @param value
     *     allowed object is
     *     {@link TargetValueStats }
     *     
     */
    public void setTargetValueStats(TargetValueStats value) {
        this.targetValueStats = value;
    }

    /**
     * Gets the value of the pairCounts property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the pairCounts property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPairCounts().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PairCounts }
     * 
     * 
     */
    public List<PairCounts> getPairCounts() {
        if (pairCounts == null) {
            pairCounts = new ArrayList<PairCounts>();
        }
        return this.pairCounts;
    }

    /**
     * Gets the value of the fieldName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFieldName() {
        return fieldName;
    }

    /**
     * Sets the value of the fieldName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFieldName(String value) {
        this.fieldName = value;
    }

    public BayesInput withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public BayesInput withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public BayesInput withDerivedField(DerivedField value) {
        setDerivedField(value);
        return this;
    }

    public BayesInput withTargetValueStats(TargetValueStats value) {
        setTargetValueStats(value);
        return this;
    }

    public BayesInput withPairCounts(PairCounts... values) {
        if (values!= null) {
            for (PairCounts value: values) {
                getPairCounts().add(value);
            }
        }
        return this;
    }

    public BayesInput withPairCounts(Collection<PairCounts> values) {
        if (values!= null) {
            getPairCounts().addAll(values);
        }
        return this;
    }

    public BayesInput withFieldName(String value) {
        setFieldName(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.derivedField!= null)) {
            status = this.derivedField.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.targetValueStats!= null)) {
            status = this.targetValueStats.accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.pairCounts!= null))&&(i<this.pairCounts.size())); i ++) {
            status = this.pairCounts.get(i).accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
