
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ParameterList"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}FactorList" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}CovariateList" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}PPMatrix"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}PCovMatrix" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ParamMatrix"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}EventValues" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}BaseCumHazardTables" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="targetVariableName" type="{http://www.dmg.org/PMML-4_1}FIELD-NAME" />
 *       &lt;attribute name="modelType" use="required">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="regression"/>
 *             &lt;enumeration value="generalLinear"/>
 *             &lt;enumeration value="multinomialLogistic"/>
 *             &lt;enumeration value="ordinalMultinomial"/>
 *             &lt;enumeration value="generalizedLinear"/>
 *             &lt;enumeration value="CoxRegression"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_1}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="targetReferenceCategory" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="cumulativeLink" type="{http://www.dmg.org/PMML-4_1}CUMULATIVE-LINK-FUNCTION" />
 *       &lt;attribute name="linkFunction" type="{http://www.dmg.org/PMML-4_1}LINK-FUNCTION" />
 *       &lt;attribute name="linkParameter" type="{http://www.dmg.org/PMML-4_1}REAL-NUMBER" />
 *       &lt;attribute name="trialsVariable" type="{http://www.dmg.org/PMML-4_1}FIELD-NAME" />
 *       &lt;attribute name="trialsValue" type="{http://www.dmg.org/PMML-4_1}INT-NUMBER" />
 *       &lt;attribute name="distribution">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="binomial"/>
 *             &lt;enumeration value="gamma"/>
 *             &lt;enumeration value="igauss"/>
 *             &lt;enumeration value="negbin"/>
 *             &lt;enumeration value="normal"/>
 *             &lt;enumeration value="poisson"/>
 *             &lt;enumeration value="tweedie"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="distParameter" type="{http://www.dmg.org/PMML-4_1}REAL-NUMBER" />
 *       &lt;attribute name="offsetVariable" type="{http://www.dmg.org/PMML-4_1}FIELD-NAME" />
 *       &lt;attribute name="offsetValue" type="{http://www.dmg.org/PMML-4_1}REAL-NUMBER" />
 *       &lt;attribute name="modelDF" type="{http://www.dmg.org/PMML-4_1}REAL-NUMBER" />
 *       &lt;attribute name="endTimeVariable" type="{http://www.dmg.org/PMML-4_1}FIELD-NAME" />
 *       &lt;attribute name="startTimeVariable" type="{http://www.dmg.org/PMML-4_1}FIELD-NAME" />
 *       &lt;attribute name="subjectIDVariable" type="{http://www.dmg.org/PMML-4_1}FIELD-NAME" />
 *       &lt;attribute name="statusVariable" type="{http://www.dmg.org/PMML-4_1}FIELD-NAME" />
 *       &lt;attribute name="baselineStrataVariable" type="{http://www.dmg.org/PMML-4_1}FIELD-NAME" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "parameterList",
    "factorList",
    "covariateList",
    "ppMatrix",
    "pCovMatrix",
    "paramMatrix",
    "eventValues",
    "baseCumHazardTables",
    "modelVerification"
})
@XmlRootElement(name = "GeneralRegressionModel")
public class GeneralRegressionModel
    extends Model
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "MiningSchema", required = true)
    protected MiningSchema miningSchema;
    @XmlElement(name = "Output")
    protected Output output;
    @XmlElement(name = "ModelStats")
    protected ModelStats modelStats;
    @XmlElement(name = "ModelExplanation")
    protected ModelExplanation modelExplanation;
    @XmlElement(name = "Targets")
    protected Targets targets;
    @XmlElement(name = "LocalTransformations")
    protected LocalTransformations localTransformations;
    @XmlElement(name = "ParameterList", required = true)
    protected ParameterList parameterList;
    @XmlElement(name = "FactorList")
    protected FactorList factorList;
    @XmlElement(name = "CovariateList")
    protected CovariateList covariateList;
    @XmlElement(name = "PPMatrix", required = true)
    protected PPMatrix ppMatrix;
    @XmlElement(name = "PCovMatrix")
    protected PCovMatrix pCovMatrix;
    @XmlElement(name = "ParamMatrix", required = true)
    protected ParamMatrix paramMatrix;
    @XmlElement(name = "EventValues")
    protected EventValues eventValues;
    @XmlElement(name = "BaseCumHazardTables")
    protected BaseCumHazardTables baseCumHazardTables;
    @XmlElement(name = "ModelVerification")
    protected ModelVerification modelVerification;
    @XmlAttribute(name = "targetVariableName")
    @XmlJavaTypeAdapter(org.dmg.pmml.Adapter1 .class)
    protected FieldName targetVariableName;
    @XmlAttribute(name = "modelType", required = true)
    protected GeneralRegressionModel.ModelType modelType;
    @XmlAttribute(name = "modelName")
    protected String modelName;
    @XmlAttribute(name = "functionName", required = true)
    protected MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    protected String algorithmName;
    @XmlAttribute(name = "targetReferenceCategory")
    protected String targetReferenceCategory;
    @XmlAttribute(name = "cumulativeLink")
    protected CumulativeLinkFunctionType cumulativeLink;
    @XmlAttribute(name = "linkFunction")
    protected LinkFunctionType linkFunction;
    @XmlAttribute(name = "linkParameter")
    protected Double linkParameter;
    @XmlAttribute(name = "trialsVariable")
    @XmlJavaTypeAdapter(org.dmg.pmml.Adapter1 .class)
    protected FieldName trialsVariable;
    @XmlAttribute(name = "trialsValue")
    @XmlJavaTypeAdapter(org.w3._2001.xmlschema.Adapter1 .class)
    protected Integer trialsValue;
    @XmlAttribute(name = "distribution")
    protected GeneralRegressionModel.Distribution distribution;
    @XmlAttribute(name = "distParameter")
    protected Double distParameter;
    @XmlAttribute(name = "offsetVariable")
    @XmlJavaTypeAdapter(org.dmg.pmml.Adapter1 .class)
    protected FieldName offsetVariable;
    @XmlAttribute(name = "offsetValue")
    protected Double offsetValue;
    @XmlAttribute(name = "modelDF")
    protected Double modelDF;
    @XmlAttribute(name = "endTimeVariable")
    @XmlJavaTypeAdapter(org.dmg.pmml.Adapter1 .class)
    protected FieldName endTimeVariable;
    @XmlAttribute(name = "startTimeVariable")
    @XmlJavaTypeAdapter(org.dmg.pmml.Adapter1 .class)
    protected FieldName startTimeVariable;
    @XmlAttribute(name = "subjectIDVariable")
    @XmlJavaTypeAdapter(org.dmg.pmml.Adapter1 .class)
    protected FieldName subjectIDVariable;
    @XmlAttribute(name = "statusVariable")
    @XmlJavaTypeAdapter(org.dmg.pmml.Adapter1 .class)
    protected FieldName statusVariable;
    @XmlAttribute(name = "baselineStrataVariable")
    @XmlJavaTypeAdapter(org.dmg.pmml.Adapter1 .class)
    protected FieldName baselineStrataVariable;
    @XmlAttribute(name = "isScorable")
    protected Boolean scorable;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    @Deprecated
    public GeneralRegressionModel() {
        super();
    }

    public GeneralRegressionModel(final MiningSchema miningSchema, final ParameterList parameterList, final PPMatrix ppMatrix, final ParamMatrix paramMatrix, final GeneralRegressionModel.ModelType modelType, final MiningFunctionType functionName) {
        super();
        this.miningSchema = miningSchema;
        this.parameterList = parameterList;
        this.ppMatrix = ppMatrix;
        this.paramMatrix = paramMatrix;
        this.modelType = modelType;
        this.functionName = functionName;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public void setMiningSchema(MiningSchema value) {
        this.miningSchema = value;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param value
     *     allowed object is
     *     {@link Output }
     *     
     */
    public void setOutput(Output value) {
        this.output = value;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public void setModelStats(ModelStats value) {
        this.modelStats = value;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public void setModelExplanation(ModelExplanation value) {
        this.modelExplanation = value;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param value
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public void setTargets(Targets value) {
        this.targets = value;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public void setLocalTransformations(LocalTransformations value) {
        this.localTransformations = value;
    }

    /**
     * Gets the value of the parameterList property.
     * 
     * @return
     *     possible object is
     *     {@link ParameterList }
     *     
     */
    public ParameterList getParameterList() {
        return parameterList;
    }

    /**
     * Sets the value of the parameterList property.
     * 
     * @param value
     *     allowed object is
     *     {@link ParameterList }
     *     
     */
    public void setParameterList(ParameterList value) {
        this.parameterList = value;
    }

    /**
     * Gets the value of the factorList property.
     * 
     * @return
     *     possible object is
     *     {@link FactorList }
     *     
     */
    public FactorList getFactorList() {
        return factorList;
    }

    /**
     * Sets the value of the factorList property.
     * 
     * @param value
     *     allowed object is
     *     {@link FactorList }
     *     
     */
    public void setFactorList(FactorList value) {
        this.factorList = value;
    }

    /**
     * Gets the value of the covariateList property.
     * 
     * @return
     *     possible object is
     *     {@link CovariateList }
     *     
     */
    public CovariateList getCovariateList() {
        return covariateList;
    }

    /**
     * Sets the value of the covariateList property.
     * 
     * @param value
     *     allowed object is
     *     {@link CovariateList }
     *     
     */
    public void setCovariateList(CovariateList value) {
        this.covariateList = value;
    }

    /**
     * Gets the value of the ppMatrix property.
     * 
     * @return
     *     possible object is
     *     {@link PPMatrix }
     *     
     */
    public PPMatrix getPPMatrix() {
        return ppMatrix;
    }

    /**
     * Sets the value of the ppMatrix property.
     * 
     * @param value
     *     allowed object is
     *     {@link PPMatrix }
     *     
     */
    public void setPPMatrix(PPMatrix value) {
        this.ppMatrix = value;
    }

    /**
     * Gets the value of the pCovMatrix property.
     * 
     * @return
     *     possible object is
     *     {@link PCovMatrix }
     *     
     */
    public PCovMatrix getPCovMatrix() {
        return pCovMatrix;
    }

    /**
     * Sets the value of the pCovMatrix property.
     * 
     * @param value
     *     allowed object is
     *     {@link PCovMatrix }
     *     
     */
    public void setPCovMatrix(PCovMatrix value) {
        this.pCovMatrix = value;
    }

    /**
     * Gets the value of the paramMatrix property.
     * 
     * @return
     *     possible object is
     *     {@link ParamMatrix }
     *     
     */
    public ParamMatrix getParamMatrix() {
        return paramMatrix;
    }

    /**
     * Sets the value of the paramMatrix property.
     * 
     * @param value
     *     allowed object is
     *     {@link ParamMatrix }
     *     
     */
    public void setParamMatrix(ParamMatrix value) {
        this.paramMatrix = value;
    }

    /**
     * Gets the value of the eventValues property.
     * 
     * @return
     *     possible object is
     *     {@link EventValues }
     *     
     */
    public EventValues getEventValues() {
        return eventValues;
    }

    /**
     * Sets the value of the eventValues property.
     * 
     * @param value
     *     allowed object is
     *     {@link EventValues }
     *     
     */
    public void setEventValues(EventValues value) {
        this.eventValues = value;
    }

    /**
     * Gets the value of the baseCumHazardTables property.
     * 
     * @return
     *     possible object is
     *     {@link BaseCumHazardTables }
     *     
     */
    public BaseCumHazardTables getBaseCumHazardTables() {
        return baseCumHazardTables;
    }

    /**
     * Sets the value of the baseCumHazardTables property.
     * 
     * @param value
     *     allowed object is
     *     {@link BaseCumHazardTables }
     *     
     */
    public void setBaseCumHazardTables(BaseCumHazardTables value) {
        this.baseCumHazardTables = value;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public void setModelVerification(ModelVerification value) {
        this.modelVerification = value;
    }

    /**
     * Gets the value of the targetVariableName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getTargetVariableName() {
        return targetVariableName;
    }

    /**
     * Sets the value of the targetVariableName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTargetVariableName(FieldName value) {
        this.targetVariableName = value;
    }

    /**
     * Gets the value of the modelType property.
     * 
     * @return
     *     possible object is
     *     {@link GeneralRegressionModel.ModelType }
     *     
     */
    public GeneralRegressionModel.ModelType getModelType() {
        return modelType;
    }

    /**
     * Sets the value of the modelType property.
     * 
     * @param value
     *     allowed object is
     *     {@link GeneralRegressionModel.ModelType }
     *     
     */
    public void setModelType(GeneralRegressionModel.ModelType value) {
        this.modelType = value;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setModelName(String value) {
        this.modelName = value;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public void setFunctionName(MiningFunctionType value) {
        this.functionName = value;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlgorithmName(String value) {
        this.algorithmName = value;
    }

    /**
     * Gets the value of the targetReferenceCategory property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTargetReferenceCategory() {
        return targetReferenceCategory;
    }

    /**
     * Sets the value of the targetReferenceCategory property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTargetReferenceCategory(String value) {
        this.targetReferenceCategory = value;
    }

    /**
     * Gets the value of the cumulativeLink property.
     * 
     * @return
     *     possible object is
     *     {@link CumulativeLinkFunctionType }
     *     
     */
    public CumulativeLinkFunctionType getCumulativeLink() {
        return cumulativeLink;
    }

    /**
     * Sets the value of the cumulativeLink property.
     * 
     * @param value
     *     allowed object is
     *     {@link CumulativeLinkFunctionType }
     *     
     */
    public void setCumulativeLink(CumulativeLinkFunctionType value) {
        this.cumulativeLink = value;
    }

    /**
     * Gets the value of the linkFunction property.
     * 
     * @return
     *     possible object is
     *     {@link LinkFunctionType }
     *     
     */
    public LinkFunctionType getLinkFunction() {
        return linkFunction;
    }

    /**
     * Sets the value of the linkFunction property.
     * 
     * @param value
     *     allowed object is
     *     {@link LinkFunctionType }
     *     
     */
    public void setLinkFunction(LinkFunctionType value) {
        this.linkFunction = value;
    }

    /**
     * Gets the value of the linkParameter property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getLinkParameter() {
        return linkParameter;
    }

    /**
     * Sets the value of the linkParameter property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setLinkParameter(Double value) {
        this.linkParameter = value;
    }

    /**
     * Gets the value of the trialsVariable property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getTrialsVariable() {
        return trialsVariable;
    }

    /**
     * Sets the value of the trialsVariable property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTrialsVariable(FieldName value) {
        this.trialsVariable = value;
    }

    /**
     * Gets the value of the trialsValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getTrialsValue() {
        return trialsValue;
    }

    /**
     * Sets the value of the trialsValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTrialsValue(Integer value) {
        this.trialsValue = value;
    }

    /**
     * Gets the value of the distribution property.
     * 
     * @return
     *     possible object is
     *     {@link GeneralRegressionModel.Distribution }
     *     
     */
    public GeneralRegressionModel.Distribution getDistribution() {
        return distribution;
    }

    /**
     * Sets the value of the distribution property.
     * 
     * @param value
     *     allowed object is
     *     {@link GeneralRegressionModel.Distribution }
     *     
     */
    public void setDistribution(GeneralRegressionModel.Distribution value) {
        this.distribution = value;
    }

    /**
     * Gets the value of the distParameter property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getDistParameter() {
        return distParameter;
    }

    /**
     * Sets the value of the distParameter property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setDistParameter(Double value) {
        this.distParameter = value;
    }

    /**
     * Gets the value of the offsetVariable property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getOffsetVariable() {
        return offsetVariable;
    }

    /**
     * Sets the value of the offsetVariable property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOffsetVariable(FieldName value) {
        this.offsetVariable = value;
    }

    /**
     * Gets the value of the offsetValue property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getOffsetValue() {
        return offsetValue;
    }

    /**
     * Sets the value of the offsetValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setOffsetValue(Double value) {
        this.offsetValue = value;
    }

    /**
     * Gets the value of the modelDF property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getModelDF() {
        return modelDF;
    }

    /**
     * Sets the value of the modelDF property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setModelDF(Double value) {
        this.modelDF = value;
    }

    /**
     * Gets the value of the endTimeVariable property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getEndTimeVariable() {
        return endTimeVariable;
    }

    /**
     * Sets the value of the endTimeVariable property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEndTimeVariable(FieldName value) {
        this.endTimeVariable = value;
    }

    /**
     * Gets the value of the startTimeVariable property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getStartTimeVariable() {
        return startTimeVariable;
    }

    /**
     * Sets the value of the startTimeVariable property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStartTimeVariable(FieldName value) {
        this.startTimeVariable = value;
    }

    /**
     * Gets the value of the subjectIDVariable property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getSubjectIDVariable() {
        return subjectIDVariable;
    }

    /**
     * Sets the value of the subjectIDVariable property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSubjectIDVariable(FieldName value) {
        this.subjectIDVariable = value;
    }

    /**
     * Gets the value of the statusVariable property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getStatusVariable() {
        return statusVariable;
    }

    /**
     * Sets the value of the statusVariable property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStatusVariable(FieldName value) {
        this.statusVariable = value;
    }

    /**
     * Gets the value of the baselineStrataVariable property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getBaselineStrataVariable() {
        return baselineStrataVariable;
    }

    /**
     * Sets the value of the baselineStrataVariable property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBaselineStrataVariable(FieldName value) {
        this.baselineStrataVariable = value;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return true;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setScorable(Boolean value) {
        this.scorable = value;
    }

    public GeneralRegressionModel withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public GeneralRegressionModel withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public GeneralRegressionModel withMiningSchema(MiningSchema value) {
        setMiningSchema(value);
        return this;
    }

    public GeneralRegressionModel withOutput(Output value) {
        setOutput(value);
        return this;
    }

    public GeneralRegressionModel withModelStats(ModelStats value) {
        setModelStats(value);
        return this;
    }

    public GeneralRegressionModel withModelExplanation(ModelExplanation value) {
        setModelExplanation(value);
        return this;
    }

    public GeneralRegressionModel withTargets(Targets value) {
        setTargets(value);
        return this;
    }

    public GeneralRegressionModel withLocalTransformations(LocalTransformations value) {
        setLocalTransformations(value);
        return this;
    }

    public GeneralRegressionModel withParameterList(ParameterList value) {
        setParameterList(value);
        return this;
    }

    public GeneralRegressionModel withFactorList(FactorList value) {
        setFactorList(value);
        return this;
    }

    public GeneralRegressionModel withCovariateList(CovariateList value) {
        setCovariateList(value);
        return this;
    }

    public GeneralRegressionModel withPPMatrix(PPMatrix value) {
        setPPMatrix(value);
        return this;
    }

    public GeneralRegressionModel withPCovMatrix(PCovMatrix value) {
        setPCovMatrix(value);
        return this;
    }

    public GeneralRegressionModel withParamMatrix(ParamMatrix value) {
        setParamMatrix(value);
        return this;
    }

    public GeneralRegressionModel withEventValues(EventValues value) {
        setEventValues(value);
        return this;
    }

    public GeneralRegressionModel withBaseCumHazardTables(BaseCumHazardTables value) {
        setBaseCumHazardTables(value);
        return this;
    }

    public GeneralRegressionModel withModelVerification(ModelVerification value) {
        setModelVerification(value);
        return this;
    }

    public GeneralRegressionModel withTargetVariableName(FieldName value) {
        setTargetVariableName(value);
        return this;
    }

    public GeneralRegressionModel withModelType(GeneralRegressionModel.ModelType value) {
        setModelType(value);
        return this;
    }

    public GeneralRegressionModel withModelName(String value) {
        setModelName(value);
        return this;
    }

    public GeneralRegressionModel withFunctionName(MiningFunctionType value) {
        setFunctionName(value);
        return this;
    }

    public GeneralRegressionModel withAlgorithmName(String value) {
        setAlgorithmName(value);
        return this;
    }

    public GeneralRegressionModel withTargetReferenceCategory(String value) {
        setTargetReferenceCategory(value);
        return this;
    }

    public GeneralRegressionModel withCumulativeLink(CumulativeLinkFunctionType value) {
        setCumulativeLink(value);
        return this;
    }

    public GeneralRegressionModel withLinkFunction(LinkFunctionType value) {
        setLinkFunction(value);
        return this;
    }

    public GeneralRegressionModel withLinkParameter(Double value) {
        setLinkParameter(value);
        return this;
    }

    public GeneralRegressionModel withTrialsVariable(FieldName value) {
        setTrialsVariable(value);
        return this;
    }

    public GeneralRegressionModel withTrialsValue(Integer value) {
        setTrialsValue(value);
        return this;
    }

    public GeneralRegressionModel withDistribution(GeneralRegressionModel.Distribution value) {
        setDistribution(value);
        return this;
    }

    public GeneralRegressionModel withDistParameter(Double value) {
        setDistParameter(value);
        return this;
    }

    public GeneralRegressionModel withOffsetVariable(FieldName value) {
        setOffsetVariable(value);
        return this;
    }

    public GeneralRegressionModel withOffsetValue(Double value) {
        setOffsetValue(value);
        return this;
    }

    public GeneralRegressionModel withModelDF(Double value) {
        setModelDF(value);
        return this;
    }

    public GeneralRegressionModel withEndTimeVariable(FieldName value) {
        setEndTimeVariable(value);
        return this;
    }

    public GeneralRegressionModel withStartTimeVariable(FieldName value) {
        setStartTimeVariable(value);
        return this;
    }

    public GeneralRegressionModel withSubjectIDVariable(FieldName value) {
        setSubjectIDVariable(value);
        return this;
    }

    public GeneralRegressionModel withStatusVariable(FieldName value) {
        setStatusVariable(value);
        return this;
    }

    public GeneralRegressionModel withBaselineStrataVariable(FieldName value) {
        setBaselineStrataVariable(value);
        return this;
    }

    public GeneralRegressionModel withScorable(Boolean value) {
        setScorable(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.miningSchema!= null)) {
            status = this.miningSchema.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.output!= null)) {
            status = this.output.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelStats!= null)) {
            status = this.modelStats.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelExplanation!= null)) {
            status = this.modelExplanation.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.targets!= null)) {
            status = this.targets.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.localTransformations!= null)) {
            status = this.localTransformations.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.parameterList!= null)) {
            status = this.parameterList.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.factorList!= null)) {
            status = this.factorList.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.covariateList!= null)) {
            status = this.covariateList.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.ppMatrix!= null)) {
            status = this.ppMatrix.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.pCovMatrix!= null)) {
            status = this.pCovMatrix.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.paramMatrix!= null)) {
            status = this.paramMatrix.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.eventValues!= null)) {
            status = this.eventValues.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.baseCumHazardTables!= null)) {
            status = this.baseCumHazardTables.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelVerification!= null)) {
            status = this.modelVerification.accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="binomial"/>
     *     &lt;enumeration value="gamma"/>
     *     &lt;enumeration value="igauss"/>
     *     &lt;enumeration value="negbin"/>
     *     &lt;enumeration value="normal"/>
     *     &lt;enumeration value="poisson"/>
     *     &lt;enumeration value="tweedie"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum Distribution {

        @XmlEnumValue("binomial")
        BINOMIAL("binomial"),
        @XmlEnumValue("gamma")
        GAMMA("gamma"),
        @XmlEnumValue("igauss")
        IGAUSS("igauss"),
        @XmlEnumValue("negbin")
        NEGBIN("negbin"),
        @XmlEnumValue("normal")
        NORMAL("normal"),
        @XmlEnumValue("poisson")
        POISSON("poisson"),
        @XmlEnumValue("tweedie")
        TWEEDIE("tweedie");
        private final String value;

        Distribution(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static GeneralRegressionModel.Distribution fromValue(String v) {
            for (GeneralRegressionModel.Distribution c: GeneralRegressionModel.Distribution.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="regression"/>
     *     &lt;enumeration value="generalLinear"/>
     *     &lt;enumeration value="multinomialLogistic"/>
     *     &lt;enumeration value="ordinalMultinomial"/>
     *     &lt;enumeration value="generalizedLinear"/>
     *     &lt;enumeration value="CoxRegression"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum ModelType {

        @XmlEnumValue("regression")
        REGRESSION("regression"),
        @XmlEnumValue("generalLinear")
        GENERAL_LINEAR("generalLinear"),
        @XmlEnumValue("multinomialLogistic")
        MULTINOMIAL_LOGISTIC("multinomialLogistic"),
        @XmlEnumValue("ordinalMultinomial")
        ORDINAL_MULTINOMIAL("ordinalMultinomial"),
        @XmlEnumValue("generalizedLinear")
        GENERALIZED_LINEAR("generalizedLinear"),
        @XmlEnumValue("CoxRegression")
        COX_REGRESSION("CoxRegression");
        private final String value;

        ModelType(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static GeneralRegressionModel.ModelType fromValue(String v) {
            for (GeneralRegressionModel.ModelType c: GeneralRegressionModel.ModelType.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
