
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;group ref="{http://www.dmg.org/PMML-4_1}PREDICATE"/>
 *         &lt;group ref="{http://www.dmg.org/PMML-4_1}MODEL-ELEMENT"/>
 *       &lt;/sequence>
 *       &lt;attribute name="id" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="weight" type="{http://www.dmg.org/PMML-4_1}NUMBER" default="1" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "predicate",
    "model"
})
@XmlRootElement(name = "Segment")
@Schema(min = Version.PMML_4_0)
public class Segment
    extends PMMLObject
    implements Locatable, HasExtensions, HasId
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "SimplePredicate", type = SimplePredicate.class),
        @XmlElement(name = "CompoundPredicate", type = CompoundPredicate.class),
        @XmlElement(name = "SimpleSetPredicate", type = SimpleSetPredicate.class),
        @XmlElement(name = "True", type = True.class),
        @XmlElement(name = "False", type = False.class)
    })
    protected Predicate predicate;
    @XmlElements({
        @XmlElement(name = "AssociationModel", type = AssociationModel.class),
        @XmlElement(name = "BaselineModel", type = BaselineModel.class),
        @XmlElement(name = "ClusteringModel", type = ClusteringModel.class),
        @XmlElement(name = "GeneralRegressionModel", type = GeneralRegressionModel.class),
        @XmlElement(name = "MiningModel", type = MiningModel.class),
        @XmlElement(name = "NaiveBayesModel", type = NaiveBayesModel.class),
        @XmlElement(name = "NearestNeighborModel", type = NearestNeighborModel.class),
        @XmlElement(name = "NeuralNetwork", type = NeuralNetwork.class),
        @XmlElement(name = "RegressionModel", type = RegressionModel.class),
        @XmlElement(name = "RuleSetModel", type = RuleSetModel.class),
        @XmlElement(name = "SequenceModel", type = SequenceModel.class),
        @XmlElement(name = "Scorecard", type = Scorecard.class),
        @XmlElement(name = "SupportVectorMachineModel", type = SupportVectorMachineModel.class),
        @XmlElement(name = "TextModel", type = TextModel.class),
        @XmlElement(name = "TimeSeriesModel", type = TimeSeriesModel.class),
        @XmlElement(name = "TreeModel", type = TreeModel.class)
    })
    protected Model model;
    @XmlAttribute(name = "id")
    protected String id;
    @XmlAttribute(name = "weight")
    protected Double weight;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the predicate property.
     * 
     * @return
     *     possible object is
     *     {@link SimplePredicate }
     *     {@link CompoundPredicate }
     *     {@link SimpleSetPredicate }
     *     {@link True }
     *     {@link False }
     *     
     */
    public Predicate getPredicate() {
        return predicate;
    }

    /**
     * Sets the value of the predicate property.
     * 
     * @param value
     *     allowed object is
     *     {@link SimplePredicate }
     *     {@link CompoundPredicate }
     *     {@link SimpleSetPredicate }
     *     {@link True }
     *     {@link False }
     *     
     */
    public void setPredicate(Predicate value) {
        this.predicate = value;
    }

    /**
     * Gets the value of the model property.
     * 
     * @return
     *     possible object is
     *     {@link AssociationModel }
     *     {@link BaselineModel }
     *     {@link ClusteringModel }
     *     {@link GeneralRegressionModel }
     *     {@link MiningModel }
     *     {@link NaiveBayesModel }
     *     {@link NearestNeighborModel }
     *     {@link NeuralNetwork }
     *     {@link RegressionModel }
     *     {@link RuleSetModel }
     *     {@link SequenceModel }
     *     {@link Scorecard }
     *     {@link SupportVectorMachineModel }
     *     {@link TextModel }
     *     {@link TimeSeriesModel }
     *     {@link TreeModel }
     *     
     */
    public Model getModel() {
        return model;
    }

    /**
     * Sets the value of the model property.
     * 
     * @param value
     *     allowed object is
     *     {@link AssociationModel }
     *     {@link BaselineModel }
     *     {@link ClusteringModel }
     *     {@link GeneralRegressionModel }
     *     {@link MiningModel }
     *     {@link NaiveBayesModel }
     *     {@link NearestNeighborModel }
     *     {@link NeuralNetwork }
     *     {@link RegressionModel }
     *     {@link RuleSetModel }
     *     {@link SequenceModel }
     *     {@link Scorecard }
     *     {@link SupportVectorMachineModel }
     *     {@link TextModel }
     *     {@link TimeSeriesModel }
     *     {@link TreeModel }
     *     
     */
    public void setModel(Model value) {
        this.model = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(String value) {
        this.id = value;
    }

    /**
     * Gets the value of the weight property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getWeight() {
        if (weight == null) {
            return  1.0D;
        } else {
            return weight;
        }
    }

    /**
     * Sets the value of the weight property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setWeight(Double value) {
        this.weight = value;
    }

    public Segment withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public Segment withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public Segment withPredicate(Predicate value) {
        setPredicate(value);
        return this;
    }

    public Segment withModel(Model value) {
        setModel(value);
        return this;
    }

    public Segment withId(String value) {
        setId(value);
        return this;
    }

    public Segment withWeight(Double value) {
        setWeight(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.predicate!= null)) {
            status = this.predicate.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.model!= null)) {
            status = this.model.accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
