
package org.dmg.pmml;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}NeuralInputs"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}NeuralLayer" maxOccurs="unbounded"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}NeuralOutputs" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_1}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="activationFunction" use="required" type="{http://www.dmg.org/PMML-4_1}ACTIVATION-FUNCTION" />
 *       &lt;attribute name="normalizationMethod" type="{http://www.dmg.org/PMML-4_1}NN-NORMALIZATION-METHOD" default="none" />
 *       &lt;attribute name="threshold" type="{http://www.dmg.org/PMML-4_1}REAL-NUMBER" default="0" />
 *       &lt;attribute name="width" type="{http://www.dmg.org/PMML-4_1}REAL-NUMBER" />
 *       &lt;attribute name="altitude" type="{http://www.dmg.org/PMML-4_1}REAL-NUMBER" default="1.0" />
 *       &lt;attribute name="numberOfLayers" type="{http://www.w3.org/2001/XMLSchema}nonNegativeInteger" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "neuralInputs",
    "neuralLayers",
    "neuralOutputs",
    "modelVerification"
})
@XmlRootElement(name = "NeuralNetwork")
public class NeuralNetwork
    extends Model
    implements Equals, HashCode, ToString
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "MiningSchema", required = true)
    protected MiningSchema miningSchema;
    @XmlElement(name = "Output")
    protected Output output;
    @XmlElement(name = "ModelStats")
    protected ModelStats modelStats;
    @XmlElement(name = "ModelExplanation")
    protected ModelExplanation modelExplanation;
    @XmlElement(name = "Targets")
    protected Targets targets;
    @XmlElement(name = "LocalTransformations")
    protected LocalTransformations localTransformations;
    @XmlElement(name = "NeuralInputs", required = true)
    protected NeuralInputs neuralInputs;
    @XmlElement(name = "NeuralLayer", required = true)
    protected List<NeuralLayer> neuralLayers;
    @XmlElement(name = "NeuralOutputs")
    protected NeuralOutputs neuralOutputs;
    @XmlElement(name = "ModelVerification")
    protected ModelVerification modelVerification;
    @XmlAttribute(name = "modelName")
    protected String modelName;
    @XmlAttribute(name = "functionName", required = true)
    protected MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    protected String algorithmName;
    @XmlAttribute(name = "activationFunction", required = true)
    protected ActivationFunctionType activationFunction;
    @XmlAttribute(name = "normalizationMethod")
    protected NnNormalizationMethodType normalizationMethod;
    @XmlAttribute(name = "threshold")
    protected Double threshold;
    @XmlAttribute(name = "width")
    protected Double width;
    @XmlAttribute(name = "altitude")
    protected Double altitude;
    @XmlAttribute(name = "numberOfLayers")
    @XmlSchemaType(name = "nonNegativeInteger")
    protected BigInteger numberOfLayers;
    @XmlAttribute(name = "isScorable")
    protected Boolean scorable;

    @Deprecated
    public NeuralNetwork() {
        super();
    }

    public NeuralNetwork(final MiningSchema miningSchema, final NeuralInputs neuralInputs, final MiningFunctionType functionName, final ActivationFunctionType activationFunction) {
        super();
        this.miningSchema = miningSchema;
        this.neuralInputs = neuralInputs;
        this.functionName = functionName;
        this.activationFunction = activationFunction;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public void setMiningSchema(MiningSchema value) {
        this.miningSchema = value;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param value
     *     allowed object is
     *     {@link Output }
     *     
     */
    public void setOutput(Output value) {
        this.output = value;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public void setModelStats(ModelStats value) {
        this.modelStats = value;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public void setModelExplanation(ModelExplanation value) {
        this.modelExplanation = value;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param value
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public void setTargets(Targets value) {
        this.targets = value;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public void setLocalTransformations(LocalTransformations value) {
        this.localTransformations = value;
    }

    /**
     * Gets the value of the neuralInputs property.
     * 
     * @return
     *     possible object is
     *     {@link NeuralInputs }
     *     
     */
    public NeuralInputs getNeuralInputs() {
        return neuralInputs;
    }

    /**
     * Sets the value of the neuralInputs property.
     * 
     * @param value
     *     allowed object is
     *     {@link NeuralInputs }
     *     
     */
    public void setNeuralInputs(NeuralInputs value) {
        this.neuralInputs = value;
    }

    /**
     * Gets the value of the neuralLayers property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the neuralLayers property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNeuralLayers().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NeuralLayer }
     * 
     * 
     */
    public List<NeuralLayer> getNeuralLayers() {
        if (neuralLayers == null) {
            neuralLayers = new ArrayList<NeuralLayer>();
        }
        return this.neuralLayers;
    }

    /**
     * Gets the value of the neuralOutputs property.
     * 
     * @return
     *     possible object is
     *     {@link NeuralOutputs }
     *     
     */
    public NeuralOutputs getNeuralOutputs() {
        return neuralOutputs;
    }

    /**
     * Sets the value of the neuralOutputs property.
     * 
     * @param value
     *     allowed object is
     *     {@link NeuralOutputs }
     *     
     */
    public void setNeuralOutputs(NeuralOutputs value) {
        this.neuralOutputs = value;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public void setModelVerification(ModelVerification value) {
        this.modelVerification = value;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setModelName(String value) {
        this.modelName = value;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public void setFunctionName(MiningFunctionType value) {
        this.functionName = value;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlgorithmName(String value) {
        this.algorithmName = value;
    }

    /**
     * Gets the value of the activationFunction property.
     * 
     * @return
     *     possible object is
     *     {@link ActivationFunctionType }
     *     
     */
    public ActivationFunctionType getActivationFunction() {
        return activationFunction;
    }

    /**
     * Sets the value of the activationFunction property.
     * 
     * @param value
     *     allowed object is
     *     {@link ActivationFunctionType }
     *     
     */
    public void setActivationFunction(ActivationFunctionType value) {
        this.activationFunction = value;
    }

    /**
     * Gets the value of the normalizationMethod property.
     * 
     * @return
     *     possible object is
     *     {@link NnNormalizationMethodType }
     *     
     */
    public NnNormalizationMethodType getNormalizationMethod() {
        if (normalizationMethod == null) {
            return NnNormalizationMethodType.NONE;
        } else {
            return normalizationMethod;
        }
    }

    /**
     * Sets the value of the normalizationMethod property.
     * 
     * @param value
     *     allowed object is
     *     {@link NnNormalizationMethodType }
     *     
     */
    public void setNormalizationMethod(NnNormalizationMethodType value) {
        this.normalizationMethod = value;
    }

    /**
     * Gets the value of the threshold property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getThreshold() {
        if (threshold == null) {
            return  0.0D;
        } else {
            return threshold;
        }
    }

    /**
     * Sets the value of the threshold property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setThreshold(Double value) {
        this.threshold = value;
    }

    /**
     * Gets the value of the width property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getWidth() {
        return width;
    }

    /**
     * Sets the value of the width property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setWidth(Double value) {
        this.width = value;
    }

    /**
     * Gets the value of the altitude property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getAltitude() {
        if (altitude == null) {
            return  1.0D;
        } else {
            return altitude;
        }
    }

    /**
     * Sets the value of the altitude property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setAltitude(Double value) {
        this.altitude = value;
    }

    /**
     * Gets the value of the numberOfLayers property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getNumberOfLayers() {
        return numberOfLayers;
    }

    /**
     * Sets the value of the numberOfLayers property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setNumberOfLayers(BigInteger value) {
        this.numberOfLayers = value;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return true;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setScorable(Boolean value) {
        this.scorable = value;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if (!(object instanceof NeuralNetwork)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        final NeuralNetwork that = ((NeuralNetwork) object);
        {
            List<Extension> lhsExtensions;
            lhsExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            List<Extension> rhsExtensions;
            rhsExtensions = (((that.extensions!= null)&&(!that.extensions.isEmpty()))?that.getExtensions():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "extensions", lhsExtensions), LocatorUtils.property(thatLocator, "extensions", rhsExtensions), lhsExtensions, rhsExtensions)) {
                return false;
            }
        }
        {
            MiningSchema lhsMiningSchema;
            lhsMiningSchema = this.getMiningSchema();
            MiningSchema rhsMiningSchema;
            rhsMiningSchema = that.getMiningSchema();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "miningSchema", lhsMiningSchema), LocatorUtils.property(thatLocator, "miningSchema", rhsMiningSchema), lhsMiningSchema, rhsMiningSchema)) {
                return false;
            }
        }
        {
            Output lhsOutput;
            lhsOutput = this.getOutput();
            Output rhsOutput;
            rhsOutput = that.getOutput();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "output", lhsOutput), LocatorUtils.property(thatLocator, "output", rhsOutput), lhsOutput, rhsOutput)) {
                return false;
            }
        }
        {
            ModelStats lhsModelStats;
            lhsModelStats = this.getModelStats();
            ModelStats rhsModelStats;
            rhsModelStats = that.getModelStats();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelStats", lhsModelStats), LocatorUtils.property(thatLocator, "modelStats", rhsModelStats), lhsModelStats, rhsModelStats)) {
                return false;
            }
        }
        {
            ModelExplanation lhsModelExplanation;
            lhsModelExplanation = this.getModelExplanation();
            ModelExplanation rhsModelExplanation;
            rhsModelExplanation = that.getModelExplanation();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelExplanation", lhsModelExplanation), LocatorUtils.property(thatLocator, "modelExplanation", rhsModelExplanation), lhsModelExplanation, rhsModelExplanation)) {
                return false;
            }
        }
        {
            Targets lhsTargets;
            lhsTargets = this.getTargets();
            Targets rhsTargets;
            rhsTargets = that.getTargets();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "targets", lhsTargets), LocatorUtils.property(thatLocator, "targets", rhsTargets), lhsTargets, rhsTargets)) {
                return false;
            }
        }
        {
            LocalTransformations lhsLocalTransformations;
            lhsLocalTransformations = this.getLocalTransformations();
            LocalTransformations rhsLocalTransformations;
            rhsLocalTransformations = that.getLocalTransformations();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "localTransformations", lhsLocalTransformations), LocatorUtils.property(thatLocator, "localTransformations", rhsLocalTransformations), lhsLocalTransformations, rhsLocalTransformations)) {
                return false;
            }
        }
        {
            NeuralInputs lhsNeuralInputs;
            lhsNeuralInputs = this.getNeuralInputs();
            NeuralInputs rhsNeuralInputs;
            rhsNeuralInputs = that.getNeuralInputs();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "neuralInputs", lhsNeuralInputs), LocatorUtils.property(thatLocator, "neuralInputs", rhsNeuralInputs), lhsNeuralInputs, rhsNeuralInputs)) {
                return false;
            }
        }
        {
            List<NeuralLayer> lhsNeuralLayers;
            lhsNeuralLayers = (((this.neuralLayers!= null)&&(!this.neuralLayers.isEmpty()))?this.getNeuralLayers():null);
            List<NeuralLayer> rhsNeuralLayers;
            rhsNeuralLayers = (((that.neuralLayers!= null)&&(!that.neuralLayers.isEmpty()))?that.getNeuralLayers():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "neuralLayers", lhsNeuralLayers), LocatorUtils.property(thatLocator, "neuralLayers", rhsNeuralLayers), lhsNeuralLayers, rhsNeuralLayers)) {
                return false;
            }
        }
        {
            NeuralOutputs lhsNeuralOutputs;
            lhsNeuralOutputs = this.getNeuralOutputs();
            NeuralOutputs rhsNeuralOutputs;
            rhsNeuralOutputs = that.getNeuralOutputs();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "neuralOutputs", lhsNeuralOutputs), LocatorUtils.property(thatLocator, "neuralOutputs", rhsNeuralOutputs), lhsNeuralOutputs, rhsNeuralOutputs)) {
                return false;
            }
        }
        {
            ModelVerification lhsModelVerification;
            lhsModelVerification = this.getModelVerification();
            ModelVerification rhsModelVerification;
            rhsModelVerification = that.getModelVerification();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelVerification", lhsModelVerification), LocatorUtils.property(thatLocator, "modelVerification", rhsModelVerification), lhsModelVerification, rhsModelVerification)) {
                return false;
            }
        }
        {
            String lhsModelName;
            lhsModelName = this.getModelName();
            String rhsModelName;
            rhsModelName = that.getModelName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelName", lhsModelName), LocatorUtils.property(thatLocator, "modelName", rhsModelName), lhsModelName, rhsModelName)) {
                return false;
            }
        }
        {
            MiningFunctionType lhsFunctionName;
            lhsFunctionName = this.getFunctionName();
            MiningFunctionType rhsFunctionName;
            rhsFunctionName = that.getFunctionName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "functionName", lhsFunctionName), LocatorUtils.property(thatLocator, "functionName", rhsFunctionName), lhsFunctionName, rhsFunctionName)) {
                return false;
            }
        }
        {
            String lhsAlgorithmName;
            lhsAlgorithmName = this.getAlgorithmName();
            String rhsAlgorithmName;
            rhsAlgorithmName = that.getAlgorithmName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "algorithmName", lhsAlgorithmName), LocatorUtils.property(thatLocator, "algorithmName", rhsAlgorithmName), lhsAlgorithmName, rhsAlgorithmName)) {
                return false;
            }
        }
        {
            ActivationFunctionType lhsActivationFunction;
            lhsActivationFunction = this.getActivationFunction();
            ActivationFunctionType rhsActivationFunction;
            rhsActivationFunction = that.getActivationFunction();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "activationFunction", lhsActivationFunction), LocatorUtils.property(thatLocator, "activationFunction", rhsActivationFunction), lhsActivationFunction, rhsActivationFunction)) {
                return false;
            }
        }
        {
            NnNormalizationMethodType lhsNormalizationMethod;
            lhsNormalizationMethod = this.getNormalizationMethod();
            NnNormalizationMethodType rhsNormalizationMethod;
            rhsNormalizationMethod = that.getNormalizationMethod();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "normalizationMethod", lhsNormalizationMethod), LocatorUtils.property(thatLocator, "normalizationMethod", rhsNormalizationMethod), lhsNormalizationMethod, rhsNormalizationMethod)) {
                return false;
            }
        }
        {
            double lhsThreshold;
            lhsThreshold = ((this.threshold!= null)?this.getThreshold(): 0.0D);
            double rhsThreshold;
            rhsThreshold = ((that.threshold!= null)?that.getThreshold(): 0.0D);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "threshold", lhsThreshold), LocatorUtils.property(thatLocator, "threshold", rhsThreshold), lhsThreshold, rhsThreshold)) {
                return false;
            }
        }
        {
            Double lhsWidth;
            lhsWidth = this.getWidth();
            Double rhsWidth;
            rhsWidth = that.getWidth();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "width", lhsWidth), LocatorUtils.property(thatLocator, "width", rhsWidth), lhsWidth, rhsWidth)) {
                return false;
            }
        }
        {
            double lhsAltitude;
            lhsAltitude = ((this.altitude!= null)?this.getAltitude(): 0.0D);
            double rhsAltitude;
            rhsAltitude = ((that.altitude!= null)?that.getAltitude(): 0.0D);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "altitude", lhsAltitude), LocatorUtils.property(thatLocator, "altitude", rhsAltitude), lhsAltitude, rhsAltitude)) {
                return false;
            }
        }
        {
            BigInteger lhsNumberOfLayers;
            lhsNumberOfLayers = this.getNumberOfLayers();
            BigInteger rhsNumberOfLayers;
            rhsNumberOfLayers = that.getNumberOfLayers();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "numberOfLayers", lhsNumberOfLayers), LocatorUtils.property(thatLocator, "numberOfLayers", rhsNumberOfLayers), lhsNumberOfLayers, rhsNumberOfLayers)) {
                return false;
            }
        }
        {
            boolean lhsScorable;
            lhsScorable = ((this.scorable!= null)?this.isScorable():false);
            boolean rhsScorable;
            rhsScorable = ((that.scorable!= null)?that.isScorable():false);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "scorable", lhsScorable), LocatorUtils.property(thatLocator, "scorable", rhsScorable), lhsScorable, rhsScorable)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        {
            List<Extension> theExtensions;
            theExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "extensions", theExtensions), currentHashCode, theExtensions);
        }
        {
            MiningSchema theMiningSchema;
            theMiningSchema = this.getMiningSchema();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "miningSchema", theMiningSchema), currentHashCode, theMiningSchema);
        }
        {
            Output theOutput;
            theOutput = this.getOutput();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "output", theOutput), currentHashCode, theOutput);
        }
        {
            ModelStats theModelStats;
            theModelStats = this.getModelStats();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelStats", theModelStats), currentHashCode, theModelStats);
        }
        {
            ModelExplanation theModelExplanation;
            theModelExplanation = this.getModelExplanation();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelExplanation", theModelExplanation), currentHashCode, theModelExplanation);
        }
        {
            Targets theTargets;
            theTargets = this.getTargets();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "targets", theTargets), currentHashCode, theTargets);
        }
        {
            LocalTransformations theLocalTransformations;
            theLocalTransformations = this.getLocalTransformations();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "localTransformations", theLocalTransformations), currentHashCode, theLocalTransformations);
        }
        {
            NeuralInputs theNeuralInputs;
            theNeuralInputs = this.getNeuralInputs();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "neuralInputs", theNeuralInputs), currentHashCode, theNeuralInputs);
        }
        {
            List<NeuralLayer> theNeuralLayers;
            theNeuralLayers = (((this.neuralLayers!= null)&&(!this.neuralLayers.isEmpty()))?this.getNeuralLayers():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "neuralLayers", theNeuralLayers), currentHashCode, theNeuralLayers);
        }
        {
            NeuralOutputs theNeuralOutputs;
            theNeuralOutputs = this.getNeuralOutputs();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "neuralOutputs", theNeuralOutputs), currentHashCode, theNeuralOutputs);
        }
        {
            ModelVerification theModelVerification;
            theModelVerification = this.getModelVerification();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelVerification", theModelVerification), currentHashCode, theModelVerification);
        }
        {
            String theModelName;
            theModelName = this.getModelName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelName", theModelName), currentHashCode, theModelName);
        }
        {
            MiningFunctionType theFunctionName;
            theFunctionName = this.getFunctionName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "functionName", theFunctionName), currentHashCode, theFunctionName);
        }
        {
            String theAlgorithmName;
            theAlgorithmName = this.getAlgorithmName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "algorithmName", theAlgorithmName), currentHashCode, theAlgorithmName);
        }
        {
            ActivationFunctionType theActivationFunction;
            theActivationFunction = this.getActivationFunction();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "activationFunction", theActivationFunction), currentHashCode, theActivationFunction);
        }
        {
            NnNormalizationMethodType theNormalizationMethod;
            theNormalizationMethod = this.getNormalizationMethod();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "normalizationMethod", theNormalizationMethod), currentHashCode, theNormalizationMethod);
        }
        {
            double theThreshold;
            theThreshold = ((this.threshold!= null)?this.getThreshold(): 0.0D);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "threshold", theThreshold), currentHashCode, theThreshold);
        }
        {
            Double theWidth;
            theWidth = this.getWidth();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "width", theWidth), currentHashCode, theWidth);
        }
        {
            double theAltitude;
            theAltitude = ((this.altitude!= null)?this.getAltitude(): 0.0D);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "altitude", theAltitude), currentHashCode, theAltitude);
        }
        {
            BigInteger theNumberOfLayers;
            theNumberOfLayers = this.getNumberOfLayers();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "numberOfLayers", theNumberOfLayers), currentHashCode, theNumberOfLayers);
        }
        {
            boolean theScorable;
            theScorable = ((this.scorable!= null)?this.isScorable():false);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "scorable", theScorable), currentHashCode, theScorable);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<Extension> theExtensions;
            theExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            strategy.appendField(locator, this, "extensions", buffer, theExtensions);
        }
        {
            MiningSchema theMiningSchema;
            theMiningSchema = this.getMiningSchema();
            strategy.appendField(locator, this, "miningSchema", buffer, theMiningSchema);
        }
        {
            Output theOutput;
            theOutput = this.getOutput();
            strategy.appendField(locator, this, "output", buffer, theOutput);
        }
        {
            ModelStats theModelStats;
            theModelStats = this.getModelStats();
            strategy.appendField(locator, this, "modelStats", buffer, theModelStats);
        }
        {
            ModelExplanation theModelExplanation;
            theModelExplanation = this.getModelExplanation();
            strategy.appendField(locator, this, "modelExplanation", buffer, theModelExplanation);
        }
        {
            Targets theTargets;
            theTargets = this.getTargets();
            strategy.appendField(locator, this, "targets", buffer, theTargets);
        }
        {
            LocalTransformations theLocalTransformations;
            theLocalTransformations = this.getLocalTransformations();
            strategy.appendField(locator, this, "localTransformations", buffer, theLocalTransformations);
        }
        {
            NeuralInputs theNeuralInputs;
            theNeuralInputs = this.getNeuralInputs();
            strategy.appendField(locator, this, "neuralInputs", buffer, theNeuralInputs);
        }
        {
            List<NeuralLayer> theNeuralLayers;
            theNeuralLayers = (((this.neuralLayers!= null)&&(!this.neuralLayers.isEmpty()))?this.getNeuralLayers():null);
            strategy.appendField(locator, this, "neuralLayers", buffer, theNeuralLayers);
        }
        {
            NeuralOutputs theNeuralOutputs;
            theNeuralOutputs = this.getNeuralOutputs();
            strategy.appendField(locator, this, "neuralOutputs", buffer, theNeuralOutputs);
        }
        {
            ModelVerification theModelVerification;
            theModelVerification = this.getModelVerification();
            strategy.appendField(locator, this, "modelVerification", buffer, theModelVerification);
        }
        {
            String theModelName;
            theModelName = this.getModelName();
            strategy.appendField(locator, this, "modelName", buffer, theModelName);
        }
        {
            MiningFunctionType theFunctionName;
            theFunctionName = this.getFunctionName();
            strategy.appendField(locator, this, "functionName", buffer, theFunctionName);
        }
        {
            String theAlgorithmName;
            theAlgorithmName = this.getAlgorithmName();
            strategy.appendField(locator, this, "algorithmName", buffer, theAlgorithmName);
        }
        {
            ActivationFunctionType theActivationFunction;
            theActivationFunction = this.getActivationFunction();
            strategy.appendField(locator, this, "activationFunction", buffer, theActivationFunction);
        }
        {
            NnNormalizationMethodType theNormalizationMethod;
            theNormalizationMethod = this.getNormalizationMethod();
            strategy.appendField(locator, this, "normalizationMethod", buffer, theNormalizationMethod);
        }
        {
            double theThreshold;
            theThreshold = ((this.threshold!= null)?this.getThreshold(): 0.0D);
            strategy.appendField(locator, this, "threshold", buffer, theThreshold);
        }
        {
            Double theWidth;
            theWidth = this.getWidth();
            strategy.appendField(locator, this, "width", buffer, theWidth);
        }
        {
            double theAltitude;
            theAltitude = ((this.altitude!= null)?this.getAltitude(): 0.0D);
            strategy.appendField(locator, this, "altitude", buffer, theAltitude);
        }
        {
            BigInteger theNumberOfLayers;
            theNumberOfLayers = this.getNumberOfLayers();
            strategy.appendField(locator, this, "numberOfLayers", buffer, theNumberOfLayers);
        }
        {
            boolean theScorable;
            theScorable = ((this.scorable!= null)?this.isScorable():false);
            strategy.appendField(locator, this, "scorable", buffer, theScorable);
        }
        return buffer;
    }

}
