
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ResultField" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}RegressionTable" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_1}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="normalizationMethod" type="{http://www.dmg.org/PMML-4_1}REGRESSIONNORMALIZATIONMETHOD" default="none" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "output",
    "modelStats",
    "targets",
    "localTransformations",
    "resultFields",
    "regressionTables"
})
@XmlRootElement(name = "Regression")
public class Regression
    extends PMMLObject
    implements Equals, HashCode, ToString
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "Output")
    protected Output output;
    @XmlElement(name = "ModelStats")
    protected ModelStats modelStats;
    @XmlElement(name = "Targets")
    protected Targets targets;
    @XmlElement(name = "LocalTransformations")
    protected LocalTransformations localTransformations;
    @XmlElement(name = "ResultField")
    protected List<ResultField> resultFields;
    @XmlElement(name = "RegressionTable", required = true)
    protected List<RegressionTable> regressionTables;
    @XmlAttribute(name = "modelName")
    protected String modelName;
    @XmlAttribute(name = "functionName", required = true)
    protected MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    protected String algorithmName;
    @XmlAttribute(name = "normalizationMethod")
    protected RegressionNormalizationMethodType normalizationMethod;

    @Deprecated
    public Regression() {
        super();
    }

    public Regression(final MiningFunctionType functionName) {
        super();
        this.functionName = functionName;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param value
     *     allowed object is
     *     {@link Output }
     *     
     */
    public void setOutput(Output value) {
        this.output = value;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public void setModelStats(ModelStats value) {
        this.modelStats = value;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param value
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public void setTargets(Targets value) {
        this.targets = value;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public void setLocalTransformations(LocalTransformations value) {
        this.localTransformations = value;
    }

    /**
     * Gets the value of the resultFields property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the resultFields property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getResultFields().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ResultField }
     * 
     * 
     */
    public List<ResultField> getResultFields() {
        if (resultFields == null) {
            resultFields = new ArrayList<ResultField>();
        }
        return this.resultFields;
    }

    /**
     * Gets the value of the regressionTables property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the regressionTables property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRegressionTables().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RegressionTable }
     * 
     * 
     */
    public List<RegressionTable> getRegressionTables() {
        if (regressionTables == null) {
            regressionTables = new ArrayList<RegressionTable>();
        }
        return this.regressionTables;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setModelName(String value) {
        this.modelName = value;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public void setFunctionName(MiningFunctionType value) {
        this.functionName = value;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlgorithmName(String value) {
        this.algorithmName = value;
    }

    /**
     * Gets the value of the normalizationMethod property.
     * 
     * @return
     *     possible object is
     *     {@link RegressionNormalizationMethodType }
     *     
     */
    public RegressionNormalizationMethodType getNormalizationMethod() {
        if (normalizationMethod == null) {
            return RegressionNormalizationMethodType.NONE;
        } else {
            return normalizationMethod;
        }
    }

    /**
     * Sets the value of the normalizationMethod property.
     * 
     * @param value
     *     allowed object is
     *     {@link RegressionNormalizationMethodType }
     *     
     */
    public void setNormalizationMethod(RegressionNormalizationMethodType value) {
        this.normalizationMethod = value;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if (!(object instanceof Regression)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        final Regression that = ((Regression) object);
        {
            List<Extension> lhsExtensions;
            lhsExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            List<Extension> rhsExtensions;
            rhsExtensions = (((that.extensions!= null)&&(!that.extensions.isEmpty()))?that.getExtensions():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "extensions", lhsExtensions), LocatorUtils.property(thatLocator, "extensions", rhsExtensions), lhsExtensions, rhsExtensions)) {
                return false;
            }
        }
        {
            Output lhsOutput;
            lhsOutput = this.getOutput();
            Output rhsOutput;
            rhsOutput = that.getOutput();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "output", lhsOutput), LocatorUtils.property(thatLocator, "output", rhsOutput), lhsOutput, rhsOutput)) {
                return false;
            }
        }
        {
            ModelStats lhsModelStats;
            lhsModelStats = this.getModelStats();
            ModelStats rhsModelStats;
            rhsModelStats = that.getModelStats();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelStats", lhsModelStats), LocatorUtils.property(thatLocator, "modelStats", rhsModelStats), lhsModelStats, rhsModelStats)) {
                return false;
            }
        }
        {
            Targets lhsTargets;
            lhsTargets = this.getTargets();
            Targets rhsTargets;
            rhsTargets = that.getTargets();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "targets", lhsTargets), LocatorUtils.property(thatLocator, "targets", rhsTargets), lhsTargets, rhsTargets)) {
                return false;
            }
        }
        {
            LocalTransformations lhsLocalTransformations;
            lhsLocalTransformations = this.getLocalTransformations();
            LocalTransformations rhsLocalTransformations;
            rhsLocalTransformations = that.getLocalTransformations();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "localTransformations", lhsLocalTransformations), LocatorUtils.property(thatLocator, "localTransformations", rhsLocalTransformations), lhsLocalTransformations, rhsLocalTransformations)) {
                return false;
            }
        }
        {
            List<ResultField> lhsResultFields;
            lhsResultFields = (((this.resultFields!= null)&&(!this.resultFields.isEmpty()))?this.getResultFields():null);
            List<ResultField> rhsResultFields;
            rhsResultFields = (((that.resultFields!= null)&&(!that.resultFields.isEmpty()))?that.getResultFields():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "resultFields", lhsResultFields), LocatorUtils.property(thatLocator, "resultFields", rhsResultFields), lhsResultFields, rhsResultFields)) {
                return false;
            }
        }
        {
            List<RegressionTable> lhsRegressionTables;
            lhsRegressionTables = (((this.regressionTables!= null)&&(!this.regressionTables.isEmpty()))?this.getRegressionTables():null);
            List<RegressionTable> rhsRegressionTables;
            rhsRegressionTables = (((that.regressionTables!= null)&&(!that.regressionTables.isEmpty()))?that.getRegressionTables():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "regressionTables", lhsRegressionTables), LocatorUtils.property(thatLocator, "regressionTables", rhsRegressionTables), lhsRegressionTables, rhsRegressionTables)) {
                return false;
            }
        }
        {
            String lhsModelName;
            lhsModelName = this.getModelName();
            String rhsModelName;
            rhsModelName = that.getModelName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelName", lhsModelName), LocatorUtils.property(thatLocator, "modelName", rhsModelName), lhsModelName, rhsModelName)) {
                return false;
            }
        }
        {
            MiningFunctionType lhsFunctionName;
            lhsFunctionName = this.getFunctionName();
            MiningFunctionType rhsFunctionName;
            rhsFunctionName = that.getFunctionName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "functionName", lhsFunctionName), LocatorUtils.property(thatLocator, "functionName", rhsFunctionName), lhsFunctionName, rhsFunctionName)) {
                return false;
            }
        }
        {
            String lhsAlgorithmName;
            lhsAlgorithmName = this.getAlgorithmName();
            String rhsAlgorithmName;
            rhsAlgorithmName = that.getAlgorithmName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "algorithmName", lhsAlgorithmName), LocatorUtils.property(thatLocator, "algorithmName", rhsAlgorithmName), lhsAlgorithmName, rhsAlgorithmName)) {
                return false;
            }
        }
        {
            RegressionNormalizationMethodType lhsNormalizationMethod;
            lhsNormalizationMethod = this.getNormalizationMethod();
            RegressionNormalizationMethodType rhsNormalizationMethod;
            rhsNormalizationMethod = that.getNormalizationMethod();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "normalizationMethod", lhsNormalizationMethod), LocatorUtils.property(thatLocator, "normalizationMethod", rhsNormalizationMethod), lhsNormalizationMethod, rhsNormalizationMethod)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        {
            List<Extension> theExtensions;
            theExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "extensions", theExtensions), currentHashCode, theExtensions);
        }
        {
            Output theOutput;
            theOutput = this.getOutput();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "output", theOutput), currentHashCode, theOutput);
        }
        {
            ModelStats theModelStats;
            theModelStats = this.getModelStats();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelStats", theModelStats), currentHashCode, theModelStats);
        }
        {
            Targets theTargets;
            theTargets = this.getTargets();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "targets", theTargets), currentHashCode, theTargets);
        }
        {
            LocalTransformations theLocalTransformations;
            theLocalTransformations = this.getLocalTransformations();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "localTransformations", theLocalTransformations), currentHashCode, theLocalTransformations);
        }
        {
            List<ResultField> theResultFields;
            theResultFields = (((this.resultFields!= null)&&(!this.resultFields.isEmpty()))?this.getResultFields():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "resultFields", theResultFields), currentHashCode, theResultFields);
        }
        {
            List<RegressionTable> theRegressionTables;
            theRegressionTables = (((this.regressionTables!= null)&&(!this.regressionTables.isEmpty()))?this.getRegressionTables():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "regressionTables", theRegressionTables), currentHashCode, theRegressionTables);
        }
        {
            String theModelName;
            theModelName = this.getModelName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelName", theModelName), currentHashCode, theModelName);
        }
        {
            MiningFunctionType theFunctionName;
            theFunctionName = this.getFunctionName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "functionName", theFunctionName), currentHashCode, theFunctionName);
        }
        {
            String theAlgorithmName;
            theAlgorithmName = this.getAlgorithmName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "algorithmName", theAlgorithmName), currentHashCode, theAlgorithmName);
        }
        {
            RegressionNormalizationMethodType theNormalizationMethod;
            theNormalizationMethod = this.getNormalizationMethod();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "normalizationMethod", theNormalizationMethod), currentHashCode, theNormalizationMethod);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<Extension> theExtensions;
            theExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            strategy.appendField(locator, this, "extensions", buffer, theExtensions);
        }
        {
            Output theOutput;
            theOutput = this.getOutput();
            strategy.appendField(locator, this, "output", buffer, theOutput);
        }
        {
            ModelStats theModelStats;
            theModelStats = this.getModelStats();
            strategy.appendField(locator, this, "modelStats", buffer, theModelStats);
        }
        {
            Targets theTargets;
            theTargets = this.getTargets();
            strategy.appendField(locator, this, "targets", buffer, theTargets);
        }
        {
            LocalTransformations theLocalTransformations;
            theLocalTransformations = this.getLocalTransformations();
            strategy.appendField(locator, this, "localTransformations", buffer, theLocalTransformations);
        }
        {
            List<ResultField> theResultFields;
            theResultFields = (((this.resultFields!= null)&&(!this.resultFields.isEmpty()))?this.getResultFields():null);
            strategy.appendField(locator, this, "resultFields", buffer, theResultFields);
        }
        {
            List<RegressionTable> theRegressionTables;
            theRegressionTables = (((this.regressionTables!= null)&&(!this.regressionTables.isEmpty()))?this.getRegressionTables():null);
            strategy.appendField(locator, this, "regressionTables", buffer, theRegressionTables);
        }
        {
            String theModelName;
            theModelName = this.getModelName();
            strategy.appendField(locator, this, "modelName", buffer, theModelName);
        }
        {
            MiningFunctionType theFunctionName;
            theFunctionName = this.getFunctionName();
            strategy.appendField(locator, this, "functionName", buffer, theFunctionName);
        }
        {
            String theAlgorithmName;
            theAlgorithmName = this.getAlgorithmName();
            strategy.appendField(locator, this, "algorithmName", buffer, theAlgorithmName);
        }
        {
            RegressionNormalizationMethodType theNormalizationMethod;
            theNormalizationMethod = this.getNormalizationMethod();
            strategy.appendField(locator, this, "normalizationMethod", buffer, theNormalizationMethod);
        }
        return buffer;
    }

}
