
package org.dmg.pmml;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}TextDictionary"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}TextCorpus"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}DocumentTermMatrix"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}TextModelNormalization" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}TextModelSimiliarity" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_1}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="numberOfTerms" use="required" type="{http://www.w3.org/2001/XMLSchema}integer" />
 *       &lt;attribute name="numberOfDocuments" use="required" type="{http://www.w3.org/2001/XMLSchema}integer" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "textDictionary",
    "textCorpus",
    "documentTermMatrix",
    "textModelNormalization",
    "textModelSimiliarity",
    "modelVerification"
})
@XmlRootElement(name = "TextModel")
public class TextModel
    extends Model
    implements Equals, HashCode, ToString
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "MiningSchema", required = true)
    protected MiningSchema miningSchema;
    @XmlElement(name = "Output")
    protected Output output;
    @XmlElement(name = "ModelStats")
    protected ModelStats modelStats;
    @XmlElement(name = "ModelExplanation")
    protected ModelExplanation modelExplanation;
    @XmlElement(name = "Targets")
    protected Targets targets;
    @XmlElement(name = "LocalTransformations")
    protected LocalTransformations localTransformations;
    @XmlElement(name = "TextDictionary", required = true)
    protected TextDictionary textDictionary;
    @XmlElement(name = "TextCorpus", required = true)
    protected TextCorpus textCorpus;
    @XmlElement(name = "DocumentTermMatrix", required = true)
    protected DocumentTermMatrix documentTermMatrix;
    @XmlElement(name = "TextModelNormalization")
    protected TextModelNormalization textModelNormalization;
    @XmlElement(name = "TextModelSimiliarity")
    protected TextModelSimiliarity textModelSimiliarity;
    @XmlElement(name = "ModelVerification")
    protected ModelVerification modelVerification;
    @XmlAttribute(name = "modelName")
    protected String modelName;
    @XmlAttribute(name = "functionName", required = true)
    protected MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    protected String algorithmName;
    @XmlAttribute(name = "numberOfTerms", required = true)
    protected BigInteger numberOfTerms;
    @XmlAttribute(name = "numberOfDocuments", required = true)
    protected BigInteger numberOfDocuments;
    @XmlAttribute(name = "isScorable")
    protected Boolean scorable;

    @Deprecated
    public TextModel() {
        super();
    }

    public TextModel(final MiningSchema miningSchema, final TextDictionary textDictionary, final TextCorpus textCorpus, final DocumentTermMatrix documentTermMatrix, final MiningFunctionType functionName, final BigInteger numberOfTerms, final BigInteger numberOfDocuments) {
        super();
        this.miningSchema = miningSchema;
        this.textDictionary = textDictionary;
        this.textCorpus = textCorpus;
        this.documentTermMatrix = documentTermMatrix;
        this.functionName = functionName;
        this.numberOfTerms = numberOfTerms;
        this.numberOfDocuments = numberOfDocuments;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public void setMiningSchema(MiningSchema value) {
        this.miningSchema = value;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param value
     *     allowed object is
     *     {@link Output }
     *     
     */
    public void setOutput(Output value) {
        this.output = value;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public void setModelStats(ModelStats value) {
        this.modelStats = value;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public void setModelExplanation(ModelExplanation value) {
        this.modelExplanation = value;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param value
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public void setTargets(Targets value) {
        this.targets = value;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public void setLocalTransformations(LocalTransformations value) {
        this.localTransformations = value;
    }

    /**
     * Gets the value of the textDictionary property.
     * 
     * @return
     *     possible object is
     *     {@link TextDictionary }
     *     
     */
    public TextDictionary getTextDictionary() {
        return textDictionary;
    }

    /**
     * Sets the value of the textDictionary property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextDictionary }
     *     
     */
    public void setTextDictionary(TextDictionary value) {
        this.textDictionary = value;
    }

    /**
     * Gets the value of the textCorpus property.
     * 
     * @return
     *     possible object is
     *     {@link TextCorpus }
     *     
     */
    public TextCorpus getTextCorpus() {
        return textCorpus;
    }

    /**
     * Sets the value of the textCorpus property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextCorpus }
     *     
     */
    public void setTextCorpus(TextCorpus value) {
        this.textCorpus = value;
    }

    /**
     * Gets the value of the documentTermMatrix property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentTermMatrix }
     *     
     */
    public DocumentTermMatrix getDocumentTermMatrix() {
        return documentTermMatrix;
    }

    /**
     * Sets the value of the documentTermMatrix property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentTermMatrix }
     *     
     */
    public void setDocumentTermMatrix(DocumentTermMatrix value) {
        this.documentTermMatrix = value;
    }

    /**
     * Gets the value of the textModelNormalization property.
     * 
     * @return
     *     possible object is
     *     {@link TextModelNormalization }
     *     
     */
    public TextModelNormalization getTextModelNormalization() {
        return textModelNormalization;
    }

    /**
     * Sets the value of the textModelNormalization property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextModelNormalization }
     *     
     */
    public void setTextModelNormalization(TextModelNormalization value) {
        this.textModelNormalization = value;
    }

    /**
     * Gets the value of the textModelSimiliarity property.
     * 
     * @return
     *     possible object is
     *     {@link TextModelSimiliarity }
     *     
     */
    public TextModelSimiliarity getTextModelSimiliarity() {
        return textModelSimiliarity;
    }

    /**
     * Sets the value of the textModelSimiliarity property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextModelSimiliarity }
     *     
     */
    public void setTextModelSimiliarity(TextModelSimiliarity value) {
        this.textModelSimiliarity = value;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public void setModelVerification(ModelVerification value) {
        this.modelVerification = value;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setModelName(String value) {
        this.modelName = value;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public void setFunctionName(MiningFunctionType value) {
        this.functionName = value;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlgorithmName(String value) {
        this.algorithmName = value;
    }

    /**
     * Gets the value of the numberOfTerms property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getNumberOfTerms() {
        return numberOfTerms;
    }

    /**
     * Sets the value of the numberOfTerms property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setNumberOfTerms(BigInteger value) {
        this.numberOfTerms = value;
    }

    /**
     * Gets the value of the numberOfDocuments property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getNumberOfDocuments() {
        return numberOfDocuments;
    }

    /**
     * Sets the value of the numberOfDocuments property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setNumberOfDocuments(BigInteger value) {
        this.numberOfDocuments = value;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return true;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setScorable(Boolean value) {
        this.scorable = value;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if (!(object instanceof TextModel)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        final TextModel that = ((TextModel) object);
        {
            List<Extension> lhsExtensions;
            lhsExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            List<Extension> rhsExtensions;
            rhsExtensions = (((that.extensions!= null)&&(!that.extensions.isEmpty()))?that.getExtensions():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "extensions", lhsExtensions), LocatorUtils.property(thatLocator, "extensions", rhsExtensions), lhsExtensions, rhsExtensions)) {
                return false;
            }
        }
        {
            MiningSchema lhsMiningSchema;
            lhsMiningSchema = this.getMiningSchema();
            MiningSchema rhsMiningSchema;
            rhsMiningSchema = that.getMiningSchema();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "miningSchema", lhsMiningSchema), LocatorUtils.property(thatLocator, "miningSchema", rhsMiningSchema), lhsMiningSchema, rhsMiningSchema)) {
                return false;
            }
        }
        {
            Output lhsOutput;
            lhsOutput = this.getOutput();
            Output rhsOutput;
            rhsOutput = that.getOutput();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "output", lhsOutput), LocatorUtils.property(thatLocator, "output", rhsOutput), lhsOutput, rhsOutput)) {
                return false;
            }
        }
        {
            ModelStats lhsModelStats;
            lhsModelStats = this.getModelStats();
            ModelStats rhsModelStats;
            rhsModelStats = that.getModelStats();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelStats", lhsModelStats), LocatorUtils.property(thatLocator, "modelStats", rhsModelStats), lhsModelStats, rhsModelStats)) {
                return false;
            }
        }
        {
            ModelExplanation lhsModelExplanation;
            lhsModelExplanation = this.getModelExplanation();
            ModelExplanation rhsModelExplanation;
            rhsModelExplanation = that.getModelExplanation();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelExplanation", lhsModelExplanation), LocatorUtils.property(thatLocator, "modelExplanation", rhsModelExplanation), lhsModelExplanation, rhsModelExplanation)) {
                return false;
            }
        }
        {
            Targets lhsTargets;
            lhsTargets = this.getTargets();
            Targets rhsTargets;
            rhsTargets = that.getTargets();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "targets", lhsTargets), LocatorUtils.property(thatLocator, "targets", rhsTargets), lhsTargets, rhsTargets)) {
                return false;
            }
        }
        {
            LocalTransformations lhsLocalTransformations;
            lhsLocalTransformations = this.getLocalTransformations();
            LocalTransformations rhsLocalTransformations;
            rhsLocalTransformations = that.getLocalTransformations();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "localTransformations", lhsLocalTransformations), LocatorUtils.property(thatLocator, "localTransformations", rhsLocalTransformations), lhsLocalTransformations, rhsLocalTransformations)) {
                return false;
            }
        }
        {
            TextDictionary lhsTextDictionary;
            lhsTextDictionary = this.getTextDictionary();
            TextDictionary rhsTextDictionary;
            rhsTextDictionary = that.getTextDictionary();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "textDictionary", lhsTextDictionary), LocatorUtils.property(thatLocator, "textDictionary", rhsTextDictionary), lhsTextDictionary, rhsTextDictionary)) {
                return false;
            }
        }
        {
            TextCorpus lhsTextCorpus;
            lhsTextCorpus = this.getTextCorpus();
            TextCorpus rhsTextCorpus;
            rhsTextCorpus = that.getTextCorpus();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "textCorpus", lhsTextCorpus), LocatorUtils.property(thatLocator, "textCorpus", rhsTextCorpus), lhsTextCorpus, rhsTextCorpus)) {
                return false;
            }
        }
        {
            DocumentTermMatrix lhsDocumentTermMatrix;
            lhsDocumentTermMatrix = this.getDocumentTermMatrix();
            DocumentTermMatrix rhsDocumentTermMatrix;
            rhsDocumentTermMatrix = that.getDocumentTermMatrix();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "documentTermMatrix", lhsDocumentTermMatrix), LocatorUtils.property(thatLocator, "documentTermMatrix", rhsDocumentTermMatrix), lhsDocumentTermMatrix, rhsDocumentTermMatrix)) {
                return false;
            }
        }
        {
            TextModelNormalization lhsTextModelNormalization;
            lhsTextModelNormalization = this.getTextModelNormalization();
            TextModelNormalization rhsTextModelNormalization;
            rhsTextModelNormalization = that.getTextModelNormalization();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "textModelNormalization", lhsTextModelNormalization), LocatorUtils.property(thatLocator, "textModelNormalization", rhsTextModelNormalization), lhsTextModelNormalization, rhsTextModelNormalization)) {
                return false;
            }
        }
        {
            TextModelSimiliarity lhsTextModelSimiliarity;
            lhsTextModelSimiliarity = this.getTextModelSimiliarity();
            TextModelSimiliarity rhsTextModelSimiliarity;
            rhsTextModelSimiliarity = that.getTextModelSimiliarity();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "textModelSimiliarity", lhsTextModelSimiliarity), LocatorUtils.property(thatLocator, "textModelSimiliarity", rhsTextModelSimiliarity), lhsTextModelSimiliarity, rhsTextModelSimiliarity)) {
                return false;
            }
        }
        {
            ModelVerification lhsModelVerification;
            lhsModelVerification = this.getModelVerification();
            ModelVerification rhsModelVerification;
            rhsModelVerification = that.getModelVerification();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelVerification", lhsModelVerification), LocatorUtils.property(thatLocator, "modelVerification", rhsModelVerification), lhsModelVerification, rhsModelVerification)) {
                return false;
            }
        }
        {
            String lhsModelName;
            lhsModelName = this.getModelName();
            String rhsModelName;
            rhsModelName = that.getModelName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelName", lhsModelName), LocatorUtils.property(thatLocator, "modelName", rhsModelName), lhsModelName, rhsModelName)) {
                return false;
            }
        }
        {
            MiningFunctionType lhsFunctionName;
            lhsFunctionName = this.getFunctionName();
            MiningFunctionType rhsFunctionName;
            rhsFunctionName = that.getFunctionName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "functionName", lhsFunctionName), LocatorUtils.property(thatLocator, "functionName", rhsFunctionName), lhsFunctionName, rhsFunctionName)) {
                return false;
            }
        }
        {
            String lhsAlgorithmName;
            lhsAlgorithmName = this.getAlgorithmName();
            String rhsAlgorithmName;
            rhsAlgorithmName = that.getAlgorithmName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "algorithmName", lhsAlgorithmName), LocatorUtils.property(thatLocator, "algorithmName", rhsAlgorithmName), lhsAlgorithmName, rhsAlgorithmName)) {
                return false;
            }
        }
        {
            BigInteger lhsNumberOfTerms;
            lhsNumberOfTerms = this.getNumberOfTerms();
            BigInteger rhsNumberOfTerms;
            rhsNumberOfTerms = that.getNumberOfTerms();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "numberOfTerms", lhsNumberOfTerms), LocatorUtils.property(thatLocator, "numberOfTerms", rhsNumberOfTerms), lhsNumberOfTerms, rhsNumberOfTerms)) {
                return false;
            }
        }
        {
            BigInteger lhsNumberOfDocuments;
            lhsNumberOfDocuments = this.getNumberOfDocuments();
            BigInteger rhsNumberOfDocuments;
            rhsNumberOfDocuments = that.getNumberOfDocuments();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "numberOfDocuments", lhsNumberOfDocuments), LocatorUtils.property(thatLocator, "numberOfDocuments", rhsNumberOfDocuments), lhsNumberOfDocuments, rhsNumberOfDocuments)) {
                return false;
            }
        }
        {
            boolean lhsScorable;
            lhsScorable = ((this.scorable!= null)?this.isScorable():false);
            boolean rhsScorable;
            rhsScorable = ((that.scorable!= null)?that.isScorable():false);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "scorable", lhsScorable), LocatorUtils.property(thatLocator, "scorable", rhsScorable), lhsScorable, rhsScorable)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        {
            List<Extension> theExtensions;
            theExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "extensions", theExtensions), currentHashCode, theExtensions);
        }
        {
            MiningSchema theMiningSchema;
            theMiningSchema = this.getMiningSchema();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "miningSchema", theMiningSchema), currentHashCode, theMiningSchema);
        }
        {
            Output theOutput;
            theOutput = this.getOutput();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "output", theOutput), currentHashCode, theOutput);
        }
        {
            ModelStats theModelStats;
            theModelStats = this.getModelStats();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelStats", theModelStats), currentHashCode, theModelStats);
        }
        {
            ModelExplanation theModelExplanation;
            theModelExplanation = this.getModelExplanation();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelExplanation", theModelExplanation), currentHashCode, theModelExplanation);
        }
        {
            Targets theTargets;
            theTargets = this.getTargets();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "targets", theTargets), currentHashCode, theTargets);
        }
        {
            LocalTransformations theLocalTransformations;
            theLocalTransformations = this.getLocalTransformations();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "localTransformations", theLocalTransformations), currentHashCode, theLocalTransformations);
        }
        {
            TextDictionary theTextDictionary;
            theTextDictionary = this.getTextDictionary();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "textDictionary", theTextDictionary), currentHashCode, theTextDictionary);
        }
        {
            TextCorpus theTextCorpus;
            theTextCorpus = this.getTextCorpus();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "textCorpus", theTextCorpus), currentHashCode, theTextCorpus);
        }
        {
            DocumentTermMatrix theDocumentTermMatrix;
            theDocumentTermMatrix = this.getDocumentTermMatrix();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "documentTermMatrix", theDocumentTermMatrix), currentHashCode, theDocumentTermMatrix);
        }
        {
            TextModelNormalization theTextModelNormalization;
            theTextModelNormalization = this.getTextModelNormalization();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "textModelNormalization", theTextModelNormalization), currentHashCode, theTextModelNormalization);
        }
        {
            TextModelSimiliarity theTextModelSimiliarity;
            theTextModelSimiliarity = this.getTextModelSimiliarity();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "textModelSimiliarity", theTextModelSimiliarity), currentHashCode, theTextModelSimiliarity);
        }
        {
            ModelVerification theModelVerification;
            theModelVerification = this.getModelVerification();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelVerification", theModelVerification), currentHashCode, theModelVerification);
        }
        {
            String theModelName;
            theModelName = this.getModelName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelName", theModelName), currentHashCode, theModelName);
        }
        {
            MiningFunctionType theFunctionName;
            theFunctionName = this.getFunctionName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "functionName", theFunctionName), currentHashCode, theFunctionName);
        }
        {
            String theAlgorithmName;
            theAlgorithmName = this.getAlgorithmName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "algorithmName", theAlgorithmName), currentHashCode, theAlgorithmName);
        }
        {
            BigInteger theNumberOfTerms;
            theNumberOfTerms = this.getNumberOfTerms();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "numberOfTerms", theNumberOfTerms), currentHashCode, theNumberOfTerms);
        }
        {
            BigInteger theNumberOfDocuments;
            theNumberOfDocuments = this.getNumberOfDocuments();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "numberOfDocuments", theNumberOfDocuments), currentHashCode, theNumberOfDocuments);
        }
        {
            boolean theScorable;
            theScorable = ((this.scorable!= null)?this.isScorable():false);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "scorable", theScorable), currentHashCode, theScorable);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<Extension> theExtensions;
            theExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            strategy.appendField(locator, this, "extensions", buffer, theExtensions);
        }
        {
            MiningSchema theMiningSchema;
            theMiningSchema = this.getMiningSchema();
            strategy.appendField(locator, this, "miningSchema", buffer, theMiningSchema);
        }
        {
            Output theOutput;
            theOutput = this.getOutput();
            strategy.appendField(locator, this, "output", buffer, theOutput);
        }
        {
            ModelStats theModelStats;
            theModelStats = this.getModelStats();
            strategy.appendField(locator, this, "modelStats", buffer, theModelStats);
        }
        {
            ModelExplanation theModelExplanation;
            theModelExplanation = this.getModelExplanation();
            strategy.appendField(locator, this, "modelExplanation", buffer, theModelExplanation);
        }
        {
            Targets theTargets;
            theTargets = this.getTargets();
            strategy.appendField(locator, this, "targets", buffer, theTargets);
        }
        {
            LocalTransformations theLocalTransformations;
            theLocalTransformations = this.getLocalTransformations();
            strategy.appendField(locator, this, "localTransformations", buffer, theLocalTransformations);
        }
        {
            TextDictionary theTextDictionary;
            theTextDictionary = this.getTextDictionary();
            strategy.appendField(locator, this, "textDictionary", buffer, theTextDictionary);
        }
        {
            TextCorpus theTextCorpus;
            theTextCorpus = this.getTextCorpus();
            strategy.appendField(locator, this, "textCorpus", buffer, theTextCorpus);
        }
        {
            DocumentTermMatrix theDocumentTermMatrix;
            theDocumentTermMatrix = this.getDocumentTermMatrix();
            strategy.appendField(locator, this, "documentTermMatrix", buffer, theDocumentTermMatrix);
        }
        {
            TextModelNormalization theTextModelNormalization;
            theTextModelNormalization = this.getTextModelNormalization();
            strategy.appendField(locator, this, "textModelNormalization", buffer, theTextModelNormalization);
        }
        {
            TextModelSimiliarity theTextModelSimiliarity;
            theTextModelSimiliarity = this.getTextModelSimiliarity();
            strategy.appendField(locator, this, "textModelSimiliarity", buffer, theTextModelSimiliarity);
        }
        {
            ModelVerification theModelVerification;
            theModelVerification = this.getModelVerification();
            strategy.appendField(locator, this, "modelVerification", buffer, theModelVerification);
        }
        {
            String theModelName;
            theModelName = this.getModelName();
            strategy.appendField(locator, this, "modelName", buffer, theModelName);
        }
        {
            MiningFunctionType theFunctionName;
            theFunctionName = this.getFunctionName();
            strategy.appendField(locator, this, "functionName", buffer, theFunctionName);
        }
        {
            String theAlgorithmName;
            theAlgorithmName = this.getAlgorithmName();
            strategy.appendField(locator, this, "algorithmName", buffer, theAlgorithmName);
        }
        {
            BigInteger theNumberOfTerms;
            theNumberOfTerms = this.getNumberOfTerms();
            strategy.appendField(locator, this, "numberOfTerms", buffer, theNumberOfTerms);
        }
        {
            BigInteger theNumberOfDocuments;
            theNumberOfDocuments = this.getNumberOfDocuments();
            strategy.appendField(locator, this, "numberOfDocuments", buffer, theNumberOfDocuments);
        }
        {
            boolean theScorable;
            theScorable = ((this.scorable!= null)?this.isScorable():false);
            strategy.appendField(locator, this, "scorable", buffer, theScorable);
        }
        return buffer;
    }

}
