
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;
import org.w3._2001.xmlschema.Adapter1;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}TrainingInstances"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ComparisonMeasure"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}KNNInputs"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_1}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_1}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="numberOfNeighbors" use="required" type="{http://www.dmg.org/PMML-4_1}INT-NUMBER" />
 *       &lt;attribute name="continuousScoringMethod" type="{http://www.dmg.org/PMML-4_1}CONT-SCORING-METHOD" default="average" />
 *       &lt;attribute name="categoricalScoringMethod" type="{http://www.dmg.org/PMML-4_1}CAT-SCORING-METHOD" default="majorityVote" />
 *       &lt;attribute name="instanceIdVariable" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="threshold" type="{http://www.dmg.org/PMML-4_1}REAL-NUMBER" default="0.001" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "trainingInstances",
    "comparisonMeasure",
    "knnInputs",
    "modelVerification"
})
@XmlRootElement(name = "NearestNeighborModel")
@Schema(min = Version.PMML_4_1)
public class NearestNeighborModel
    extends Model
    implements Equals, HashCode, ToString
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "MiningSchema", required = true)
    protected MiningSchema miningSchema;
    @XmlElement(name = "Output")
    protected Output output;
    @XmlElement(name = "ModelStats")
    protected ModelStats modelStats;
    @XmlElement(name = "ModelExplanation")
    protected ModelExplanation modelExplanation;
    @XmlElement(name = "Targets")
    protected Targets targets;
    @XmlElement(name = "LocalTransformations")
    protected LocalTransformations localTransformations;
    @XmlElement(name = "TrainingInstances", required = true)
    protected TrainingInstances trainingInstances;
    @XmlElement(name = "ComparisonMeasure", required = true)
    protected ComparisonMeasure comparisonMeasure;
    @XmlElement(name = "KNNInputs", required = true)
    protected KNNInputs knnInputs;
    @XmlElement(name = "ModelVerification")
    protected ModelVerification modelVerification;
    @XmlAttribute(name = "modelName")
    protected String modelName;
    @XmlAttribute(name = "functionName", required = true)
    protected MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    protected String algorithmName;
    @XmlAttribute(name = "numberOfNeighbors", required = true)
    @XmlJavaTypeAdapter(Adapter1 .class)
    protected Integer numberOfNeighbors;
    @XmlAttribute(name = "continuousScoringMethod")
    protected ContScoringMethodType continuousScoringMethod;
    @XmlAttribute(name = "categoricalScoringMethod")
    protected CatScoringMethodType categoricalScoringMethod;
    @XmlAttribute(name = "instanceIdVariable")
    protected String instanceIdVariable;
    @XmlAttribute(name = "threshold")
    protected Double threshold;
    @XmlAttribute(name = "isScorable")
    protected Boolean scorable;

    @Deprecated
    public NearestNeighborModel() {
        super();
    }

    public NearestNeighborModel(final MiningSchema miningSchema, final TrainingInstances trainingInstances, final ComparisonMeasure comparisonMeasure, final KNNInputs knnInputs, final MiningFunctionType functionName, final Integer numberOfNeighbors) {
        super();
        this.miningSchema = miningSchema;
        this.trainingInstances = trainingInstances;
        this.comparisonMeasure = comparisonMeasure;
        this.knnInputs = knnInputs;
        this.functionName = functionName;
        this.numberOfNeighbors = numberOfNeighbors;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public void setMiningSchema(MiningSchema value) {
        this.miningSchema = value;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param value
     *     allowed object is
     *     {@link Output }
     *     
     */
    public void setOutput(Output value) {
        this.output = value;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public void setModelStats(ModelStats value) {
        this.modelStats = value;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public void setModelExplanation(ModelExplanation value) {
        this.modelExplanation = value;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param value
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public void setTargets(Targets value) {
        this.targets = value;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public void setLocalTransformations(LocalTransformations value) {
        this.localTransformations = value;
    }

    /**
     * Gets the value of the trainingInstances property.
     * 
     * @return
     *     possible object is
     *     {@link TrainingInstances }
     *     
     */
    public TrainingInstances getTrainingInstances() {
        return trainingInstances;
    }

    /**
     * Sets the value of the trainingInstances property.
     * 
     * @param value
     *     allowed object is
     *     {@link TrainingInstances }
     *     
     */
    public void setTrainingInstances(TrainingInstances value) {
        this.trainingInstances = value;
    }

    /**
     * Gets the value of the comparisonMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link ComparisonMeasure }
     *     
     */
    public ComparisonMeasure getComparisonMeasure() {
        return comparisonMeasure;
    }

    /**
     * Sets the value of the comparisonMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link ComparisonMeasure }
     *     
     */
    public void setComparisonMeasure(ComparisonMeasure value) {
        this.comparisonMeasure = value;
    }

    /**
     * Gets the value of the knnInputs property.
     * 
     * @return
     *     possible object is
     *     {@link KNNInputs }
     *     
     */
    public KNNInputs getKNNInputs() {
        return knnInputs;
    }

    /**
     * Sets the value of the knnInputs property.
     * 
     * @param value
     *     allowed object is
     *     {@link KNNInputs }
     *     
     */
    public void setKNNInputs(KNNInputs value) {
        this.knnInputs = value;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public void setModelVerification(ModelVerification value) {
        this.modelVerification = value;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setModelName(String value) {
        this.modelName = value;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public void setFunctionName(MiningFunctionType value) {
        this.functionName = value;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlgorithmName(String value) {
        this.algorithmName = value;
    }

    /**
     * Gets the value of the numberOfNeighbors property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfNeighbors() {
        return numberOfNeighbors;
    }

    /**
     * Sets the value of the numberOfNeighbors property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNumberOfNeighbors(Integer value) {
        this.numberOfNeighbors = value;
    }

    /**
     * Gets the value of the continuousScoringMethod property.
     * 
     * @return
     *     possible object is
     *     {@link ContScoringMethodType }
     *     
     */
    public ContScoringMethodType getContinuousScoringMethod() {
        if (continuousScoringMethod == null) {
            return ContScoringMethodType.AVERAGE;
        } else {
            return continuousScoringMethod;
        }
    }

    /**
     * Sets the value of the continuousScoringMethod property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContScoringMethodType }
     *     
     */
    public void setContinuousScoringMethod(ContScoringMethodType value) {
        this.continuousScoringMethod = value;
    }

    /**
     * Gets the value of the categoricalScoringMethod property.
     * 
     * @return
     *     possible object is
     *     {@link CatScoringMethodType }
     *     
     */
    public CatScoringMethodType getCategoricalScoringMethod() {
        if (categoricalScoringMethod == null) {
            return CatScoringMethodType.MAJORITY_VOTE;
        } else {
            return categoricalScoringMethod;
        }
    }

    /**
     * Sets the value of the categoricalScoringMethod property.
     * 
     * @param value
     *     allowed object is
     *     {@link CatScoringMethodType }
     *     
     */
    public void setCategoricalScoringMethod(CatScoringMethodType value) {
        this.categoricalScoringMethod = value;
    }

    /**
     * Gets the value of the instanceIdVariable property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getInstanceIdVariable() {
        return instanceIdVariable;
    }

    /**
     * Sets the value of the instanceIdVariable property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setInstanceIdVariable(String value) {
        this.instanceIdVariable = value;
    }

    /**
     * Gets the value of the threshold property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getThreshold() {
        if (threshold == null) {
            return  0.0010D;
        } else {
            return threshold;
        }
    }

    /**
     * Sets the value of the threshold property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setThreshold(Double value) {
        this.threshold = value;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return true;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setScorable(Boolean value) {
        this.scorable = value;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if (!(object instanceof NearestNeighborModel)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        final NearestNeighborModel that = ((NearestNeighborModel) object);
        {
            List<Extension> lhsExtensions;
            lhsExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            List<Extension> rhsExtensions;
            rhsExtensions = (((that.extensions!= null)&&(!that.extensions.isEmpty()))?that.getExtensions():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "extensions", lhsExtensions), LocatorUtils.property(thatLocator, "extensions", rhsExtensions), lhsExtensions, rhsExtensions)) {
                return false;
            }
        }
        {
            MiningSchema lhsMiningSchema;
            lhsMiningSchema = this.getMiningSchema();
            MiningSchema rhsMiningSchema;
            rhsMiningSchema = that.getMiningSchema();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "miningSchema", lhsMiningSchema), LocatorUtils.property(thatLocator, "miningSchema", rhsMiningSchema), lhsMiningSchema, rhsMiningSchema)) {
                return false;
            }
        }
        {
            Output lhsOutput;
            lhsOutput = this.getOutput();
            Output rhsOutput;
            rhsOutput = that.getOutput();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "output", lhsOutput), LocatorUtils.property(thatLocator, "output", rhsOutput), lhsOutput, rhsOutput)) {
                return false;
            }
        }
        {
            ModelStats lhsModelStats;
            lhsModelStats = this.getModelStats();
            ModelStats rhsModelStats;
            rhsModelStats = that.getModelStats();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelStats", lhsModelStats), LocatorUtils.property(thatLocator, "modelStats", rhsModelStats), lhsModelStats, rhsModelStats)) {
                return false;
            }
        }
        {
            ModelExplanation lhsModelExplanation;
            lhsModelExplanation = this.getModelExplanation();
            ModelExplanation rhsModelExplanation;
            rhsModelExplanation = that.getModelExplanation();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelExplanation", lhsModelExplanation), LocatorUtils.property(thatLocator, "modelExplanation", rhsModelExplanation), lhsModelExplanation, rhsModelExplanation)) {
                return false;
            }
        }
        {
            Targets lhsTargets;
            lhsTargets = this.getTargets();
            Targets rhsTargets;
            rhsTargets = that.getTargets();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "targets", lhsTargets), LocatorUtils.property(thatLocator, "targets", rhsTargets), lhsTargets, rhsTargets)) {
                return false;
            }
        }
        {
            LocalTransformations lhsLocalTransformations;
            lhsLocalTransformations = this.getLocalTransformations();
            LocalTransformations rhsLocalTransformations;
            rhsLocalTransformations = that.getLocalTransformations();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "localTransformations", lhsLocalTransformations), LocatorUtils.property(thatLocator, "localTransformations", rhsLocalTransformations), lhsLocalTransformations, rhsLocalTransformations)) {
                return false;
            }
        }
        {
            TrainingInstances lhsTrainingInstances;
            lhsTrainingInstances = this.getTrainingInstances();
            TrainingInstances rhsTrainingInstances;
            rhsTrainingInstances = that.getTrainingInstances();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "trainingInstances", lhsTrainingInstances), LocatorUtils.property(thatLocator, "trainingInstances", rhsTrainingInstances), lhsTrainingInstances, rhsTrainingInstances)) {
                return false;
            }
        }
        {
            ComparisonMeasure lhsComparisonMeasure;
            lhsComparisonMeasure = this.getComparisonMeasure();
            ComparisonMeasure rhsComparisonMeasure;
            rhsComparisonMeasure = that.getComparisonMeasure();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "comparisonMeasure", lhsComparisonMeasure), LocatorUtils.property(thatLocator, "comparisonMeasure", rhsComparisonMeasure), lhsComparisonMeasure, rhsComparisonMeasure)) {
                return false;
            }
        }
        {
            KNNInputs lhsKNNInputs;
            lhsKNNInputs = this.getKNNInputs();
            KNNInputs rhsKNNInputs;
            rhsKNNInputs = that.getKNNInputs();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "knnInputs", lhsKNNInputs), LocatorUtils.property(thatLocator, "knnInputs", rhsKNNInputs), lhsKNNInputs, rhsKNNInputs)) {
                return false;
            }
        }
        {
            ModelVerification lhsModelVerification;
            lhsModelVerification = this.getModelVerification();
            ModelVerification rhsModelVerification;
            rhsModelVerification = that.getModelVerification();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelVerification", lhsModelVerification), LocatorUtils.property(thatLocator, "modelVerification", rhsModelVerification), lhsModelVerification, rhsModelVerification)) {
                return false;
            }
        }
        {
            String lhsModelName;
            lhsModelName = this.getModelName();
            String rhsModelName;
            rhsModelName = that.getModelName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "modelName", lhsModelName), LocatorUtils.property(thatLocator, "modelName", rhsModelName), lhsModelName, rhsModelName)) {
                return false;
            }
        }
        {
            MiningFunctionType lhsFunctionName;
            lhsFunctionName = this.getFunctionName();
            MiningFunctionType rhsFunctionName;
            rhsFunctionName = that.getFunctionName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "functionName", lhsFunctionName), LocatorUtils.property(thatLocator, "functionName", rhsFunctionName), lhsFunctionName, rhsFunctionName)) {
                return false;
            }
        }
        {
            String lhsAlgorithmName;
            lhsAlgorithmName = this.getAlgorithmName();
            String rhsAlgorithmName;
            rhsAlgorithmName = that.getAlgorithmName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "algorithmName", lhsAlgorithmName), LocatorUtils.property(thatLocator, "algorithmName", rhsAlgorithmName), lhsAlgorithmName, rhsAlgorithmName)) {
                return false;
            }
        }
        {
            Integer lhsNumberOfNeighbors;
            lhsNumberOfNeighbors = this.getNumberOfNeighbors();
            Integer rhsNumberOfNeighbors;
            rhsNumberOfNeighbors = that.getNumberOfNeighbors();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "numberOfNeighbors", lhsNumberOfNeighbors), LocatorUtils.property(thatLocator, "numberOfNeighbors", rhsNumberOfNeighbors), lhsNumberOfNeighbors, rhsNumberOfNeighbors)) {
                return false;
            }
        }
        {
            ContScoringMethodType lhsContinuousScoringMethod;
            lhsContinuousScoringMethod = this.getContinuousScoringMethod();
            ContScoringMethodType rhsContinuousScoringMethod;
            rhsContinuousScoringMethod = that.getContinuousScoringMethod();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "continuousScoringMethod", lhsContinuousScoringMethod), LocatorUtils.property(thatLocator, "continuousScoringMethod", rhsContinuousScoringMethod), lhsContinuousScoringMethod, rhsContinuousScoringMethod)) {
                return false;
            }
        }
        {
            CatScoringMethodType lhsCategoricalScoringMethod;
            lhsCategoricalScoringMethod = this.getCategoricalScoringMethod();
            CatScoringMethodType rhsCategoricalScoringMethod;
            rhsCategoricalScoringMethod = that.getCategoricalScoringMethod();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "categoricalScoringMethod", lhsCategoricalScoringMethod), LocatorUtils.property(thatLocator, "categoricalScoringMethod", rhsCategoricalScoringMethod), lhsCategoricalScoringMethod, rhsCategoricalScoringMethod)) {
                return false;
            }
        }
        {
            String lhsInstanceIdVariable;
            lhsInstanceIdVariable = this.getInstanceIdVariable();
            String rhsInstanceIdVariable;
            rhsInstanceIdVariable = that.getInstanceIdVariable();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "instanceIdVariable", lhsInstanceIdVariable), LocatorUtils.property(thatLocator, "instanceIdVariable", rhsInstanceIdVariable), lhsInstanceIdVariable, rhsInstanceIdVariable)) {
                return false;
            }
        }
        {
            double lhsThreshold;
            lhsThreshold = ((this.threshold!= null)?this.getThreshold(): 0.0D);
            double rhsThreshold;
            rhsThreshold = ((that.threshold!= null)?that.getThreshold(): 0.0D);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "threshold", lhsThreshold), LocatorUtils.property(thatLocator, "threshold", rhsThreshold), lhsThreshold, rhsThreshold)) {
                return false;
            }
        }
        {
            boolean lhsScorable;
            lhsScorable = ((this.scorable!= null)?this.isScorable():false);
            boolean rhsScorable;
            rhsScorable = ((that.scorable!= null)?that.isScorable():false);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "scorable", lhsScorable), LocatorUtils.property(thatLocator, "scorable", rhsScorable), lhsScorable, rhsScorable)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        {
            List<Extension> theExtensions;
            theExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "extensions", theExtensions), currentHashCode, theExtensions);
        }
        {
            MiningSchema theMiningSchema;
            theMiningSchema = this.getMiningSchema();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "miningSchema", theMiningSchema), currentHashCode, theMiningSchema);
        }
        {
            Output theOutput;
            theOutput = this.getOutput();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "output", theOutput), currentHashCode, theOutput);
        }
        {
            ModelStats theModelStats;
            theModelStats = this.getModelStats();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelStats", theModelStats), currentHashCode, theModelStats);
        }
        {
            ModelExplanation theModelExplanation;
            theModelExplanation = this.getModelExplanation();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelExplanation", theModelExplanation), currentHashCode, theModelExplanation);
        }
        {
            Targets theTargets;
            theTargets = this.getTargets();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "targets", theTargets), currentHashCode, theTargets);
        }
        {
            LocalTransformations theLocalTransformations;
            theLocalTransformations = this.getLocalTransformations();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "localTransformations", theLocalTransformations), currentHashCode, theLocalTransformations);
        }
        {
            TrainingInstances theTrainingInstances;
            theTrainingInstances = this.getTrainingInstances();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "trainingInstances", theTrainingInstances), currentHashCode, theTrainingInstances);
        }
        {
            ComparisonMeasure theComparisonMeasure;
            theComparisonMeasure = this.getComparisonMeasure();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "comparisonMeasure", theComparisonMeasure), currentHashCode, theComparisonMeasure);
        }
        {
            KNNInputs theKNNInputs;
            theKNNInputs = this.getKNNInputs();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "knnInputs", theKNNInputs), currentHashCode, theKNNInputs);
        }
        {
            ModelVerification theModelVerification;
            theModelVerification = this.getModelVerification();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelVerification", theModelVerification), currentHashCode, theModelVerification);
        }
        {
            String theModelName;
            theModelName = this.getModelName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "modelName", theModelName), currentHashCode, theModelName);
        }
        {
            MiningFunctionType theFunctionName;
            theFunctionName = this.getFunctionName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "functionName", theFunctionName), currentHashCode, theFunctionName);
        }
        {
            String theAlgorithmName;
            theAlgorithmName = this.getAlgorithmName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "algorithmName", theAlgorithmName), currentHashCode, theAlgorithmName);
        }
        {
            Integer theNumberOfNeighbors;
            theNumberOfNeighbors = this.getNumberOfNeighbors();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "numberOfNeighbors", theNumberOfNeighbors), currentHashCode, theNumberOfNeighbors);
        }
        {
            ContScoringMethodType theContinuousScoringMethod;
            theContinuousScoringMethod = this.getContinuousScoringMethod();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "continuousScoringMethod", theContinuousScoringMethod), currentHashCode, theContinuousScoringMethod);
        }
        {
            CatScoringMethodType theCategoricalScoringMethod;
            theCategoricalScoringMethod = this.getCategoricalScoringMethod();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "categoricalScoringMethod", theCategoricalScoringMethod), currentHashCode, theCategoricalScoringMethod);
        }
        {
            String theInstanceIdVariable;
            theInstanceIdVariable = this.getInstanceIdVariable();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "instanceIdVariable", theInstanceIdVariable), currentHashCode, theInstanceIdVariable);
        }
        {
            double theThreshold;
            theThreshold = ((this.threshold!= null)?this.getThreshold(): 0.0D);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "threshold", theThreshold), currentHashCode, theThreshold);
        }
        {
            boolean theScorable;
            theScorable = ((this.scorable!= null)?this.isScorable():false);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "scorable", theScorable), currentHashCode, theScorable);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<Extension> theExtensions;
            theExtensions = (((this.extensions!= null)&&(!this.extensions.isEmpty()))?this.getExtensions():null);
            strategy.appendField(locator, this, "extensions", buffer, theExtensions);
        }
        {
            MiningSchema theMiningSchema;
            theMiningSchema = this.getMiningSchema();
            strategy.appendField(locator, this, "miningSchema", buffer, theMiningSchema);
        }
        {
            Output theOutput;
            theOutput = this.getOutput();
            strategy.appendField(locator, this, "output", buffer, theOutput);
        }
        {
            ModelStats theModelStats;
            theModelStats = this.getModelStats();
            strategy.appendField(locator, this, "modelStats", buffer, theModelStats);
        }
        {
            ModelExplanation theModelExplanation;
            theModelExplanation = this.getModelExplanation();
            strategy.appendField(locator, this, "modelExplanation", buffer, theModelExplanation);
        }
        {
            Targets theTargets;
            theTargets = this.getTargets();
            strategy.appendField(locator, this, "targets", buffer, theTargets);
        }
        {
            LocalTransformations theLocalTransformations;
            theLocalTransformations = this.getLocalTransformations();
            strategy.appendField(locator, this, "localTransformations", buffer, theLocalTransformations);
        }
        {
            TrainingInstances theTrainingInstances;
            theTrainingInstances = this.getTrainingInstances();
            strategy.appendField(locator, this, "trainingInstances", buffer, theTrainingInstances);
        }
        {
            ComparisonMeasure theComparisonMeasure;
            theComparisonMeasure = this.getComparisonMeasure();
            strategy.appendField(locator, this, "comparisonMeasure", buffer, theComparisonMeasure);
        }
        {
            KNNInputs theKNNInputs;
            theKNNInputs = this.getKNNInputs();
            strategy.appendField(locator, this, "knnInputs", buffer, theKNNInputs);
        }
        {
            ModelVerification theModelVerification;
            theModelVerification = this.getModelVerification();
            strategy.appendField(locator, this, "modelVerification", buffer, theModelVerification);
        }
        {
            String theModelName;
            theModelName = this.getModelName();
            strategy.appendField(locator, this, "modelName", buffer, theModelName);
        }
        {
            MiningFunctionType theFunctionName;
            theFunctionName = this.getFunctionName();
            strategy.appendField(locator, this, "functionName", buffer, theFunctionName);
        }
        {
            String theAlgorithmName;
            theAlgorithmName = this.getAlgorithmName();
            strategy.appendField(locator, this, "algorithmName", buffer, theAlgorithmName);
        }
        {
            Integer theNumberOfNeighbors;
            theNumberOfNeighbors = this.getNumberOfNeighbors();
            strategy.appendField(locator, this, "numberOfNeighbors", buffer, theNumberOfNeighbors);
        }
        {
            ContScoringMethodType theContinuousScoringMethod;
            theContinuousScoringMethod = this.getContinuousScoringMethod();
            strategy.appendField(locator, this, "continuousScoringMethod", buffer, theContinuousScoringMethod);
        }
        {
            CatScoringMethodType theCategoricalScoringMethod;
            theCategoricalScoringMethod = this.getCategoricalScoringMethod();
            strategy.appendField(locator, this, "categoricalScoringMethod", buffer, theCategoricalScoringMethod);
        }
        {
            String theInstanceIdVariable;
            theInstanceIdVariable = this.getInstanceIdVariable();
            strategy.appendField(locator, this, "instanceIdVariable", buffer, theInstanceIdVariable);
        }
        {
            double theThreshold;
            theThreshold = ((this.threshold!= null)?this.getThreshold(): 0.0D);
            strategy.appendField(locator, this, "threshold", buffer, theThreshold);
        }
        {
            boolean theScorable;
            theScorable = ((this.scorable!= null)?this.isScorable():false);
            strategy.appendField(locator, this, "scorable", buffer, theScorable);
        }
        return buffer;
    }

}
