
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.w3._2001.xmlschema.Adapter3;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="antecedent" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="consequent" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="support" use="required" type="{http://www.dmg.org/PMML-4_2}PROB-NUMBER" />
 *       &lt;attribute name="confidence" use="required" type="{http://www.dmg.org/PMML-4_2}PROB-NUMBER" />
 *       &lt;attribute name="lift" type="{http://www.w3.org/2001/XMLSchema}float" />
 *       &lt;attribute name="leverage" type="{http://www.w3.org/2001/XMLSchema}float" />
 *       &lt;attribute name="affinity" type="{http://www.dmg.org/PMML-4_2}PROB-NUMBER" />
 *       &lt;attribute name="id" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "AssociationRule")
public class AssociationRule
    extends Entity
    implements Locatable, HasExtensions, HasId
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlAttribute(name = "antecedent", required = true)
    protected String antecedent;
    @XmlAttribute(name = "consequent", required = true)
    protected String consequent;
    @XmlAttribute(name = "support", required = true)
    @XmlJavaTypeAdapter(Adapter3 .class)
    protected Double support;
    @XmlAttribute(name = "confidence", required = true)
    @XmlJavaTypeAdapter(Adapter3 .class)
    protected Double confidence;
    @XmlAttribute(name = "lift")
    protected Float lift;
    @XmlAttribute(name = "leverage")
    @Schema(min = Version.PMML_4_1)
    protected Float leverage;
    @XmlAttribute(name = "affinity")
    @XmlJavaTypeAdapter(Adapter3 .class)
    @Schema(min = Version.PMML_4_1)
    protected Double affinity;
    @XmlAttribute(name = "id")
    protected String id;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    @Deprecated
    public AssociationRule() {
        super();
    }

    public AssociationRule(final String antecedent, final String consequent, final Double support, final Double confidence) {
        super();
        this.antecedent = antecedent;
        this.consequent = consequent;
        this.support = support;
        this.confidence = confidence;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the antecedent property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAntecedent() {
        return antecedent;
    }

    /**
     * Sets the value of the antecedent property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAntecedent(String value) {
        this.antecedent = value;
    }

    /**
     * Gets the value of the consequent property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getConsequent() {
        return consequent;
    }

    /**
     * Sets the value of the consequent property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setConsequent(String value) {
        this.consequent = value;
    }

    /**
     * Gets the value of the support property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Double getSupport() {
        return support;
    }

    /**
     * Sets the value of the support property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSupport(Double value) {
        this.support = value;
    }

    /**
     * Gets the value of the confidence property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Double getConfidence() {
        return confidence;
    }

    /**
     * Sets the value of the confidence property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setConfidence(Double value) {
        this.confidence = value;
    }

    /**
     * Gets the value of the lift property.
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public Float getLift() {
        return lift;
    }

    /**
     * Sets the value of the lift property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     */
    public void setLift(Float value) {
        this.lift = value;
    }

    /**
     * Gets the value of the leverage property.
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public Float getLeverage() {
        return leverage;
    }

    /**
     * Sets the value of the leverage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     */
    public void setLeverage(Float value) {
        this.leverage = value;
    }

    /**
     * Gets the value of the affinity property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Double getAffinity() {
        return affinity;
    }

    /**
     * Sets the value of the affinity property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAffinity(Double value) {
        this.affinity = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(String value) {
        this.id = value;
    }

    public AssociationRule withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public AssociationRule withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public AssociationRule withAntecedent(String value) {
        setAntecedent(value);
        return this;
    }

    public AssociationRule withConsequent(String value) {
        setConsequent(value);
        return this;
    }

    public AssociationRule withSupport(Double value) {
        setSupport(value);
        return this;
    }

    public AssociationRule withConfidence(Double value) {
        setConfidence(value);
        return this;
    }

    public AssociationRule withLift(Float value) {
        setLift(value);
        return this;
    }

    public AssociationRule withLeverage(Float value) {
        setLeverage(value);
        return this;
    }

    public AssociationRule withAffinity(Double value) {
        setAffinity(value);
        return this;
    }

    public AssociationRule withId(String value) {
        setId(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
