
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;group ref="{http://www.dmg.org/PMML-4_2}CONTINUOUS-DISTRIBUTION-TYPES"/>
 *           &lt;group ref="{http://www.dmg.org/PMML-4_2}DISCRETE-DISTRIBUTION-TYPES"/>
 *         &lt;/choice>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "continuousDistribution",
    "countTable",
    "normalizedCountTable",
    "fieldRefs"
})
@XmlRootElement(name = "Baseline")
@Schema(min = Version.PMML_4_1)
public class Baseline
    extends PMMLObject
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "AnyDistribution", type = AnyDistribution.class),
        @XmlElement(name = "GaussianDistribution", type = GaussianDistribution.class),
        @XmlElement(name = "PoissonDistribution", type = PoissonDistribution.class),
        @XmlElement(name = "UniformDistribution", type = UniformDistribution.class)
    })
    protected ContinuousDistribution continuousDistribution;
    @XmlElement(name = "CountTable")
    protected CountTable countTable;
    @XmlElement(name = "NormalizedCountTable")
    protected CountTable normalizedCountTable;
    @XmlElement(name = "FieldRef")
    protected List<FieldRef> fieldRefs;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the continuousDistribution property.
     * 
     * @return
     *     possible object is
     *     {@link AnyDistribution }
     *     {@link GaussianDistribution }
     *     {@link PoissonDistribution }
     *     {@link UniformDistribution }
     *     
     */
    public ContinuousDistribution getContinuousDistribution() {
        return continuousDistribution;
    }

    /**
     * Sets the value of the continuousDistribution property.
     * 
     * @param value
     *     allowed object is
     *     {@link AnyDistribution }
     *     {@link GaussianDistribution }
     *     {@link PoissonDistribution }
     *     {@link UniformDistribution }
     *     
     */
    public void setContinuousDistribution(ContinuousDistribution value) {
        this.continuousDistribution = value;
    }

    /**
     * Gets the value of the countTable property.
     * 
     * @return
     *     possible object is
     *     {@link CountTable }
     *     
     */
    public CountTable getCountTable() {
        return countTable;
    }

    /**
     * Sets the value of the countTable property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountTable }
     *     
     */
    public void setCountTable(CountTable value) {
        this.countTable = value;
    }

    /**
     * Gets the value of the normalizedCountTable property.
     * 
     * @return
     *     possible object is
     *     {@link CountTable }
     *     
     */
    public CountTable getNormalizedCountTable() {
        return normalizedCountTable;
    }

    /**
     * Sets the value of the normalizedCountTable property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountTable }
     *     
     */
    public void setNormalizedCountTable(CountTable value) {
        this.normalizedCountTable = value;
    }

    /**
     * Gets the value of the fieldRefs property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the fieldRefs property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFieldRefs().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FieldRef }
     * 
     * 
     */
    public List<FieldRef> getFieldRefs() {
        if (fieldRefs == null) {
            fieldRefs = new ArrayList<FieldRef>();
        }
        return this.fieldRefs;
    }

    public Baseline withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public Baseline withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public Baseline withContinuousDistribution(ContinuousDistribution value) {
        setContinuousDistribution(value);
        return this;
    }

    public Baseline withCountTable(CountTable value) {
        setCountTable(value);
        return this;
    }

    public Baseline withNormalizedCountTable(CountTable value) {
        setNormalizedCountTable(value);
        return this;
    }

    public Baseline withFieldRefs(FieldRef... values) {
        if (values!= null) {
            for (FieldRef value: values) {
                getFieldRefs().add(value);
            }
        }
        return this;
    }

    public Baseline withFieldRefs(Collection<FieldRef> values) {
        if (values!= null) {
            getFieldRefs().addAll(values);
        }
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.continuousDistribution!= null)) {
            status = this.continuousDistribution.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.countTable!= null)) {
            status = this.countTable.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.normalizedCountTable!= null)) {
            status = this.normalizedCountTable.accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.fieldRefs!= null))&&(i<this.fieldRefs.size())); i ++) {
            status = this.fieldRefs.get(i).accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
