
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.w3._2001.xmlschema.Adapter3;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ResultField" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Node"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_2}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="missingValueStrategy" type="{http://www.dmg.org/PMML-4_2}MISSING-VALUE-STRATEGY" default="none" />
 *       &lt;attribute name="missingValuePenalty" type="{http://www.dmg.org/PMML-4_2}PROB-NUMBER" default="1.0" />
 *       &lt;attribute name="noTrueChildStrategy" type="{http://www.dmg.org/PMML-4_2}NO-TRUE-CHILD-STRATEGY" default="returnNullPrediction" />
 *       &lt;attribute name="splitCharacteristic" default="multiSplit">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="binarySplit"/>
 *             &lt;enumeration value="multiSplit"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "output",
    "modelStats",
    "targets",
    "localTransformations",
    "resultFields",
    "node"
})
@XmlRootElement(name = "DecisionTree")
public class DecisionTree
    extends EmbeddedModel
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "Output")
    @Schema(min = Version.PMML_4_0)
    protected Output output;
    @XmlElement(name = "ModelStats")
    @Schema(min = Version.PMML_4_0)
    protected ModelStats modelStats;
    @XmlElement(name = "Targets")
    @Schema(min = Version.PMML_4_0)
    protected Targets targets;
    @XmlElement(name = "LocalTransformations")
    protected LocalTransformations localTransformations;
    @XmlElement(name = "ResultField")
    protected List<ResultField> resultFields;
    @XmlElement(name = "Node", required = true)
    protected Node node;
    @XmlAttribute(name = "modelName")
    protected String modelName;
    @XmlAttribute(name = "functionName", required = true)
    protected MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    protected String algorithmName;
    @XmlAttribute(name = "missingValueStrategy")
    @Schema(min = Version.PMML_3_1)
    protected MissingValueStrategyType missingValueStrategy;
    @XmlAttribute(name = "missingValuePenalty")
    @XmlJavaTypeAdapter(Adapter3 .class)
    @Schema(min = Version.PMML_3_1)
    protected Double missingValuePenalty;
    @XmlAttribute(name = "noTrueChildStrategy")
    @Schema(min = Version.PMML_3_1)
    protected NoTrueChildStrategyType noTrueChildStrategy;
    @XmlAttribute(name = "splitCharacteristic")
    protected DecisionTree.SplitCharacteristic splitCharacteristic;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    @Deprecated
    public DecisionTree() {
        super();
    }

    public DecisionTree(final Node node, final MiningFunctionType functionName) {
        super();
        this.node = node;
        this.functionName = functionName;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param value
     *     allowed object is
     *     {@link Output }
     *     
     */
    public void setOutput(Output value) {
        this.output = value;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public void setModelStats(ModelStats value) {
        this.modelStats = value;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param value
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public void setTargets(Targets value) {
        this.targets = value;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public void setLocalTransformations(LocalTransformations value) {
        this.localTransformations = value;
    }

    /**
     * Gets the value of the resultFields property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the resultFields property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getResultFields().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ResultField }
     * 
     * 
     */
    public List<ResultField> getResultFields() {
        if (resultFields == null) {
            resultFields = new ArrayList<ResultField>();
        }
        return this.resultFields;
    }

    /**
     * Gets the value of the node property.
     * 
     * @return
     *     possible object is
     *     {@link Node }
     *     
     */
    public Node getNode() {
        return node;
    }

    /**
     * Sets the value of the node property.
     * 
     * @param value
     *     allowed object is
     *     {@link Node }
     *     
     */
    public void setNode(Node value) {
        this.node = value;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setModelName(String value) {
        this.modelName = value;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public void setFunctionName(MiningFunctionType value) {
        this.functionName = value;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlgorithmName(String value) {
        this.algorithmName = value;
    }

    /**
     * Gets the value of the missingValueStrategy property.
     * 
     * @return
     *     possible object is
     *     {@link MissingValueStrategyType }
     *     
     */
    public MissingValueStrategyType getMissingValueStrategy() {
        if (missingValueStrategy == null) {
            return MissingValueStrategyType.NONE;
        } else {
            return missingValueStrategy;
        }
    }

    /**
     * Sets the value of the missingValueStrategy property.
     * 
     * @param value
     *     allowed object is
     *     {@link MissingValueStrategyType }
     *     
     */
    public void setMissingValueStrategy(MissingValueStrategyType value) {
        this.missingValueStrategy = value;
    }

    /**
     * Gets the value of the missingValuePenalty property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public double getMissingValuePenalty() {
        if (missingValuePenalty == null) {
            return new Adapter3().unmarshal("1.0");
        } else {
            return missingValuePenalty;
        }
    }

    /**
     * Sets the value of the missingValuePenalty property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMissingValuePenalty(Double value) {
        this.missingValuePenalty = value;
    }

    /**
     * Gets the value of the noTrueChildStrategy property.
     * 
     * @return
     *     possible object is
     *     {@link NoTrueChildStrategyType }
     *     
     */
    public NoTrueChildStrategyType getNoTrueChildStrategy() {
        if (noTrueChildStrategy == null) {
            return NoTrueChildStrategyType.RETURN_NULL_PREDICTION;
        } else {
            return noTrueChildStrategy;
        }
    }

    /**
     * Sets the value of the noTrueChildStrategy property.
     * 
     * @param value
     *     allowed object is
     *     {@link NoTrueChildStrategyType }
     *     
     */
    public void setNoTrueChildStrategy(NoTrueChildStrategyType value) {
        this.noTrueChildStrategy = value;
    }

    /**
     * Gets the value of the splitCharacteristic property.
     * 
     * @return
     *     possible object is
     *     {@link DecisionTree.SplitCharacteristic }
     *     
     */
    public DecisionTree.SplitCharacteristic getSplitCharacteristic() {
        if (splitCharacteristic == null) {
            return DecisionTree.SplitCharacteristic.MULTI_SPLIT;
        } else {
            return splitCharacteristic;
        }
    }

    /**
     * Sets the value of the splitCharacteristic property.
     * 
     * @param value
     *     allowed object is
     *     {@link DecisionTree.SplitCharacteristic }
     *     
     */
    public void setSplitCharacteristic(DecisionTree.SplitCharacteristic value) {
        this.splitCharacteristic = value;
    }

    public DecisionTree withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public DecisionTree withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public DecisionTree withOutput(Output value) {
        setOutput(value);
        return this;
    }

    public DecisionTree withModelStats(ModelStats value) {
        setModelStats(value);
        return this;
    }

    public DecisionTree withTargets(Targets value) {
        setTargets(value);
        return this;
    }

    public DecisionTree withLocalTransformations(LocalTransformations value) {
        setLocalTransformations(value);
        return this;
    }

    public DecisionTree withResultFields(ResultField... values) {
        if (values!= null) {
            for (ResultField value: values) {
                getResultFields().add(value);
            }
        }
        return this;
    }

    public DecisionTree withResultFields(Collection<ResultField> values) {
        if (values!= null) {
            getResultFields().addAll(values);
        }
        return this;
    }

    public DecisionTree withNode(Node value) {
        setNode(value);
        return this;
    }

    public DecisionTree withModelName(String value) {
        setModelName(value);
        return this;
    }

    public DecisionTree withFunctionName(MiningFunctionType value) {
        setFunctionName(value);
        return this;
    }

    public DecisionTree withAlgorithmName(String value) {
        setAlgorithmName(value);
        return this;
    }

    public DecisionTree withMissingValueStrategy(MissingValueStrategyType value) {
        setMissingValueStrategy(value);
        return this;
    }

    public DecisionTree withMissingValuePenalty(Double value) {
        setMissingValuePenalty(value);
        return this;
    }

    public DecisionTree withNoTrueChildStrategy(NoTrueChildStrategyType value) {
        setNoTrueChildStrategy(value);
        return this;
    }

    public DecisionTree withSplitCharacteristic(DecisionTree.SplitCharacteristic value) {
        setSplitCharacteristic(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.output!= null)) {
            status = this.output.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelStats!= null)) {
            status = this.modelStats.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.targets!= null)) {
            status = this.targets.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.localTransformations!= null)) {
            status = this.localTransformations.accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.resultFields!= null))&&(i<this.resultFields.size())); i ++) {
            status = this.resultFields.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.node!= null)) {
            status = this.node.accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="binarySplit"/>
     *     &lt;enumeration value="multiSplit"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum SplitCharacteristic {

        @XmlEnumValue("binarySplit")
        BINARY_SPLIT("binarySplit"),
        @XmlEnumValue("multiSplit")
        MULTI_SPLIT("multiSplit");
        private final String value;

        SplitCharacteristic(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static DecisionTree.SplitCharacteristic fromValue(String v) {
            for (DecisionTree.SplitCharacteristic c: DecisionTree.SplitCharacteristic.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
