
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.w3._2001.xmlschema.Adapter1;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}TextDictionary"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}TextCorpus"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}DocumentTermMatrix"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}TextModelNormalization" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}TextModelSimiliarity" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_2}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="numberOfTerms" use="required" type="{http://www.w3.org/2001/XMLSchema}integer" />
 *       &lt;attribute name="numberOfDocuments" use="required" type="{http://www.w3.org/2001/XMLSchema}integer" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "textDictionary",
    "textCorpus",
    "documentTermMatrix",
    "textModelNormalization",
    "textModelSimiliarity",
    "modelVerification"
})
@XmlRootElement(name = "TextModel")
public class TextModel
    extends Model
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension")
    protected List<Extension> extensions;
    @XmlElement(name = "MiningSchema", required = true)
    protected MiningSchema miningSchema;
    @XmlElement(name = "Output")
    protected Output output;
    @XmlElement(name = "ModelStats")
    protected ModelStats modelStats;
    @XmlElement(name = "ModelExplanation")
    @Schema(min = Version.PMML_4_0)
    protected ModelExplanation modelExplanation;
    @XmlElement(name = "Targets")
    protected Targets targets;
    @XmlElement(name = "LocalTransformations")
    protected LocalTransformations localTransformations;
    @XmlElement(name = "TextDictionary", required = true)
    protected TextDictionary textDictionary;
    @XmlElement(name = "TextCorpus", required = true)
    protected TextCorpus textCorpus;
    @XmlElement(name = "DocumentTermMatrix", required = true)
    protected DocumentTermMatrix documentTermMatrix;
    @XmlElement(name = "TextModelNormalization")
    protected TextModelNormalization textModelNormalization;
    @XmlElement(name = "TextModelSimiliarity")
    protected TextModelSimiliarity textModelSimiliarity;
    @XmlElement(name = "ModelVerification")
    protected ModelVerification modelVerification;
    @XmlAttribute(name = "modelName")
    protected String modelName;
    @XmlAttribute(name = "functionName", required = true)
    protected MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    protected String algorithmName;
    @XmlAttribute(name = "numberOfTerms", required = true)
    @XmlJavaTypeAdapter(Adapter1 .class)
    @XmlSchemaType(name = "integer")
    protected Integer numberOfTerms;
    @XmlAttribute(name = "numberOfDocuments", required = true)
    @XmlJavaTypeAdapter(Adapter1 .class)
    @XmlSchemaType(name = "integer")
    protected Integer numberOfDocuments;
    @XmlAttribute(name = "isScorable")
    @Schema(min = Version.PMML_4_1)
    protected Boolean scorable;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    @Deprecated
    public TextModel() {
        super();
    }

    public TextModel(final MiningSchema miningSchema, final TextDictionary textDictionary, final TextCorpus textCorpus, final DocumentTermMatrix documentTermMatrix, final MiningFunctionType functionName, final Integer numberOfTerms, final Integer numberOfDocuments) {
        super();
        this.miningSchema = miningSchema;
        this.textDictionary = textDictionary;
        this.textCorpus = textCorpus;
        this.documentTermMatrix = documentTermMatrix;
        this.functionName = functionName;
        this.numberOfTerms = numberOfTerms;
        this.numberOfDocuments = numberOfDocuments;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public void setMiningSchema(MiningSchema value) {
        this.miningSchema = value;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param value
     *     allowed object is
     *     {@link Output }
     *     
     */
    public void setOutput(Output value) {
        this.output = value;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public void setModelStats(ModelStats value) {
        this.modelStats = value;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public void setModelExplanation(ModelExplanation value) {
        this.modelExplanation = value;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param value
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public void setTargets(Targets value) {
        this.targets = value;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public void setLocalTransformations(LocalTransformations value) {
        this.localTransformations = value;
    }

    /**
     * Gets the value of the textDictionary property.
     * 
     * @return
     *     possible object is
     *     {@link TextDictionary }
     *     
     */
    public TextDictionary getTextDictionary() {
        return textDictionary;
    }

    /**
     * Sets the value of the textDictionary property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextDictionary }
     *     
     */
    public void setTextDictionary(TextDictionary value) {
        this.textDictionary = value;
    }

    /**
     * Gets the value of the textCorpus property.
     * 
     * @return
     *     possible object is
     *     {@link TextCorpus }
     *     
     */
    public TextCorpus getTextCorpus() {
        return textCorpus;
    }

    /**
     * Sets the value of the textCorpus property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextCorpus }
     *     
     */
    public void setTextCorpus(TextCorpus value) {
        this.textCorpus = value;
    }

    /**
     * Gets the value of the documentTermMatrix property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentTermMatrix }
     *     
     */
    public DocumentTermMatrix getDocumentTermMatrix() {
        return documentTermMatrix;
    }

    /**
     * Sets the value of the documentTermMatrix property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentTermMatrix }
     *     
     */
    public void setDocumentTermMatrix(DocumentTermMatrix value) {
        this.documentTermMatrix = value;
    }

    /**
     * Gets the value of the textModelNormalization property.
     * 
     * @return
     *     possible object is
     *     {@link TextModelNormalization }
     *     
     */
    public TextModelNormalization getTextModelNormalization() {
        return textModelNormalization;
    }

    /**
     * Sets the value of the textModelNormalization property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextModelNormalization }
     *     
     */
    public void setTextModelNormalization(TextModelNormalization value) {
        this.textModelNormalization = value;
    }

    /**
     * Gets the value of the textModelSimiliarity property.
     * 
     * @return
     *     possible object is
     *     {@link TextModelSimiliarity }
     *     
     */
    public TextModelSimiliarity getTextModelSimiliarity() {
        return textModelSimiliarity;
    }

    /**
     * Sets the value of the textModelSimiliarity property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextModelSimiliarity }
     *     
     */
    public void setTextModelSimiliarity(TextModelSimiliarity value) {
        this.textModelSimiliarity = value;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public void setModelVerification(ModelVerification value) {
        this.modelVerification = value;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setModelName(String value) {
        this.modelName = value;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public void setFunctionName(MiningFunctionType value) {
        this.functionName = value;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlgorithmName(String value) {
        this.algorithmName = value;
    }

    /**
     * Gets the value of the numberOfTerms property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfTerms() {
        return numberOfTerms;
    }

    /**
     * Sets the value of the numberOfTerms property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNumberOfTerms(Integer value) {
        this.numberOfTerms = value;
    }

    /**
     * Gets the value of the numberOfDocuments property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfDocuments() {
        return numberOfDocuments;
    }

    /**
     * Sets the value of the numberOfDocuments property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNumberOfDocuments(Integer value) {
        this.numberOfDocuments = value;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return true;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setScorable(Boolean value) {
        this.scorable = value;
    }

    public TextModel withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public TextModel withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public TextModel withMiningSchema(MiningSchema value) {
        setMiningSchema(value);
        return this;
    }

    public TextModel withOutput(Output value) {
        setOutput(value);
        return this;
    }

    public TextModel withModelStats(ModelStats value) {
        setModelStats(value);
        return this;
    }

    public TextModel withModelExplanation(ModelExplanation value) {
        setModelExplanation(value);
        return this;
    }

    public TextModel withTargets(Targets value) {
        setTargets(value);
        return this;
    }

    public TextModel withLocalTransformations(LocalTransformations value) {
        setLocalTransformations(value);
        return this;
    }

    public TextModel withTextDictionary(TextDictionary value) {
        setTextDictionary(value);
        return this;
    }

    public TextModel withTextCorpus(TextCorpus value) {
        setTextCorpus(value);
        return this;
    }

    public TextModel withDocumentTermMatrix(DocumentTermMatrix value) {
        setDocumentTermMatrix(value);
        return this;
    }

    public TextModel withTextModelNormalization(TextModelNormalization value) {
        setTextModelNormalization(value);
        return this;
    }

    public TextModel withTextModelSimiliarity(TextModelSimiliarity value) {
        setTextModelSimiliarity(value);
        return this;
    }

    public TextModel withModelVerification(ModelVerification value) {
        setModelVerification(value);
        return this;
    }

    public TextModel withModelName(String value) {
        setModelName(value);
        return this;
    }

    public TextModel withFunctionName(MiningFunctionType value) {
        setFunctionName(value);
        return this;
    }

    public TextModel withAlgorithmName(String value) {
        setAlgorithmName(value);
        return this;
    }

    public TextModel withNumberOfTerms(Integer value) {
        setNumberOfTerms(value);
        return this;
    }

    public TextModel withNumberOfDocuments(Integer value) {
        setNumberOfDocuments(value);
        return this;
    }

    public TextModel withScorable(Boolean value) {
        setScorable(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.miningSchema!= null)) {
            status = this.miningSchema.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.output!= null)) {
            status = this.output.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelStats!= null)) {
            status = this.modelStats.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelExplanation!= null)) {
            status = this.modelExplanation.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.targets!= null)) {
            status = this.targets.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.localTransformations!= null)) {
            status = this.localTransformations.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.textDictionary!= null)) {
            status = this.textDictionary.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.textCorpus!= null)) {
            status = this.textCorpus.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.documentTermMatrix!= null)) {
            status = this.documentTermMatrix.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.textModelNormalization!= null)) {
            status = this.textModelNormalization.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.textModelSimiliarity!= null)) {
            status = this.textModelSimiliarity.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelVerification!= null)) {
            status = this.modelVerification.accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
