
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}XCoordinates"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}YCoordinates"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}BoundaryValues" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "xCoordinates",
    "yCoordinates",
    "boundaryValues"
})
@XmlRootElement(name = "ROCGraph", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_4_0)
public class ROCGraph
    extends PMMLObject
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElement(name = "XCoordinates", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    protected XCoordinates xCoordinates;
    @XmlElement(name = "YCoordinates", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    protected YCoordinates yCoordinates;
    @XmlElement(name = "BoundaryValues", namespace = "http://www.dmg.org/PMML-4_2")
    protected BoundaryValues boundaryValues;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    public ROCGraph() {
        super();
    }

    public ROCGraph(final XCoordinates xCoordinates, final YCoordinates yCoordinates) {
        super();
        this.xCoordinates = xCoordinates;
        this.yCoordinates = yCoordinates;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the xCoordinates property.
     * 
     * @return
     *     possible object is
     *     {@link XCoordinates }
     *     
     */
    public XCoordinates getXCoordinates() {
        return xCoordinates;
    }

    /**
     * Sets the value of the xCoordinates property.
     * 
     * @param value
     *     allowed object is
     *     {@link XCoordinates }
     *     
     */
    public void setXCoordinates(XCoordinates value) {
        this.xCoordinates = value;
    }

    /**
     * Gets the value of the yCoordinates property.
     * 
     * @return
     *     possible object is
     *     {@link YCoordinates }
     *     
     */
    public YCoordinates getYCoordinates() {
        return yCoordinates;
    }

    /**
     * Sets the value of the yCoordinates property.
     * 
     * @param value
     *     allowed object is
     *     {@link YCoordinates }
     *     
     */
    public void setYCoordinates(YCoordinates value) {
        this.yCoordinates = value;
    }

    /**
     * Gets the value of the boundaryValues property.
     * 
     * @return
     *     possible object is
     *     {@link BoundaryValues }
     *     
     */
    public BoundaryValues getBoundaryValues() {
        return boundaryValues;
    }

    /**
     * Sets the value of the boundaryValues property.
     * 
     * @param value
     *     allowed object is
     *     {@link BoundaryValues }
     *     
     */
    public void setBoundaryValues(BoundaryValues value) {
        this.boundaryValues = value;
    }

    public ROCGraph withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public ROCGraph withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public ROCGraph withXCoordinates(XCoordinates value) {
        setXCoordinates(value);
        return this;
    }

    public ROCGraph withYCoordinates(YCoordinates value) {
        setYCoordinates(value);
        return this;
    }

    public ROCGraph withBoundaryValues(BoundaryValues value) {
        setBoundaryValues(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.xCoordinates!= null)) {
            status = this.xCoordinates.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.yCoordinates!= null)) {
            status = this.yCoordinates.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.boundaryValues!= null)) {
            status = this.boundaryValues.accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
