
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}NumericPredictor" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}CategoricalPredictor" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}PredictorTerm" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="intercept" use="required" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="targetCategory" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "numericPredictors",
    "categoricalPredictors",
    "predictorTerms"
})
@XmlRootElement(name = "RegressionTable", namespace = "http://www.dmg.org/PMML-4_2")
public class RegressionTable
    extends PMMLObject
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElement(name = "NumericPredictor", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<NumericPredictor> numericPredictors;
    @XmlElement(name = "CategoricalPredictor", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<CategoricalPredictor> categoricalPredictors;
    @XmlElement(name = "PredictorTerm", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<PredictorTerm> predictorTerms;
    @XmlAttribute(name = "intercept", required = true)
    protected double intercept;
    @XmlAttribute(name = "targetCategory")
    protected String targetCategory;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    public RegressionTable() {
        super();
    }

    public RegressionTable(final double intercept) {
        super();
        this.intercept = intercept;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the numericPredictors property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the numericPredictors property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNumericPredictors().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NumericPredictor }
     * 
     * 
     */
    public List<NumericPredictor> getNumericPredictors() {
        if (numericPredictors == null) {
            numericPredictors = new ArrayList<NumericPredictor>();
        }
        return this.numericPredictors;
    }

    /**
     * Gets the value of the categoricalPredictors property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the categoricalPredictors property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCategoricalPredictors().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CategoricalPredictor }
     * 
     * 
     */
    public List<CategoricalPredictor> getCategoricalPredictors() {
        if (categoricalPredictors == null) {
            categoricalPredictors = new ArrayList<CategoricalPredictor>();
        }
        return this.categoricalPredictors;
    }

    /**
     * Gets the value of the predictorTerms property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the predictorTerms property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPredictorTerms().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PredictorTerm }
     * 
     * 
     */
    public List<PredictorTerm> getPredictorTerms() {
        if (predictorTerms == null) {
            predictorTerms = new ArrayList<PredictorTerm>();
        }
        return this.predictorTerms;
    }

    /**
     * Gets the value of the intercept property.
     * 
     */
    public double getIntercept() {
        return intercept;
    }

    /**
     * Sets the value of the intercept property.
     * 
     */
    public void setIntercept(double value) {
        this.intercept = value;
    }

    /**
     * Gets the value of the targetCategory property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTargetCategory() {
        return targetCategory;
    }

    /**
     * Sets the value of the targetCategory property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTargetCategory(String value) {
        this.targetCategory = value;
    }

    public RegressionTable withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public RegressionTable withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public RegressionTable withNumericPredictors(NumericPredictor... values) {
        if (values!= null) {
            for (NumericPredictor value: values) {
                getNumericPredictors().add(value);
            }
        }
        return this;
    }

    public RegressionTable withNumericPredictors(Collection<NumericPredictor> values) {
        if (values!= null) {
            getNumericPredictors().addAll(values);
        }
        return this;
    }

    public RegressionTable withCategoricalPredictors(CategoricalPredictor... values) {
        if (values!= null) {
            for (CategoricalPredictor value: values) {
                getCategoricalPredictors().add(value);
            }
        }
        return this;
    }

    public RegressionTable withCategoricalPredictors(Collection<CategoricalPredictor> values) {
        if (values!= null) {
            getCategoricalPredictors().addAll(values);
        }
        return this;
    }

    public RegressionTable withPredictorTerms(PredictorTerm... values) {
        if (values!= null) {
            for (PredictorTerm value: values) {
                getPredictorTerms().add(value);
            }
        }
        return this;
    }

    public RegressionTable withPredictorTerms(Collection<PredictorTerm> values) {
        if (values!= null) {
            getPredictorTerms().addAll(values);
        }
        return this;
    }

    public RegressionTable withIntercept(double value) {
        setIntercept(value);
        return this;
    }

    public RegressionTable withTargetCategory(String value) {
        setTargetCategory(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.numericPredictors!= null))&&(i<this.numericPredictors.size())); i ++) {
            status = this.numericPredictors.get(i).accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.categoricalPredictors!= null))&&(i<this.categoricalPredictors.size())); i ++) {
            status = this.categoricalPredictors.get(i).accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.predictorTerms!= null))&&(i<this.predictorTerms.size())); i ++) {
            status = this.predictorTerms.get(i).accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
