
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}TargetValue" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="field" use="required" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="optype" type="{http://www.dmg.org/PMML-4_2}OPTYPE" />
 *       &lt;attribute name="castInteger">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="round"/>
 *             &lt;enumeration value="ceiling"/>
 *             &lt;enumeration value="floor"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="min" type="{http://www.w3.org/2001/XMLSchema}double" />
 *       &lt;attribute name="max" type="{http://www.w3.org/2001/XMLSchema}double" />
 *       &lt;attribute name="rescaleConstant" type="{http://www.w3.org/2001/XMLSchema}double" default="0" />
 *       &lt;attribute name="rescaleFactor" type="{http://www.w3.org/2001/XMLSchema}double" default="1" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "targetValues"
})
@XmlRootElement(name = "Target", namespace = "http://www.dmg.org/PMML-4_2")
public class Target
    extends PMMLObject
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElement(name = "TargetValue", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<TargetValue> targetValues;
    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    protected FieldName field;
    @XmlAttribute(name = "optype")
    protected OpType optype;
    @XmlAttribute(name = "castInteger")
    protected Target.CastInteger castInteger;
    @XmlAttribute(name = "min")
    @Added(Version.PMML_3_1)
    protected Double min;
    @XmlAttribute(name = "max")
    @Added(Version.PMML_3_1)
    protected Double max;
    @XmlAttribute(name = "rescaleConstant")
    @Added(Version.PMML_3_1)
    protected Double rescaleConstant;
    @XmlAttribute(name = "rescaleFactor")
    @Added(Version.PMML_3_1)
    protected Double rescaleFactor;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    public Target() {
        super();
    }

    public Target(final FieldName field) {
        super();
        this.field = field;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the targetValues property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the targetValues property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTargetValues().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TargetValue }
     * 
     * 
     */
    public List<TargetValue> getTargetValues() {
        if (targetValues == null) {
            targetValues = new ArrayList<TargetValue>();
        }
        return this.targetValues;
    }

    /**
     * Gets the value of the field property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getField() {
        return field;
    }

    /**
     * Sets the value of the field property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setField(FieldName value) {
        this.field = value;
    }

    /**
     * Gets the value of the optype property.
     * 
     * @return
     *     possible object is
     *     {@link OpType }
     *     
     */
    public OpType getOptype() {
        return optype;
    }

    /**
     * Sets the value of the optype property.
     * 
     * @param value
     *     allowed object is
     *     {@link OpType }
     *     
     */
    public void setOptype(OpType value) {
        this.optype = value;
    }

    /**
     * Gets the value of the castInteger property.
     * 
     * @return
     *     possible object is
     *     {@link Target.CastInteger }
     *     
     */
    public Target.CastInteger getCastInteger() {
        return castInteger;
    }

    /**
     * Sets the value of the castInteger property.
     * 
     * @param value
     *     allowed object is
     *     {@link Target.CastInteger }
     *     
     */
    public void setCastInteger(Target.CastInteger value) {
        this.castInteger = value;
    }

    /**
     * Gets the value of the min property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMin() {
        return min;
    }

    /**
     * Sets the value of the min property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setMin(Double value) {
        this.min = value;
    }

    /**
     * Gets the value of the max property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMax() {
        return max;
    }

    /**
     * Sets the value of the max property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setMax(Double value) {
        this.max = value;
    }

    /**
     * Gets the value of the rescaleConstant property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getRescaleConstant() {
        if (rescaleConstant == null) {
            return  0.0D;
        } else {
            return rescaleConstant;
        }
    }

    /**
     * Sets the value of the rescaleConstant property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setRescaleConstant(Double value) {
        this.rescaleConstant = value;
    }

    /**
     * Gets the value of the rescaleFactor property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getRescaleFactor() {
        if (rescaleFactor == null) {
            return  1.0D;
        } else {
            return rescaleFactor;
        }
    }

    /**
     * Sets the value of the rescaleFactor property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setRescaleFactor(Double value) {
        this.rescaleFactor = value;
    }

    public Target withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public Target withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public Target withTargetValues(TargetValue... values) {
        if (values!= null) {
            for (TargetValue value: values) {
                getTargetValues().add(value);
            }
        }
        return this;
    }

    public Target withTargetValues(Collection<TargetValue> values) {
        if (values!= null) {
            getTargetValues().addAll(values);
        }
        return this;
    }

    public Target withField(FieldName value) {
        setField(value);
        return this;
    }

    public Target withOptype(OpType value) {
        setOptype(value);
        return this;
    }

    public Target withCastInteger(Target.CastInteger value) {
        setCastInteger(value);
        return this;
    }

    public Target withMin(Double value) {
        setMin(value);
        return this;
    }

    public Target withMax(Double value) {
        setMax(value);
        return this;
    }

    public Target withRescaleConstant(Double value) {
        setRescaleConstant(value);
        return this;
    }

    public Target withRescaleFactor(Double value) {
        setRescaleFactor(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.targetValues!= null))&&(i<this.targetValues.size())); i ++) {
            status = this.targetValues.get(i).accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="round"/>
     *     &lt;enumeration value="ceiling"/>
     *     &lt;enumeration value="floor"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum CastInteger {

        @XmlEnumValue("round")
        ROUND("round"),
        @XmlEnumValue("ceiling")
        CEILING("ceiling"),
        @XmlEnumValue("floor")
        FLOOR("floor");
        private final String value;

        CastInteger(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Target.CastInteger fromValue(String v) {
            for (Target.CastInteger c: Target.CastInteger.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
